package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteADHApertura;
import com.ejie.y41b.model.TramiteComun;

import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbadhtramService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tramiteADHApertura")
@SessionAttributes({ "tramiteADHApertura", "modoADHApertura" })
public class TramiteADHAperturaController {

	private static final Logger logger = LoggerFactory.getLogger(TramiteGenericoController.class);

	@Autowired()
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;
	@Autowired()
	private ArbadhtramService arbadhtramService;
	@Autowired()
	private ArbadhsolService arbadhsolService;

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param adhid
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{adhid}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable() String codProcedimiento, @PathVariable() String adhid,
			@PathVariable() String idTramite, Model model) throws Exception {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(adhid.toString());
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		Arbadhsol arbadhsol = new Arbadhsol(adhid);
		arbadhsol = this.arbadhsolService.find(arbadhsol);
		StringBuffer numeroExpediente = new StringBuffer();
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ADHESION_APERTURA_ALTA);
			numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_ALTA);
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ADHESION_APERTURA_BAJA);
			numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_BAJA);
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ADHESION_APERTURA_MOD);
			numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_MOD);
		}

		this.arbadhtramService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);

		numeroExpediente.append("-").append(Y41bConstantes.ID_ORGANISMO_SOLICITUD_ADH).append("-")
				.append(arbadhsol.getAdhsolnror()).append("-").append(arbadhsol.getAdhsolnran());
		tramiteComun.setNumExpediente(numeroExpediente.toString());
		model.addAttribute("tramiteADHApertura", tramiteComun);

		model.addAttribute("modoADHApertura", Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteADHApertura", "model", model);
	}

	/**
	 * Method 'getTramiteGenericoById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteADHApertura
	 */
	@RequestMapping(value = "/findTramite/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody() TramiteADHApertura getTramiteById(@PathVariable() String idTramite,
			@ModelAttribute(value = "tramiteADHApertura") TramiteComun tramiteComun, HttpServletRequest request) {
		try {

			TramiteADHApertura tramite = new TramiteADHApertura();
			tramite.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramite = this.arbadhtramService.findTramiteApertura(tramite, censoMonitor);

			if (tramite == null) {
				throw new Exception(idTramite.toString());
			}

			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllDocsTramiteAcuerdoIncoacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocsTramite(
			@ModelAttribute(value = "tramiteADHApertura") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsFilter.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoAcuerdoIncoacion'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumento(@PathVariable() String thcodocumento,
			@ModelAttribute(value = "tramiteADHApertura") TramiteComun tramiteComun, HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody() String handle(ControlException e) {
		TramiteADHAperturaController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
