package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TipsubsanaService;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Tipsubsana;

/**
 * TipsubsanaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tipsubsana")
public class TipsubsanaController {

	private static final Logger logger = LoggerFactory
			.getLogger(TipsubsanaController.class);

	@Autowired
	private TipsubsanaService tipsubsanaService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TipsubsanaController.logger.info("[GET - View] : tipsubsana");
		return "tipsubsana";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tsid
	 *            String
	 * @return tipsubsana Tipsubsana
	 */
	@RequestMapping(value = "/{tsid}", method = RequestMethod.GET)
	public @ResponseBody
	Tipsubsana getById(@PathVariable String tsid) {
		Tipsubsana tipsubsana = new Tipsubsana();
		tipsubsana.setTsid(tsid);
		tipsubsana = this.tipsubsanaService.find(tipsubsana);
		TipsubsanaController.logger
				.info("[GET - findBy_PK] : Obtener Tipsubsana por PK");
		return tipsubsana;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTipsubsana
	 *            Tipsubsana
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Tipsubsana> getAll(@ModelAttribute Tipsubsana filterTipsubsana) {
		TipsubsanaController.logger
				.info("[GET - find_ALL] : Obtener Tipsubsana por filtro");
		return this.tipsubsanaService.findAll(filterTipsubsana, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Tipsubsana
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Tipsubsana edit(@RequestBody Tipsubsana tipsubsana) {
		Tipsubsana tipsubsanaAux = this.tipsubsanaService.update(tipsubsana);
		TipsubsanaController.logger
				.info("[PUT] : Tipsubsana actualizado correctamente");
		return tipsubsanaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Tipsubsana
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Tipsubsana add(@RequestBody Tipsubsana tipsubsana) {
		Tipsubsana tipsubsanaAux = this.tipsubsanaService.add(tipsubsana);
		TipsubsanaController.logger
				.info("[POST] : Tipsubsana insertado correctamente");
		return tipsubsanaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tsid
	 *            String
	 * @return tipsubsana
	 */
	@RequestMapping(value = "/{tsid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Tipsubsana remove(@PathVariable String tsid) {
		Tipsubsana tipsubsana = new Tipsubsana();
		tipsubsana.setTsid(tsid);
		this.tipsubsanaService.remove(tipsubsana);
		TipsubsanaController.logger
				.info("[DELETE] : Tipsubsana borrado correctamente");
		return tipsubsana;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tipsubsanaIds
	 *            List
	 * @return tipsubsanaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> tipsubsanaIds) {
		List<Tipsubsana> tipsubsanaList = new ArrayList<Tipsubsana>();
		for (List<String> tipsubsanaId : tipsubsanaIds) {
			Iterator<String> iterator = tipsubsanaId.iterator();
			Tipsubsana tipsubsana = new Tipsubsana(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			tipsubsana.setTsid(ObjectConversionManager.convert(iterator.next(),
					String.class));
			tipsubsanaList.add(tipsubsana);
		}
		this.tipsubsanaService.removeMultiple(tipsubsanaList);
		TipsubsanaController.logger
				.info("[POST - DELETE_ALL] : Tipsubsana borrados correctamente");
		return tipsubsanaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterTipsubsana
	 *            Tipsubsana
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Tipsubsana filterTipsubsana,
			@ModelAttribute Pagination pagination) {

		List<Tipsubsana> tipsubsanas = null;
		Long recordNum = 0L;
		if (filterTipsubsana.getTipsubsanaByTrid() != null) {
			tipsubsanas = this.tipsubsanaService.findAllPorTramite(
					filterTipsubsana, null);
			recordNum = Long.valueOf(tipsubsanas.size());
		} else {
			tipsubsanas = this.tipsubsanaService.findAll(filterTipsubsana,
					pagination);
			recordNum = this.tipsubsanaService.findAllCount(filterTipsubsana);
		}

		TipsubsanaController.logger.info("[GET - jqGrid] : Obtener Tipsubsana");
		return new JQGridJSONModel(pagination, recordNum, tipsubsanas);
	}

}
