package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TiposerroresService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Tiposerrores;

/**
 * TiposerroresController  
 *  
 */
 
@Controller
@RequestMapping (value = "/tiposerrores")

public class TiposerroresController  {

	private static final Logger logger = LoggerFactory.getLogger(TiposerroresController.class);

	@Autowired
	private TiposerroresService tiposerroresService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TiposerroresController.logger.info("[GET - View] : tiposerrores");
		return "tiposerrores";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param sjcodigo String
	 * @return tiposerrores Tiposerrores
	 */
	@RequestMapping(value = "/{sjcodigo}", method = RequestMethod.GET)
	public @ResponseBody Tiposerrores getById(@PathVariable String sjcodigo) {
        Tiposerrores tiposerrores = new Tiposerrores();
		tiposerrores.setSjcodigo(sjcodigo);
        tiposerrores = this.tiposerroresService.find(tiposerrores);
        TiposerroresController.logger.info("[GET - findBy_PK] : Obtener Tiposerrores por PK");
        return tiposerrores;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterTiposerrores Tiposerrores
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Tiposerrores> getAll(@ModelAttribute Tiposerrores filterTiposerrores) {
		TiposerroresController.logger.info("[GET - find_ALL] : Obtener Tiposerrores por filtro");
	    return this.tiposerroresService.findAll(filterTiposerrores, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param tiposerrores Tiposerrores 
	 * @return Tiposerrores
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Tiposerrores edit(@RequestBody Tiposerrores tiposerrores) {		
        Tiposerrores tiposerroresAux = this.tiposerroresService.update(tiposerrores);
		TiposerroresController.logger.info("[PUT] : Tiposerrores actualizado correctamente");
        return tiposerroresAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param tiposerrores Tiposerrores 
	 * @return Tiposerrores
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Tiposerrores add(@RequestBody Tiposerrores tiposerrores) {		
        Tiposerrores tiposerroresAux = this.tiposerroresService.add(tiposerrores);
        TiposerroresController.logger.info("[POST] : Tiposerrores insertado correctamente");
    	return tiposerroresAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param sjcodigo String
	 * @return tiposerrores
	 */
	@RequestMapping(value = "/{sjcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Tiposerrores remove(@PathVariable String sjcodigo) {
        Tiposerrores tiposerrores = new Tiposerrores();
        tiposerrores.setSjcodigo(sjcodigo);
        this.tiposerroresService.remove(tiposerrores);
       	TiposerroresController.logger.info("[DELETE] : Tiposerrores borrado correctamente");
       	return tiposerrores;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param tiposerroresIds List
	 * @return tiposerroresList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> tiposerroresIds) {
        List<Tiposerrores> tiposerroresList = new ArrayList<Tiposerrores>();
        for (List<String> tiposerroresId:tiposerroresIds) {
		    Iterator<String> iterator = tiposerroresId.iterator();
		    Tiposerrores tiposerrores = new Tiposerrores(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        tiposerrores.setSjcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    tiposerroresList.add(tiposerrores);
	    }
        this.tiposerroresService.removeMultiple(tiposerroresList);
		TiposerroresController.logger.info("[POST - DELETE_ALL] : Tiposerrores borrados correctamente");
		return tiposerroresIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterTiposerrores Tiposerrores
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Tiposerrores filterTiposerrores, @ModelAttribute Pagination pagination) {
        List<Tiposerrores> tiposerroress = this.tiposerroresService.findAll(filterTiposerrores, pagination);
        Long recordNum = this.tiposerroresService.findAllCount(filterTiposerrores);
        TiposerroresController.logger.info("[GET - jqGrid] : Obtener Tiposerrores");
		return new JQGridJSONModel(pagination, recordNum, tiposerroress);
	}
	
}	
