package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TipopronunciamentoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Tipopronunciamento;

/**
 * TipopronunciamentoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/tipopronunciamento")

public class TipopronunciamentoController  {

	private static final Logger logger = LoggerFactory.getLogger(TipopronunciamentoController.class);

	@Autowired
	private TipopronunciamentoService tipopronunciamentoService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TipopronunciamentoController.logger.info("[GET - View] : tipopronunciamento");
		return "tipopronunciamento";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param ttpcodigo String
	 * @return tipopronunciamento Tipopronunciamento
	 */
	@RequestMapping(value = "/{ttpcodigo}", method = RequestMethod.GET)
	public @ResponseBody Tipopronunciamento getById(@PathVariable String ttpcodigo) {
        Tipopronunciamento tipopronunciamento = new Tipopronunciamento();
		tipopronunciamento.setTtpcodigo(ttpcodigo);
        tipopronunciamento = this.tipopronunciamentoService.find(tipopronunciamento);
        TipopronunciamentoController.logger.info("[GET - findBy_PK] : Obtener Tipopronunciamento por PK");
        return tipopronunciamento;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterTipopronunciamento Tipopronunciamento
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Tipopronunciamento> getAll(@ModelAttribute Tipopronunciamento filterTipopronunciamento) {
		TipopronunciamentoController.logger.info("[GET - find_ALL] : Obtener Tipopronunciamento por filtro");
	    return this.tipopronunciamentoService.findAll(filterTipopronunciamento, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param tipopronunciamento Tipopronunciamento 
	 * @return Tipopronunciamento
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Tipopronunciamento edit(@RequestBody Tipopronunciamento tipopronunciamento) {		
        Tipopronunciamento tipopronunciamentoAux = this.tipopronunciamentoService.update(tipopronunciamento);
		TipopronunciamentoController.logger.info("[PUT] : Tipopronunciamento actualizado correctamente");
        return tipopronunciamentoAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param tipopronunciamento Tipopronunciamento 
	 * @return Tipopronunciamento
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Tipopronunciamento add(@RequestBody Tipopronunciamento tipopronunciamento) {		
        Tipopronunciamento tipopronunciamentoAux = this.tipopronunciamentoService.add(tipopronunciamento);
        TipopronunciamentoController.logger.info("[POST] : Tipopronunciamento insertado correctamente");
    	return tipopronunciamentoAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param ttpcodigo String
	 * @return tipopronunciamento
	 */
	@RequestMapping(value = "/{ttpcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Tipopronunciamento remove(@PathVariable String ttpcodigo) {
        Tipopronunciamento tipopronunciamento = new Tipopronunciamento();
        tipopronunciamento.setTtpcodigo(ttpcodigo);
        this.tipopronunciamentoService.remove(tipopronunciamento);
       	TipopronunciamentoController.logger.info("[DELETE] : Tipopronunciamento borrado correctamente");
       	return tipopronunciamento;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param tipopronunciamentoIds List
	 * @return tipopronunciamentoList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> tipopronunciamentoIds) {
        List<Tipopronunciamento> tipopronunciamentoList = new ArrayList<Tipopronunciamento>();
        for (List<String> tipopronunciamentoId:tipopronunciamentoIds) {
		    Iterator<String> iterator = tipopronunciamentoId.iterator();
		    Tipopronunciamento tipopronunciamento = new Tipopronunciamento(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        tipopronunciamento.setTtpcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    tipopronunciamentoList.add(tipopronunciamento);
	    }
        this.tipopronunciamentoService.removeMultiple(tipopronunciamentoList);
		TipopronunciamentoController.logger.info("[POST - DELETE_ALL] : Tipopronunciamento borrados correctamente");
		return tipopronunciamentoIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterTipopronunciamento Tipopronunciamento
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Tipopronunciamento filterTipopronunciamento, @ModelAttribute Pagination pagination) {
        List<Tipopronunciamento> tipopronunciamentos = this.tipopronunciamentoService.findAll(filterTipopronunciamento, pagination);
        Long recordNum = this.tipopronunciamentoService.findAllCount(filterTipopronunciamento);
        TipopronunciamentoController.logger.info("[GET - jqGrid] : Obtener Tipopronunciamento");
		return new JQGridJSONModel(pagination, recordNum, tipopronunciamentos);
	}
	
}	
