package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TipomovimientosService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Tipomovimientos;

/**
 * TipomovimientosController  
 *  
 */
 
@Controller
@RequestMapping (value = "/tipomovimientos")

public class TipomovimientosController  {

	private static final Logger logger = LoggerFactory.getLogger(TipomovimientosController.class);

	@Autowired
	private TipomovimientosService tipomovimientosService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TipomovimientosController.logger.info("[GET - View] : tipomovimientos");
		return "tipomovimientos";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param secodigo String
	 * @return tipomovimientos Tipomovimientos
	 */
	@RequestMapping(value = "/{secodigo}", method = RequestMethod.GET)
	public @ResponseBody Tipomovimientos getById(@PathVariable String secodigo) {
        Tipomovimientos tipomovimientos = new Tipomovimientos();
		tipomovimientos.setSecodigo(secodigo);
        tipomovimientos = this.tipomovimientosService.find(tipomovimientos);
        TipomovimientosController.logger.info("[GET - findBy_PK] : Obtener Tipomovimientos por PK");
        return tipomovimientos;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterTipomovimientos Tipomovimientos
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Tipomovimientos> getAll(@ModelAttribute Tipomovimientos filterTipomovimientos) {
		TipomovimientosController.logger.info("[GET - find_ALL] : Obtener Tipomovimientos por filtro");
	    return this.tipomovimientosService.findAll(filterTipomovimientos, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param tipomovimientos Tipomovimientos 
	 * @return Tipomovimientos
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Tipomovimientos edit(@RequestBody Tipomovimientos tipomovimientos) {		
        Tipomovimientos tipomovimientosAux = this.tipomovimientosService.update(tipomovimientos);
		TipomovimientosController.logger.info("[PUT] : Tipomovimientos actualizado correctamente");
        return tipomovimientosAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param tipomovimientos Tipomovimientos 
	 * @return Tipomovimientos
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Tipomovimientos add(@RequestBody Tipomovimientos tipomovimientos) {		
        Tipomovimientos tipomovimientosAux = this.tipomovimientosService.add(tipomovimientos);
        TipomovimientosController.logger.info("[POST] : Tipomovimientos insertado correctamente");
    	return tipomovimientosAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param secodigo String
	 * @return tipomovimientos
	 */
	@RequestMapping(value = "/{secodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Tipomovimientos remove(@PathVariable String secodigo) {
        Tipomovimientos tipomovimientos = new Tipomovimientos();
        tipomovimientos.setSecodigo(secodigo);
        this.tipomovimientosService.remove(tipomovimientos);
       	TipomovimientosController.logger.info("[DELETE] : Tipomovimientos borrado correctamente");
       	return tipomovimientos;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param tipomovimientosIds List
	 * @return tipomovimientosList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> tipomovimientosIds) {
        List<Tipomovimientos> tipomovimientosList = new ArrayList<Tipomovimientos>();
        for (List<String> tipomovimientosId:tipomovimientosIds) {
		    Iterator<String> iterator = tipomovimientosId.iterator();
		    Tipomovimientos tipomovimientos = new Tipomovimientos(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        tipomovimientos.setSecodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    tipomovimientosList.add(tipomovimientos);
	    }
        this.tipomovimientosService.removeMultiple(tipomovimientosList);
		TipomovimientosController.logger.info("[POST - DELETE_ALL] : Tipomovimientos borrados correctamente");
		return tipomovimientosIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterTipomovimientos Tipomovimientos
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Tipomovimientos filterTipomovimientos, @ModelAttribute Pagination pagination) {
        List<Tipomovimientos> tipomovimientoss = this.tipomovimientosService.findAll(filterTipomovimientos, pagination);
        Long recordNum = this.tipomovimientosService.findAllCount(filterTipomovimientos);
        TipomovimientosController.logger.info("[GET - jqGrid] : Obtener Tipomovimientos");
		return new JQGridJSONModel(pagination, recordNum, tipomovimientoss);
	}
	
}	
