package com.ejie.y41b.control;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TipoconceptopagoService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

import java.io.IOException;
import java.io.Writer;
import java.util.*;

import javax.servlet.http.*;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.*;

/**
 * TipoconceptopagoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tipoconceptopago")
public class TipoconceptopagoController {

	private static final Logger logger = LoggerFactory
			.getLogger(TipoconceptopagoController.class);

	@Autowired
	private TipoconceptopagoService tipoconceptopagoService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintConceptoIngreso", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TipoconceptopagoController.logger
				.info("[GET - View] : tipoconceptopago");
		return "tipoconceptopago";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sccodigo
	 *            String
	 * @return tipoconceptopago Tipoconceptopago
	 */
	@RequestMapping(value = "/{sccodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Tipoconceptopago getById(@PathVariable String sccodigo) {
		Tipoconceptopago tipoconceptopago = new Tipoconceptopago();
		tipoconceptopago.setSccodigo(sccodigo);
		tipoconceptopago = this.tipoconceptopagoService.find(tipoconceptopago);
		TipoconceptopagoController.logger
				.info("[GET - findBy_PK] : Obtener Tipoconceptopago por PK");
		return tipoconceptopago;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTipoconceptopago
	 *            Tipoconceptopago
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Tipoconceptopago> getAll(
			@ModelAttribute Tipoconceptopago filterTipoconceptopago) {
		TipoconceptopagoController.logger
				.info("[GET - find_ALL] : Obtener Tipoconceptopago por filtro");
		return this.tipoconceptopagoService.findAll(filterTipoconceptopago,
				null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @return Tipoconceptopago
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Tipoconceptopago edit(@RequestBody Tipoconceptopago tipoconceptopago) {
		Tipoconceptopago tipoconceptopagoAux = this.tipoconceptopagoService
				.update(tipoconceptopago);
		TipoconceptopagoController.logger
				.info("[PUT] : Tipoconceptopago actualizado correctamente");
		return tipoconceptopagoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @return Tipoconceptopago
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Tipoconceptopago add(@RequestBody Tipoconceptopago tipoconceptopago) {
		tipoconceptopago.setSccodigo(String.valueOf(tipoconceptopagoService
				.getNewPK()));
		Tipoconceptopago tipoconceptopagoAux = this.tipoconceptopagoService
				.add(tipoconceptopago);
		TipoconceptopagoController.logger
				.info("[POST] : Tipoconceptopago insertado correctamente");
		return tipoconceptopagoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param sccodigo
	 *            String
	 */
	@RequestMapping(value = "/eliminar/{sccodigo}", method = RequestMethod.POST)
	public @ResponseBody
	void remove(@PathVariable String sccodigo) {
		try {
			Tipoconceptopago tipoconceptopago = new Tipoconceptopago();
			tipoconceptopago.setSccodigo(sccodigo);
			this.tipoconceptopagoService.remove(tipoconceptopago);
			TipoconceptopagoController.logger
					.info("[DELETE] : Tipoconceptopago borrado correctamente");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException(
					"error.tipoconceptopago.DataIntegrityViolationException",
					true, e);
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tipoconceptopagoIds
	 *            List
	 * @return tipoconceptopagoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> tipoconceptopagoIds) {
		List<Tipoconceptopago> tipoconceptopagoList = new ArrayList<Tipoconceptopago>();
		for (List<String> tipoconceptopagoId : tipoconceptopagoIds) {
			Iterator<String> iterator = tipoconceptopagoId.iterator();
			Tipoconceptopago tipoconceptopago = new Tipoconceptopago(); // NOPMD
																		// -
																		// Objeto
																		// nuevo
																		// en la
																		// lista
																		// (parametro
																		// del
																		// servicio)
			tipoconceptopago.setSccodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			tipoconceptopagoList.add(tipoconceptopago);
		}
		this.tipoconceptopagoService.removeMultiple(tipoconceptopagoList);
		TipoconceptopagoController.logger
				.info("[POST - DELETE_ALL] : Tipoconceptopago borrados correctamente");
		return tipoconceptopagoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterTipoconceptopago
	 *            Tipoconceptopago
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute Tipoconceptopago filterTipoconceptopago,
			@ModelAttribute Pagination pagination) {
		List<Tipoconceptopago> tipoconceptopagos = this.tipoconceptopagoService
				.findAll(filterTipoconceptopago, pagination);
		Long recordNum = this.tipoconceptopagoService
				.findAllCount(filterTipoconceptopago);
		TipoconceptopagoController.logger
				.info("[GET - jqGrid] : Obtener Tipoconceptopago");
		return new JQGridJSONModel(pagination, recordNum, tipoconceptopagos);
	}

	/**
	 * Method 'getCreateFormAltaDecision'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		model.addAttribute("sccodigo", "");
		if (censoMonitor.getPerfilEconomico() == null
				|| censoMonitor.getPerfilEconomico().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleTipoconceptopago", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAltaDecision'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/modificacion/{sccodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable String sccodigo,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("sccodigo", sccodigo);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilEconomico() == null
				|| censoMonitor.getPerfilEconomico().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleTipoconceptopago", "model", model);
		}
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'comboConceptoIngreso'.
	 * 
	 * @return List
	 */
	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody
	List<Tipoconceptopago> comboConceptoIngreso(HttpServletRequest request) {

		Tipoconceptopago tipoconceptopago = new Tipoconceptopago();
		/*
		 * desde la ficha de expedientes
		 */
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("scdesces");
		} else {
			pagination.setSort("scdesceu");
		}
		pagination.setAscDsc("ASC");

		if (!"".equalsIgnoreCase((String) request
				.getParameter("y41bConceptoPagoDetalleClaseIngreso"))
				&& null != (String) request
						.getParameter("y41bConceptoPagoDetalleClaseIngreso")) {
			String slcodigo = (String) request
					.getParameter("y41bConceptoPagoDetalleClaseIngreso");
			tipoconceptopago.setClaseingreso(new Claseingreso(slcodigo, null,
					null));
		}

		return tipoconceptopagoService.findAll(tipoconceptopago, pagination);
	}
}
