package com.ejie.y41b.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TipoReclamacionService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TipoReclamacion;

/**
 * * TipoReclamacionController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tiporeclamacion")
public class TipoReclamacionController {

	private static final Logger logger = LoggerFactory
			.getLogger(TipoReclamacionController.class);

	@Autowired
	private TipoReclamacionService tipoReclamacionService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {

			return new ModelAndView("tiporeclamacion", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tsrcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{tsrcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	TipoReclamacion getById(@PathVariable String tsrcodigo) {
		try {
			TipoReclamacion tipoReclamacion = new TipoReclamacion();
			tipoReclamacion.setTsrcodigo(tsrcodigo);
			tipoReclamacion = this.tipoReclamacionService.find(tipoReclamacion);
			if (tipoReclamacion == null) {
				throw new Exception(tsrcodigo.toString());
			}
			return tipoReclamacion;
		} catch (Exception e) {
			throw new ResourceNotFoundException(tsrcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param tsrcodigo
	 *            String
	 * @param tsrnombre
	 *            String
	 * @param tsrnombree
	 *            String
	 * @param tsrnombrei
	 *            String
	 * @param tsrnombref
	 *            String
	 * @param tsrnombrea
	 *            String
	 * @param tsrimporte
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "tsrcodigo", required = false) String tsrcodigo,
			@RequestParam(value = "tsrnombre", required = false) String tsrnombre,
			@RequestParam(value = "tsrnombree", required = false) String tsrnombree,
			@RequestParam(value = "tsrnombrei", required = false) String tsrnombrei,
			@RequestParam(value = "tsrnombref", required = false) String tsrnombref,
			@RequestParam(value = "tsrnombrea", required = false) String tsrnombrea,
			@RequestParam(value = "tsrimporte", required = false) String tsrimporte,
			HttpServletRequest request) {
		try {
			TipoReclamacion filterTipoReclamacion = new TipoReclamacion(
					tsrcodigo, tsrnombre, tsrnombree, tsrnombrei, tsrnombref,
					tsrnombrea, tsrimporte);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipoReclamacion> tipoReclamacions = this.tipoReclamacionService
						.findAll(filterTipoReclamacion, pagination);

				if (tipoReclamacions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterTipoReclamacion, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipoReclamacions);
				return data;
			} else {
				List<TipoReclamacion> tipoReclamacions = this.tipoReclamacionService
						.findAll(filterTipoReclamacion, pagination);
				if (tipoReclamacions == null) {
					throw new Exception("No data Found.");
				}
				return tipoReclamacions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllAlta'.
	 * 
	 * @param tsrcodigo
	 *            String
	 * @param tsrnombre
	 *            String
	 * @param tsrnombree
	 *            String
	 * @param tsrnombrei
	 *            String
	 * @param tsrnombref
	 *            String
	 * @param tsrnombrea
	 *            String
	 * @param tsrimporte
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/tiporeclamacionAlta", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllAlta(
			@RequestParam(value = "tsrcodigo", required = false) String tsrcodigo,
			@RequestParam(value = "tsrnombre", required = false) String tsrnombre,
			@RequestParam(value = "tsrnombree", required = false) String tsrnombree,
			@RequestParam(value = "tsrnombrei", required = false) String tsrnombrei,
			@RequestParam(value = "tsrnombref", required = false) String tsrnombref,
			@RequestParam(value = "tsrnombrea", required = false) String tsrnombrea,
			@RequestParam(value = "tsrimporte", required = false) String tsrimporte,
			HttpServletRequest request) {
		try {
			TipoReclamacion filterTipoReclamacion = new TipoReclamacion(
					tsrcodigo, tsrnombre, tsrnombree, tsrnombrei, tsrnombref,
					tsrnombrea, tsrimporte);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipoReclamacion> tipoReclamacions = this.tipoReclamacionService
						.findAllAlta(filterTipoReclamacion, pagination);

				if (tipoReclamacions == null) {
					throw new Exception("No data Found.");
				}

				Long total = tipoReclamacionService
						.findAllAltaCount(filterTipoReclamacion);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipoReclamacions);
				return data;
			} else {
				List<TipoReclamacion> tipoReclamacions = this.tipoReclamacionService
						.findAllAlta(filterTipoReclamacion, pagination);
				if (tipoReclamacions == null) {
					throw new Exception("No data Found.");
				}
				return tipoReclamacions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTipoReclamacion
	 *            TipoReclamacion
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "tipoReclamacion", required = false) TipoReclamacion filterTipoReclamacion,
			HttpServletRequest request) {
		try {
			return tipoReclamacionService
					.findAllCount(filterTipoReclamacion != null ? filterTipoReclamacion
							: new TipoReclamacion());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param response
	 *            HttpServletResponse
	 * @return TipoReclamacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	TipoReclamacion edit(@RequestBody TipoReclamacion tipoReclamacion,
			HttpServletResponse response) {
		try {
			TipoReclamacion tipoReclamacionAux = this.tipoReclamacionService
					.update(tipoReclamacion);
			logger.info("Entity correctly inserted!");
			return tipoReclamacionAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	TipoReclamacion add(@RequestBody TipoReclamacion tipoReclamacion) {
		try {
			TipoReclamacion tipoReclamacionAux = this.tipoReclamacionService
					.add(tipoReclamacion);
			logger.info("Entity correctly inserted!");
			return tipoReclamacionAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tsrcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{tsrcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String tsrcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			TipoReclamacion tipoReclamacion = new TipoReclamacion();
			tipoReclamacion.setTsrcodigo(tsrcodigo);
			this.tipoReclamacionService.remove(tipoReclamacion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + tsrcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tipoReclamacionIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> tipoReclamacionIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<TipoReclamacion> tipoReclamacionList = new ArrayList<TipoReclamacion>();
		try {
			for (ArrayList<String> tipoReclamacionId : tipoReclamacionIds) {
				Iterator<String> iterator = tipoReclamacionId.iterator();
				TipoReclamacion tipoReclamacion = new TipoReclamacion();
				tipoReclamacion.setTsrcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				tipoReclamacionList.add(tipoReclamacion);
			}
			this.tipoReclamacionService.removeMultiple(tipoReclamacionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipoReclamacionService'.
	 * 
	 * @return TipoReclamacionService
	 */
	protected TipoReclamacionService getTipoReclamacionService() {
		return this.tipoReclamacionService;
	}

	/**
	 * Method 'setTipoReclamacionService'.
	 * 
	 * @param tipoReclamacionService
	 *            TipoReclamacionService
	 * @return
	 */
	public void setTipoReclamacionService(
			TipoReclamacionService tipoReclamacionService) {
		this.tipoReclamacionService = tipoReclamacionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'comboTipoReclamacion'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody()
	List<TipoReclamacion> comboTipoReclamacion(HttpServletRequest request) {

		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();
		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("tsrnombre");
		} else {
			pagination.setSort("tsrnombree");
		}
		pagination.setAscDsc("DESC");
		return this.tipoReclamacionService.findAll(new TipoReclamacion(),
				pagination);
	}
}
