package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.service.TipoProcedimientoService;

/**
 * TipoProcedimientoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tipoprocedimiento")
public class TipoProcedimientoController {

	private static final Logger logger = LoggerFactory.getLogger(TipoProcedimientoController.class);

	@Autowired
	private TipoProcedimientoService tipoProcedimientoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TipoProcedimientoController.logger.info("[GET - View] : tipoprocedimiento");
		return "tipoprocedimiento";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param pcodigo
	 *            String
	 * @return tipoProcedimiento TipoProcedimiento
	 */
	@RequestMapping(value = "/{pcodigo}", method = RequestMethod.GET)
	public @ResponseBody TipoProcedimiento getById(@PathVariable String pcodigo) {
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(pcodigo);
		tipoProcedimiento = this.tipoProcedimientoService.find(tipoProcedimiento);
		TipoProcedimientoController.logger.info("[GET - findBy_PK] : Obtener TipoProcedimiento por PK");
		return tipoProcedimiento;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTipoProcedimiento
	 *            TipoProcedimiento
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TipoProcedimiento> getAll(@ModelAttribute TipoProcedimiento filterTipoProcedimiento) {
		TipoProcedimientoController.logger.info("[GET - find_ALL] : Obtener TipoProcedimiento por filtro");
		return this.tipoProcedimientoService.findAll(filterTipoProcedimiento, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return TipoProcedimiento
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody TipoProcedimiento edit(@RequestBody TipoProcedimiento tipoProcedimiento) {
		TipoProcedimiento tipoProcedimientoAux = this.tipoProcedimientoService.update(tipoProcedimiento);
		TipoProcedimientoController.logger.info("[PUT] : TipoProcedimiento actualizado correctamente");
		return tipoProcedimientoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return TipoProcedimiento
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipoProcedimiento add(@RequestBody TipoProcedimiento tipoProcedimiento) {
		TipoProcedimiento tipoProcedimientoAux = this.tipoProcedimientoService.add(tipoProcedimiento);
		TipoProcedimientoController.logger.info("[POST] : TipoProcedimiento insertado correctamente");
		return tipoProcedimientoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param pcodigo
	 *            String
	 * @return tipoProcedimiento
	 */
	@RequestMapping(value = "/{pcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody TipoProcedimiento remove(@PathVariable String pcodigo) {
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(pcodigo);
		this.tipoProcedimientoService.remove(tipoProcedimiento);
		TipoProcedimientoController.logger.info("[DELETE] : TipoProcedimiento borrado correctamente");
		return tipoProcedimiento;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tipoProcedimientoIds
	 *            List
	 * @return tipoProcedimientoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> tipoProcedimientoIds) {
		List<TipoProcedimiento> tipoProcedimientoList = new ArrayList<TipoProcedimiento>();
		for (List<String> tipoProcedimientoId : tipoProcedimientoIds) {
			Iterator<String> iterator = tipoProcedimientoId.iterator();
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento(); // NOPMD
																			// -
																			// Objeto
																			// nuevo
																			// en
																			// la
																			// lista
																			// (parametro
																			// del
																			// servicio)
			tipoProcedimiento.setPcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
			tipoProcedimientoList.add(tipoProcedimiento);
		}
		this.tipoProcedimientoService.removeMultiple(tipoProcedimientoList);
		TipoProcedimientoController.logger.info("[POST - DELETE_ALL] : TipoProcedimiento borrados correctamente");
		return tipoProcedimientoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterTipoProcedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute TipoProcedimiento filterTipoProcedimiento,
			@ModelAttribute Pagination pagination) {
		List<TipoProcedimiento> tipoProcedimientos = this.tipoProcedimientoService.findAll(filterTipoProcedimiento,
				pagination);
		Long recordNum = this.tipoProcedimientoService.findAllCount(filterTipoProcedimiento);
		TipoProcedimientoController.logger.info("[GET - jqGrid] : Obtener TipoProcedimiento");
		return new JQGridJSONModel(pagination, recordNum, tipoProcedimientos);
	}

	// /**
	// * Method 'getAllTramite'.
	// *
	// * @param pcodigo
	// * String
	// * @param pnombre
	// * String
	// * @param pnombree
	// * String
	// * @param pbaja
	// * Date
	// * @param request
	// * HttpServletRequest
	// * @return String
	// */
	// @RequestMapping(value = "/getAllTipoProcedimiento", method =
	// RequestMethod.GET)
	// public @ResponseBody
	// Object getAllTramite(
	// @RequestParam(value = "pcodigo", required = false) String pcodigo,
	// @RequestParam(value = "pnombre", required = false) String pnombre,
	// @RequestParam(value = "pnombree", required = false) String pnombree,
	// @RequestParam(value = "pbaja", required = false) Date pbaja,
	// HttpServletRequest request) {
	// try {
	//
	// TipoProcedimiento filterTipoProcedimiento = new TipoProcedimiento(
	// pcodigo, pnombre, pnombree, pbaja);
	//
	// Pagination pagination = null;
	// if (request.getHeader("JQGridModel") != null
	// && request.getHeader("JQGridModel").equals("true")) {
	// pagination = new Pagination();
	// pagination.setPage(Long.valueOf(request.getParameter("page")));
	// pagination.setRows(Long.valueOf(request.getParameter("rows")));
	// pagination.setSort(request.getParameter("sidx"));
	// pagination.setAscDsc(request.getParameter("sord"));
	// List<TipoProcedimiento> plantillaTramitesBusqueda =
	// this.tipoProcedimientoService
	// .findAllLike(filterTipoProcedimiento, pagination, null);
	//
	// if (plantillaTramitesBusqueda == null) {
	// throw new Exception("No data Found.");
	// }
	//
	// Long total = getAllCountTipoProcedimiento(
	// filterTipoProcedimiento, null);
	// JQGridJSONModel data = new JQGridJSONModel();
	// data.setPage(request.getParameter("page"));
	// data.setRecords(total.intValue());
	// data.setTotal(total, pagination.getRows());
	// data.setRows(plantillaTramitesBusqueda);
	// return data;
	// } else {
	// List<TipoProcedimiento> plantillaTramitesBusqueda =
	// this.tipoProcedimientoService
	// .findAllLike(filterTipoProcedimiento, pagination, null);
	// if (plantillaTramitesBusqueda == null) {
	// throw new Exception("No data Found.");
	// }
	// return plantillaTramitesBusqueda;
	// }
	// } catch (Exception e) {
	// throw new ResourceNotFoundException("No data Found.");
	// }
	// }
	//
	// /**
	// * Method 'getAllCountTipoProcedimiento'.
	// *
	// * @param filterTipoProcedimiento
	// * TipoProcedimiento
	// * @param request
	// * HttpServletRequest
	// * @return Long
	// */
	// @RequestMapping(value = "/count", method = RequestMethod.GET)
	// public @ResponseBody
	// Long getAllCountTipoProcedimiento(
	// @RequestParam(value = "tipoProcedimiento", required = false)
	// TipoProcedimiento filterTipoProcedimiento,
	// HttpServletRequest request) {
	// try {
	// return tipoProcedimientoService.findAllLikeCount(
	// filterTipoProcedimiento != null ? filterTipoProcedimiento
	// : new TipoProcedimiento(), null);
	// } catch (Exception e) {
	// throw new ServiceUnavailableException(
	// "Count Service is not responding.");
	// }
	// }

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTipoProcedimiento
	 *            TipoProcedimiento
	 * @return List
	 */
	@RequestMapping(value = "/getAllTipoProcedimiento", method = RequestMethod.GET)
	public @ResponseBody List<TipoProcedimiento> getAllTipoProcedimiento(
			@ModelAttribute TipoProcedimiento filterTipoProcedimiento) {
		TipoProcedimientoController.logger.info("[GET - find_ALL] : Obtener TipoProcedimiento por filtro");
		return this.tipoProcedimientoService.findAll(filterTipoProcedimiento, null);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTipoProcedimiento
	 *            TipoProcedimiento
	 * @return List
	 */
	@RequestMapping(value = "/getAllTipoProcedimientoConRemesa", method = RequestMethod.GET)
	public @ResponseBody List<TipoProcedimiento> getAllTipoProcedimientoConRemesa(
			@ModelAttribute TipoProcedimiento filterTipoProcedimiento) {
		TipoProcedimientoController.logger.info("[GET - find_ALL] : Obtener TipoProcedimiento por filtro");
		return this.tipoProcedimientoService.findAllConRemesa(filterTipoProcedimiento, null);
	}

	/**
	 * Method 'getAllTipoProcRelExp'.
	 * 
	 * @param filterTipoProcedimiento
	 *            TipoProcedimiento
	 * @return List
	 */
	@RequestMapping(value = "/getAllTipoProcRelExp/{origen}", method = RequestMethod.GET)
	public @ResponseBody List<TipoProcedimiento> getAllTipoProcRelExp(@PathVariable String origen,
			@ModelAttribute TipoProcedimiento filterTipoProcedimiento) {
		TipoProcedimientoController.logger.info("[GET - find_ALL] : Obtener TipoProcedimiento por filtro");
		List<TipoProcedimiento> lista = this.tipoProcedimientoService.findAll(filterTipoProcedimiento, null);
		if (Y41bConstantes.VALOR_SI.equals(origen) || "A".equals(origen)) {
			// Esto es para nuevo Sancionador
			for (int i = 0; i < lista.size(); i++) {
				if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(lista.get(i).getPcodigo())) {
					lista.remove(i);
					break;
				}
			}
		}
		// for (int i = 0; i < lista.size(); i++) {
		// if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(lista.get(i)
		// .getPcodigo())) {
		// lista.remove(i);
		// break;
		// }
		// }
		for (int i = 0; i < lista.size(); i++) {
			if (Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(lista.get(i).getPcodigo())) {
				lista.remove(i);
				break;
			}
		}
		for (int i = 0; i < lista.size(); i++) {
			if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(lista.get(i).getPcodigo())) {
				lista.remove(i);
				break;
			}
		}
		for (int i = 0; i < lista.size(); i++) {
			if (Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(lista.get(i).getPcodigo())) {
				lista.remove(i);
				break;
			}
		}
		for (int i = 0; i < lista.size(); i++) {
			if (Y41bConstantes.TIPO_PROC_ESTABLECIMIENTO.equals(lista.get(i).getPcodigo())) {
				lista.remove(i);
				break;
			}
		}
		return lista;
	}

	// EVOLUTIVO 0150942
	@RequestMapping(value = "/getAllTipoProcedimientoComboSanciones", method = RequestMethod.GET)
	public @ResponseBody List<TipoProcedimiento> getAllTipoProcedimientoComboSanciones(
			@ModelAttribute TipoProcedimiento filterTipoProcedimiento) {
		TipoProcedimientoController.logger.info("[GET - find_ALL] : Obtener TipoProcedimiento por filtro");
		List<TipoProcedimiento> listaCombo = this.tipoProcedimientoService.findAllCombo(filterTipoProcedimiento, null);
		TipoProcedimiento tipoDenunciaEmpresa = new TipoProcedimiento();
		tipoDenunciaEmpresa.setPcodigo("DEN");
		tipoDenunciaEmpresa.setPnombre("Denuncia de empresa");
		listaCombo.add(tipoDenunciaEmpresa);

		return listaCombo;
	}
	// EVOLUTIVO 0150942

	/**
	 * Finds a List of rows in the TipoProcedimiento table. Para el combo de
	 * avisos multiple en establecimiento
	 * 
	 * @param filterTipoProcedimiento
	 *            TipoProcedimiento
	 * @return List
	 */
	@RequestMapping(value = "/findAllProcAvisos", method = RequestMethod.GET)
	public @ResponseBody List<TipoProcedimiento> getAllTipoProcedimientoAvisos() {
		TipoProcedimientoController.logger.info("[GET - find_ALL] : Obtener TipoProcedimiento por filtro");
		return this.tipoProcedimientoService.findAllProcAvisos();
	}

}
