package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TipoInfraccionAgrupado;
import com.ejie.y41b.service.TipoInfraccionAgrupadoService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * TipoInfraccionAgrupadoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tipoinfraccionagrupado")
@SessionAttributes({ "codTipoInfraccionAgrupado",
		"modoBusquedaTipoInfraccionAgrupado", "modoTipoInfraccionAgrupado" })
public class TipoInfraccionAgrupadoController {

	private static final Logger logger = LoggerFactory
			.getLogger(TipoInfraccionAgrupadoController.class);

	@Autowired
	private TipoInfraccionAgrupadoService tipoInfraccionAgrupadoService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "tiposinfraccionesagrupados", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model,
			HttpServletRequest request) {

		model.addAttribute("modoBusquedaTipoInfraccionAgrupado", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("tiposinfraccionesagrupados", "model",
					model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionTipoinfraccionagrupado", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {

		model.addAttribute("modoBusquedaTipoInfraccionAgrupado",
				Y41bConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("seleccionTipoinfraccionagrupado", "model",
				model);
	}

	/**
	 * Method 'getCreateFormAltaProdagrupado'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaTipoinfraccionagrupado", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaProdagrupado(Model model,
			HttpServletRequest request) {

		model.addAttribute("codTipoInfraccionAgrupado", Y41bUIDGenerator
				.getInstance().generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoTipoInfraccionAgrupado",
				Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleTipoinfraccionagrupado", "model",
					model);
		}
	}

	/**
	 * Method 'getCreateFormModProdagrupado'.
	 * 
	 * @param codTipoInfraccionAgrupado
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modTipoInfraccionAgrupado/{codTipoInfraccionAgrupado}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModProdagrupado(
			@PathVariable String codTipoInfraccionAgrupado, Model model,
			HttpServletRequest request) {

		model.addAttribute("codTipoInfraccionAgrupado",
				codTipoInfraccionAgrupado);

		model.addAttribute("modoTipoInfraccionAgrupado",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleTipoinfraccionagrupado", "model",
					model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param l4codigo
	 *            String
	 * @return tipoInfraccionAgrupado TipoInfraccionAgrupado
	 */
	@RequestMapping(value = "/{l4codigo}", method = RequestMethod.GET)
	public @ResponseBody
	TipoInfraccionAgrupado getById(@PathVariable String l4codigo) {
		TipoInfraccionAgrupado tipoInfraccionAgrupado = new TipoInfraccionAgrupado();
		tipoInfraccionAgrupado.setL4codigo(l4codigo);
		tipoInfraccionAgrupado = this.tipoInfraccionAgrupadoService
				.find(tipoInfraccionAgrupado);
		TipoInfraccionAgrupadoController.logger
				.info("[GET - findBy_PK] : Obtener TipoInfraccionAgrupado por PK");
		return tipoInfraccionAgrupado;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTipoInfraccionAgrupado
	 *            TipoInfraccionAgrupado
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<TipoInfraccionAgrupado> getAll(
			@ModelAttribute TipoInfraccionAgrupado filterTipoInfraccionAgrupado) {
		TipoInfraccionAgrupadoController.logger
				.info("[GET - find_ALL] : Obtener TipoInfraccionAgrupado por filtro");
		return this.tipoInfraccionAgrupadoService.findAll(
				filterTipoInfraccionAgrupado, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tipoInfraccionAgrupado
	 *            TipoInfraccionAgrupado
	 * @return TipoInfraccionAgrupado
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	TipoInfraccionAgrupado edit(
			@RequestBody TipoInfraccionAgrupado tipoInfraccionAgrupado) {
		TipoInfraccionAgrupado tipoInfraccionAgrupadoAux = this.tipoInfraccionAgrupadoService
				.update(tipoInfraccionAgrupado);
		TipoInfraccionAgrupadoController.logger
				.info("[PUT] : TipoInfraccionAgrupado actualizado correctamente");
		return tipoInfraccionAgrupadoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tipoInfraccionAgrupado
	 *            TipoInfraccionAgrupado
	 * @return TipoInfraccionAgrupado
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	TipoInfraccionAgrupado add(
			@RequestBody TipoInfraccionAgrupado tipoInfraccionAgrupado) {
		TipoInfraccionAgrupado tipoInfraccionAgrupadoAux = this.tipoInfraccionAgrupadoService
				.add(tipoInfraccionAgrupado);
		TipoInfraccionAgrupadoController.logger
				.info("[POST] : TipoInfraccionAgrupado insertado correctamente");
		return tipoInfraccionAgrupadoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param l4codigo
	 *            String
	 * @return tipoInfraccionAgrupado
	 */
	@RequestMapping(value = "/{l4codigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	TipoInfraccionAgrupado remove(@PathVariable String l4codigo) {
		TipoInfraccionAgrupado tipoInfraccionAgrupado = new TipoInfraccionAgrupado();
		tipoInfraccionAgrupado.setL4codigo(l4codigo);
		this.tipoInfraccionAgrupadoService.remove(tipoInfraccionAgrupado);
		TipoInfraccionAgrupadoController.logger
				.info("[DELETE] : TipoInfraccionAgrupado borrado correctamente");
		return tipoInfraccionAgrupado;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tipoInfraccionAgrupadoIds
	 *            List
	 * @return tipoInfraccionAgrupadoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> tipoInfraccionAgrupadoIds) {
		List<TipoInfraccionAgrupado> tipoInfraccionAgrupadoList = new ArrayList<TipoInfraccionAgrupado>();
		for (List<String> tipoInfraccionAgrupadoId : tipoInfraccionAgrupadoIds) {
			Iterator<String> iterator = tipoInfraccionAgrupadoId.iterator();
			TipoInfraccionAgrupado tipoInfraccionAgrupado = new TipoInfraccionAgrupado(); // NOPMD
																							// -
																							// Objeto
																							// nuevo
																							// en
																							// la
																							// lista
																							// (parametro
																							// del
																							// servicio)
			tipoInfraccionAgrupado.setL4codigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			tipoInfraccionAgrupadoList.add(tipoInfraccionAgrupado);
		}
		this.tipoInfraccionAgrupadoService
				.removeMultiple(tipoInfraccionAgrupadoList);
		TipoInfraccionAgrupadoController.logger
				.info("[POST - DELETE_ALL] : TipoInfraccionAgrupado borrados correctamente");
		return tipoInfraccionAgrupadoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterTipoInfraccionAgrupado
	 *            TipoInfraccionAgrupado
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute TipoInfraccionAgrupado filterTipoInfraccionAgrupado,
			@ModelAttribute Pagination pagination) {
		List<TipoInfraccionAgrupado> tipoInfraccionAgrupados = this.tipoInfraccionAgrupadoService
				.findAll(filterTipoInfraccionAgrupado, pagination);
		Long recordNum = this.tipoInfraccionAgrupadoService
				.findAllCount(filterTipoInfraccionAgrupado);
		TipoInfraccionAgrupadoController.logger
				.info("[GET - jqGrid] : Obtener TipoInfraccionAgrupado");
		return new JQGridJSONModel(pagination, recordNum,
				tipoInfraccionAgrupados);
	}

	/**
	 * Method 'getAllTipoInfraccionAgrupado'. de tipo like
	 * 
	 * @param l4codigo_
	 *            String
	 * @param l4nombre_
	 *            String
	 * @param l4nombree_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllTipoInfraccionAgrupado(
			@RequestParam(value = "l4codigo", required = false) String l4codigo_,
			@RequestParam(value = "l4nombre", required = false) String l4nombre_,
			@RequestParam(value = "l4nombree", required = false) String l4nombree_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String l4codigo = ("".equals(l4codigo_)) ? null : l4codigo_;
			String l4nombre = null;
			String l4nombree = null;

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				l4nombre = ("".equals(l4nombre_)) ? null : l4nombre_;
			} else {
				l4nombree = ("".equals(l4nombre_)) ? null : l4nombre_;
			}

			TipoInfraccionAgrupado filterTipoInfraccionAgrupado = new TipoInfraccionAgrupado(
					l4codigo, l4nombre, l4nombree, null, null);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipoInfraccionAgrupado> tipoInfraccionAgrupados = this.tipoInfraccionAgrupadoService
						.findAllLike(filterTipoInfraccionAgrupado, pagination,
								false);

				if (tipoInfraccionAgrupados == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.tipoInfraccionAgrupadoService
						.findAllLikeCount(filterTipoInfraccionAgrupado, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipoInfraccionAgrupados);
				return data;
			} else {
				List<TipoInfraccionAgrupado> tipoInfraccionAgrupados = this.tipoInfraccionAgrupadoService
						.findAllLike(filterTipoInfraccionAgrupado, pagination,
								false);
				if (tipoInfraccionAgrupados == null) {
					throw new Exception("No data Found.");
				}
				return tipoInfraccionAgrupados;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

}
