package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TipoDocumentoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.TipoDocumento;

/**
 * TipoDocumentoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/tipodocumento")

public class TipoDocumentoController  {

	private static final Logger logger = LoggerFactory.getLogger(TipoDocumentoController.class);

	@Autowired
	private TipoDocumentoService tipoDocumentoService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TipoDocumentoController.logger.info("[GET - View] : tipodocumento");
		return "tipodocumento";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param idTipodoc String
	 * @return tipoDocumento TipoDocumento
	 */
	@RequestMapping(value = "/{idTipodoc}", method = RequestMethod.GET)
	public @ResponseBody TipoDocumento getById(@PathVariable String idTipodoc) {
        TipoDocumento tipoDocumento = new TipoDocumento();
		tipoDocumento.setIdTipodoc(idTipodoc);
        tipoDocumento = this.tipoDocumentoService.find(tipoDocumento);
        TipoDocumentoController.logger.info("[GET - findBy_PK] : Obtener TipoDocumento por PK");
        return tipoDocumento;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterTipoDocumento TipoDocumento
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TipoDocumento> getAll(@ModelAttribute TipoDocumento filterTipoDocumento) {
		TipoDocumentoController.logger.info("[GET - find_ALL] : Obtener TipoDocumento por filtro");
	    return this.tipoDocumentoService.findAll(filterTipoDocumento, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param tipoDocumento TipoDocumento 
	 * @return TipoDocumento
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody TipoDocumento edit(@RequestBody TipoDocumento tipoDocumento) {		
        TipoDocumento tipoDocumentoAux = this.tipoDocumentoService.update(tipoDocumento);
		TipoDocumentoController.logger.info("[PUT] : TipoDocumento actualizado correctamente");
        return tipoDocumentoAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param tipoDocumento TipoDocumento 
	 * @return TipoDocumento
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipoDocumento add(@RequestBody TipoDocumento tipoDocumento) {		
        TipoDocumento tipoDocumentoAux = this.tipoDocumentoService.add(tipoDocumento);
        TipoDocumentoController.logger.info("[POST] : TipoDocumento insertado correctamente");
    	return tipoDocumentoAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param idTipodoc String
	 * @return tipoDocumento
	 */
	@RequestMapping(value = "/{idTipodoc}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody TipoDocumento remove(@PathVariable String idTipodoc) {
        TipoDocumento tipoDocumento = new TipoDocumento();
        tipoDocumento.setIdTipodoc(idTipodoc);
        this.tipoDocumentoService.remove(tipoDocumento);
       	TipoDocumentoController.logger.info("[DELETE] : TipoDocumento borrado correctamente");
       	return tipoDocumento;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param tipoDocumentoIds List
	 * @return tipoDocumentoList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> tipoDocumentoIds) {
        List<TipoDocumento> tipoDocumentoList = new ArrayList<TipoDocumento>();
        for (List<String> tipoDocumentoId:tipoDocumentoIds) {
		    Iterator<String> iterator = tipoDocumentoId.iterator();
		    TipoDocumento tipoDocumento = new TipoDocumento(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        tipoDocumento.setIdTipodoc(ObjectConversionManager.convert(iterator.next(), String.class));
		    tipoDocumentoList.add(tipoDocumento);
	    }
        this.tipoDocumentoService.removeMultiple(tipoDocumentoList);
		TipoDocumentoController.logger.info("[POST - DELETE_ALL] : TipoDocumento borrados correctamente");
		return tipoDocumentoIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterTipoDocumento TipoDocumento
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute TipoDocumento filterTipoDocumento, @ModelAttribute Pagination pagination) {
        List<TipoDocumento> tipoDocumentos = this.tipoDocumentoService.findAll(filterTipoDocumento, pagination);
        Long recordNum = this.tipoDocumentoService.findAllCount(filterTipoDocumento);
        TipoDocumentoController.logger.info("[GET - jqGrid] : Obtener TipoDocumento");
		return new JQGridJSONModel(pagination, recordNum, tipoDocumentos);
	}
	
}	
