package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TipoCaracterAlertaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.TipoCaracterAlerta;

/**
 * TipoCaracterAlertaController  
 *  
 */
 
@Controller
@RequestMapping (value = "/tipocaracteralerta")

public class TipoCaracterAlertaController  {

	private static final Logger logger = LoggerFactory.getLogger(TipoCaracterAlertaController.class);

	@Autowired
	private TipoCaracterAlertaService tipoCaracterAlertaService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TipoCaracterAlertaController.logger.info("[GET - View] : tipocaracteralerta");
		return "tipocaracteralerta";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param tcacodigo String
	 * @return tipoCaracterAlerta TipoCaracterAlerta
	 */
	@RequestMapping(value = "/{tcacodigo}", method = RequestMethod.GET)
	public @ResponseBody TipoCaracterAlerta getById(@PathVariable String tcacodigo) {
        TipoCaracterAlerta tipoCaracterAlerta = new TipoCaracterAlerta();
		tipoCaracterAlerta.setTcacodigo(tcacodigo);
        tipoCaracterAlerta = this.tipoCaracterAlertaService.find(tipoCaracterAlerta);
        TipoCaracterAlertaController.logger.info("[GET - findBy_PK] : Obtener TipoCaracterAlerta por PK");
        return tipoCaracterAlerta;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterTipoCaracterAlerta TipoCaracterAlerta
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TipoCaracterAlerta> getAll(@ModelAttribute TipoCaracterAlerta filterTipoCaracterAlerta) {
		TipoCaracterAlertaController.logger.info("[GET - find_ALL] : Obtener TipoCaracterAlerta por filtro");
	    return this.tipoCaracterAlertaService.findAll(filterTipoCaracterAlerta, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta 
	 * @return TipoCaracterAlerta
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody TipoCaracterAlerta edit(@RequestBody TipoCaracterAlerta tipoCaracterAlerta) {		
        TipoCaracterAlerta tipoCaracterAlertaAux = this.tipoCaracterAlertaService.update(tipoCaracterAlerta);
		TipoCaracterAlertaController.logger.info("[PUT] : TipoCaracterAlerta actualizado correctamente");
        return tipoCaracterAlertaAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta 
	 * @return TipoCaracterAlerta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipoCaracterAlerta add(@RequestBody TipoCaracterAlerta tipoCaracterAlerta) {		
        TipoCaracterAlerta tipoCaracterAlertaAux = this.tipoCaracterAlertaService.add(tipoCaracterAlerta);
        TipoCaracterAlertaController.logger.info("[POST] : TipoCaracterAlerta insertado correctamente");
    	return tipoCaracterAlertaAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param tcacodigo String
	 * @return tipoCaracterAlerta
	 */
	@RequestMapping(value = "/{tcacodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody TipoCaracterAlerta remove(@PathVariable String tcacodigo) {
        TipoCaracterAlerta tipoCaracterAlerta = new TipoCaracterAlerta();
        tipoCaracterAlerta.setTcacodigo(tcacodigo);
        this.tipoCaracterAlertaService.remove(tipoCaracterAlerta);
       	TipoCaracterAlertaController.logger.info("[DELETE] : TipoCaracterAlerta borrado correctamente");
       	return tipoCaracterAlerta;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param tipoCaracterAlertaIds List
	 * @return tipoCaracterAlertaList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> tipoCaracterAlertaIds) {
        List<TipoCaracterAlerta> tipoCaracterAlertaList = new ArrayList<TipoCaracterAlerta>();
        for (List<String> tipoCaracterAlertaId:tipoCaracterAlertaIds) {
		    Iterator<String> iterator = tipoCaracterAlertaId.iterator();
		    TipoCaracterAlerta tipoCaracterAlerta = new TipoCaracterAlerta(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        tipoCaracterAlerta.setTcacodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    tipoCaracterAlertaList.add(tipoCaracterAlerta);
	    }
        this.tipoCaracterAlertaService.removeMultiple(tipoCaracterAlertaList);
		TipoCaracterAlertaController.logger.info("[POST - DELETE_ALL] : TipoCaracterAlerta borrados correctamente");
		return tipoCaracterAlertaIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterTipoCaracterAlerta TipoCaracterAlerta
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute TipoCaracterAlerta filterTipoCaracterAlerta, @ModelAttribute Pagination pagination) {
        List<TipoCaracterAlerta> tipoCaracterAlertas = this.tipoCaracterAlertaService.findAll(filterTipoCaracterAlerta, pagination);
        Long recordNum = this.tipoCaracterAlertaService.findAllCount(filterTipoCaracterAlerta);
        TipoCaracterAlertaController.logger.info("[GET - jqGrid] : Obtener TipoCaracterAlerta");
		return new JQGridJSONModel(pagination, recordNum, tipoCaracterAlertas);
	}
	
}	
