package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.*;
import com.ejie.y41b.service.*;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.tree.Y41bTiposInfraccionTree;

/**
 * * TipReqNormativoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tipreqnormativo")
@SessionAttributes({ "codTipoInfraccion", "modoBusquedaTipoInfraccion",
		"modoTipoInfraccion" })
public class TipReqNormativoController {

	private static final Logger logger = LoggerFactory
			.getLogger(TipReqNormativoController.class);

	@Autowired
	private TipReqNormativoService tipReqNormativoService;
	@Autowired
	private ArbolTiposInfraccionService arbolTiposInfraccionService;

	@Autowired
	private InfraccHechoDenExpSancService infracchechodenexpsancservice;

	@Autowired
	private InfraccHechoDenService infracchechodenservice;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "tiposinfracciones", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaTipoInfraccion", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("tiposinfracciones", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionTipoInfraccion", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaTipoInfraccion",
				Y41bConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("seleccionTiposInfracciones", "model", model);
	}

	/**
	 * Method 'getCreateFormAltaTipoInfraccion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaTipoInfraccion", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaTipoInfraccion(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codTipoInfraccion", "");

		model.addAttribute("modoTipoInfraccion", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleTipoInfraccion", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModTipoInfraccion'.
	 * 
	 * @param codTipoInfraccion
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modTipoInfraccion/{codTipoInfraccion}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModTipoInfraccion(
			@PathVariable String codTipoInfraccion, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codTipoInfraccion", codTipoInfraccion);

		model.addAttribute("modoTipoInfraccion",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleTipoInfraccion", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tticodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{tticodigo}", method = RequestMethod.GET)
	public @ResponseBody
	TipReqNormativo getById(@PathVariable String tticodigo) {
		try {
			TipReqNormativo tipReqNormativo = new TipReqNormativo();
			tipReqNormativo.setTticodigo(tticodigo);
			tipReqNormativo = this.tipReqNormativoService.find(tipReqNormativo);
			if (tipReqNormativo == null) {
				throw new Exception(tticodigo.toString());
			}
			return tipReqNormativo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(tticodigo.toString());
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintBusqueda/{type}", method = RequestMethod.GET)
	public ModelAndView getCreateForm(
			@PathVariable String type,
			@RequestParam(value = "relacionados", required = false) String relacionados,
			Model model, HttpServletRequest httpRequest) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		if ("0".equals(type)) {
			return new ModelAndView("aniadirArticulo", "model", model);
		} else {
			return new ModelAndView("aniadirMateria", "model", model);
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param tticodigo
	 *            String
	 * @param ttinombre
	 *            String
	 * @param ttinoco
	 *            String
	 * @param ttitede
	 *            String
	 * @param tticose
	 *            String
	 * @param ttinoco2
	 *            String
	 * @param ttiinsel1
	 *            String
	 * @param tticol4
	 *            String
	 * @param ttinombree
	 *            String
	 * @param ttinombrei
	 *            String
	 * @param ttinombref
	 *            String
	 * @param ttinocoe
	 *            String
	 * @param ttinocoi
	 *            String
	 * @param ttinocof
	 *            String
	 * @param ttitedee
	 *            String
	 * @param ttitedei
	 *            String
	 * @param ttitedef
	 *            String
	 * @param tticodgrupo
	 *            String
	 * @param ttinombrea
	 *            String
	 * @param ttinocoa
	 *            String
	 * @param ttitedea
	 *            String
	 * @param tticoe7
	 *            String
	 * @param tticoinc
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "tticodigo", required = false) String tticodigo,
			@RequestParam(value = "ttinombre", required = false) String ttinombre,
			@RequestParam(value = "ttinoco", required = false) String ttinoco,
			@RequestParam(value = "ttitede", required = false) String ttitede,
			@RequestParam(value = "tticose", required = false) String tticose,
			@RequestParam(value = "ttinoco2", required = false) String ttinoco2,
			@RequestParam(value = "ttiinsel1", required = false) String ttiinsel1,
			@RequestParam(value = "tticol4", required = false) String tticol4,
			@RequestParam(value = "ttinombree", required = false) String ttinombree,
			@RequestParam(value = "ttinombrei", required = false) String ttinombrei,
			@RequestParam(value = "ttinombref", required = false) String ttinombref,
			@RequestParam(value = "ttinocoe", required = false) String ttinocoe,
			@RequestParam(value = "ttinocoi", required = false) String ttinocoi,
			@RequestParam(value = "ttinocof", required = false) String ttinocof,
			@RequestParam(value = "ttitedee", required = false) String ttitedee,
			@RequestParam(value = "ttitedei", required = false) String ttitedei,
			@RequestParam(value = "ttitedef", required = false) String ttitedef,
			@RequestParam(value = "tticodgrupo", required = false) String tticodgrupo,
			@RequestParam(value = "ttinombrea", required = false) String ttinombrea,
			@RequestParam(value = "ttinocoa", required = false) String ttinocoa,
			@RequestParam(value = "ttitedea", required = false) String ttitedea,
			@RequestParam(value = "tticoe7", required = false) String tticoe7,
			@RequestParam(value = "tticoinc", required = false) String tticoinc,
			HttpServletRequest request) {
		try {
			TipReqNormativo filterTipReqNormativo = new TipReqNormativo(
					tticodigo, ttinombre, ttinoco, ttitede, tticose, ttinoco2,
					ttiinsel1, tticol4, ttinombree, ttinombrei, ttinombref,
					ttinocoe, ttinocoi, ttinocof, ttitedee, ttitedei, ttitedef,
					tticodgrupo, ttinombrea, ttinocoa, ttitedea, tticoe7,
					tticoinc);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipReqNormativo> tipReqNormativos = this.tipReqNormativoService
						.findAll(filterTipReqNormativo, pagination);

				if (tipReqNormativos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterTipReqNormativo, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipReqNormativos);
				return data;
			} else {
				List<TipReqNormativo> tipReqNormativos = this.tipReqNormativoService
						.findAll(filterTipReqNormativo, pagination);
				if (tipReqNormativos == null) {
					throw new Exception("No data Found.");
				}
				return tipReqNormativos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTipReqNormativo
	 *            TipReqNormativo
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count2", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "tipReqNormativo", required = false) TipReqNormativo filterTipReqNormativo,
			HttpServletRequest request) {
		try {
			return tipReqNormativoService
					.findAllCount(filterTipReqNormativo != null ? filterTipReqNormativo
							: new TipReqNormativo());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param tticodigo
	 *            String
	 * @param ttinombre
	 *            String
	 * @param ttinoco
	 *            String
	 * @param ttitede
	 *            String
	 * @param tticose
	 *            String
	 * @param ttinoco2
	 *            String
	 * @param ttiinsel1_
	 *            String
	 * @param tticol4
	 *            String
	 * @param ttinombree
	 *            String
	 * @param ttinombrei
	 *            String
	 * @param ttinombref
	 *            String
	 * @param ttinocoe
	 *            String
	 * @param ttinocoi
	 *            String
	 * @param ttinocof
	 *            String
	 * @param ttitedee
	 *            String
	 * @param ttitedei
	 *            String
	 * @param ttitedef
	 *            String
	 * @param tticodgrupo
	 *            String
	 * @param ttinombrea
	 *            String
	 * @param ttinocoa
	 *            String
	 * @param ttitedea
	 *            String
	 * @param tticoe7
	 *            String
	 * @param tticoinc
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllInfracciones", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllInfracciones(
			@RequestParam(value = "tticodigo", required = false) String tticodigo,
			@RequestParam(value = "ttinombre", required = false) String ttinombre,
			@RequestParam(value = "ttinoco", required = false) String ttinoco,
			@RequestParam(value = "ttitede", required = false) String ttitede,
			@RequestParam(value = "tticose", required = false) String tticose,
			@RequestParam(value = "ttinoco2", required = false) String ttinoco2,
			@RequestParam(value = "ttiinsel1", required = false) String ttiinsel1_,
			@RequestParam(value = "tticol4", required = false) String tticol4,
			@RequestParam(value = "ttinombree", required = false) String ttinombree,
			@RequestParam(value = "ttinombrei", required = false) String ttinombrei,
			@RequestParam(value = "ttinombref", required = false) String ttinombref,
			@RequestParam(value = "ttinocoe", required = false) String ttinocoe,
			@RequestParam(value = "ttinocoi", required = false) String ttinocoi,
			@RequestParam(value = "ttinocof", required = false) String ttinocof,
			@RequestParam(value = "ttitedee", required = false) String ttitedee,
			@RequestParam(value = "ttitedei", required = false) String ttitedei,
			@RequestParam(value = "ttitedef", required = false) String ttitedef,
			@RequestParam(value = "tticodgrupo", required = false) String tticodgrupo,
			@RequestParam(value = "ttinombrea", required = false) String ttinombrea,
			@RequestParam(value = "ttinocoa", required = false) String ttinocoa,
			@RequestParam(value = "ttitedea", required = false) String ttitedea,
			@RequestParam(value = "tticoe7", required = false) String tticoe7,
			@RequestParam(value = "tticoinc", required = false) String tticoinc,
			HttpServletRequest request) {
		try {
			String ttiinsel1 = ("".equals(ttiinsel1_)) ? null : ttiinsel1_;
			TipReqNormativo filterTipReqNormativo = new TipReqNormativo(
					tticodigo, ttinombre, ttinoco, ttitede, tticose, ttinoco2,
					ttiinsel1, tticol4, ttinombree, ttinombrei, ttinombref,
					ttinocoe, ttinocoi, ttinocof, ttitedee, ttitedei, ttitedef,
					tticodgrupo, ttinombrea, ttinocoa, ttitedea, tticoe7,
					tticoinc);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipReqNormativo> tipReqNormativos = this.tipReqNormativoService
						.findAllLikeReqNormativo(filterTipReqNormativo,
								pagination, false);

				if (tipReqNormativos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountInfracciones(filterTipReqNormativo,
						request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipReqNormativos);
				return data;
			} else {
				List<TipReqNormativo> tipReqNormativos = this.tipReqNormativoService
						.findAllLikeReqNormativo(filterTipReqNormativo,
								pagination, false);
				if (tipReqNormativos == null) {
					throw new Exception("No data Found.");
				}
				return tipReqNormativos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	@RequestMapping(value = "/findAllArticulos/{filter}", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel findAllArticulos(@PathVariable String filter,
			HttpServletRequest request) {
		try {
			filter = filter.substring(1, filter.length() - 1);
			JQGridJSONModel jqGrid = null;
			Pagination pagination = null;

			pagination = new Pagination();
			pagination.setPage(Long.valueOf(request.getParameter("page")));
			pagination.setRows(Long.valueOf(request.getParameter("rows")));
			pagination.setSort(request.getParameter("sidx"));
			pagination.setAscDsc(request.getParameter("sord"));

			TipReqNormativo filterTipReqNormativo = new TipReqNormativo();
			filterTipReqNormativo.setTtinombre(filter);
			List<TipReqNormativo> tipReqNormativos = this.tipReqNormativoService
					.findAllArticulos(
							filterTipReqNormativo,
							pagination,
							(List<String>) request.getSession().getAttribute(
									"articulosAniadidos"));

			if (tipReqNormativos == null) {
				throw new Exception("No data Found.");
			}

			Long total = getAllCountArticulos(filter, request);
			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(request.getParameter("page"));
			data.setRecords(total.intValue());
			data.setTotal(total, pagination.getRows());
			data.setRows(tipReqNormativos);

			jqGrid = new JQGridJSONModel(pagination, total, tipReqNormativos);

			return jqGrid;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	@RequestMapping(value = "/findAllMaterias/{filter}", method = RequestMethod.GET)
	public @ResponseBody
	Object findAllMaterias(@PathVariable String filter,
			HttpServletRequest request) {
		try {
			filter = filter.substring(1, filter.length() - 1);

			Pagination pagination = new Pagination();
			pagination.setPage(Long.valueOf(request.getParameter("page")));
			pagination.setRows(Long.valueOf(request.getParameter("rows")));
			pagination.setSort(request.getParameter("sidx"));
			pagination.setAscDsc(request.getParameter("sord"));

			if (pagination.getSort() != null
					&& pagination.getSort().equals("nombre"))
				pagination.setSort("ttinombre");

			TipReqNormativo filterTipReqNormativo = new TipReqNormativo();
			filterTipReqNormativo.setTtinombre(filter);
			List<TipReqNormativo> tipReqNormativos = this.tipReqNormativoService
					.findAllMaterias(
							filterTipReqNormativo,
							pagination,
							(List<String>) request.getSession().getAttribute(
									"materiasAniadidas"));

			for (TipReqNormativo tipReqNormativo : tipReqNormativos) {
				tipReqNormativo.setCodigo(tipReqNormativo.getTticodigo());
				tipReqNormativo.setNombre(tipReqNormativo.getTtinombre());
				tipReqNormativo.setCodaux(null);
			}

			if (tipReqNormativos == null) {
				throw new Exception("No data Found.");
			}

			Long total = getAllCountMaterias(filter, request);
			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(request.getParameter("page"));
			data.setRecords(total.intValue());
			data.setTotal(total, pagination.getRows());
			data.setRows(tipReqNormativos);
			return data;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTipReqNormativo
	 *            TipReqNormativo
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCountInfracciones(
			@RequestParam(value = "tipReqNormativo", required = false) TipReqNormativo filterTipReqNormativo,
			HttpServletRequest request) {
		try {
			return tipReqNormativoService.findAllLikeReqNormativoCount(
					filterTipReqNormativo != null ? filterTipReqNormativo
							: new TipReqNormativo(), false);
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTipReqNormativo
	 *            TipReqNormativo
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/articulosCount", method = RequestMethod.GET)
	Long getAllCountArticulos(String filter, HttpServletRequest request) {
		try {
			TipReqNormativo filterTipReqNormativo = new TipReqNormativo();
			filterTipReqNormativo.setTtinombre(filter);
			return tipReqNormativoService.findAllArticulosCount(
					filterTipReqNormativo, (List<String>) request.getSession()
							.getAttribute("articulosAniadidos"));
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTipReqNormativo
	 *            TipReqNormativo
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/countMaterias", method = RequestMethod.GET)
	Long getAllCountMaterias(String filter, HttpServletRequest request) {
		try {
			TipReqNormativo filterTipReqNormativo = new TipReqNormativo();
			filterTipReqNormativo.setTtinombre(filter);
			return tipReqNormativoService.findAllMateriasCount(
					filterTipReqNormativo, (List<String>) request.getSession()
							.getAttribute("materiasAniadidas"));
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param response
	 *            HttpServletResponse
	 * @return TipReqNormativo
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	TipReqNormativo edit(@RequestBody TipReqNormativo tipReqNormativo,
			HttpServletResponse response) {
		try {
			TipReqNormativo tipReqNormativoAux = this.tipReqNormativoService
					.update(tipReqNormativo);
			logger.info("Entity correctly inserted!");
			return tipReqNormativoAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	TipReqNormativo add(@RequestBody TipReqNormativo tipReqNormativo) {
		try {
			TipReqNormativo tipReqNormativoAux = this.tipReqNormativoService
					.add(tipReqNormativo);
			logger.info("Entity correctly inserted!");
			return tipReqNormativoAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tticodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{tticodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String tticodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			TipReqNormativo tipReqNormativo = new TipReqNormativo();
			tipReqNormativo.setTticodigo(tticodigo);
			this.tipReqNormativoService.remove(tipReqNormativo);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + tticodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tipReqNormativoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> tipReqNormativoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<TipReqNormativo> tipReqNormativoList = new ArrayList<TipReqNormativo>();
		try {
			for (ArrayList<String> tipReqNormativoId : tipReqNormativoIds) {
				Iterator<String> iterator = tipReqNormativoId.iterator();
				TipReqNormativo tipReqNormativo = new TipReqNormativo();
				tipReqNormativo.setTticodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				tipReqNormativoList.add(tipReqNormativo);
			}
			this.tipReqNormativoService.removeMultiple(tipReqNormativoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Loading entity group tree
	 * 
	 * @param response
	 *            Response
	 * @param request
	 *            Request
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "/tiposinfraccionestree", method = RequestMethod.GET)
	public void getCategoriasTree(HttpServletRequest request,
			HttpServletResponse response) throws IOException {

		response.setCharacterEncoding("ISO-8859-1");
		response.setHeader("Cache-Control", "no-cache");
		response.setContentType("text/html;charset=utf-8");

		String mostrarHabituales = "";
		String tticodigo_ = "";
		String ttinombre_ = "";
		Enumeration e = request.getParameterNames();
		while (e.hasMoreElements()) {
			String param = e.nextElement().toString();

			if (param.equals("mostrarHabituales")) {
				mostrarHabituales = request.getParameter(param);
			}
			if (param.equals("tticodigo")) {
				tticodigo_ = request.getParameter(param);
			}
			if (param.equals("ttinombre")) {
				ttinombre_ = request.getParameter(param);
			}
		}

		String ttiinsel1 = null;

		if (mostrarHabituales.equals("true")) {
			ttiinsel1 = Y41bConstantes.HABITUALES;
		}

		String tticodigo = ("".equals(tticodigo_)) ? null : tticodigo_;
		String ttinombre = null;
		String ttinombree = null;
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
			ttinombre = ("".equals(ttinombre_)) ? null : ttinombre_;
		} else {
			ttinombree = ("".equals(ttinombre_)) ? null : ttinombre_;
		}

		TipReqNormativo filterTipReqNormativo = new TipReqNormativo(tticodigo,
				ttinombre, null, null, null, null, ttiinsel1, null, ttinombree,
				null, null, null, null, null, null, null, null, null, null,
				null, null, null, null);

		Pagination pagination = new Pagination();
		pagination.setSort("TTICODIGO");
		pagination.setAscDsc("ASC");

		Y41bArbolTiposInfraccion arbolTiposInfraccion = this.arbolTiposInfraccionService
				.obtenerArbol(filterTipReqNormativo, pagination);

		String json = Y41bTiposInfraccionTree
				.obtieneJsonArbol(arbolTiposInfraccion);

		PrintWriter out = response.getWriter();
		out.println(json);
		out.flush();
		out.close();
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipReqNormativoService'.
	 * 
	 * @return TipReqNormativoService
	 */
	protected TipReqNormativoService getTipReqNormativoService() {
		return this.tipReqNormativoService;
	}

	/**
	 * Method 'setTipReqNormativoService'.
	 * 
	 * @param tipReqNormativoService
	 *            TipReqNormativoService
	 * @return
	 */
	public void setTipReqNormativoService(
			TipReqNormativoService tipReqNormativoService) {
		this.tipReqNormativoService = tipReqNormativoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'guardarArticulosRelacionados'.
	 * 
	 * @param seleccionados
	 *            String
	 * @param excodigo
	 *            String
	 */
	@RequestMapping(value = "/guardarArticulosRelacionados/{seleccionados}", method = RequestMethod.POST)
	public void guardarArticulosRelacionados(
			@PathVariable String seleccionados, HttpServletRequest request,
			HttpServletResponse response) {
		try {
			String[] arrayIds = seleccionados.substring(1,
					seleccionados.length() - 1).split("__");

			List<String> articulosAniadidos = new ArrayList<String>();

			for (int i = 0; i < arrayIds.length; i++) {
				articulosAniadidos.add(arrayIds[i]);
			}

			request.getSession().setAttribute("articulosAniadidos",
					articulosAniadidos);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	@RequestMapping(value = "/eliminaArticulo/{codElimina}/{codExp}", method = RequestMethod.POST)
	public void eliminaArticulo(@PathVariable String codElimina,
			@PathVariable String codExp, HttpServletRequest request,
			HttpServletResponse response) {
		try {

			InfraccHechoDen infrrhechoden = new InfraccHechoDen(codElimina,
					null, null, null, null);
			InfraccHechoDenExpSanc infrrhechodensan = new InfraccHechoDenExpSanc(
					null, codExp, infrrhechoden, null);

			List<InfraccHechoDenExpSanc> listaObjetos = infracchechodenexpsancservice
					.findAll(infrrhechodensan, null);

			List<InfraccHechoDen> listaArticulos = infracchechodenservice
					.findArticulos(codExp, null);
			List<InfraccHechoDen> listaMaterias = infracchechodenservice
					.findMaterias(codExp, null);
			boolean esArticulo = false;
			for (InfraccHechoDen articulo : listaArticulos) {
				if (articulo.getHicodigo().equals(codElimina)) {
					esArticulo = true;
					break;
				}
			}
			if (esArticulo && listaArticulos != null
					&& listaArticulos.size() == 1) {
				throw new Y41bUDAException(
						"error.adjuntarinfraccionesSAN.deleteException", true,
						new Exception());
			} else if (!esArticulo && listaMaterias != null
					&& listaMaterias.size() == 1) {
				throw new Y41bUDAException(
						"error.adjuntarinfraccionesSAN.deleteException", true,
						new Exception());
			}

			if (listaObjetos != null) {
				infracchechodenexpsancservice.remove(listaObjetos.get(0));
				response.setStatus(HttpServletResponse.SC_OK);
			} else {
				response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	@RequestMapping(value = "/eliminaMateria/{codElimina}", method = RequestMethod.POST)
	public void eliminaMateria(@PathVariable String codElimina,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			List<String> materiasAniadidas = (List<String>) request
					.getSession().getAttribute("materiasAniadidas");
			List<String> materiasAniadidasNuevo = new ArrayList<String>();
			for (String cod : materiasAniadidas)
				if (!cod.replaceAll("~", "IFID").equals(codElimina))
					materiasAniadidasNuevo.add(cod);

			request.getSession().setAttribute("materiasAniadidas",
					materiasAniadidasNuevo);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'guardarMateriasRelacionados'.
	 * 
	 * @param seleccionados
	 *            String
	 * @param excodigo
	 *            String
	 */
	@RequestMapping(value = "/guardarMateriasRelacionados/{seleccionados}", method = RequestMethod.POST)
	public void guardarMateriasRelacionados(@PathVariable String seleccionados,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			String[] arrayIds = seleccionados.substring(1,
					seleccionados.length() - 1).split("__");

			List<String> materiasAniadidas = new ArrayList<String>();
			for (int i = 0; i < arrayIds.length; i++) {
				materiasAniadidas.add(arrayIds[i]);
			}

			request.getSession().setAttribute("materiasAniadidas",
					materiasAniadidas);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getByIdSeleccionable'.
	 * 
	 * @param tticodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "seleccionable/{tticodigo}", method = RequestMethod.GET)
	public @ResponseBody
	TipReqNormativo getByIdSeleccionable(@PathVariable String tticodigo) {
		try {
			TipReqNormativo tipReqNormativo = new TipReqNormativo();
			tipReqNormativo.setTticodigo(tticodigo);
			tipReqNormativo = this.tipReqNormativoService
					.findTipReqNormativoSeleccionable(tipReqNormativo);
			if (tipReqNormativo == null) {
				throw new Exception(tticodigo.toString());
			}
			return tipReqNormativo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(tticodigo.toString());
		}
	}

	@RequestMapping(value = "/guardarArticulo/{codAniadir}/{codExp}", method = RequestMethod.POST)
	public void guardarArticulo(@PathVariable String codAniadir,
			@PathVariable String codExp, HttpServletRequest request,
			HttpServletResponse response) {
		try {

			TipReqNormativo tipoRequisito = new TipReqNormativo();
			tipoRequisito.setTticodigo(codAniadir);

			// PRIMERO COMPROBAMOS QUE NO ESTA YA INSERTADO
			InfraccHechoDenExpSanc infrrhechodensanbusqueda = new InfraccHechoDenExpSanc();
			infrrhechodensanbusqueda.setDxcoex(codExp);
			List<InfraccHechoDenExpSanc> infraccionesExpedienteBusqueda = infracchechodenexpsancservice
					.findAll(infrrhechodensanbusqueda, null);
			boolean encontrado = false;
			if (infraccionesExpedienteBusqueda != null) {
				for (InfraccHechoDenExpSanc infraccHechoDenExpSanc : infraccionesExpedienteBusqueda) {
					InfraccHechoDen infraccionHechoDenunciadoBusqueda = infraccHechoDenExpSanc
							.getInfraccHechoDen();
					if (infraccionHechoDenunciadoBusqueda.getTipReqNormativo()
							.getTticodigo().equals(codAniadir)) {
						encontrado = true;
					}
				}
			}

			if (encontrado) {
				throw new Y41bUDAException(
						"error.adjuntarinfraccionesSAN.duplicateException",
						true, new Exception());
			} else {
				String hiinexiid = null;
				if (codAniadir.indexOf("N0") > -1) {
					// es un articulo
					hiinexiid = "S";
				}
				String hicodigo = Y41bUIDGenerator.getInstance().generateId(
						Y41bConstantes.PK_SIZE);
				InfraccHechoDen infrrhechoden = new InfraccHechoDen(hicodigo,
						null, tipoRequisito, hiinexiid, null);
				infracchechodenservice.add(infrrhechoden);
				InfraccHechoDenExpSanc infrrhechodensan = new InfraccHechoDenExpSanc(
						hicodigo, codExp, infrrhechoden, null);
				infracchechodenexpsancservice.add(infrrhechodensan);
				response.setStatus(HttpServletResponse.SC_OK);
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}
}
