package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjuntartipPregProtoc;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.CopiaTipoProtocolo;
import com.ejie.y41b.model.DetalleProtocolo;
import com.ejie.y41b.model.PlantillaProtocoloDetalle;
import com.ejie.y41b.model.ProtocoloCabecera;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.model.TipReqNormativo;
import com.ejie.y41b.service.ActaService;
import com.ejie.y41b.service.AdjuntartipPregProtocService;
import com.ejie.y41b.service.CampanhaService;
import com.ejie.y41b.service.ProtocolService;
import com.ejie.y41b.service.TipPregProtocService;
import com.ejie.y41b.service.TipProtocoloService;
import com.ejie.y41b.service.TipReqNormativoService;
import com.ejie.y41b.utils.Y41bStringUtils;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * TipProtocoloController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tipprotocolo")
@SessionAttributes({ "codTipoProtocolo", "modoBusquedaTipoProtocolo", "modoTipoProtocolo" })
public class TipProtocoloController {

	private static final Logger logger = LoggerFactory.getLogger(TipProtocoloController.class);

	@Autowired
	private TipProtocoloService tipProtocoloService;
	@Autowired
	private AdjuntartipPregProtocService adjuntartipPregProtocService;
	@Autowired
	private TipPregProtocService tipPregProtocService;
	@Autowired
	private CampanhaService campanhaService;
	@Autowired
	private TipReqNormativoService tipReqNormativoService;
	@Autowired
	private ActaService actaService;

	@Autowired
	private ProtocolService protocolService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "tiposProtocolos", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaTipoProtocolo", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("tiposProtocolos", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormCopia'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "copiarTiposProtocolo", method = RequestMethod.GET)
	public ModelAndView getCreateFormCopia(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		// model.addAttribute("modoBusquedaTipoProtocolo", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("copiaTiposProtocolos", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionTipoProtocolo", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaTipoProtocolo", Y41bConstantes.MODO_POPUP_SELECCION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("seleccionTiposProtocolos", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAltaTipoProtocolo'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaTipoProtocolo", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaTipoProtocolo(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codTipoProtocolo", Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoTipoProtocolo", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleTipoProtocolo", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModTipoProtocolo'.
	 * 
	 * @param codTipoProtocolo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	// /////////////////////////////////////
	// @RequestMapping(value = "modTipoProtocolo/{codTipoProtocolo}", method =
	// RequestMethod.GET)
	// @PathVariable String codTipoProtocolo,

	// /////////////////////////////////////
	@RequestMapping(value = "modTipoProtocolo", method = RequestMethod.GET)
	public ModelAndView getCreateFormModTipoProtocolo(
			@RequestParam(value = "codTipoProtocolo", required = false) String codTipoProtocolo, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codTipoProtocolo", codTipoProtocolo);

		model.addAttribute("modoTipoProtocolo", Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		TipProtocolo tipProtocolo = new TipProtocolo();
		tipProtocolo.setTpcodigo(codTipoProtocolo);

		this.adjuntartipPregProtocService.addTipPregProtocTableTemporal(tipProtocolo);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleTipoProtocolo", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAltaRespuesta'.
	 *
	 * @param codTipoProtocolo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaRespuesta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaRespuesta(@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocolo,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		AdjuntartipPregProtoc adjuntartipPregProtoc = new AdjuntartipPregProtoc();
		adjuntartipPregProtoc.setTrcotp(codTipoProtocolo);
		model.addAttribute("orden", this.adjuntartipPregProtocService.findNumOrden(adjuntartipPregProtoc));

		model.addAttribute("codRespuesta", Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoRespuesta", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleRespuesta", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModRespuesta'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modRespuesta/{trcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModRespuesta(@PathVariable String trcodigo, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("orden", "");

		model.addAttribute("codRespuesta", trcodigo);

		model.addAttribute("modoRespuesta", Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleRespuesta", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "previsualizarProtocolo", method = RequestMethod.GET)
	public ModelAndView getCreateFormPrevisualizarProtocolo(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("previsualizarProtocolo", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "visualizarProtocolo", method = RequestMethod.GET)
	public ModelAndView getCreateFormVisualizarProtocolo(@RequestParam("codTipoProtocolo") String codTipoProtocolo,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codTipoProtocolo", codTipoProtocolo);
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("previsualizarProtocolo", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tpcodigo
	 *            String
	 * @return tipProtocolo TipProtocolo
	 */
	@RequestMapping(value = "/{tpcodigo}", method = RequestMethod.GET)
	public @ResponseBody TipProtocolo getById(@PathVariable String tpcodigo) {
		TipProtocolo tipProtocolo = new TipProtocolo();
		tipProtocolo.setTpcodigo(tpcodigo);
		tipProtocolo = this.tipProtocoloService.find(tipProtocolo);
		TipProtocoloController.logger.info("[GET - findBy_PK] : Obtener TipProtocolo por PK");
		return tipProtocolo;
	}

	/**
	 * Method 'getTipoProtocoloById'.
	 * 
	 * @param codTipoProtocolo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findTipoProtocolo", method = RequestMethod.GET)
	public @ResponseBody TipProtocolo getTipoProtocoloById(
			@RequestParam(value = "codTipoProtocolo", required = false) String codTipoProtocolo) {
		try {
			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(codTipoProtocolo);
			tipProtocolo = this.tipProtocoloService.find(tipProtocolo);
			if (tipProtocolo == null) {
				throw new Exception(codTipoProtocolo.toString());
			}
			return tipProtocolo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codTipoProtocolo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTipProtocolo
	 *            TipProtocolo
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TipProtocolo> getAll(@ModelAttribute TipProtocolo filterTipProtocolo) {
		TipProtocoloController.logger.info("[GET - find_ALL] : Obtener TipProtocolo por filtro");
		return this.tipProtocoloService.findAll(filterTipProtocolo, null);
	}

	/**
	 * Method 'getAllTipoProtocolo'.
	 * 
	 * @param tpcodigo_
	 *            String
	 * @param campanhaCmcodigo_
	 *            String
	 * @param tpnombre_
	 *            String
	 * @param tpestandar_
	 *            String
	 * @param atcodigo_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody Object getAllTipoProtocolo(
			@RequestParam(value = "tpcodigo", required = false) String tpcodigo_,
			@RequestParam(value = "campanhaCmcodigo", required = false) String campanhaCmcodigo_,
			@RequestParam(value = "tpnombre", required = false) String tpnombre_,
			@RequestParam(value = "tpestandar", required = false) String tpestandar_,
			@RequestParam(value = "atcodigo", required = false) String atcodigo_, HttpServletRequest request) {
		try {

			// control de los campos susceptibles de llegar a "" desde el filtro
			String tpcodigo = ("".equals(tpcodigo_)) ? null : tpcodigo_;

			String tpnombre = ("".equals(tpnombre_)) ? null : tpnombre_;
			String campanhaCmcodigo = ("".equals(campanhaCmcodigo_)) ? null : campanhaCmcodigo_;

			String atcodigo = ("".equals(atcodigo_)) ? null : atcodigo_;

			// control checks
			String tpestandar = ("on".equals(tpestandar_)) ? Y41bConstantes.VALOR_SI : null;

			if (tpestandar_ != null && tpestandar_.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				tpestandar = Y41bConstantes.VALOR_NO;
			}

			TipProtocolo filterTipProtocolo = new TipProtocolo(tpcodigo, tpnombre, null, tpestandar,
					new Campanha(campanhaCmcodigo, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null));
			filterTipProtocolo.setAtcodigo(atcodigo);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipProtocolo> tipProtocolos = this.tipProtocoloService.findAllLike(filterTipProtocolo, pagination,
						false);

				if (tipProtocolos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.tipProtocoloService.findAllLikeCount(filterTipProtocolo, false);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipProtocolos);
				return data;
			} else {
				List<TipProtocolo> tipProtocolos = this.tipProtocoloService.findAllLike(filterTipProtocolo, pagination,
						false);
				if (tipProtocolos == null) {
					throw new Exception("No data Found.");
				}
				return tipProtocolos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllTipoProtocoloCount'.
	 * 
	 * @param tpcodigo_
	 *            String
	 * @param campanhaCmcodigo_
	 *            String
	 * @param tpnombre_
	 *            String
	 * @param tpestandar_
	 *            String
	 * @param atcodigo_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/likecount", method = RequestMethod.GET)
	public @ResponseBody Object getAllTipoProtocoloCount(
			@RequestParam(value = "tpcodigo", required = false) String tpcodigo_,
			@RequestParam(value = "campanhaCmcodigo", required = false) String campanhaCmcodigo_,
			@RequestParam(value = "tpnombre", required = false) String tpnombre_,
			@RequestParam(value = "tpestandar", required = false) String tpestandar_,
			@RequestParam(value = "atcodigo", required = false) String atcodigo_, HttpServletRequest request) {
		try {

			// control de los campos susceptibles de llegar a "" desde el filtro
			String tpcodigo = ("".equals(tpcodigo_)) ? null : tpcodigo_;

			String tpnombre = ("".equals(tpnombre_)) ? null : tpnombre_;
			String campanhaCmcodigo = ("".equals(campanhaCmcodigo_)) ? null : campanhaCmcodigo_;

			String atcodigo = ("".equals(atcodigo_)) ? null : atcodigo_;

			// control checks
			String tpestandar = ("on".equals(tpestandar_)) ? Y41bConstantes.VALOR_SI : null;

			if (tpestandar_ != null && tpestandar_.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				tpestandar = Y41bConstantes.VALOR_NO;
			}

			TipProtocolo filterTipProtocolo = new TipProtocolo(tpcodigo, tpnombre, null, tpestandar,
					new Campanha(campanhaCmcodigo, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null));
			filterTipProtocolo.setAtcodigo(atcodigo);

			Long total = this.tipProtocoloService.findAllLikeCount(filterTipProtocolo, false);

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody TipProtocolo edit(@RequestBody TipProtocolo tipProtocolo) {
		TipProtocolo tipProtocoloAux = this.tipProtocoloService.update(tipProtocolo);
		TipProtocoloController.logger.info("[PUT] : TipProtocolo actualizado correctamente");
		return tipProtocoloAux;
	}

	/**
	 * Method 'editTipoProtocolo'.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param response
	 *            HttpServletResponse
	 * @return TipProtocolo
	 */
	@RequestMapping(value = "/updateTipoProtocolo", method = RequestMethod.PUT)
	public @ResponseBody TipProtocolo editTipoProtocolo(@RequestBody TipProtocolo tipProtocolo,
			HttpServletResponse response) {
		try {
			TipProtocolo tipProtocoloAux = this.tipProtocoloService.updateTipProtocolo(tipProtocolo);
			logger.info("Entity correctly inserted!");
			return tipProtocoloAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipProtocolo add(@RequestBody TipProtocolo tipProtocolo) {
		TipProtocolo tipProtocoloAux = this.tipProtocoloService.add(tipProtocolo);
		TipProtocoloController.logger.info("[POST] : TipProtocolo insertado correctamente");
		return tipProtocoloAux;
	}

	/**
	 * Method 'addTipoProtocolo'.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param codTipoProtocoloAlta
	 *            String
	 * @return TipProtocolo
	 */
	@RequestMapping(value = "/addTipoProtocolo", method = RequestMethod.POST)
	public @ResponseBody TipProtocolo addTipoProtocolo(@RequestBody TipProtocolo tipProtocolo,
			@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocoloAlta) {
		try {
			TipProtocolo tipProtocoloAux = this.tipProtocoloService.addTipProtocolo(tipProtocolo, codTipoProtocoloAlta);
			logger.info("Entity correctly inserted!");
			return tipProtocoloAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tpcodigo
	 *            String
	 * @return tipProtocolo
	 */
	@RequestMapping(value = "/{tpcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody TipProtocolo remove(@PathVariable String tpcodigo) {
		TipProtocolo tipProtocolo = new TipProtocolo();
		tipProtocolo.setTpcodigo(tpcodigo);
		this.tipProtocoloService.remove(tipProtocolo);
		TipProtocoloController.logger.info("[DELETE] : TipProtocolo borrado correctamente");
		return tipProtocolo;
	}

	/**
	 * Method 'removeTipoProtocolo'.
	 * 
	 * @param tpcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeTipoProtocolo", method = RequestMethod.DELETE)
	public void removeTipoProtocolo(@RequestParam(value = "tpcodigo", required = false) String tpcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(tpcodigo);
			this.tipProtocoloService.removeTipProtocolo(tipProtocolo);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + tpcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tipProtocoloIds
	 *            List
	 * @return tipProtocoloList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> tipProtocoloIds) {
		List<TipProtocolo> tipProtocoloList = new ArrayList<TipProtocolo>();
		for (List<String> tipProtocoloId : tipProtocoloIds) {
			Iterator<String> iterator = tipProtocoloId.iterator();
			TipProtocolo tipProtocolo = new TipProtocolo(); // NOPMD - Objeto
															// nuevo en la lista
															// (parametro del
															// servicio)
			tipProtocolo.setTpcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
			tipProtocoloList.add(tipProtocolo);
		}
		this.tipProtocoloService.removeMultiple(tipProtocoloList);
		TipProtocoloController.logger.info("[POST - DELETE_ALL] : TipProtocolo borrados correctamente");
		return tipProtocoloIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterTipProtocolo
	 *            TipProtocolo
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute TipProtocolo filterTipProtocolo,
			@ModelAttribute Pagination pagination) {
		List<TipProtocolo> tipProtocolos = this.tipProtocoloService.findAll(filterTipProtocolo, pagination);
		Long recordNum = this.tipProtocoloService.findAllCount(filterTipProtocolo);
		TipProtocoloController.logger.info("[GET - jqGrid] : Obtener TipProtocolo");
		return new JQGridJSONModel(pagination, recordNum, tipProtocolos);
	}

	/**
	 * Method 'unBind' CampanhaTipoprotocolo
	 * 
	 * @param tpcodigo
	 *            String
	 * @param campanhaCmcodigo
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindCampanhaTipoprotocolo", method = RequestMethod.POST)
	public void unBindCampanhaTipoprotocolo(@RequestParam(value = "tpcodigo", required = false) String tpcodigo,
			@RequestParam(value = "campanhaCmcodigo", required = false) String campanhaCmcodigo) {
		TipProtocolo tipProtocolo = new TipProtocolo();
		Campanha campanha = new Campanha();
		if (tpcodigo != null) {
			tipProtocolo.setTpcodigo(tpcodigo);
		}
		if (campanhaCmcodigo != null) {
			campanha.setCmcodigo(campanhaCmcodigo);
		}
		tipProtocolo.getCampanhas().add(campanha);
		this.tipProtocoloService.removeCampanhaTipoprotocolo(tipProtocolo);
	}

	/**
	 * Method 'bind' CampanhaTipoprotocolo
	 * 
	 * @param tpcodigo
	 *            String
	 * @param campanhaCmcodigo
	 *            String
	 */
	@RequestMapping(value = "/bindCampanhaTipoprotocolo", method = RequestMethod.POST)
	public void bindCampanhaTipoprotocolo(@RequestParam(value = "tpcodigo", required = false) String tpcodigo,
			@RequestParam(value = "campanhaCmcodigo", required = false) String campanhaCmcodigo) {
		TipProtocolo tipProtocolo = new TipProtocolo();
		Campanha campanha = new Campanha();
		if (tpcodigo != null) {
			tipProtocolo.setTpcodigo(tpcodigo);
		}
		if (campanhaCmcodigo != null) {
			campanha.setCmcodigo(campanhaCmcodigo);
		}
		tipProtocolo.getCampanhas().add(campanha);
		this.tipProtocoloService.addCampanhaTipoprotocolo(tipProtocolo);
	}

	/**
	 * Method 'getAllTipPregProtoc'.
	 * 
	 * @param codTipoProtocolo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/tipPregProtoc", method = RequestMethod.GET)
	public @ResponseBody Object getAllTipPregProtoc(@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocolo,
			HttpServletRequest request) {
		try {
			AdjuntartipPregProtoc adjuntartipPregProtoc = new AdjuntartipPregProtoc();
			adjuntartipPregProtoc.setTrcotp(codTipoProtocolo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<AdjuntartipPregProtoc> listAdjuntartipPregProtoc = null;

				listAdjuntartipPregProtoc = this.adjuntartipPregProtocService.findAll(adjuntartipPregProtoc,
						pagination);

				if (listAdjuntartipPregProtoc == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntartipPregProtocService.findAllCount(adjuntartipPregProtoc);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntartipPregProtoc);
				return data;
			} else {
				List<AdjuntartipPregProtoc> listAdjuntartipPregProtoc = null;

				listAdjuntartipPregProtoc = this.adjuntartipPregProtocService.findAll(adjuntartipPregProtoc,
						pagination);

				if (listAdjuntartipPregProtoc == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntartipPregProtoc;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTipPregProtocById'.
	 * 
	 * @param trcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "tipPregProtoc/{trcodigo}", method = RequestMethod.GET)
	public @ResponseBody AdjuntartipPregProtoc getTipPregProtocById(@PathVariable String trcodigo) {
		try {
			AdjuntartipPregProtoc adjuntartipPregProtoc = new AdjuntartipPregProtoc();
			adjuntartipPregProtoc.setTrcodigo(trcodigo);
			adjuntartipPregProtoc = this.adjuntartipPregProtocService.find(adjuntartipPregProtoc);
			if (adjuntartipPregProtoc == null) {
				throw new Exception(trcodigo.toString());
			}
			return adjuntartipPregProtoc;
		} catch (Exception e) {
			throw new ResourceNotFoundException(trcodigo.toString());
		}
	}

	/**
	 * Method 'addTipPregProtoc'.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @param codTipoProtocoloAlta
	 *            String
	 * @return AdjuntartipPregProtoc
	 */
	@RequestMapping(value = "/tipPregProtoc", method = RequestMethod.POST)
	public @ResponseBody AdjuntartipPregProtoc addTipPregProtoc(
			@RequestBody AdjuntartipPregProtoc adjuntartipPregProtoc,
			@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocoloAlta) {
		try {
			AdjuntartipPregProtoc adjuntartipPregProtocAux = this.adjuntartipPregProtocService
					.addTipPregProtoc(adjuntartipPregProtoc, codTipoProtocoloAlta);
			logger.info("Entity correctly inserted!");
			return adjuntartipPregProtocAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editTipPregProtoc'.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @param response
	 *            HttpServletResponse
	 * @return AdjuntartipPregProtoc
	 */
	@RequestMapping(value = "/tipPregProtoc", method = RequestMethod.PUT)
	public @ResponseBody AdjuntartipPregProtoc editTipPregProtoc(
			@RequestBody AdjuntartipPregProtoc adjuntartipPregProtoc, HttpServletResponse response) {
		try {

			if (adjuntartipPregProtoc.getTrcotti() != null && !"".equals(adjuntartipPregProtoc.getTrcotti())) {
				// Comprobamos que el codigo de infraccion es valido.
				TipReqNormativo tipReqNormativo = new TipReqNormativo();
				tipReqNormativo.setTticodigo(adjuntartipPregProtoc.getTrcotti());
				try {
					tipReqNormativo = this.tipReqNormativoService.findTipReqNormativoSeleccionable(tipReqNormativo);
				} catch (Exception e) {
					throw new Y41bUDAException("error.tipProtocolo.InfraccionNoValida", true, null);
				}
			}

			AdjuntartipPregProtoc adjuntartipPregProtocAux = this.adjuntartipPregProtocService
					.updateTipPregProtoc(adjuntartipPregProtoc);
			logger.info("Entity correctly inserted!");
			return adjuntartipPregProtocAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeTipPregProtoc'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param codTipoProtocolo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/tipPregProtoc/{trcodigo}", method = RequestMethod.DELETE)
	public void removeTipPregProtoc(@PathVariable String trcodigo,
			@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocolo, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AdjuntartipPregProtoc adjuntartipPregProtoc = new AdjuntartipPregProtoc();
			adjuntartipPregProtoc.setTrcodigo(trcodigo);
			adjuntartipPregProtoc.setTrcotp(codTipoProtocolo);

			this.adjuntartipPregProtocService.remove(adjuntartipPregProtoc);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdProtocoloOrdenadoBusqueda'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/protocoloOrdenadoBusqueda", method = RequestMethod.GET)
	public @ResponseBody Object getByIdProtocoloOrdenadoBusqueda(
			@RequestParam(value = "trcodigo", required = false) String trcodigo, HttpServletRequest request) {
		try {
			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(trcodigo);

			TipPregProtoc tipPregProtoc = new TipPregProtoc();
			tipPregProtoc.setTipProtocolo(tipProtocolo);

			List<TipPregProtoc> listTipPregProtoc = this.tipPregProtocService.findAllProtocoloOrdenado(tipPregProtoc);

			return listTipPregProtoc;
		} catch (Exception e) {
			throw new ResourceNotFoundException(trcodigo.toString());
		}
	}

	/**
	 * Method 'getByIdProtocoloOrdenadoDetalle'.
	 * 
	 * @param codTipoProtocolo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/protocoloOrdenadoDetalle", method = RequestMethod.GET)
	public @ResponseBody Object getByIdProtocoloOrdenadoDetalle(
			@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocolo, HttpServletRequest request) {
		try {

			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(codTipoProtocolo);

			TipPregProtoc tipPregProtoc = new TipPregProtoc();
			tipPregProtoc.setTipProtocolo(tipProtocolo);

			List<TipPregProtoc> listTipPregProtoc = this.adjuntartipPregProtocService
					.findAllProtocoloOrdenado(tipPregProtoc);

			return listTipPregProtoc;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codTipoProtocolo.toString());
		}
	}

	/**
	 * Method 'getImprimirprotocoloOrdenadoDetalle'.
	 * 
	 * @param codTipoProtocolo
	 *            String
	 * @param descprotocolo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/imprimirprotocoloOrdenadoDetalle", method = RequestMethod.GET)
	public @ResponseBody void getImprimirprotocoloOrdenadoDetalle(
			@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocolo,
			@RequestParam(value = "descprotocolo", required = false) String descprotocolo,
			HttpServletResponse response) {
		try {
			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(codTipoProtocolo);

			TipPregProtoc tipPregProtoc = new TipPregProtoc();
			tipPregProtoc.setTipProtocolo(tipProtocolo);

			PlantillaProtocoloDetalle plantillaProtocoloDetalle = this.adjuntartipPregProtocService
					.findPlantillaProtocolo(tipPregProtoc, descprotocolo, false);

			plantillaProtocoloDetalle.setTablaProtocolo(plantillaProtocoloDetalle.getTablaProtocolo()
					.replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;").replaceAll("\u2026", "&ellipsis;"));

			plantillaProtocoloDetalle
					.setTablaProtocolo(Y41bStringUtils.unescapeHTML(plantillaProtocoloDetalle.getTablaProtocolo(), 0));

			if (plantillaProtocoloDetalle == null) {
				throw new Exception(codTipoProtocolo.toString());
			}

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_PROTOCOLO_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_PROTOCOLO_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaProtocoloDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = plantillaProtocoloDetalle.getTipoProtocolo() + ".rtf";

			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombreFichero) + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(codTipoProtocolo.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(codTipoProtocolo.toString());
		}
	}

	/**
	 * Method 'getImprimirprotocoloOrdenadoDetalleConInfraccion'.
	 * 
	 * @param codTipoProtocolo
	 *            String
	 * @param descprotocolo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/imprimirprotocoloOrdenadoDetalleConInfraccion", method = RequestMethod.GET)
	public @ResponseBody void getImprimirprotocoloOrdenadoDetalleConInfraccion(
			@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocolo,
			@RequestParam(value = "descprotocolo", required = false) String descprotocolo,
			HttpServletResponse response) {
		try {
			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(codTipoProtocolo);

			TipPregProtoc tipPregProtoc = new TipPregProtoc();
			tipPregProtoc.setTipProtocolo(tipProtocolo);

			PlantillaProtocoloDetalle plantillaProtocoloDetalle = this.adjuntartipPregProtocService
					.findPlantillaProtocolo(tipPregProtoc, descprotocolo, true);

			plantillaProtocoloDetalle.setTablaProtocolo(plantillaProtocoloDetalle.getTablaProtocolo()
					.replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;").replaceAll("\u2026", "&ellipsis;"));

			plantillaProtocoloDetalle
					.setTablaProtocolo(Y41bStringUtils.unescapeHTML(plantillaProtocoloDetalle.getTablaProtocolo(), 0));

			if (plantillaProtocoloDetalle == null) {
				throw new Exception(codTipoProtocolo.toString());
			}

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_PROTOCOLO_CON_INFRACCION_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_PROTOCOLO_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaProtocoloDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = descprotocolo + ".rtf";

			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombreFichero) + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(codTipoProtocolo.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(codTipoProtocolo.toString());
		}
	}

	/**
	 * Method 'getByIdProtocoloOrdenadoDetalleInspeccion'.
	 * 
	 * @param codTipoProtocolo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/protocoloOrdenadoDetalleInspeccion", method = RequestMethod.GET)
	public @ResponseBody Object getByIdProtocoloOrdenadoDetalleInspeccion(
			@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocolo, HttpServletRequest request) {
		try {

			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(codTipoProtocolo);

			TipPregProtoc tipPregProtoc = new TipPregProtoc();
			tipPregProtoc.setTipProtocolo(tipProtocolo);

			List<TipPregProtoc> listTipPregProtoc = this.adjuntartipPregProtocService
					.findAllProtocoloOrdenadoInspeccion(tipPregProtoc);

			return listTipPregProtoc;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codTipoProtocolo.toString());
		}
	}

	/**
	 * Method 'getImprimirprotocoloOrdenadoDetalle'.
	 * 
	 * @param codTipoProtocolo
	 *            String
	 * @param codActuacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/imprimirprotocoloOrdenadoDetalleInspeccion", method = RequestMethod.GET)
	public @ResponseBody void getImprimirprotocoloOrdenadoDetalleInspeccion(
			@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocolo,
			@RequestParam(value = "codActuacion") String codActuacion, HttpServletResponse response) {
		try {
			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(codTipoProtocolo);

			TipPregProtoc tipPregProtoc = new TipPregProtoc();
			tipPregProtoc.setTipProtocolo(tipProtocolo);

			PlantillaProtocoloDetalle plantillaProtocoloDetalle = this.adjuntartipPregProtocService
					.findPlantillaProtocoloInspeccion(tipPregProtoc, codActuacion);

			plantillaProtocoloDetalle.setTablaProtocolo(plantillaProtocoloDetalle.getTablaProtocolo()
					.replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;").replaceAll("\u2026", "&ellipsis;"));

			plantillaProtocoloDetalle
					.setTablaProtocolo(Y41bStringUtils.unescapeHTML(plantillaProtocoloDetalle.getTablaProtocolo(), 0));

			if (plantillaProtocoloDetalle == null) {
				throw new Exception(codTipoProtocolo.toString());
			}

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_PROTOCOLO_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_PROTOCOLO_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaProtocoloDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = plantillaProtocoloDetalle.getTipoProtocolo() + ".rtf";

			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombreFichero) + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(codTipoProtocolo.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(codTipoProtocolo.toString());
		}
	}

	/**
	 * Method 'getImprimirprotocoloOrdenadoDetalle'.
	 * 
	 * @param codTipoProtocolo
	 *            String
	 * @param codActuacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/imprimirprotocoloDesdeActa", method = RequestMethod.GET)
	public @ResponseBody void getImprimirprotocoloDesdeActa(
			@RequestParam(value = "codTipoProtocolo") String codTipoProtocolo,
			@RequestParam(value = "codActuacion") String codActuacion, HttpServletResponse response) {
		try {
			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(codTipoProtocolo);

			TipPregProtoc tipPregProtoc = new TipPregProtoc();
			tipPregProtoc.setTipProtocolo(tipProtocolo);

			PlantillaProtocoloDetalle plantillaProtocoloDetalle = this.adjuntartipPregProtocService
					.findPlantillaProtocoloInspeccion(tipPregProtoc, codActuacion);

			plantillaProtocoloDetalle.setTablaProtocolo(plantillaProtocoloDetalle.getTablaProtocolo()
					.replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;").replaceAll("\u2026", "&ellipsis;"));

			plantillaProtocoloDetalle
					.setTablaProtocolo(Y41bStringUtils.unescapeHTML(plantillaProtocoloDetalle.getTablaProtocolo(), 0));

			if (plantillaProtocoloDetalle == null) {
				throw new Exception(codTipoProtocolo.toString());
			}

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_PROTOCOLO_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_PROTOCOLO_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaProtocoloDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = plantillaProtocoloDetalle.getTipoProtocolo() + ".rtf";

			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombreFichero) + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(codTipoProtocolo.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(codTipoProtocolo.toString());
		}
	}

	/**
	 * Method 'getByIdProtocoloOrdenadoEdicion'.
	 * 
	 * @param codTipoProtocolo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/protocoloOrdenadoEdicion", method = RequestMethod.GET)
	public @ResponseBody Object getByIdProtocoloOrdenadoEdicion(
			@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocolo,
			@RequestParam(value = "codActuacion") String codActuacion, HttpServletRequest request) {
		try {

			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(codTipoProtocolo);

			TipPregProtoc tipPregProtoc = new TipPregProtoc();
			tipPregProtoc.setTipProtocolo(tipProtocolo);

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(codActuacion);

			List<DetalleProtocolo> listaPreguntasRespuesta = this.actaService.findProtocolo(actuacion, tipProtocolo,
					null);

			return listaPreguntasRespuesta;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codTipoProtocolo.toString());
		}
	}

	/**
	 * Method 'getByIdProtocoloCabecera'.
	 * 
	 * @param codTipoProtocolo
	 *            String
	 * @param codActuacion
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/protocoloCabecera", method = RequestMethod.GET)
	public @ResponseBody Object getByIdProtocoloCabecera(
			@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocolo,
			@RequestParam(value = "codActuacion") String codActuacion, HttpServletRequest request) {
		try {

			ProtocoloCabecera protocoloCabecera = this.protocolService.findCabecera(codActuacion, codTipoProtocolo);

			return protocoloCabecera;
		} catch (Exception e) {
			throw new ResourceNotFoundException("");
		}
	}

	/**
	 * Method 'protocoloGuardarRespuestas'.
	 * 
	 * @param allRequestParams
	 *            Map<String, String>
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/protocoloGuardarRespuestas", method = RequestMethod.GET)
	public @ResponseBody Object protocoloGuardarRespuestas(@RequestParam Map<String, String> allRequestParams,
			HttpServletRequest request) {
		try {

			this.protocolService.updateAnswers(allRequestParams);

			return null;
		} catch (Exception e) {
			throw new ResourceNotFoundException("");
		}
	}

	/**
	 * Method 'copiarTipoProtocolo'.
	 * 
	 * @param copiaTipoProtocolo
	 *            CopiaTipoProtocolo
	 * 
	 */
	@RequestMapping(value = "/copiarTipoProtocolo", method = RequestMethod.POST)
	public @ResponseBody void copiarTipoProtocolo(@RequestBody CopiaTipoProtocolo copiaTipoProtocolo) {
		try {

			this.tipProtocoloService.copiarTipoProtocolo(copiaTipoProtocolo);
			logger.info("Entity correctly inserted!");

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getAllCampanhaProtocolo'.
	 * 
	 * @param codTipoProtocolo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllCampanhaProtocolo", method = RequestMethod.GET)
	public @ResponseBody Object getAllCampanhaProtocolo(
			@ModelAttribute(value = "codTipoProtocolo") String codTipoProtocolo, HttpServletRequest request) {
		try {
			Campanha filterCampanha = new Campanha();
			filterCampanha.setTpcodigo(codTipoProtocolo);
			filterCampanha.setCmincluircerradas(Y41bConstantes.VALOR_SI);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Campanha> campanhas = this.campanhaService.findAllLikeCampanha(filterCampanha, pagination, false);

				if (campanhas == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.campanhaService.findAllLikeCampanhaCount(filterCampanha, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(campanhas);
				return data;
			} else {
				List<Campanha> campanhas = this.campanhaService.findAllLikeCampanha(filterCampanha, pagination, false);

				if (campanhas == null) {
					throw new Exception("No data Found.");
				}
				return campanhas;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
