package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TipPregProtocService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.TipPregProtoc;

/**
 * TipPregProtocController  
 *  
 */
 
@Controller
@RequestMapping (value = "/tippregprotoc")

public class TipPregProtocController  {

	private static final Logger logger = LoggerFactory.getLogger(TipPregProtocController.class);

	@Autowired
	private TipPregProtocService tipPregProtocService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TipPregProtocController.logger.info("[GET - View] : tippregprotoc");
		return "tippregprotoc";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param trcodigo String
	 * @return tipPregProtoc TipPregProtoc
	 */
	@RequestMapping(value = "/{trcodigo}", method = RequestMethod.GET)
	public @ResponseBody TipPregProtoc getById(@PathVariable String trcodigo) {
        TipPregProtoc tipPregProtoc = new TipPregProtoc();
		tipPregProtoc.setTrcodigo(trcodigo);
        tipPregProtoc = this.tipPregProtocService.find(tipPregProtoc);
        TipPregProtocController.logger.info("[GET - findBy_PK] : Obtener TipPregProtoc por PK");
        return tipPregProtoc;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterTipPregProtoc TipPregProtoc
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TipPregProtoc> getAll(@ModelAttribute TipPregProtoc filterTipPregProtoc) {
		TipPregProtocController.logger.info("[GET - find_ALL] : Obtener TipPregProtoc por filtro");
	    return this.tipPregProtocService.findAll(filterTipPregProtoc, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param tipPregProtoc TipPregProtoc 
	 * @return TipPregProtoc
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody TipPregProtoc edit(@RequestBody TipPregProtoc tipPregProtoc) {		
        TipPregProtoc tipPregProtocAux = this.tipPregProtocService.update(tipPregProtoc);
		TipPregProtocController.logger.info("[PUT] : TipPregProtoc actualizado correctamente");
        return tipPregProtocAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param tipPregProtoc TipPregProtoc 
	 * @return TipPregProtoc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipPregProtoc add(@RequestBody TipPregProtoc tipPregProtoc) {		
        TipPregProtoc tipPregProtocAux = this.tipPregProtocService.add(tipPregProtoc);
        TipPregProtocController.logger.info("[POST] : TipPregProtoc insertado correctamente");
    	return tipPregProtocAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param trcodigo String
	 * @return tipPregProtoc
	 */
	@RequestMapping(value = "/{trcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody TipPregProtoc remove(@PathVariable String trcodigo) {
        TipPregProtoc tipPregProtoc = new TipPregProtoc();
        tipPregProtoc.setTrcodigo(trcodigo);
        this.tipPregProtocService.remove(tipPregProtoc);
       	TipPregProtocController.logger.info("[DELETE] : TipPregProtoc borrado correctamente");
       	return tipPregProtoc;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param tipPregProtocIds List
	 * @return tipPregProtocList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> tipPregProtocIds) {
        List<TipPregProtoc> tipPregProtocList = new ArrayList<TipPregProtoc>();
        for (List<String> tipPregProtocId:tipPregProtocIds) {
		    Iterator<String> iterator = tipPregProtocId.iterator();
		    TipPregProtoc tipPregProtoc = new TipPregProtoc(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        tipPregProtoc.setTrcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    tipPregProtocList.add(tipPregProtoc);
	    }
        this.tipPregProtocService.removeMultiple(tipPregProtocList);
		TipPregProtocController.logger.info("[POST - DELETE_ALL] : TipPregProtoc borrados correctamente");
		return tipPregProtocIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterTipPregProtoc TipPregProtoc
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute TipPregProtoc filterTipPregProtoc, @ModelAttribute Pagination pagination) {
        List<TipPregProtoc> tipPregProtocs = this.tipPregProtocService.findAll(filterTipPregProtoc, pagination);
        Long recordNum = this.tipPregProtocService.findAllCount(filterTipPregProtoc);
        TipPregProtocController.logger.info("[GET - jqGrid] : Obtener TipPregProtoc");
		return new JQGridJSONModel(pagination, recordNum, tipPregProtocs);
	}
	
}	
