package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TctipresService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Tctipres;

/**
 * TctipresController  
 *  
 */
 
@Controller
@RequestMapping (value = "/tctipres")

public class TctipresController  {

	private static final Logger logger = LoggerFactory.getLogger(TctipresController.class);

	@Autowired
	private TctipresService tctipresService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TctipresController.logger.info("[GET - View] : tctipres");
		return "tctipres";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param ttrcodigo String
	 * @return tctipres Tctipres
	 */
	@RequestMapping(value = "/{ttrcodigo}", method = RequestMethod.GET)
	public @ResponseBody Tctipres getById(@PathVariable String ttrcodigo) {
        Tctipres tctipres = new Tctipres();
		tctipres.setTtrcodigo(ttrcodigo);
        tctipres = this.tctipresService.find(tctipres);
        TctipresController.logger.info("[GET - findBy_PK] : Obtener Tctipres por PK");
        return tctipres;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterTctipres Tctipres
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Tctipres> getAll(@ModelAttribute Tctipres filterTctipres) {
		TctipresController.logger.info("[GET - find_ALL] : Obtener Tctipres por filtro");
	    return this.tctipresService.findAll(filterTctipres, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param tctipres Tctipres 
	 * @return Tctipres
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Tctipres edit(@RequestBody Tctipres tctipres) {		
        Tctipres tctipresAux = this.tctipresService.update(tctipres);
		TctipresController.logger.info("[PUT] : Tctipres actualizado correctamente");
        return tctipresAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param tctipres Tctipres 
	 * @return Tctipres
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Tctipres add(@RequestBody Tctipres tctipres) {		
        Tctipres tctipresAux = this.tctipresService.add(tctipres);
        TctipresController.logger.info("[POST] : Tctipres insertado correctamente");
    	return tctipresAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param ttrcodigo String
	 * @return tctipres
	 */
	@RequestMapping(value = "/{ttrcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Tctipres remove(@PathVariable String ttrcodigo) {
        Tctipres tctipres = new Tctipres();
        tctipres.setTtrcodigo(ttrcodigo);
        this.tctipresService.remove(tctipres);
       	TctipresController.logger.info("[DELETE] : Tctipres borrado correctamente");
       	return tctipres;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param tctipresIds List
	 * @return tctipresList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> tctipresIds) {
        List<Tctipres> tctipresList = new ArrayList<Tctipres>();
        for (List<String> tctipresId:tctipresIds) {
		    Iterator<String> iterator = tctipresId.iterator();
		    Tctipres tctipres = new Tctipres(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        tctipres.setTtrcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    tctipresList.add(tctipres);
	    }
        this.tctipresService.removeMultiple(tctipresList);
		TctipresController.logger.info("[POST - DELETE_ALL] : Tctipres borrados correctamente");
		return tctipresIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterTctipres Tctipres
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Tctipres filterTctipres, @ModelAttribute Pagination pagination) {
        List<Tctipres> tctipress = this.tctipresService.findAll(filterTctipres, pagination);
        Long recordNum = this.tctipresService.findAllCount(filterTctipres);
        TctipresController.logger.info("[GET - jqGrid] : Obtener Tctipres");
		return new JQGridJSONModel(pagination, recordNum, tctipress);
	}
	
}	
