package com.ejie.y41b.control;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TctiacreService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Tctiacre;

/**
 * TctiacreController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tctiacre")
public class TctiacreController {

	private static final Logger logger = LoggerFactory
			.getLogger(TctiacreController.class);

	@Autowired
	private TctiacreService tctiacreService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TctiacreController.logger.info("[GET - View] : tctiacre");
		return "tctiacre";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tarcodigo
	 *            String
	 * @return tctiacre Tctiacre
	 */
	@RequestMapping(value = "/{tarcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Tctiacre getById(@PathVariable String tarcodigo) {
		Tctiacre tctiacre = new Tctiacre();
		tctiacre.setTarcodigo(tarcodigo);
		tctiacre = this.tctiacreService.find(tctiacre);
		TctiacreController.logger
				.info("[GET - findBy_PK] : Obtener Tctiacre por PK");
		return tctiacre;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTctiacre
	 *            Tctiacre
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Tctiacre> getAll(@ModelAttribute Tctiacre filterTctiacre) {
		TctiacreController.logger
				.info("[GET - find_ALL] : Obtener Tctiacre por filtro");
		return this.tctiacreService.findAll(filterTctiacre, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tctiacre
	 *            Tctiacre
	 * @return Tctiacre
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Tctiacre edit(@RequestBody Tctiacre tctiacre) {
		Tctiacre tctiacreAux = this.tctiacreService.update(tctiacre);
		TctiacreController.logger
				.info("[PUT] : Tctiacre actualizado correctamente");
		return tctiacreAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tctiacre
	 *            Tctiacre
	 * @return Tctiacre
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Tctiacre add(@RequestBody Tctiacre tctiacre) {
		Tctiacre tctiacreAux = this.tctiacreService.add(tctiacre);

		TctiacreController.logger
				.info("[POST] : Tctiacre insertado correctamente");

		return tctiacreAux;
	}

	/**
	 * Method 'getCreateFormAltaTipoResolucion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaTipoResolucion", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaTipoResolucion(Model model,
			HttpServletRequest request) {

		model.addAttribute("tipoResolucion", "");

		model.addAttribute("modoTipoResolucion", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() != null
				&& censoMonitor
						.getPerfilMaestros()
						.getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
			return new ModelAndView("resolucionDetalle", "model", model);
		} else {
			return new ModelAndView("accessDeniedModal", "model", model);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tarcodigo
	 *            String
	 * @return tctiacre
	 */
	@RequestMapping(value = "/{tarcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Tctiacre remove(@PathVariable String tarcodigo) {
		Tctiacre tctiacre = new Tctiacre();
		tctiacre.setTarcodigo(tarcodigo);
		this.tctiacreService.remove(tctiacre);
		TctiacreController.logger
				.info("[DELETE] : Tctiacre borrado correctamente");
		return tctiacre;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tctiacreIds
	 *            List
	 * @return tctiacreList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> tctiacreIds) {
		List<Tctiacre> tctiacreList = new ArrayList<Tctiacre>();
		for (List<String> tctiacreId : tctiacreIds) {
			Iterator<String> iterator = tctiacreId.iterator();
			Tctiacre tctiacre = new Tctiacre(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			tctiacre.setTarcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			tctiacreList.add(tctiacre);
		}
		this.tctiacreService.removeMultiple(tctiacreList);
		TctiacreController.logger
				.info("[POST - DELETE_ALL] : Tctiacre borrados correctamente");
		return tctiacreIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterTctiacre
	 *            Tctiacre
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Tctiacre filterTctiacre,
			@ModelAttribute Pagination pagination) {
		List<Tctiacre> tctiacres = this.tctiacreService.findAll(filterTctiacre,
				pagination);
		Long recordNum = this.tctiacreService.findAllCount(filterTctiacre);
		TctiacreController.logger.info("[GET - jqGrid] : Obtener Tctiacre");
		return new JQGridJSONModel(pagination, recordNum, tctiacres);
	}

	/**
	 * Method 'getAllParametros'. de tipo like
	 * 
	 * @param parametro_
	 *            String
	 * @param cpdesces_
	 *            String
	 * @param cpdesceu_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllTipoResolucion(
			@RequestParam(value = "tarcodigo", required = false) String codigo_,
			@RequestParam(value = "tarnombre", required = false) String nombre_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codigo = ("".equals(codigo_)) ? null : codigo_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;

			Tctiacre filterTipoResolucion = new Tctiacre(codigo, nombre);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Tctiacre> tipoResoluciones = tctiacreService.findAllLike(
						filterTipoResolucion, pagination, false);

				if (tipoResoluciones == null) {
					throw new Exception("No data Found.");
				}

				Long total = tctiacreService.findAllLikeCount(
						filterTipoResolucion, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipoResoluciones);
				return data;
			} else {
				List<Tctiacre> tipoResoluciones = tctiacreService.findAllLike(
						filterTipoResolucion, pagination, false);
				if (tipoResoluciones == null) {
					throw new Exception("No data Found.");
				}
				return tipoResoluciones;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateFormModTipoResolucion'.
	 * 
	 * @param codProcedimental
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modTipoResolucion/{tarcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModTipoResolucion(
			@PathVariable String tarcodigo, Model model,
			HttpServletRequest request) {

		model.addAttribute("tipoResolucion", tarcodigo);

		model.addAttribute("modoTipoResolucion",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Tctiacre tipoResol = new Tctiacre();
		tipoResol.setTarcodigo(tarcodigo);

		if (censoMonitor.getPerfilMaestros() != null
				&& censoMonitor
						.getPerfilMaestros()
						.getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
			return new ModelAndView("resolucionDetalle", "model", model);
		} else {
			return new ModelAndView("accessDeniedModal", "model", model);
		}
	}

}
