package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Tcmotina;
import com.ejie.y41b.service.TcmotinaService;

/**
 * TcmotinaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tcmotina")
public class TcmotinaController {

	private static final Logger logger = LoggerFactory
			.getLogger(TcmotinaController.class);

	@Autowired
	private TcmotinaService tcmotinaService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TcmotinaController.logger.info("[GET - View] : tcmotina");
		return "tcmotina";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param t5codigo
	 *            String
	 * @return tcmotina Tcmotina
	 */
	@RequestMapping(value = "/{t5codigo}", method = RequestMethod.GET)
	public @ResponseBody
	Tcmotina getById(@PathVariable String t5codigo) {
		Tcmotina tcmotina = new Tcmotina();
		tcmotina.setT5codigo(t5codigo);
		tcmotina = this.tcmotinaService.find(tcmotina);
		TcmotinaController.logger
				.info("[GET - findBy_PK] : Obtener Tcmotina por PK");
		return tcmotina;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTcmotina
	 *            Tcmotina
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Tcmotina> getAll(
			@RequestParam(value = "t5y41b", required = false) String t5y41b,
			@ModelAttribute Tcmotina filterTcmotina) {
		filterTcmotina.setT5y41b(t5y41b);
		TcmotinaController.logger
				.info("[GET - find_ALL] : Obtener Tcmotina por filtro");
		return this.tcmotinaService.findAll(filterTcmotina, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @return Tcmotina
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Tcmotina edit(@RequestBody Tcmotina tcmotina) {
		Tcmotina tcmotinaAux = this.tcmotinaService.update(tcmotina);
		TcmotinaController.logger
				.info("[PUT] : Tcmotina actualizado correctamente");
		return tcmotinaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @return Tcmotina
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Tcmotina add(@RequestBody Tcmotina tcmotina) {
		Tcmotina tcmotinaAux = this.tcmotinaService.add(tcmotina);
		TcmotinaController.logger
				.info("[POST] : Tcmotina insertado correctamente");
		return tcmotinaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param t5codigo
	 *            String
	 * @return tcmotina
	 */
	@RequestMapping(value = "/{t5codigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Tcmotina remove(@PathVariable String t5codigo) {
		Tcmotina tcmotina = new Tcmotina();
		tcmotina.setT5codigo(t5codigo);
		this.tcmotinaService.remove(tcmotina);
		TcmotinaController.logger
				.info("[DELETE] : Tcmotina borrado correctamente");
		return tcmotina;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tcmotinaIds
	 *            List
	 * @return tcmotinaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> tcmotinaIds) {
		List<Tcmotina> tcmotinaList = new ArrayList<Tcmotina>();
		for (List<String> tcmotinaId : tcmotinaIds) {
			Iterator<String> iterator = tcmotinaId.iterator();
			Tcmotina tcmotina = new Tcmotina(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			tcmotina.setT5codigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			tcmotinaList.add(tcmotina);
		}
		this.tcmotinaService.removeMultiple(tcmotinaList);
		TcmotinaController.logger
				.info("[POST - DELETE_ALL] : Tcmotina borrados correctamente");
		return tcmotinaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterTcmotina
	 *            Tcmotina
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Tcmotina filterTcmotina,
			@ModelAttribute Pagination pagination) {
		List<Tcmotina> tcmotinas = this.tcmotinaService.findAll(filterTcmotina,
				pagination);
		Long recordNum = this.tcmotinaService.findAllCount(filterTcmotina);
		TcmotinaController.logger.info("[GET - jqGrid] : Obtener Tcmotina");
		return new JQGridJSONModel(pagination, recordNum, tcmotinas);
	}

}
