package com.ejie.y41b.control;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TclugaudService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;

import com.ejie.y41b.model.Tclugaud;

/**
 * TclugaudController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tclugaud")
@SessionAttributes({ "cod", "modoBusqueda", "modo" })
public class TclugaudController {

	private static final Logger logger = LoggerFactory
			.getLogger(TclugaudController.class);

	@Autowired
	private TclugaudService tclugaudService;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * 
	 * @param indIncluirBaja_
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusqueda", "");

		TclugaudController.logger.info("[GET - View] : tclugaud");
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		if (censoMonitor.getPerfilMaestros() == null
				|| (censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO) && censoMonitor
						.getPerfilArbitraje().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO))) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("tclugaud", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionLugarAudiencia", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusqueda", Y41bConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("lugarAudienciaSeleccion", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param t4codigo
	 *            String
	 * @return tclugaud Tclugaud
	 */
	@RequestMapping(value = "/getById/{t4codigo}", method = RequestMethod.GET)
	public @ResponseBody
	Tclugaud getById(@PathVariable String t4codigo) {
		Tclugaud tclugaud = new Tclugaud();
		tclugaud.setT4codigo(t4codigo);
		tclugaud = this.tclugaudService.find(tclugaud);
		TclugaudController.logger
				.info("[GET - findBy_PK] : Obtener Tclugaud por PK");
		return tclugaud;
	}

	/**
	 * Method 'getMotivoById'.
	 * 
	 * @param t4nombre
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findLugarAudiencia/{t4codigo}", method = RequestMethod.GET)
	public @ResponseBody
	Tclugaud getLugarAudienciaById(@PathVariable String t4codigo) {
		try {
			Tclugaud tclugaud = new Tclugaud();
			tclugaud.setT4codigo(t4codigo);
			tclugaud = this.tclugaudService.find(tclugaud);
			if (tclugaud == null) {
				throw new Exception(t4codigo.toString());
			}
			return tclugaud;
		} catch (Exception e) {
			throw new ResourceNotFoundException(t4codigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTclugaud
	 *            Tclugaud
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Tclugaud> getAll(@ModelAttribute Tclugaud filterTclugaud) {
		TclugaudController.logger
				.info("[GET - find_ALL] : Obtener Tclugaud por filtro");
		return this.tclugaudService.findAll(filterTclugaud, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Tclugaud
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Tclugaud edit(@RequestBody Tclugaud tclugaud) {
		Tclugaud tclugaudAux = this.tclugaudService.update(tclugaud);
		TclugaudController.logger
				.info("[PUT] : Tclugaud actualizado correctamente");
		return tclugaudAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Tclugaud
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Tclugaud add(@RequestBody Tclugaud tclugaud) {
		Tclugaud tclugaudAux = this.tclugaudService.add(tclugaud);
		TclugaudController.logger
				.info("[POST] : Tclugaud insertado correctamente");
		return tclugaudAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param t4codigo
	 *            String
	 * @return tclugaud
	 */
	@RequestMapping(value = "/{t4codigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Tclugaud remove(@PathVariable String t4codigo) {
		Tclugaud tclugaud = new Tclugaud();
		tclugaud.setT4codigo(t4codigo);
		this.tclugaudService.remove(tclugaud);
		TclugaudController.logger
				.info("[DELETE] : Tclugaud borrado correctamente");
		return tclugaud;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tclugaudIds
	 *            List
	 * @return tclugaudList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> tclugaudIds) {
		List<Tclugaud> tclugaudList = new ArrayList<Tclugaud>();
		for (List<String> tclugaudId : tclugaudIds) {
			Iterator<String> iterator = tclugaudId.iterator();
			Tclugaud tclugaud = new Tclugaud(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			tclugaud.setT4codigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			tclugaudList.add(tclugaud);
		}
		this.tclugaudService.removeMultiple(tclugaudList);
		TclugaudController.logger
				.info("[POST - DELETE_ALL] : Tclugaud borrados correctamente");
		return tclugaudIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterTclugaud
	 *            Tclugaud
	 * @param pagination
	 *            Pagination
	 * @param indIncluirBaja
	 *            Boolean
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Tclugaud filterTclugaud,
			@ModelAttribute() Pagination pagination,
			@RequestParam(value = "indIncluirBaja", required = false) Boolean indIncluirBaja) {

		// Control para poder paginar por un campo calculado - numeroConsulta
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("direccionCompleta")) {
				pagination.setSort("T4CALLE");
			}
		}

		if (!Y41bUtils.esNullOCadenaVacia(filterTclugaud.getT4nombre())) {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				filterTclugaud.setT4nombre(filterTclugaud.getT4nombre());
			} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
				filterTclugaud.setT4nombreeu(filterTclugaud.getT4nombreeu());
			}
		}
		filterTclugaud.setIndIncluirBaja((indIncluirBaja == null ? false
				: indIncluirBaja.booleanValue()));

		List<Tclugaud> tclugauds = this.tclugaudService.findAllBusqueda(
				filterTclugaud, pagination);
		Long recordNum = this.tclugaudService
				.findAllBusquedaCount(filterTclugaud);
		TclugaudController.logger.debug("[GET - jqGrid] : Obtener Tclugaud");
		return new JQGridJSONModel(pagination, recordNum, tclugauds);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param t4codigo
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/detalle/{t4codigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalle(@PathVariable() String t4codigo,
			Model model) {
		TclugaudController.logger.info("[GET - View] : tclugaud");
		model.addAttribute("t4codigo", t4codigo);
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_MODIFICACION);
		return new ModelAndView("lugarAudienciaDetalle", "model", model);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model) {
		TclugaudController.logger.info("[GET - View] : tclugaud");
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_ALTA);
		return new ModelAndView("lugarAudienciaDetalle", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param t4codigo
	 *            String
	 * @return tclugaud Tclugaud
	 */
	@RequestMapping(value = "/existe/{t4codigo}", method = RequestMethod.GET)
	public @ResponseBody()
	long existe(@PathVariable() String t4codigo) {
		Tclugaud tclugaud = new Tclugaud();
		tclugaud.setT4codigo(t4codigo);
		return this.tclugaudService.findAllCount(tclugaud);
	}

	// /**
	// * Method 'borrarTemporales'.
	// *
	// * @param oecodigo
	// * String
	// */
	// @RequestMapping(value = "/borrarTemporales/{t4codigo}", method =
	// RequestMethod.DELETE)
	// @ResponseStatus(value = HttpStatus.OK)
	// public @ResponseBody()
	// void borrarTemporales(@PathVariable() String t4codigo) {
	// Tclugaud tclugaud = new Tclugaud();
	// tclugaud.setT4codigo(t4codigo);
	// this.tclugaudService.borrarTemporales(tclugaud);
	// OoeeController.logger
	// .info("[DELETE] : Tclugaud Temporalres borrado correctamente");
	//
	// }

	/**
	 * Method 'getAllExcel'.
	 * 
	 * @param filterTclugaud
	 *            Tclugaud
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllExcel(@ModelAttribute() Tclugaud filterTclugaud,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			if (!Y41bUtils.esNullOCadenaVacia(filterTclugaud.getT4nombre())) {
				Locale locale = LocaleContextHolder.getLocale();
				String idioma = locale.getLanguage();
				if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					filterTclugaud.setT4nombre(filterTclugaud.getT4nombre());
				} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
					filterTclugaud
							.setT4nombreeu(filterTclugaud.getT4nombreeu());
				}
			}

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");
			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_TCLUGAUD + fechaActual
					+ ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService
					.getTclugaudExcel(filterTclugaud);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

}
