package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.jms.Y41bSirJMSService;
import com.ejie.y41b.jms.Y41bSolicitudesTelematicasEventosClientJMSService;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.SolicitudTelematicaEventos;
import com.ejie.y41b.service.SolicitudesTelematicasEventosService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SolicitudesTelematicasController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/solicitudesTelematicasEventos")
public class SolicitudesTelematicasEventosController {

	private static final Logger logger = LoggerFactory.getLogger(SolicitudesTelematicasEventosController.class);

	@Autowired
	private SolicitudesTelematicasEventosService solicitudesTelematicasEventosService;

	@Autowired
	private Y41bSolicitudesTelematicasEventosClientJMSService y41bSolicitudesTelematicasEventosClientJMSService;

	@Autowired
	private Y41bSirJMSService y41bSirJMSService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if ((censoMonitor.getPerfilSolicitudes() != null
				&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR))
				|| (censoMonitor.getPerfilSanciones() != null
						&& censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR))
				|| (censoMonitor.getPerfilArbitraje() != null
						&& censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR))
				|| (censoMonitor.getPerfilInspecciones() != null && censoMonitor.getPerfilInspecciones().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SUPERVISOR))) {

			return new ModelAndView("solicitudesTelematicas", "model", model);

		} else {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		}

	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param rmcodigoRemesa_
	 *            String
	 * @param defereDesde_
	 *            String
	 * @param defereHasta_
	 *            String
	 * @param rmtipo_
	 *            String
	 * @param rmcodOrg_
	 *            String
	 * @param rmtipoexpediente_
	 *            String
	 * @param rmestado_
	 *            String
	 * @param rmcheckcerradas_
	 *            String
	 * @param fechaActEnvDesde_
	 *            String
	 * @param fechaActEnvHasta_
	 *            String
	 * @param rmestadoenvio_
	 *            String
	 * @param rmsituacioncorreos_
	 *            String
	 * @param rmsituacionacuse_
	 *            String
	 * @param rmestadoacuse_
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return JQGridJSONModel
	 */

	@RequestMapping(value = "/busquedaSolicitudesTelematicasEventos", method = RequestMethod.GET)
	public @ResponseBody Object getAllSolicitudesTelematicasEventos(
			@RequestParam(value = "tipoExpediente", required = false) String tipoExpediente_,
			@RequestParam(value = "accionTelematica", required = false) String accionTelematica_,
			@RequestParam(value = "fechaRegistroDesde", required = false) String fechaRegistroDesde_,
			@RequestParam(value = "fechaRegistroHasta", required = false) String fechaRegistroHasta_,
			HttpServletRequest request) {

		try {

			// control de los campos susceptibles de llegar a "" desde el filtro
			String tipoExpediente = ("".equals(tipoExpediente_)) ? null : tipoExpediente_;
			String accionTelematica = ("".equals(accionTelematica_)) ? null : accionTelematica_;

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date fechaRegistroDesde = Y41bUtils.parseDate(fechaRegistroDesde_, locale);
			Date fechaRegistroHasta = Y41bUtils.parseDate(fechaRegistroHasta_, locale);

			SolicitudTelematicaEventos filterSolicitudTelematicaEventos = new SolicitudTelematicaEventos();
			filterSolicitudTelematicaEventos.setStTipoExpediente(tipoExpediente);
			filterSolicitudTelematicaEventos.setStIdAccionTelematica(accionTelematica);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<SolicitudTelematicaEventos> listaSolicitudTelematicaEventos = new ArrayList<SolicitudTelematicaEventos>();

				listaSolicitudTelematicaEventos = this.solicitudesTelematicasEventosService
						.findAllListaSolicitudTelematicaEventos(filterSolicitudTelematicaEventos, fechaRegistroDesde,
								fechaRegistroHasta, pagination);

				if (listaSolicitudTelematicaEventos == null) {
					throw new Exception("No data Found.");
				}

				Long total = new Long(0);

				total = this.solicitudesTelematicasEventosService.findAllListaSolicitudTelematicaEventosCount(
						filterSolicitudTelematicaEventos, fechaRegistroDesde, fechaRegistroHasta);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaSolicitudTelematicaEventos);
				return data;
			} else {
				List<SolicitudTelematicaEventos> listaSolicitudTelematicaEventos = new ArrayList<SolicitudTelematicaEventos>();

				listaSolicitudTelematicaEventos = this.solicitudesTelematicasEventosService
						.findAllListaSolicitudTelematicaEventos(filterSolicitudTelematicaEventos, fechaRegistroDesde,
								fechaRegistroHasta, null);

				if (listaSolicitudTelematicaEventos == null) {
					throw new Exception("No data Found.");
				}

				return listaSolicitudTelematicaEventos;
			}
		} catch (Exception e) {

			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'findXmlSolicitud'.
	 * 
	 * @param idsolicitud
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findXmlSolicitud/{stCodigo}", method = RequestMethod.GET)
	public @ResponseBody void findXmlSolicitud(@PathVariable String stCodigo, HttpServletResponse response) {
		try {
			SolicitudTelematicaEventos solicitud = new SolicitudTelematicaEventos();
			solicitud.setStCodigo(stCodigo);
			solicitud = this.solicitudesTelematicasEventosService.findXmlSolicitud(solicitud);

			// Fin Bloque del Test
			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition", "attachment;filename=\"solicitud.xml\"");
			response.setContentType("application/xml");
			if (solicitud.getStXMLSolicitud() != null) {
				byte[] fileArray = IOUtils.toByteArray(solicitud.getStXMLSolicitud().getCharacterStream(), "UTF-8");
				response.getOutputStream().write(fileArray);
			}
			response.getOutputStream().flush();
		} catch (Exception e) {
			throw new ResourceNotFoundException(stCodigo.toString());
		}
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param solicitud
	 *            SolicitudTelematicaEventos Bean que contiene la informacion
	 *            con la que se va a crear el nuevo registro.
	 * @return SolicitudTelematicaEventos Bean resultante del proceso de
	 *         creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody SolicitudTelematicaEventos add(
			@RequestBody SolicitudTelematicaEventos solicitudTelematicaEventos) {
		SolicitudTelematicaEventos solicitudTelematicaEventosAux = this.solicitudesTelematicasEventosService
				.add(solicitudTelematicaEventos);
		SolicitudesTelematicasEventosController.logger.info("[POST] : Solicitud insertado correctamente");
		return solicitudTelematicaEventosAux;
	}

	/**
	 * Method 'onMessage'.
	 * 
	 * @param stCodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/onMessage/{stCodigo}/{stIdAccionTelematica}", method = RequestMethod.POST)
	public void onMessage(@PathVariable String stCodigo, @PathVariable String stIdAccionTelematica,
			HttpServletResponse response) throws Exception {

		SolicitudTelematicaEventos solicitudTelematicaEventos = new SolicitudTelematicaEventos();
		solicitudTelematicaEventos.setStCodigo(stCodigo);
		solicitudTelematicaEventos = this.solicitudesTelematicasEventosService
				.findXmlSolicitud(solicitudTelematicaEventos);

		String mensajeStr = Y41bUtils.clobToString(solicitudTelematicaEventos.getStXMLSolicitud());

		if (stIdAccionTelematica.equalsIgnoreCase(Y41bConstantes.TEXTO_SIR)) {
			y41bSirJMSService.sendMessage(this.putCData(mensajeStr));

		} else {
			y41bSolicitudesTelematicasEventosClientJMSService.sendMessage(this.putCData(mensajeStr));

		}
		solicitudTelematicaEventos.setStIdAccionTelematica(stIdAccionTelematica);
		this.solicitudesTelematicasEventosService.onMessage(solicitudTelematicaEventos);

	}

	/**
	 * Method 'putCData'.
	 * 
	 * @param mensaje
	 *            String
	 * @return String
	 */
	private String putCData(String mensaje) {
		String mensajeCData = mensaje;
		// PRESENTACION DE SOLICITUD
		mensajeCData = mensajeCData.replaceAll("<Value><contextSubmission", "<Value><![CDATA[<contextSubmission");
		mensajeCData = mensajeCData.replaceAll("</contextSubmission></Value>", "</contextSubmission>]]></Value>");

		mensajeCData = mensajeCData.replaceAll("<Value><documentsBO", "<Value><![CDATA[<documentsBO");
		mensajeCData = mensajeCData.replaceAll("</documentsBO></Value>", "</documentsBO>]]></Value>");
		// R02_NOTIFICATION + APORTACION DE DOCUMENTOS
		mensajeCData = mensajeCData.replaceAll("<xmlValue><notificationEvent", "<xmlValue><![CDATA[<notificationEvent");
		mensajeCData = mensajeCData.replaceAll("</notificationEvent></xmlValue>", "</notificationEvent>]]></xmlValue>");
		// LOCATOR_RESULT - No se necesita ningun replace
		return mensajeCData;
	}
}
