package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.adapter.Y41bEIKAAdapterService;
import com.ejie.y41b.constantes.Y41bADOConstantes;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.Adjuntardocs;

import com.ejie.y41b.model.ArbFicheroADO;
import com.ejie.y41b.model.ArbPagoArbitroADO;
import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arbpropbandeja;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Dtsa;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.Essa;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.FiltroArbitraje;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Jjaa;
import com.ejie.y41b.model.Ooee;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Pagosarbitros;
import com.ejie.y41b.model.Parametros;
//import com.ejie.y41b.model.Perfil;
//import com.ejie.y41b.model.PlantillaPegatinaEstablecimiento;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolarbKgest;
import com.ejie.y41b.model.SolicitudBusqueda;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.model.Tclugaud;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.ArbexpService;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.ArbpropbandejaService;
import com.ejie.y41b.service.Arbtramexp2Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.DtsaService;
import com.ejie.y41b.service.EssaService;
import com.ejie.y41b.service.EstablecimientoService;
import com.ejie.y41b.service.OoeeService;
import com.ejie.y41b.service.OrganismoService;
import com.ejie.y41b.service.PagosarbitrosService;
import com.ejie.y41b.service.ParametrosService;
import com.ejie.y41b.service.ProductoService;
import com.ejie.y41b.service.SanexprelService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.service.T17MunicipioService;
import com.ejie.y41b.service.T17ProvinciaService;
import com.ejie.y41b.service.TclugaudService;
import com.ejie.y41b.service.TramiteHechoService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.modulos.Y41bModuloUtils;

/**
 * SolarbController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/solarb")
@SessionAttributes({ "numPetActEst", "mesesPetActEst", "numMailsIconoWeb", "mesesMailsIconoWeb" })
public class SolarbController {

	private static final Logger logger = LoggerFactory.getLogger(SolarbController.class);

	@Autowired()
	private SolarbService solarbService;

	@Autowired()
	private TclugaudService tclugaudService;

	@Autowired()
	private ProductoService productoService;

	@Autowired()
	private HechoDenunciadoDao hechodenunciadoDao;

	@Autowired()
	private SanexprelService sanexprelService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private CensoMonitorService censoMonitorService;

	@Autowired()
	private ArbexpService arbexpService;

	@Autowired()
	private OrganismoService organismoService;

	@Autowired()
	private ArbpropbandejaService arbpropbandejaService;

	@Autowired()
	private Arbtramexp2Service arbtramexp2Service;

	@Autowired()
	private ArbintervService arbintervService;

	@Autowired()
	private EstablecimientoService establecimientoService;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private OoeeService ooeeService;

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired()
	private ArbtramexpService arbtramexpService;

	@Autowired()
	private ArbdoctempService arbdoctempService;

	@Autowired()
	private ParametrosService parametrosService;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired()
	private T17MunicipioService municipioService;
	@Autowired()
	private T17ProvinciaService provinciaService;
	@Autowired()
	private TramiteHechoService tramiteHechoService;
	@Autowired()
	private EssaService essaService;
	@Autowired()
	private DtsaService dtsaService;
	@Autowired()
	private PagosarbitrosService pagosArbitrosService;
	@Autowired()
	private Y41bEIKAAdapterService y41bEIKAAdapterService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SolarbController.logger.info("[GET - View] : solarb");
		return "solarb";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sacodigo
	 *            String
	 * @return solarb Solarb
	 */
	@RequestMapping(value = "/{sacodigo}", method = RequestMethod.GET)
	public @ResponseBody() Solarb getById(@PathVariable() String sacodigo) {
		Solarb solarb = new Solarb();
		solarb.setSacodigo(sacodigo);
		solarb = this.solarbService.find(solarb);
		SolarbController.logger.info("[GET - findBy_PK] : Obtener Solarb por PK");
		return solarb;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSolarb
	 *            Solarb
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody() List<Solarb> getAll(@ModelAttribute() Solarb filterSolarb) {
		SolarbController.logger.info("[GET - find_ALL] : Obtener Solarb por filtro");
		return this.solarbService.findAll(filterSolarb, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() Solarb edit(@RequestBody() Solarb solarb, HttpServletRequest request) {

		HttpSession httpSession = request.getSession(false);

		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		solarb = this.solarbService.actualizaExpediente(solarb, censoMonitor);

		SolarbController.logger.info("[PUT] : Solarb actualizado correctamente");
		return solarb;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() Solarb add(@RequestBody() Solarb solarb) {

		Map<String, Object> retornoAlta = new HashMap<String, Object>();
		try {

			// si el tipo de presentacion es ODR, el campo forma presentacion
			// tiene que ser NULL

			if (solarb.getArbexp().getExtippres().equals(Y41bConstantes.TIPOPRES_ARB_ODR)) {
				solarb.getArbexp().setExformapres(null);
			}
			solarb.setSafesoli(Y41bUtils.obtenerFechaHoy());

			retornoAlta = this.solarbService.add(solarb);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Solarb solarbAux = (Solarb) retornoAlta.get("solarb");
		SolarbController.logger.info("[POST] : Solarb insertado correctamente");
		return solarbAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param sacodigo
	 *            String
	 * @return solarb
	 */
	@RequestMapping(value = "/{sacodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() Solarb remove(@PathVariable() String sacodigo) {
		Solarb solarb = new Solarb();
		solarb.setSacodigo(sacodigo);
		this.solarbService.remove(solarb);
		SolarbController.logger.info("[DELETE] : Solarb borrado correctamente");
		return solarb;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param solarbIds
	 *            List
	 * @return solarbList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() List<List<String>> removeMultiple(@RequestBody() List<List<String>> solarbIds) {
		List<Solarb> solarbList = new ArrayList<Solarb>();
		for (List<String> solarbId : solarbIds) {
			Iterator<String> iterator = solarbId.iterator();
			Solarb solarb = new Solarb(); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			solarb.setSacodigo(ObjectConversionManager.convert(iterator.next(), String.class));
			solarbList.add(solarb);
		}
		this.solarbService.removeMultiple(solarbList);
		SolarbController.logger.info("[POST - DELETE_ALL] : Solarb borrados correctamente");
		return solarbIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSolarb
	 *            Solarb
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGrid(@ModelAttribute() Solarb filterSolarb,
			@ModelAttribute() Pagination pagination) {
		List<Solarb> solarbs = this.solarbService.findAll(filterSolarb, pagination);
		Long recordNum = this.solarbService.findAllCount(filterSolarb);
		SolarbController.logger.info("[GET - jqGrid] : Obtener Solarb");
		return new JQGridJSONModel(pagination, recordNum, solarbs);
	}

	/**
	 * Method 'getAllExpedientesAbiertosCount'.
	 * 
	 * @param tipoentidad
	 *            String
	 * @param entidad
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/busquedaExpedientesAbiertos/{tipoentidad}/{entidad}", method = RequestMethod.GET)
	public @ResponseBody() Long getAllExpedientesAbiertosCount(@PathVariable() String tipoentidad,
			@PathVariable() String entidad, HttpServletRequest request) {
		Long total = new Long("0");
		try {
			Solarb solarrb = new Solarb();
			if (Y41bConstantes.CENSO_ARB_OOEE.equals(tipoentidad)) {
				Ooee ooee = new Ooee();
				ooee.setOecodigo(entidad);
				solarrb.setOoee(ooee);
			} else if (Y41bConstantes.CENSO_ARB_AACC.equals(tipoentidad)) {
				Aacc aacc = new Aacc();
				aacc.setCccodigo(entidad);
				solarrb.setAacc(aacc);
			} else if (Y41bConstantes.CENSO_ARB_ARBITRO.equals(tipoentidad)) {
				Arbitro aacc = new Arbitro();
				aacc.setArcodigo(entidad);
				solarrb.setArbitro(aacc);
			} else if (Y41bConstantes.CENSO_ARB_EMPPER.equals(tipoentidad)) {
				Empper empper = new Empper();
				empper.setPecodigo(entidad);
				solarrb.setEmpper(empper);
			} else if (Y41bConstantes.CENSO_ARB_JJAA.equals(tipoentidad)) {
				Jjaa jjaa = new Jjaa();
				jjaa.setJacodigo(entidad);
				solarrb.setJjaa(jjaa);
			} else if (Y41bConstantes.CENSO_ARB_TCLUGAUD.equals(tipoentidad)) {
				Tclugaud tclugaud = new Tclugaud();
				tclugaud.setT4codigo(entidad);
				solarrb.setTclugaud(tclugaud);
			}

			total = this.solarbService.findAllCount(solarrb);
			// return total;

			if (total > 0) {
				return total;
			} else {
				Arbexp arbexpp = new Arbexp();
				Arbtramexp exp = new Arbtramexp();

				// se han elimiando los if que comprobaban los rbitros en
				// artramexp porque
				// ahora estos campos ya se consolidan

				if (Y41bConstantes.CENSO_ARB_TCLUGAUD.equals(tipoentidad)) {
					exp.setTrclugaud(entidad);
					arbexpp.setArbtramexp(exp);
					total = this.arbexpService.findExpedientesAbiertos(arbexpp);
				}

			}
			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getFichaExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            String
	 * @param accesoPest2
	 *            String
	 * @param sacodigo
	 *            String
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/maintBusquedaArbitraje/fichaExpedienteArbitraje/{sacodigo}", method = RequestMethod.GET)
	public ModelAndView getFichaExpediente(Model model, @RequestParam(value = "desde", required = false) String desde,
			@RequestParam(value = "accesoPest2", required = false) String accesoPest2, @PathVariable() String sacodigo,
			HttpServletRequest httpRequest) {

		try {
			sacodigo = new String(Y41bUtilsDokusi.decode(sacodigo));
			return this.solarbService.getFichaExpedienteArbitraje(model, desde, accesoPest2, sacodigo, httpRequest);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true, e);
		}
	}

	/**
	 * Method 'getFichaExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            String
	 * @param accesoPest2
	 *            String
	 * @param sacodigo
	 *            String
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "fichaExpedienteArbitraje/{sacodigo}", method = RequestMethod.GET)
	public ModelAndView getFichaExpediente2(Model model, @RequestParam(value = "desde", required = false) String desde,
			@RequestParam(value = "accesoPest2", required = false) String accesoPest2, @PathVariable() String sacodigo,
			HttpServletRequest httpRequest) {

		try {
			String sacodigoDecode = new String(Y41bUtilsDokusi.decode(sacodigo));
			return this.solarbService.getFichaExpedienteArbitraje(model, desde, accesoPest2, sacodigoDecode,
					httpRequest);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true, e);
		}
	}

	/**
	 * Method 'getFichaExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            String
	 * @param accesoPest2
	 *            String
	 * @param sacodigo
	 *            String
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "fichaExpedienteArbitrajeSinCabecera/{sacodigo}", method = RequestMethod.GET)
	public ModelAndView getFichaExpediente2SinCabecera(Model model,
			@RequestParam(value = "desde", required = false) String desde,
			@RequestParam(value = "accesoPest2", required = false) String accesoPest2, @PathVariable() String sacodigo,
			HttpServletRequest httpRequest) {

		try {
			String sacodigoDecode = new String(Y41bUtilsDokusi.decode(sacodigo));
			return this.solarbService.getFichaExpedienteArbitraje(model, desde, accesoPest2, true, sacodigoDecode,
					httpRequest);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true, e);
		}
	}

	/**
	 * Method 'getExpedientePestania1'.
	 * 
	 * @param model
	 *            Model
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedientePestania1", method = RequestMethod.GET)
	public ModelAndView getExpedientePestania1(Model model, HttpServletRequest httpRequest) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = this.censoMonitorService.find(censoMonitor);
		String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();
		if (perfil != null && Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
			// Si perfil sin acceso devolvemos listado vacio
			return new ModelAndView("accessDenied", "model", model);
		} else {
			return new ModelAndView("fichaExpedienteArbitrajePestania1", "model", model);
		}
	}

	/**
	 * Method 'getExpedientePestania2'.
	 * 
	 * @param model
	 *            Model
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedientePestania2", method = RequestMethod.GET)
	public ModelAndView getExpedientePestania2(Model model, HttpServletRequest httpRequest) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = this.censoMonitorService.find(censoMonitor);

		String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();
		if (perfil != null && Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
			// Si perfil sin acceso devolvemos listado vacio
			return new ModelAndView("accessDenied", "model", model);
		} else {
			return new ModelAndView("fichaExpedienteArbitrajePestania2", "model", model);
		}
	}

	/**
	 * Method 'getExpedientePestania3'.
	 * 
	 * @param model
	 *            Model
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedientePestania3", method = RequestMethod.GET)
	public ModelAndView getExpedientePestania3(Model model, HttpServletRequest httpRequest) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = this.censoMonitorService.find(censoMonitor);
		String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();
		if (perfil != null && Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
			// Si perfil sin acceso devolvemos listado vacio
			return new ModelAndView("accessDenied", "model", model);
		} else {
			return new ModelAndView("fichaExpedienteArbitrajePestania3", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sacodigo
	 *            String
	 * @return solarb Expedien
	 * @throws Y41bUDAException
	 *             Exception
	 */
	@RequestMapping(value = "/fichaArbitraje", method = RequestMethod.GET)
	public @ResponseBody() Map<String, Object> getByIdFichaArbitraje(
			@RequestParam(value = "sacodigo", required = true) String sacodigo) throws Y41bUDAException {
		Map<String, Object> mapa = new HashMap<String, Object>();
		try {

			Locale locale = LocaleContextHolder.getLocale();

			SolarbController.logger.info("[GET - findBy_PK] : Obtener Expedien por PK . AAAAAAAAAAA");
			Solarb solarb = new Solarb();

			Sanexprel sanexprel = new Sanexprel();
			solarb.setSacodigo(sacodigo);
			sanexprel.setRlarbcodigo(sacodigo);
			List<Sanexprel> listaRelacionados = this.sanexprelService.findAll(sanexprel, null);

			solarb = this.solarbService.find(solarb);
			solarb.setcodCompleto(solarb.damecodCompleto());

			if (solarb.getSacops() != null) {
				solarb.setProducto(this.productoService.find(new Producto(solarb.getSacops())));
			} else {
				solarb.setProducto(null);
			}

			Arbexp arbexp = this.arbexpService.find(new Arbexp(sacodigo));

			if (arbexp.getExcoorg() != null) {
				Organismo organismo = this.organismoService.find(new Organismo(arbexp.getExcoorg()));
				if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
					arbexp.setOrganismoDesc(organismo.getNombreEu());
				} else if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
					arbexp.setOrganismoDesc(organismo.getNombreEs());
				}
			}

			if (solarb.getSacohd() != null) {
				arbexp.setHechoDenunciado(this.hechodenunciadoDao.find(new HechoDenunciado(solarb.getSacohd())));
			} else {
				arbexp.setHechoDenunciado(null);
			}

			arbexp.setImportePret(Y41bUtils.formatearAEuros(arbexp.getHdcaptso()));
			if (!Y41bUtils.esNullOCadenaVacia(arbexp.getEximporteSol())) {
				arbexp.setEximporteSol(Y41bUtils.formatearAEuros(new BigDecimal(arbexp.getEximporteSol())));
			}
			if (!Y41bUtils.esNullOCadenaVacia(arbexp.getEximporteOtor())) {
				arbexp.setEximporteOtor(Y41bUtils.formatearAEuros(new BigDecimal(arbexp.getEximporteOtor())));
			}

			solarb.setArbexp(arbexp);

			StringBuffer exp_relacionados = new StringBuffer();
			if (listaRelacionados != null) {
				TramiteHecho tramitehecho = new TramiteHecho();
				boolean hayMediacion = false;
				for (int i = 0; i < listaRelacionados.size(); i++) {
					sanexprel = listaRelacionados.get(i);
					if (!sanexprel.getRlesorig().equals(Y41bConstantes.VALOR_NO)) {
						if (exp_relacionados.length() > 0) {
							exp_relacionados.append("\n");
						}
						exp_relacionados.append(sanexprel.getCodCompleto());
						if (sanexprel.getRlesorig().equals(Y41bConstantes.VALOR_SI)) {
							solarb.getArbexp().setTipoprocOrigen(sanexprel.getTipoProcedimiento().getPnombre());
						}
						// Existe mediacion en la reclamacin relacionada
						if (sanexprel.getRlhdcodrel() != null && !hayMediacion) {
							tramitehecho.setEhcohd(sanexprel.getRlhdcodrel());
							tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_MEDIACION_PRESENCIAL);
							tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
							Long cont1 = this.tramiteHechoService.findAllCount(tramitehecho);
							tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_MEDIACION_TELEFONICA);
							Long cont2 = this.tramiteHechoService.findAllCount(tramitehecho);
							if (cont1.longValue() > 0L || cont2.longValue() > 0L) {
								hayMediacion = true;
							}
						}
					}

				}
				if (hayMediacion) {
					mapa.put("mediacionHdRel", Y41bConstantes.VALOR_SI);
				} else {
					mapa.put("mediacionHdRel", Y41bConstantes.VALOR_NO);
				}

			}

			solarb.getArbexp().setExpedienteOrigen(exp_relacionados.toString());

			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setSolarb(new Solarb(sacodigo));

			List<Arbinterv> listaArbtinterv = this.arbintervService.findAll(arbinterv, null);
			boolean tieneDireccionCompleta = true;
			if (listaArbtinterv != null && listaArbtinterv.size() > 0) {
				for (int i = 0; i < listaArbtinterv.size(); i++) {
					arbinterv = listaArbtinterv.get(i);
					if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
							|| Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())) {
						if (!Y41bConstantes.COD_PAIS_ESTADO.equals(arbinterv.getUapaisId())) { // si
																								// es
																								// extranjero
							if (!Y41bUtils.esNullOCadenaVacia(arbinterv.getUapaisId())
									&& !Y41bUtils.esNullOCadenaVacia(arbinterv.getUadireNocapv())) {
								tieneDireccionCompleta = true;
							} else {
								tieneDireccionCompleta = false;
							}
						} else {// si es nacional
							if (!Y41bUtils.esNullOCadenaVacia(arbinterv.getUaprovId())
									&& !Y41bUtils.esNullOCadenaVacia(arbinterv.getUamunId())) {
								if (arbinterv.getUamunId() != null && arbinterv.getUaprovId() != null) {
									T17Municipio municipio = this.municipioService.find(this
											.crearMunicipio(arbinterv.getUamunId(), arbinterv.getUaprovId(), sacodigo));
									arbinterv.setMunicipioTxt(municipio.getDsO());
								}

								if (arbinterv.getUaprovId() != null) {
									T17Provincia provincia = this.provinciaService
											.find(this.crearProvincia(arbinterv.getUaprovId(), sacodigo));
									arbinterv.setProvinciaTxt(provincia.getDsO());
								}
								if (!Y41bUtils.esNullOCadenaVacia(arbinterv.getProvinciaTxt())
										&& !Y41bUtils.esNullOCadenaVacia(arbinterv.getMunicipioTxt())) {
									// si es de capv
									if (arbinterv.getUaprovId().equals(Y41bConstantes.CODIGO_PROVINCIA_ARABA)
											|| arbinterv.getUaprovId().equals(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)
											|| arbinterv.getUaprovId()
													.equals(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
										if (!Y41bUtils.esNullOCadenaVacia(arbinterv.getUacalleId())) {
											tieneDireccionCompleta = true;
										} else {
											tieneDireccionCompleta = false;
										}
									} else { // si no es de capv
										if (!Y41bUtils.esNullOCadenaVacia(arbinterv.getUadireNocapv())) {// si
																											// NO
																											// es
																											// de
																											// capv
											tieneDireccionCompleta = true;
										} else {
											tieneDireccionCompleta = false;
										}
									}
								} else {// Es nacional y no tiene descripcin de
										// provincia y municipio
									tieneDireccionCompleta = false;
								}
							} else {// Es nacional y no tiene provincia
								tieneDireccionCompleta = false;
							}
						}
						if (tieneDireccionCompleta) {
							arbinterv.setDireccionCompleta("OK");
						} else {
							arbinterv.setDireccionCompleta("ERROR");
						}
						if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())) {
							solarb.setReclamado(arbinterv);
						} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
							solarb.setReclamante(arbinterv);
						}
					}

				}
			}

			mapa.put("solarb", solarb);

			mapa = this.arbtramexp2Service.obtenerDatosTramitesFichaArbitraje(sacodigo, mapa);

			SolarbController.logger.info("[GET - findBy_PK] : Obtener Expedien por PK");
			return mapa;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true, e);
		}
	}

	/**
	 * Method 'getEtiquetaBySacodigo'.
	 * 
	 * @param sacodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/etiqueta", method = RequestMethod.GET)
	public @ResponseBody() void getEtiquetaBySacodigo(
			@RequestParam(value = "sacodigo", required = true) String sacodigo, HttpServletResponse response) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			sacodigo = new String(Y41bUtilsDokusi.decode(sacodigo));

			Solarb solarb = new Solarb();
			solarb.setSacodigo(sacodigo);
			solarb = this.solarbService.find(solarb);
			if (solarb == null) {
				throw new Exception(sacodigo.toString());
			}
			// Nrex
			solarb.setNrex(solarb.damecodCompleto());
			// Tipo
			if (solarb.getSaintiso() != null
					&& solarb.getSaintiso().equals(Y41bConstantes.ARBITRAJE_SAINTISO_EQUIDAD)) {
				solarb.setSaintiso(Y41bConstantes.ARBITRAJE_EQUIDAD);
			} else if (solarb.getSaintiso() != null
					&& solarb.getSaintiso().equals(Y41bConstantes.ARBITRAJE_SAINTISO_DERECHO)) {
				solarb.setSaintiso(Y41bConstantes.ARBITRAJE_DERECHO);
			}
			// Presentado
			if (solarb.getSainacuo() != null
					&& solarb.getSainacuo().equals(Y41bConstantes.ARBITRAJE_SAINACUO_PARTICULAR)) {
				solarb.setSainacuo(Y41bConstantes.ARBITRAJE_PARTICULAR);
			} else if (solarb.getSainacuo() != null
					&& solarb.getSainacuo().equals(Y41bConstantes.ARBITRAJE_SAINACUO_ORGANISMO)) {
				Organismo organismo = this.arbexpService.dameNombreOrganismo(solarb.getSacodigo());
				if (organismo != null) {
					if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
						solarb.setSainacuo(organismo.getNombreEs());
					} else if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
						solarb.setSainacuo(organismo.getNombreEu());
					}
				}
			}
			// Exfereg
			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(sacodigo);
			arbexp = this.arbexpService.find(arbexp);
			solarb.setArbexp(arbexp);

			// Lugar
			Arbtramexp arbtramexp = new Arbtramexp();
			Tclugaud lugarAud = new Tclugaud();

			arbtramexp.setTrestado("T");
			arbtramexp.setTrexcodigo(solarb.getSacodigo());
			arbtramexp = arbtramexpService.dameUltimaAudiencia(arbtramexp);
			if (arbtramexp != null) {
				lugarAud.setT4codigo(arbtramexp.getTrclugaud());
				lugarAud = tclugaudService.find(lugarAud);
				if (lugarAud != null) {
					if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
						// Se mantiene nombre
					} else if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
						lugarAud.setT4nombre(lugarAud.getT4nombreeu());
					}
				}
				solarb.setTclugaud(lugarAud);
			}

			// Arbinterv
			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setSolarb(solarb);
			arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			Pagination pagination = new Pagination();
			pagination.setRows(2L);
			List<Arbinterv> listaArbinterv = this.arbintervService.findAll(arbinterv, pagination);
			if (listaArbinterv != null && listaArbinterv.size() == 1) {
				arbinterv = listaArbinterv.get(0);
				if (arbinterv != null) {

					// T17Municipio municipio = this.municipioService
					// .find(new T17Municipio(arbinterv.getUamunId(),
					// arbinterv.getUaprovId(), "", sacodigo));
					// solarb.setEsNombreMunicipio(municipio.getDsO());
					solarb.setEsNombreSancionado((arbinterv.getUanombre() == null ? ""
							: arbinterv.getUanombre().concat(" ")
									.concat(arbinterv.getUaapellido1() == null ? "" : arbinterv.getUaapellido1())
									.concat(" ")
									.concat(arbinterv.getUaapellido2() == null ? "" : arbinterv.getUaapellido2()))
											.trim());
					solarb.setNordtot(solarb.getEsNombreSancionado());
					if (arbinterv.getUaescodigo() != null) {
						Establecimiento establecimiento = new Establecimiento(arbinterv.getUaescodigo());
						establecimiento = this.establecimientoService.find(establecimiento);
						if (establecimiento != null) {
							solarb.setEsnoco(establecimiento.getEsnoco());
							if (establecimiento.getEscooe() != null) {
								Ooee ooee = new Ooee();
								ooee.setOecodigo(establecimiento.getEscooe());
								List<Ooee> listaOoee = this.ooeeService.findAllBusqueda(ooee, null);
								if (listaOoee.size() > 0) {
									Organismo organismo = listaOoee.get(0).getOrganismo();
									if (organismo != null) {
										if (organismo.getNombreEs() != null && !organismo.getNombreEs().equals("")
												&& organismo.getNombreEu() != null
												&& !organismo.getNombreEu().equals("")) {
											if (organismo.getNombreEs().equals(organismo.getNombreEu())) {
												solarb.setOrnombre(organismo.getNombreEs());
											} else {
												solarb.setOrnombre(
														organismo.getNombreEs() + "/" + organismo.getNombreEu());
											}
										} else if (organismo.getNombreEs() != null
												&& !organismo.getNombreEs().equals("")) {
											solarb.setOrnombre(organismo.getNombreEs());
										} else if (organismo.getNombreEu() != null
												&& !organismo.getNombreEu().equals("")) {
											solarb.setOrnombre(organismo.getNombreEu());
										}
									}
								}
							}
						}

						// Safesoli
						solarb.setSafesoli(null);

						/*
						 * EstablecimArbitra establecimientoArbitra = new
						 * EstablecimArbitra(); establecimientoArbitra
						 * .setEstablecimiento(establecimiento);
						 * establecimientoArbitra =
						 * this.establecimArbitraService
						 * .findArbitrajeSinExcepcion(establecimientoArbitra);
						 */

						/*
						 * TODO: Revisar con Oscar if (solarb != null &&
						 * solarb.getSafesoli() != null &&
						 * establecimientoArbitra != null &&
						 * establecimiento.getEsfeadar() != null &&
						 * solarb.getSafesoli().before(
						 * establecimiento.getEsfeadar())) { // No se muestra la
						 * fecha de entrada (no est // adherida)
						 * solarb.setSafesoli(null); }
						 * 
						 * if (establecimientoArbitra != null &&
						 * establecimientoArbitra.getAhfeba() != null) { if
						 * (solarb != null && solarb.getSafesoli() != null &&
						 * solarb.getSafesoli().after( Y41bUtils.addDays(
						 * establecimientoArbitra .getAhfeba(),
						 * Y41bConstantes.NUM_30))) { // No se muestra la fecha
						 * de entrada (no // est // adherida)
						 * solarb.setSafesoli(null); } }
						 */
						// TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA
						// TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_NO_ADHERIDA_CONTRATO
						// TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE
						Arbtramexp tramite = new Arbtramexp();
						tramite.setTrestado("T");
						tramite.setSolarb(new Solarb(solarb.getSacodigo()));
						Pagination pagination1 = new Pagination();
						pagination1.setSort("TRID");
						pagination1.setAscDsc("DESC");
						List<Arbtramexp> ltramites = this.arbtramexpService.findAll(tramite, pagination1);
						for (int i = 0; i < ltramites.size(); i++) {
							tramite = ltramites.get(i);
							if (tramite.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE)) {
								if (Y41bConstantes.VALOR_SI.equals(ltramites.get(0).getTrresparb())) {
									solarb.setSafesoli(tramite.getTrfecfin());
								}
								break;
							} else if (tramite.getTrcodigo()
									.equals(Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_NO_ADHERIDA_CONTRATO)) {
								solarb.setSafesoli(tramite.getTrfecfin());
								break;
							} else if (tramite.getTrcodigo()
									.equals(Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA)) {
								solarb.setSafesoli(arbexp.getExfecreg());
								break;
							}
						}
					}
				}
			}

			arbinterv = new Arbinterv();
			arbinterv.setSolarb(solarb);
			arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
			listaArbinterv = this.arbintervService.findAll(arbinterv, pagination);
			if (listaArbinterv != null && listaArbinterv.size() == 1) {
				arbinterv = listaArbinterv.get(0);
				if (arbinterv != null) {
					// if (arbinterv.getUamunId() != null
					// && arbinterv.getUaprovId() != null) {
					// T17Municipio municipio = this.municipioService
					// .find(new T17Municipio(arbinterv.getUamunId(),
					// arbinterv.getUaprovId(), "", sacodigo));
					// solarb.setEsNombreMunicipio(municipio.getDsO());
					// EVOLUTIVO 134898 2.1
					if (arbinterv.getUaprovId() != null) {
						T17Provincia provincia = this.provinciaService
								.find(new T17Provincia(arbinterv.getUaprovId(), null, null));
						if (provincia != null) {
							solarb.setDtnombreProvincia(provincia.getDsO());
						}
					}
					// EVOLUTIVO 134898 2.1
					solarb.setNort((arbinterv.getUanombre() == null ? ""
							: arbinterv.getUanombre().concat(" ")
									.concat(arbinterv.getUaapellido1() == null ? "" : arbinterv.getUaapellido1())
									.concat(" ")
									.concat(arbinterv.getUaapellido2() == null ? "" : arbinterv.getUaapellido2()))
											.trim());
					// }
				}
			}

			String rutaRTF = (String) this.appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) this.appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_ARBITRAJE_ETIQUETA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_ARBITRAJE_ETIQUETA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));
			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML, solarb, plantilla);
			byte[] bytesFichero = strFileDataDecode.getBytes();

			String nombreFichero = solarb.getSacoja() + "-" + solarb.getSanror() + "-" + solarb.getSanran() + ".rtf";

			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombreFichero) + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);
			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	// /**
	// * Method 'getPegatinaBySacodigo'.
	// *
	// * @param sacodigo
	// * String
	// * @param response
	// * HttpServletResponse
	// *
	// */
	// @RequestMapping(value = "/pegatina", method = RequestMethod.GET)
	// public @ResponseBody()
	// void getPegatinaBySacodigo(
	// @RequestParam(value = "sacodigo", required = true) String sacodigo,
	// HttpServletResponse response) {
	// try {
	// PlantillaPegatinaEstablecimiento pegatina = new
	// PlantillaPegatinaEstablecimiento();
	//
	// Establecimiento establecimiento = null;
	//
	// sacodigo = new String(Y41bUtilsDokusi.decode(sacodigo));
	//
	// Solarb solarb = new Solarb();
	// solarb.setSacodigo(sacodigo);
	// solarb = this.solarbService.find(solarb);
	//
	// if (solarb == null) {
	// throw new Exception(sacodigo.toString());
	// }
	//
	// // Establecimiento
	// Arbinterv arbinterv = new Arbinterv();
	// arbinterv.setSolarb(solarb);
	// arbinterv
	// .setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
	// Pagination pagination = new Pagination();
	// pagination.setRows(2L);
	// List<Arbinterv> listaArbinterv = this.arbintervService.findAll(
	// arbinterv, pagination);
	// if (listaArbinterv != null && listaArbinterv.size() == 1) {
	// arbinterv = listaArbinterv.get(0);
	// if (arbinterv != null && arbinterv.getUaescodigo() != null) {
	// establecimiento = new Establecimiento(
	// arbinterv.getUaescodigo());
	// establecimiento = this.establecimientoService
	// .find(establecimiento);
	// if (establecimiento != null) {
	// // Obtenemos los campos del establecimiento requeridos
	// pegatina.setEsnombre(establecimiento.getEsnombre());
	// StringBuffer direccion = new StringBuffer();
	// if (establecimiento.getEsnombreCalle() != null) {
	// direccion.append(establecimiento.getEsnombreCalle()
	// .trim());
	// if (establecimiento.getEsnombrePortal() != null) {
	// direccion.append(" ");
	// direccion.append(establecimiento
	// .getEsnombrePortal().trim());
	// if (establecimiento.getEsnombrePiso() != null) {
	// direccion.append(" ");
	// direccion.append(establecimiento
	// .getEsnombrePiso());
	// }
	// }
	// }
	// pegatina.setEsnodir(direccion.toString());
	// pegatina.setEsnombreCp(establecimiento.getEsnombreCp());
	// pegatina.setEsnombreMunicipio(establecimiento
	// .getEsnombreMunicipio());
	// pegatina.setEsnombreProvincia(establecimiento
	// .getEsnombreProvincia());
	// }
	// }
	// }
	//
	// // Fecha
	// pegatina.setFechaTextoCas(Y41bUtils.formatearDateToString(
	// new Date(), Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA,
	// Y41bConstantes.CASTELLANO));
	// pegatina.setFechaTextoEus(Y41bUtils.formatearDateToStringEuskera(
	// new Date(), Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA,
	// Y41bConstantes.EUSKERA));
	//
	// // Responsable\Coordinador junta arbitral
	// CensoMonitor censoMonitorResp = new CensoMonitor();
	// Organismo organismoResponsable = new Organismo();
	// organismoResponsable
	// .setCodOrg(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
	// censoMonitorResp.setOrganismo(organismoResponsable);
	// censoMonitorResp.setPerfilArbitraje(new Perfil(
	// Y41bConstantes.PERFIL_COORDINADOR, null, null));
	//
	// StringBuffer nombreResponsable = new StringBuffer("");
	// List<CensoMonitor> listaResponsables = this.censoMonitorService
	// .findAll(censoMonitorResp, null);
	// if (listaResponsables != null) {
	// for (int i = 0; i < listaResponsables.size(); i++) {
	// censoMonitorResp = listaResponsables.get(i);
	// if (nombreResponsable.length() == 0) {
	// nombreResponsable
	// .append(censoMonitorResp.getMonombre());
	// } else {
	// nombreResponsable.append(" ,").append(
	// censoMonitorResp.getMonombre());
	// }
	// }
	// pegatina.setCoordinador(nombreResponsable.toString());
	// pegatina.setTextoPuestoCoordinadorCas(this.appMessageSource
	// .getMessage("plantilla.puestosecretarioJJAA", null,
	// new Locale(Y41bConstantes.CASTELLANO)));
	// pegatina.setTextoPuestoCoordinadorEus(this.appMessageSource
	// .getMessage("plantilla.puestosecretarioJJAA", null,
	// new Locale(Y41bConstantes.EUSKERA)));
	// }
	//
	// Organismo organismo = new Organismo();
	// organismo.setCodOrg(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
	// List<Organismo> listaoficinaProvincia = this.organismoService
	// .findAll(organismo, null);
	// if (listaoficinaProvincia != null) {
	// organismo = listaoficinaProvincia.get(0);
	// if (organismo != null && organismo.getEntidadId() != null) {
	//
	// // Lugar
	// pegatina.setLugarOficina(organismo.getNombreLocalidad());
	// // Creamos el campo pie pagina linea1
	// StringBuffer piepagina_linea1 = new StringBuffer();
	//
	// piepagina_linea1.append(organismo.getAdressCallePortal())
	// .append(" - ").append(organismo.getAdressCP())
	// .append(" / ").append(" Tl. ")
	// .append(organismo.getTelefono()).append(" - ")
	// .append(" Fx. ").append(organismo.getFax());
	//
	// pegatina.setPiePaginaLinea1(piepagina_linea1.toString());
	//
	// // Creamos el campo pie pagina linea2
	// StringBuffer piepagina_linea2 = new StringBuffer();
	//
	// piepagina_linea2.append("e-mail: ")
	// .append(organismo.getEmail()).append(" / ")
	// .append(organismo.getUrl());
	//
	// pegatina.setPiePaginaLinea2(piepagina_linea2.toString());
	// }
	// }
	//
	// String rutaRTF = (String) this.appConfiguration
	// .get("y41bVistaWar.ruta.plantillas.word");
	// String rutaXML = (String) this.appConfiguration
	// .get("y41bVistaWar.rutaxml.plantillas.word");
	// String nombreRTF =
	// Y41bConstantes.NOMBRE_PLANTILLA_ARBITRAJE_ESTABLECIMIENTO_PEGATINA_RTF;
	// String nombreXML =
	// Y41bConstantes.NOMBRE_PLANTILLA_ARBITRAJE_ESTABLECIMIENTO_PEGATINA_XML;
	// String rutaCompletaRTF = rutaRTF + nombreRTF;
	// String rutaCompletaXML = rutaXML + nombreXML;
	//
	// String plantilla = new String(
	// Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));
	// String strFileDataDecode = Y41bGenerarDocumento
	// .generarDocumentoWord(rutaCompletaXML, pegatina, plantilla);
	// byte[] bytesFichero = strFileDataDecode.getBytes();
	//
	// String nombreFichero = solarb.getSacoja() + "-"
	// + solarb.getSanror() + "-" + solarb.getSanran() + ".doc";
	//
	// response.setHeader("Content-Disposition", "attachment; filename=\""
	// + StringEscapeUtils.unescapeHtml(nombreFichero) + "\"");
	// response.setContentType("application/msword");
	// response.setContentLength(bytesFichero.length);
	// response.getOutputStream().write(bytesFichero);
	// // Vaciamos el stream
	// response.getOutputStream().flush();
	//
	// } catch (Exception e) {
	// SolarbController.logger.error(e.getMessage());
	// throw new Y41bUDAException("error.generico", true, e);
	// }
	// }

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaArbitrajeModal", method = RequestMethod.GET)
	public String getCreateFormModal(Model model) {
		SolarbController.logger.info("[GET - View] : expedien");
		return "busquedaarbitrajemodal";
	}

	/**
	 * Method 'getArbitrajeByNumExpediente'.
	 * 
	 * @param sacoja
	 *            String
	 * @param sanror
	 *            BigDecimal
	 * @param sanran
	 *            BigDecimal
	 * @return Solarb
	 * @throws Y41bUDAException
	 *             Exception
	 */
	@RequestMapping(value = "/getArbitrajeByNumExpediente/{sacoja}/{sanror}/{sanran}", method = RequestMethod.GET)
	public @ResponseBody() Solarb getArbitrajeByNumExpediente(@PathVariable() String sacoja,
			@PathVariable() BigDecimal sanror, @PathVariable() BigDecimal sanran) throws Y41bUDAException {
		Solarb solarb = new Solarb();

		solarb.setSacoja(sacoja);
		solarb.setSanror(sanror);
		solarb.setSanran(sanran);

		solarb = this.solarbService.findArbitrajeByNumeroExpediente(solarb);

		SolarbController.logger.info("[GET - getSancionByNumExpediente] : Obtener Expedien por numero de solarbte");
		return solarb;

	}

	/**
	 * @param arbitrajenueva
	 *            Solarb
	 * @param request
	 *            HttpServletRequest
	 * @return Solarb
	 */
	@RequestMapping(value = "/guardarArbitraje", method = RequestMethod.POST)
	public @ResponseBody() Solarb updateArbitraje(@RequestBody() Solarb solarb, HttpServletRequest request) {
		Solarb nuevoExpedien;
		try {
			SolarbController.logger.info("Entity correctly inserted!" + solarb.toString() + request.toString());
			HttpSession httpSession = request.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (solarb.getModoAlta() != null && "S".equals(solarb.getModoAlta())) {

				String sacodigo = new String(Y41bUtilsDokusi.decode(solarb.getSacodigo()));
				solarb.setSacodigo(sacodigo);

				if (solarb.getArbexp() == null) {
					solarb.setArbexp(new Arbexp());
				}

				solarb.getArbexp().setExcodigo(sacodigo);

				// 0169289: Estudio de la Integracin SIR
				if (!solarb.getArbexp().getIsSir().equalsIgnoreCase(Y41bConstantes.SI)) {
					solarb.getArbexp().setIsSir("");
					solarb.getArbexp().setIdAsiento("");
					solarb.getArbexp().setArSolicitante("");
					solarb.getArbexp().setArResumen("");
				}
				// 0169289: Estudio de la Integracin SIR

				if (solarb.getArbexp().getExtippres().equals(Y41bConstantes.TIPOPRES_ARB_ODR)) {
					solarb.getArbexp().setExformapres(null);
				}
				solarb.setSafesoli(Y41bUtils.obtenerFechaHoy());

				solarb.getArbexp().setExmocodigo(censoMonitor.getMocodigo());

				nuevoExpedien = (Solarb) (this.solarbService.add(solarb)).get("solarb");
			} else {

				nuevoExpedien = this.solarbService.actualizaExpediente(solarb, censoMonitor);
			}

			nuevoExpedien.setSacodigo(Y41bUtilsDokusi.encode(nuevoExpedien.getSacodigo().getBytes()));
			return nuevoExpedien;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * @param arbitrajenueva
	 *            Solarb
	 * @param request
	 *            HttpServletRequest
	 * @return Solarb
	 */
	@RequestMapping(value = "/guardarAnulacionEjecucion", method = RequestMethod.POST)
	public @ResponseBody() Solarb updateAnulacionEjecucion(@RequestBody() Solarb datosAnulacionEjecucion,
			HttpServletRequest request) {
		Solarb solarb;
		try {
			solarb = this.solarbService.find(datosAnulacionEjecucion);
			solarb.setTclugaud(datosAnulacionEjecucion.getTclugaud());
			solarb.setSainfdra(datosAnulacionEjecucion.getSainfdra());
			solarb.setSafesera(datosAnulacionEjecucion.getSafesera());
			solarb.setSafeinef(datosAnulacionEjecucion.getSafeinef());
			this.solarbService.update(solarb);

			return solarb;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaSolicitud", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoPestaniaSolicitud(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		return new ModelAndView("fichaExpedienteHistoricoArbitrajePestaniaSolicitud", "model", model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaInadmisionTraslado", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoPestaniaInadmisionTraslado(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		return new ModelAndView("fichaExpedienteHistoricoArbitrajePestaniaInadmisionTraslado", "model", model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaMediacionDesestimiento", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoPestaniaMediacionDesestimiento(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		return new ModelAndView("fichaExpedienteHistoricoArbitrajePestaniaMediacionDesestimiento", "model", model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaNotificacion", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoPestaniaNotificacion(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		return new ModelAndView("fichaExpedienteHistoricoArbitrajePestaniaNotificacion", "model", model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaColegioAudiencia", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoPestaniaInadmisionColegioAudiencia(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		return new ModelAndView("fichaExpedienteHistoricoArbitrajePestaniaColegioAudiencia", "model", model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaPruebas", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoPestaniaPruebas(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		return new ModelAndView("fichaExpedienteHistoricoArbitrajePestaniaPruebas", "model", model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestania2Audiencia", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoPestania2Audiencia(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		return new ModelAndView("fichaExpedienteHistoricoArbitrajePestania2Audiencia", "model", model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaLaudoArchivo", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoPestaniaLaudoArchivo(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		return new ModelAndView("fichaExpedienteHistoricoArbitrajePestaniaLaudoArchivo", "model", model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaRAnulacionEjecucion", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoPestaniaRAnulacionEjecucion(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		return new ModelAndView("fichaExpedienteHistoricoArbitrajePestaniaRAnulacionEjecucion", "model", model);
	}

	/**
	 * Gets the solarb kgest.
	 * 
	 * @param sacodigo
	 *            the sacodigo
	 * @return the solarb kgest
	 * @throws Exception
	 */
	@RequestMapping(value = "/obtenerSolarbKgest/{sacodigo}", method = RequestMethod.GET)
	public @ResponseBody() SolarbKgest getSolarbKgest(@PathVariable() String sacodigo) throws Exception {
		// Locale locale = LocaleContextHolder.getLocale();
		// String idioma = locale.getLanguage();

		sacodigo = new String(Y41bUtilsDokusi.decode(sacodigo));

		SolarbKgest solarbKges = new SolarbKgest();
		solarbKges.setSacodigo(sacodigo);
		solarbKges = this.solarbService.findKgest(solarbKges);

		solarbKges.setcodCompleto(solarbKges.damecodCompleto());
		return solarbKges;
	}

	/**
	 * Method 'getCreateFormRechazoMod'. Rechazo de una propuesta de sancion.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param baprarbid
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/maintRechazoMod/{codProcedimiento}/{baprarbid}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormRechazoMod(@PathVariable() String codProcedimiento,
			@PathVariable() String baprarbid, @PathVariable() String idExpediente, Model model) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		model.addAttribute("idExpediente", idExpediente);
		model.addAttribute("codProcedimiento", codProcedimiento);
		model.addAttribute("baprarbid", baprarbid);

		return new ModelAndView("modalArbitrajeRechazo", "model", model);
	}

	/**
	 * 
	 * @param rechazosanobserv
	 *            String
	 * @param codInstructor
	 *            String
	 * @param idExpediente
	 *            String
	 * @param baprsanid
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return boolean
	 */
	@RequestMapping(value = "/guardarRechazoArbitraje/{idExpediente}/{baprarbid}", method = RequestMethod.POST)
	public @ResponseBody() boolean updateRechazoSancion(
			@RequestParam(value = "rechazoarbobserv", required = false) String rechazosanobserv,
			@RequestParam(value = "instructor", required = false) String codInstructor,
			@PathVariable() String idExpediente, @PathVariable() String baprarbid, HttpServletRequest request) {
		try {
			SolarbController.logger
					.info("INICIO updateRechazoSancion: " + rechazosanobserv.toString() + request.toString());

			TramiteGenerico tramiteGenerico = new TramiteGenerico();
			tramiteGenerico.setIdExpediente(idExpediente);
			tramiteGenerico.setFechaInicio(new Date());

			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(codInstructor);

			tramiteGenerico.setInstructorAsignado(censoMonitor);
			tramiteGenerico.setComentario(rechazosanobserv);

			String literalNombreTramite = "propuestaArbitraje.rechazo";

			this.soltramexpService.addTramiteGenericoAutomatico(tramiteGenerico, literalNombreTramite);
			// 111718 Se aade el reseteo del flag del expediente de solicitud
			// que impide que se pueda modificar en y41a
			this.soltramexpService.resetIndicadorArbitraje(idExpediente);
			Arbpropbandeja arbpropbandeja = new Arbpropbandeja();
			arbpropbandeja.setBaprarbid(Long.valueOf(baprarbid));
			arbpropbandeja = this.arbpropbandejaService.find(arbpropbandeja);

			this.soltramexpService.tratamientoEnviarcomunicacionDesdePropuestaArbitraje(
					arbpropbandeja.getBaprarbexcodigo(), false, "", codInstructor, rechazosanobserv);
			// Y41bUtils.clobToString(arbpropbandeja.getBaprarbobserv()));

			SolarbController.logger.info("Entity correctly inserted!");

			this.arbpropbandejaService.remove(arbpropbandeja);
			return true;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed" + e.getMessage());
		}
	}

	/**
	 * Method 'maintNuevaMod'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintNuevaMod", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(Model model, HttpServletRequest request,
			@RequestParam(value = "desdeBandejaPropuestas", required = false) boolean desdeBandejaPropuestas,
			@RequestParam(value = "codExpediente", required = false) String codExpediente,
			@RequestParam(value = "asientoRegistral", required = false) String asientoRegistral) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilArbitraje() == null) {
			return new ModelAndView("accessDeniedModal", "model", model);
		}

		// obtenemos el id del expediente y el id del tramite
		String sacodigo = Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE);
		String sacodigoB64 = new String(Y41bUtilsDokusi.encode(sacodigo.getBytes()));
		model.addAttribute("sacodigo", sacodigoB64);

		String idTramiteApertura = this.arbtramexpService.getNewPK().toString();
		model.addAttribute("idTramiteApertura", idTramiteApertura);

		model.addAttribute("desdePropuesta", desdeBandejaPropuestas);
		model.addAttribute("codExpediente", codExpediente);
		if (desdeBandejaPropuestas && !Y41bUtils.esNullOCadenaVacia(codExpediente)) {
			// Recuperar documentos aportados de la reclamacion previa
			this.solarbService.volcarDocumentosReclamacionPrevia(codExpediente, idTramiteApertura);
		}
		// 0169289: Estudio de la Integracin SIR
		model.addAttribute("desdeAR", asientoRegistral);
		// Copiar de asientoRegistral a tramite para que se vean los documentos
		// en grid de documentos de modal de nuevo arbitraje cuando viene de SIR
		if (!Y41bUtils.esNullOCadenaVacia(asientoRegistral)) {
			this.arbtramexp2Service.copiarDocumentosAsientoRegistralNuevoArbitraje(asientoRegistral, sacodigo,
					idTramiteApertura);
		}
		// 0169289: Estudio de la Integracin SIR

		// PAra limpiar la variable de sesin del buscador de solicitudes
		httpSession.setAttribute("solicitudBusqueda", new SolicitudBusqueda());

		if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)) {
			return new ModelAndView("modalArbitrajeNueva", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
			return new ModelAndView("modalArbitrajeNueva", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
			return new ModelAndView("modalArbitrajeNueva", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)) {
			return new ModelAndView("modalArbitrajeNueva", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)) {
			return new ModelAndView("modalArbitrajeNueva", "model", model);
		} else {
			return new ModelAndView("accessDeniedModal", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormFiltroArbitrajes'.
	 * 
	 * @param httpRequest
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFiltro", method = RequestMethod.GET)
	public ModelAndView getCreateFormFiltroArbitrajes(HttpServletRequest httpRequest, Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		HttpSession httpSession = httpRequest.getSession();
		FiltroArbitraje arbitrajeBusqueda = (FiltroArbitraje) httpSession.getAttribute("arbitrajeBusqueda");
		if (arbitrajeBusqueda == null) {
			model.addAttribute("cargarFiltroInicial", true);
			model.addAttribute("arbitrajeBusqueda", new FiltroArbitraje());
		} else {
			model.addAttribute("cargarFiltroInicial", false);
			model.addAttribute("arbitrajeBusqueda", arbitrajeBusqueda);
		}
		return new ModelAndView("busquedaArbitrajeFiltro", "model", model);
	}

	/**
	 * Method 'getCreateFormListadoArbitrajes'.
	 * 
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraResultadoArbitrajes", method = RequestMethod.GET)
	public ModelAndView getCreateFormListadoArbitrajes(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));
		return new ModelAndView("busquedaArbitrajeListado", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaArbitrajeInicial", method = RequestMethod.GET)
	public String getCreateFormInicial(Model model, HttpServletRequest request) {
		SolarbController.logger.info("[GET - View] : arbitraje");
		request.getSession().setAttribute("arbitrajeBusqueda", null);
		return "busquedaarbitraje";
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaArbitraje", method = RequestMethod.GET)
	public String getCreateForm2(Model model) {
		SolarbController.logger.info("[GET - View] : expedien");
		return "busquedaarbitraje";
	}

	/**
	 * 
	 * @param sacoja
	 *            String
	 * @param sanror
	 *            String
	 * @param sanran
	 *            String
	 * @param cofechaInicioDesde
	 *            String
	 * @param cofechaInicioHasta
	 *            String
	 * @param y41bBusquedaArbitrajeFiltroEstadoExp
	 *            String
	 * @param cifnif
	 *            String
	 * @param conoco
	 *            String
	 * @param provinciaId
	 *            String
	 * @param municipioId
	 *            String
	 * @param localidadId
	 *            String
	 * @param cifnif2
	 *            String
	 * @param conoco2
	 *            String
	 * @param dtapellido1
	 *            String
	 * @param dtapellido2
	 *            String
	 * @param provinciaId2
	 *            String
	 * @param municipioId2
	 *            String
	 * @param localidadId2
	 *            String
	 * @param y41bBusquedaArbitrajeFiltroFase
	 *            String
	 * @param y41bBusquedaArbitrajeFiltroTramite
	 *            String
	 * @param indUltimoTramite
	 *            String
	 * @param y41bBusquedaArbitrajeFiltroResolucion
	 *            String
	 * @param y41bBusquedaArbitrajeFiltroInstructor
	 *            String
	 * @param y41bBusquedaArbitrajeFiltroResponsable
	 *            String
	 * @param indAcuseRecibo
	 *            String
	 * @param cofechaTramitacionDesde
	 *            String
	 * @param cofechaTramitacionHasta
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param model
	 *            Model
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */

	@RequestMapping(value = "searchArbitrajesFiltro", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGridPrueba(

			@RequestParam(value = "sacoja", required = false) String sacoja,
			@RequestParam(value = "sanror", required = false) BigDecimal sanror,
			@RequestParam(value = "sanran", required = false) BigDecimal sanran,
			@RequestParam(value = "cofechaInicioDesde", required = false) String cofechaInicioDesde,
			@RequestParam(value = "cofechaInicioHasta", required = false) String cofechaInicioHasta,
			@RequestParam(value = "y41bBusquedaArbitrajeFiltroEstadoExp", required = false) String y41bBusquedaArbitrajeFiltroEstadoExp,
			@RequestParam(value = "cifnif", required = false) String cifnif,
			@RequestParam(value = "conoco", required = false) String conoco,
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "municipioId", required = false) String municipioId,
			@RequestParam(value = "localidadId", required = false) String localidadId,
			@RequestParam(value = "cifnif2", required = false) String cifnif2,
			@RequestParam(value = "conoco2", required = false) String conoco2,
			@RequestParam(value = "dtapellido1", required = false) String dtapellido1,
			@RequestParam(value = "dtapellido2", required = false) String dtapellido2,
			@RequestParam(value = "provinciaId2", required = false) String provinciaId2,
			@RequestParam(value = "municipioId2", required = false) String municipioId2,
			@RequestParam(value = "localidadId2", required = false) String localidadId2,
			@RequestParam(value = "y41bBusquedaArbitrajeFiltroFase", required = false) String y41bBusquedaArbitrajeFiltroFase,
			@RequestParam(value = "y41bBusquedaArbitrajeFiltroTramite", required = false) String y41bBusquedaArbitrajeFiltroTramite,
			@RequestParam(value = "indUltimoTramite", required = false) String indUltimoTramite,
			@RequestParam(value = "y41bBusquedaArbitrajeFiltroResolucion", required = false) String y41bBusquedaArbitrajeFiltroResolucion,
			@RequestParam(value = "y41bBusquedaArbitrajeFiltroInstructor", required = false) String y41bBusquedaArbitrajeFiltroInstructor,
			@RequestParam(value = "y41bBusquedaArbitrajeFiltroResponsable", required = false) String y41bBusquedaArbitrajeFiltroResponsable,
			@RequestParam(value = "indAcuseRecibo", required = false) String indAcuseRecibo,
			@RequestParam(value = "indPendienteFirma", required = false) String indPendienteFirma,
			@RequestParam(value = "indPendienteDecision", required = false) String indPendienteDecision,
			@RequestParam(value = "indCerrados", required = false) String indCerrados,
			@RequestParam(value = "cofechaTramitacionDesde", required = false) String cofechaTramitacionDesde,
			@RequestParam(value = "cofechaTramitacionHasta", required = false) String cofechaTramitacionHasta,
			@RequestParam(value = "exregen", required = false) String exregen,
			@RequestParam(value = "radioTramite", required = false) String radioTramite,
			@ModelAttribute() Pagination pagination, Model model, HttpServletRequest httpRequest) {

		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = this.censoMonitorService.find(censoMonitor);
		String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();
		if (perfil != null && Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
			// Si perfil sin acceso devolvemos listado vacio
			return new JQGridJSONModel(pagination, 0L, new ArrayList<Arbbandeja>());
		}

		FiltroArbitraje filtroArbitraje = new FiltroArbitraje();

		if (!Y41bUtils.esNullOCadenaVacia(sacoja)) {
			filtroArbitraje.setSacoja(sacoja);
		}
		if (null != sanror) {
			filtroArbitraje.setSanror(sanror);
		}
		if (null != sanran) {
			filtroArbitraje.setSanran(sanran);
		}

		if (!Y41bUtils.esNullOCadenaVacia(cifnif)) {
			filtroArbitraje.getArbintervReclamado().setUanif(cifnif);
		}
		if (!Y41bUtils.esNullOCadenaVacia(conoco)) {
			filtroArbitraje.getArbintervReclamado().setUanombre(conoco);
		}
		if (!Y41bUtils.esNullOCadenaVacia(provinciaId)) {
			filtroArbitraje.getArbintervReclamado().setUaprovId(provinciaId);
		}
		if (!Y41bUtils.esNullOCadenaVacia(municipioId)) {
			filtroArbitraje.getArbintervReclamado().setUamunId(municipioId);
		}
		if (!Y41bUtils.esNullOCadenaVacia(localidadId)) {
			filtroArbitraje.getArbintervReclamado().setUalocId(localidadId);
		}

		if (!Y41bUtils.esNullOCadenaVacia(cifnif2)) {
			filtroArbitraje.getArbintervReclamante().setUanif(cifnif2);
		}
		if (!Y41bUtils.esNullOCadenaVacia(conoco2)) {
			filtroArbitraje.getArbintervReclamante().setUanombre(conoco2);
		}
		if (!Y41bUtils.esNullOCadenaVacia(dtapellido1)) {
			filtroArbitraje.getArbintervReclamante().setUaapellido1(dtapellido1);
		}
		if (!Y41bUtils.esNullOCadenaVacia(dtapellido2)) {
			filtroArbitraje.getArbintervReclamante().setUaapellido2(dtapellido2);
		}
		if (!Y41bUtils.esNullOCadenaVacia(provinciaId2)) {
			filtroArbitraje.getArbintervReclamante().setUaprovId(provinciaId2);
		}
		if (!Y41bUtils.esNullOCadenaVacia(municipioId2)) {
			filtroArbitraje.getArbintervReclamante().setUamunId(municipioId2);
		}
		if (!Y41bUtils.esNullOCadenaVacia(localidadId2)) {
			filtroArbitraje.getArbintervReclamante().setUalocId(localidadId2);
		}

		if (!Y41bUtils.esNullOCadenaVacia(y41bBusquedaArbitrajeFiltroFase)) {
			filtroArbitraje.getArbexp().setExfcodigo(y41bBusquedaArbitrajeFiltroFase);
			filtroArbitraje.setIdFase(y41bBusquedaArbitrajeFiltroFase);
		}
		if (!Y41bUtils.esNullOCadenaVacia(y41bBusquedaArbitrajeFiltroTramite)) {
			filtroArbitraje.getArbtramexp().setTrcodigo(y41bBusquedaArbitrajeFiltroTramite);
			filtroArbitraje.setTramite(y41bBusquedaArbitrajeFiltroTramite);
		}
		// EVOLUTIVO 0134898 2.10
		if (!Y41bUtils.esNullOCadenaVacia(radioTramite)
				&& Y41bConstantes.BUSQUEDA_ARBITRAJE_ULTIMO_TRAMITE.equals(radioTramite)) {
			// EQUIVALENTE A LA SITUACION ANTERIOR CON EL CHECK ULTIMO TRAMITE
			// MARCADO
			filtroArbitraje.setUltimoTramite(true);
			filtroArbitraje.setRadioTramite(Y41bConstantes.BUSQUEDA_ARBITRAJE_ULTIMO_TRAMITE);
		} else if (!Y41bUtils.esNullOCadenaVacia(radioTramite)
				&& Y41bConstantes.BUSQUEDA_ARBITRAJE_ACTUAL_TRAMITE.equals(radioTramite)) {
			// //NUEVA SITUACION CONTROLADA, A LA SITUACION ANTERIOR CON EL
			// CHECK ULTIMO TRAMITE MARCADO
			filtroArbitraje.setRadioTramite(Y41bConstantes.BUSQUEDA_ARBITRAJE_ACTUAL_TRAMITE);
		} else if (!Y41bUtils.esNullOCadenaVacia(radioTramite)
				&& Y41bConstantes.BUSQUEDA_ARBITRAJE_EXISTE_TRAMITE.equals(radioTramite)) {
			// EQUIVALENTE A LA SITUACION ANTERIOR CON EL CHECK ULTIMO TRAMITE
			// DESMARCADO
			filtroArbitraje.setUltimoTramite(false);
			filtroArbitraje.setRadioTramite(Y41bConstantes.BUSQUEDA_ARBITRAJE_EXISTE_TRAMITE);
		}

		// if (!Y41bUtils.esNullOCadenaVacia(indUltimoTramite)
		// && "on".equals(indUltimoTramite)) {
		// filtroArbitraje.setUltimoTramite(true);
		// } else {
		// filtroArbitraje.setUltimoTramite(false);
		// }
		// EVOLUTIVO 0134898 2.10
		if (!Y41bUtils.esNullOCadenaVacia(y41bBusquedaArbitrajeFiltroResolucion)) {
			filtroArbitraje.getArbexp().setExtipres(y41bBusquedaArbitrajeFiltroResolucion);
			filtroArbitraje.setTipoResolucion(y41bBusquedaArbitrajeFiltroResolucion);
		}
		if (!Y41bUtils.esNullOCadenaVacia(y41bBusquedaArbitrajeFiltroResponsable)) {
			filtroArbitraje.getArbexp().setExmocodigo(y41bBusquedaArbitrajeFiltroResponsable);
			filtroArbitraje.setResponsable(y41bBusquedaArbitrajeFiltroResponsable);
		}
		if (!Y41bUtils.esNullOCadenaVacia(y41bBusquedaArbitrajeFiltroInstructor)) {
			filtroArbitraje.getArbtramexp().setTrmonitor(y41bBusquedaArbitrajeFiltroInstructor);
			filtroArbitraje.setInstructor(y41bBusquedaArbitrajeFiltroInstructor);
		}

		if (!Y41bUtils.esNullOCadenaVacia(indPendienteFirma) && "on".equals(indPendienteFirma)) {
			filtroArbitraje.setIndPendienteFirma(true);
		} else {
			filtroArbitraje.setIndPendienteFirma(false);
		}

		if (!Y41bUtils.esNullOCadenaVacia(indAcuseRecibo) && "on".equals(indAcuseRecibo)) {
			filtroArbitraje.setAcuseRecibo(true);
		} else {
			filtroArbitraje.setAcuseRecibo(false);
		}

		if (!Y41bUtils.esNullOCadenaVacia(indPendienteDecision) && "on".equals(indPendienteDecision)) {
			filtroArbitraje.setIndPendienteDecision(true);
		} else {
			filtroArbitraje.setIndPendienteDecision(false);
		}

		if (!Y41bUtils.esNullOCadenaVacia(indCerrados) && "on".equals(indCerrados)) {
			filtroArbitraje.setIndCerrados(true);
		} else {
			filtroArbitraje.setIndCerrados(false);
		}

		if (!Y41bUtils.esNullOCadenaVacia(exregen)) {
			filtroArbitraje.getArbexp().setExregen(exregen);
		}
		filtroArbitraje = this.prepararFiltro(filtroArbitraje, cofechaInicioDesde, cofechaInicioHasta,
				cofechaTramitacionDesde, cofechaTramitacionHasta);
		httpSession.setAttribute("arbitrajeBusqueda", filtroArbitraje);

		List<FiltroArbitraje> listaArbitrajes = this.solarbService.findAllLikeArbitrajes(filtroArbitraje, pagination,
				false);
		Long recordNum = this.solarbService.findAllLikeCountArbitrajes(filtroArbitraje, false);
		SolarbController.logger.info("[GET - jqGrid] : Obtener arbitrajes");
		return new JQGridJSONModel(pagination, recordNum, listaArbitrajes);
	}

	/**
	 * 
	 * @param filtroSanciones
	 *            FiltroArbitraje
	 * @param cofechaInicioDesde
	 *            String
	 * @param cofechaInicioHasta
	 *            String
	 * @param cofechaTramitacionDesde
	 *            String
	 * @param cofechaTramitacionHasta
	 *            String
	 * @return FiltroSanciones
	 */
	private FiltroArbitraje prepararFiltro(FiltroArbitraje filtroArbitraje, String cofechaInicioDesde,
			String cofechaInicioHasta, String cofechaTramitacionDesde, String cofechaTramitacionHasta) {
		Locale locale = LocaleContextHolder.getLocale();

		try {
			if (null != cofechaInicioDesde) {
				filtroArbitraje.setFechaIniDesde(Y41bUtils.parseDate(cofechaInicioDesde, locale));
				filtroArbitraje.setFechaIniDesdeStr(cofechaInicioDesde);
			}
			if (null != cofechaInicioHasta) {
				filtroArbitraje.setFechaIniHasta(Y41bUtils.parseDate(cofechaInicioHasta, locale));
				filtroArbitraje.setFechaIniHastaStr(cofechaInicioHasta);
			}
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
		try {
			if (null != cofechaTramitacionDesde && !cofechaTramitacionDesde.equals("")) {
				filtroArbitraje.setFechaTramitacionDesde(
						Y41bUtils.parseDateTime(cofechaTramitacionDesde.concat(" 00:00:00"), locale));
				filtroArbitraje.setFechaTramitacionDesdeStr(cofechaTramitacionDesde);
			}
			if (null != cofechaTramitacionHasta && !cofechaTramitacionHasta.equals("")) {
				filtroArbitraje.setFechaTramitacionHasta(
						Y41bUtils.parseDateTime(cofechaTramitacionHasta.concat(" 23:59:59"), locale));
				filtroArbitraje.setFechaTramitacionHastaStr(cofechaTramitacionHasta);
			}
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
		return filtroArbitraje;
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllConsultaExcel(HttpServletRequest request, HttpServletResponse response) {
		try {

			HttpSession httpSession = request.getSession();
			FiltroArbitraje filtroArbitraje = (FiltroArbitraje) httpSession.getAttribute("arbitrajeBusqueda");

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_ARBITRAJE + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getArbitrajesExcel(filtroArbitraje);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'getAllDocsTramiteAcuerdoIncoacion'.
	 * 
	 * @param sacodigo
	 *            String
	 * @param idTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocsTramite(
			@RequestParam(value = "idTramite", required = true) String idTramite, HttpServletRequest request) {
		try {

			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidTramite(idTramite);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;
				adjuntardocsFilter.setTrpcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsTramite'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param sacodigo
	 *            String
	 * @param idTramite
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocsTramite", method = RequestMethod.POST)
	public @ResponseBody() List<Map<String, Object>> addDocsTramite(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@RequestParam(value = "sacodigo", required = true) String sacodigo,
			@RequestParam(value = "idTramite", required = true) String idTramite,

			HttpServletResponse response, HttpServletRequest request) {
		try {

			sacodigo = new String(Y41bUtilsDokusi.decode(sacodigo));

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");

			adjuntardocsAux.setThcodocumento(this.arbdoctempService.getNewPK().toString());
			adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE);

			TipoDocumento tipoDocumento = new TipoDocumento();
			tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ARB_SOLICITUD);

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			adjuntardocsAux.setThtedesfile(thtedesfile);

			// Blob blob = new SerialBlob(file.getBytes());
			// adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThdatafileinputstream(file.getInputStream());
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(sacodigo);
			adjuntardocsAux.setThidTramite(idTramite);
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			adjuntardocsAux.setTipoProcedimiento(tipoProcedimiento);
			adjuntardocsAux.setThfecha(new Date());
			adjuntardocsAux.setTrpcodigo(tipoProcedimiento.getPcodigo());
			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();

		/*
		 * mapaRetorno.put("url", "/y41bVistaWar/" +
		 * Y41bConstantes.MODOTRAMITES_TRAMITE_K91_idTramite + "/guardar/" +
		 * file.getOriginalFilename());
		 */
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/" + Y41bConstantes.MODOTRAMITES_TRAMITE_K91_idTramite + "/guardar/"
				+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'getByIdDocumentoAcuerdoIncoacion'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param sacodigo
	 *            String
	 * @param idTramite
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumento(@PathVariable() String thcodocumento,
			@RequestParam(value = "sacodigo", required = true) String sacodigo,
			@RequestParam(value = "idTramite", required = true) String idTramite, HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(sacodigo);
			adjuntardocsAux.setThidTramite(idTramite);
			adjuntardocsAux.setThcodocumento(thcodocumento);
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			adjuntardocsAux.setTipoProcedimiento(tipoProcedimiento);

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());
			// response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param sacodigo
	 *            String
	 * @param idTramite
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String thcodocumento,
			@RequestParam(value = "sacodigo", required = true) String sacodigo,
			@RequestParam(value = "idTramite", required = true) String idTramite, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(sacodigo);
			adjuntardocsAux.setThidTramite(idTramite);
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			adjuntardocsAux.setTipoProcedimiento(tipoProcedimiento);

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param dtcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return Map<String, Object>
	 */
	@RequestMapping(value = "/numreclamacionesyarb", method = RequestMethod.POST)
	public @ResponseBody() Map<String, Object> numreclamacionesyarb(

			@RequestParam(value = "dtcodigo", required = true) String dtcodigo, HttpServletResponse response,
			HttpServletRequest request) {
		try {

			Map<String, Object> retorno = this.solarbService.numreclamacionesyarb(dtcodigo);

			String[] args = new String[1];

			Long numReclamaciones = (Long) retorno.get("numReclamaciones");
			args[0] = numReclamaciones.toString();

			if (numReclamaciones.longValue() == 1) {
				retorno.put("msgReclamaciones", this.appMessageSource.getMessage("arbitraje.alta.msg.unaReclamacion",
						null, LocaleContextHolder.getLocale()));
			} else {
				retorno.put("msgReclamaciones", this.appMessageSource.getMessage("arbitraje.alta.msg.numReclamaciones",
						args, LocaleContextHolder.getLocale()));
			}

			Long numArbitraje = (Long) retorno.get("numArbitraje");
			args[0] = numArbitraje.toString();

			if (numArbitraje.longValue() == 1) {
				retorno.put("msgArbitraje", this.appMessageSource.getMessage("arbitraje.alta.msg.unaSolArbitraje", null,
						LocaleContextHolder.getLocale()));
			} else {
				retorno.put("msgArbitraje", this.appMessageSource.getMessage("arbitraje.alta.msg.numSolArbitraje", args,
						LocaleContextHolder.getLocale()));
			}

			return retorno;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bArbitrajeModificacionInstructor", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bArbitrajeModificacionInstructor(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("y41bArbitrajeModificacionInstructor", "model", model);
		}
	}

	/**
	 * Method 'editInstructor'.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 */
	@RequestMapping(value = "/modificarInstructor", method = RequestMethod.PUT)
	public @ResponseBody() void editInstructor(@RequestBody() SolicitudCambioInstructor solicitudCambioInstructor) {
		try {

			this.solarbService.updateCambioInstructor(solicitudCambioInstructor);
			SolarbController.logger.info("Entity correctly inserted!");

		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'trasvaseTotal'.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 */
	@RequestMapping(value = "/trasvaseTotal", method = RequestMethod.PUT)
	public @ResponseBody() void trasvaseTotal(@RequestBody() SolicitudCambioInstructor solicitudCambioInstructor) {
		try {

			this.arbexpService.updateTrasvaseTotalCambioInstructor(solicitudCambioInstructor);

			SolarbController.logger.info("Entity correctly inserted!");

		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'maintNuevaMod'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintFicheroAdoMod", method = RequestMethod.GET)
	public ModelAndView getCreateFormModFicheroAdo(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilArbitraje() == null) {
			return new ModelAndView("accessDeniedModal", "model", model);
		}

		if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
			return new ModelAndView("modalArbitrajeFicheroAdo", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
			return new ModelAndView("modalArbitrajeFicheroAdo", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)) {
			return new ModelAndView("modalArbitrajeFicheroAdo", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)) {
			return new ModelAndView("modalArbitrajeFicheroAdo", "model", model);
		} else {
			return new ModelAndView("accessDeniedModal", "model", model);
		}
	}

	/**
	 * Method 'editInstructor'.
	 * 
	 * @return Map<String, Object>
	 */
	@RequestMapping(value = "/validaParametrosFicheroADO", method = RequestMethod.POST)
	public @ResponseBody() Map<String, Object> validaParametrosFicheroADO() {
		Map<String, Object> mapa = new HashMap<String, Object>();
		StringBuilder mensaje = new StringBuilder("");
		boolean flagError = false;
		try {

			Parametros parametrosfiltro = new Parametros();
			parametrosfiltro.setParametro("ADO_");
			List<Parametros> listParametros = this.parametrosService.findAllLike(parametrosfiltro, null, false);

			Map<String, BigDecimal> mapaLongitudes = Y41bADOConstantes.mapeoLongitudesParam();

			Map<String, String> mapaTipos = Y41bADOConstantes.mapeoTiposParam();

			if (listParametros != null && listParametros.size() > 0) {
				BigDecimal longitudCampoMaxima;
				BigDecimal paramTipoNumber;

				for (int i = 0; i < listParametros.size(); i++) {
					Parametros param = listParametros.get(i);

					if (mapaLongitudes.get(param.getParametro()) != null) {
						longitudCampoMaxima = mapaLongitudes.get(param.getParametro());

						BigDecimal longitudActual;
						if (param.getValor() != null) {
							longitudActual = new BigDecimal(param.getValor().length());
						} else {
							longitudActual = new BigDecimal(0);
						}
						if (longitudActual.compareTo(longitudCampoMaxima) == 1) {
							flagError = true;
							// el parametro guardado en BBDD supera la longitud
							// mxima permitida

							String[] args = { param.getParametro(), longitudCampoMaxima.toString() };
							;
							mensaje.append(this.appMessageSource.getMessage("arbitraje.ficheroado.msg.parametrolong.0",
									args, LocaleContextHolder.getLocale())).append("<br>");

						}
					}

					// miramos si el parametro tiene algun tipo que no sea
					// String
					if (mapaTipos.get(param.getParametro()) != null) {

						if (param.getValor() != null
								&& mapaTipos.get(param.getParametro()).equals(Y41bADOConstantes.TIPO_NUMBER)) {
							try {
								paramTipoNumber = new BigDecimal(param.getValor());
								SolarbController.logger.debug(paramTipoNumber.toString());
							} catch (NumberFormatException ex) {
								flagError = true;
								String[] args = { param.getParametro() };

								mensaje.append(
										this.appMessageSource.getMessage("arbitraje.ficheroado.msg.parametrotipo.0",
												args, LocaleContextHolder.getLocale()))
										.append("<br>");

							}
						} else if (param.getValor() != null
								&& mapaTipos.get(param.getParametro()).equals(Y41bADOConstantes.TIPO_EMAIL)) {

							String[] emails = param.getValor().split(";");
							for (int j = 0; j < emails.length; j++) {

								if (!Y41bUtils.validaEmailFormato(emails[j])) {
									String[] args = { param.getParametro() };
									flagError = true;
									mensaje.append(
											this.appMessageSource.getMessage("arbitraje.ficheroado.msg.parametrotipo.1",
													args, LocaleContextHolder.getLocale()))
											.append("<br>");
								}
							}

						}

					}

				}

			}
			mapa.put("flagError", flagError);
			mapa.put("mensaje", mensaje.toString());

			return mapa;
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editInstructor'.
	 * 
	 * @param arbFicheroADO
	 *            {@link ArbFicheroADO}
	 * @return Map<String, Object>
	 */
	@RequestMapping(value = "/validaTercerosFicheroADO", method = RequestMethod.POST)
	public @ResponseBody() Map<String, Object> validaTercerosFicheroADO(@RequestBody() ArbFicheroADO arbFicheroADO) {
		Map<String, Object> mapa = new HashMap<String, Object>();
		StringBuilder mensaje = new StringBuilder("");
		boolean flagError = false;
		try {

			arbFicheroADO.setFindByAltaTercero("S");

			List<ArbFicheroADO> listFicheroADO = this.solarbService.findAllFicheroADO(arbFicheroADO);

			if (Y41bModuloUtils.getInstance().mostrarPagoPericialColegio()) {
				List<ArbFicheroADO> listFicheroADOPagoPericialColegio = this.solarbService
						.findAllFicheroADOPagoPericialColegio(arbFicheroADO);

				if (listFicheroADO != null) {
					listFicheroADO.addAll(listFicheroADOPagoPericialColegio);
				} else {
					listFicheroADO = listFicheroADOPagoPericialColegio;
				}
			}

			if (listFicheroADO != null && listFicheroADO.size() > 0) {
				// flagError =true;

				ArbFicheroADO arbFicheroExpediente;
				List<Arbitro> listaArbitros;
				Arbitro arbitro;
				String identificadorArbitro;
				List<String> listaArbitrosSinAlta = new ArrayList<String>();
				for (int i = 0; i < listFicheroADO.size(); i++) {

					arbFicheroExpediente = listFicheroADO.get(i);
					listaArbitros = arbFicheroExpediente.getArbitrosPagoLaudo();
					if (listaArbitros != null && listaArbitros.size() > 0) {

						for (int j = 0; j < listaArbitros.size(); j++) {

							arbitro = listaArbitros.get(j);
							if (arbitro.getArtercero() == null || !"S".equals(arbitro.getArtercero())) {
								// el arbitro no est dado de alta para tercero

								String arnif = arbitro.getArnif();
								if (!listaArbitrosSinAlta.contains(arnif)) {

									listaArbitrosSinAlta.add(arnif);
									flagError = true;

									identificadorArbitro = arbitro.getArnombre()
											.concat(arbitro.getArnif() != null ? "-".concat(arbitro.getArnif()) : "");
									String[] args = { identificadorArbitro };

									mensaje.append(
											this.appMessageSource.getMessage("arbitraje.ficheroado.msg.arbitro.0", args,
													LocaleContextHolder.getLocale()))
											.append("<br><br>");
								}

							}

						}

					}
				}

			}

			mapa.put("flagError", flagError);
			mapa.put("mensaje", mensaje.toString());

			return mapa;
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editInstructor'.
	 * 
	 * @param arbFicheroADO
	 *            {@link ArbFicheroADO}
	 * @return Map<String, Object>
	 */
	@RequestMapping(value = "/generaFicheroADO", method = RequestMethod.POST)
	public @ResponseBody() Map<String, Object> generaFicheroADO(@RequestBody() ArbFicheroADO arbFicheroADO,
			HttpServletRequest httpRequest) {
		Map<String, Object> mapa = new HashMap<String, Object>();
		StringBuilder mensaje = new StringBuilder("");
		boolean flagError = false;
		try {

			// obtenemos todos los parmetros
			Parametros parametrosfiltro = new Parametros();
			parametrosfiltro.setParametro("ADO_");

			Map<String, String> mapParametros = this.parametrosService.findParametrosFicheroADO();

			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);

			String codUsuario = censoMonitor.getPuestoxlnet();
			mapParametros.put(Y41bADOConstantes.NAME_ADO_USUARIO, codUsuario);

			mapParametros.put(Y41bADOConstantes.NAME_ADO_IDIOMA, "0");

			String enviado = this.solarbService.generarFicheroADO(arbFicheroADO, mapParametros, censoMonitor);
			if (!"0".equals(enviado)) {
				enviado = enviado.replaceAll(";", "<br><br>");
				mensaje.append(this.appMessageSource.getMessage("arbitraje.ficheroado.msg.correcto", null,
						LocaleContextHolder.getLocale())).append("<br><br>")
						// .append(mapParametros
						// .get(Y41bADOConstantes.NAME_ADO_EMAIL));
						.append(enviado);

				mapa.put("flagError", flagError);
				mapa.put("mensaje", mensaje.toString());
			} else {
				mensaje.append(this.appMessageSource.getMessage("arbitraje.ficheroado.msg.sinEnvio", null,
						LocaleContextHolder.getLocale()));
				mapa.put("flagError", flagError);
				mapa.put("mensaje", mensaje.toString());
			}

			return mapa;
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param munId
	 *            String
	 * @param provId
	 *            String
	 * @param excodigo
	 *            String
	 * @return T17Municipio
	 */
	private T17Municipio crearMunicipio(String munId, String provId, String excodigo) {
		return new T17Municipio(munId, provId, "", excodigo);
	}

	/**
	 * 
	 * @param provId
	 *            String
	 * @param excodigo
	 *            String
	 * @return T17Provincia
	 */
	private T17Provincia crearProvincia(String provId, String excodigo) {
		return new T17Provincia(provId, "", excodigo);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param sacodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/dameReclamados", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGridReclamados(
			@RequestParam(value = "sacodigo", required = false) String sacodigo,
			@ModelAttribute() Pagination pagination) {

		Solarb solarb = new Solarb();
		solarb.setSacodigo(sacodigo);

		Essa essa = new Essa();
		essa.setSolarb(solarb);

		List<Essa> lEssa = this.essaService.findAll(essa, pagination);
		Long recordNum = this.essaService.findAllCount(essa);
		return new JQGridJSONModel(pagination, recordNum, lEssa);
	}

	/**
	 * Method 'getAllConsumidorGrid'.
	 * 
	 * @param sacodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/dameConsumidorGrid", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllConsumidorGrid(
			@RequestParam(value = "sacodigo", required = true) String sacodigo,
			@ModelAttribute() Pagination pagination) {

		Dtsa dtsa = new Dtsa();
		dtsa.setSolarb(new Solarb(sacodigo));

		List<Dtsa> consumidores = this.dtsaService.findConsumidorGrid(dtsa);

		Long recordNum = this.dtsaService.findAllCount(dtsa);
		return new JQGridJSONModel(pagination, recordNum, consumidores);

	}

	/**
	 * Method 'maintNuevaMod'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintNuevaDocs", method = RequestMethod.GET)
	public void getDocsReclamacion(@RequestParam(value = "idTramite", required = true) String idTramiteApertura,
			@RequestParam(value = "codExpediente", required = true) String codExpediente) {

		if (!Y41bUtils.esNullOCadenaVacia(codExpediente)) {
			// Recuperar documentos aportados de la reclamacion previa
			this.solarbService.volcarDocumentosReclamacionPrevia(codExpediente, idTramiteApertura);
		}
	}

	/**
	 * Method 'maintNuevaMod'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/borrarDocsReclamacion", method = RequestMethod.GET)
	public void borrarDocsReclamacion(@RequestParam(value = "idTramite", required = true) String idTramiteApertura) {
		// Recuperar documentos aportados de la reclamacion previa
		this.solarbService.volcarDocumentosReclamacionPrevia(null, idTramiteApertura);
	}

	/**
	 * Method 'maintNuevaMod'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintPeticionActualizacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormPetAct(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.NUM_ACTUALIZACION_ESTABLECIMIENTOS);
		parametros = this.parametrosService.find(parametros);
		model.addAttribute("numPetActEst", parametros.getValor());

		parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.MESES_ACTUALIZACION_ESTABLECIMIENTOS);
		parametros = this.parametrosService.find(parametros);
		model.addAttribute("mesesPetActEst", parametros.getValor());

		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilArbitraje() == null) {
			return new ModelAndView("accessDeniedModal", "model", model);
		}

		if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
			return new ModelAndView("modalArbPeticionActualizacion", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
			return new ModelAndView("modalArbPeticionActualizacion", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)) {
			return new ModelAndView("modalArbPeticionActualizacion", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)) {
			return new ModelAndView("modalArbPeticionActualizacion", "model", model);
		} else {
			return new ModelAndView("accessDeniedModal", "model", model);
		}
	}

	/**
	 * Method 'maintMailingIconoWeb'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintMailingIconoWeb", method = RequestMethod.GET)
	public ModelAndView getCreateFormMailingIconoWeb(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.NUM_MAILS_ICONO_WEB);
		parametros = this.parametrosService.find(parametros);
		model.addAttribute("numMailsIconoWeb", parametros.getValor());

		parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.MESES_MAILS_ICONO_WEB);
		parametros = this.parametrosService.find(parametros);
		model.addAttribute("mesesMailsIconoWeb", parametros.getValor());

		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilArbitraje() == null) {
			return new ModelAndView("accessDeniedModal", "model", model);
		}

		if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
			return new ModelAndView("modalArbMailingIconoWeb", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
			return new ModelAndView("modalArbMailingIconoWeb", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)) {
			return new ModelAndView("modalArbMailingIconoWeb", "model", model);
		} else if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)) {
			return new ModelAndView("modalArbMailingIconoWeb", "model", model);
		} else {
			return new ModelAndView("accessDeniedModal", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormExcelEmpresasAdheridas'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(method = RequestMethod.GET, value = "maintExcelEmpresasAdheridas")
	public ModelAndView getCreateFormExcelEmpresasAdheridas(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilArbitraje() == null) {
			return new ModelAndView("accessDeniedModal", "model", model);
		}

		if (Y41bConstantes.PERFIL_ADMINISTRATIVO.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())
				|| Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())
				|| Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())
				|| Y41bConstantes.PERFIL_COORDINADOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())
				|| Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())) {
			return new ModelAndView("modalArbExcelEmpresasAdheridas", "model", model);
		} else {
			return new ModelAndView("accessDeniedModal", "model", model);
		}
	}

	/**
	 * Method 'editInstructor'.
	 * 
	 * @param arbFicheroADO
	 *            {@link ArbFicheroADO}
	 * @return Map<String, Object>
	 */
	@RequestMapping(value = "/enviaPeticionActualizacion", method = RequestMethod.GET)
	public @ResponseBody() Map<String, Object> enviaPeticionActualizacion(
			@ModelAttribute(value = "numPetActEst") String numPetActEst,
			@ModelAttribute(value = "mesesPetActEst") String mesesPetActEst, HttpServletRequest request) {
		Map<String, Object> mapa = new HashMap<String, Object>();
		StringBuilder mensaje = new StringBuilder("");
		HttpSession httpSession = request.getSession();
		SolarbController.logger.debug("Inicio enviaPeticionActualizacion");
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = censoMonitorService.find(censoMonitor);
		if (censoMonitor != null && (censoMonitor.getMocoem() == null || censoMonitor.getMocoem().equals(""))) {
			throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, new Exception());
		}
		try {
			SolarbController.logger.debug("Recuperamos lista de establecimientos");
			List<Establecimiento> listPetActEst = this.establecimientoService.findAllPetActDatos(numPetActEst,
					mesesPetActEst);
			Establecimiento establecimiento = null;
			if (listPetActEst != null && listPetActEst.size() > 0) {
				SolarbController.logger.debug("Numero de establecimientos: " + listPetActEst.size());
				mensaje.append(this.appMessageSource.getMessage("arbitraje.petActDatos.establecimiento.0", null,
						LocaleContextHolder.getLocale())).append("<br><br>");
				for (int i = 0; i < listPetActEst.size(); i++) {
					establecimiento = listPetActEst.get(i);
					StringBuffer direccionCompleta = new StringBuffer();

					if (establecimiento.getEsnombreCalle() != null && !establecimiento.getEsnombreCalle().equals("")) {
						direccionCompleta.append(establecimiento.getEsnombreCalle());
						if (establecimiento.getEsnombrePortal() != null
								&& !establecimiento.getEsnombrePortal().equals("")) {
							direccionCompleta.append(", ").append(establecimiento.getEsnombrePortal());
						}
						if (establecimiento.getEsnombrePiso() != null
								&& !establecimiento.getEsnombrePiso().equals("")) {
							direccionCompleta.append(" ").append(establecimiento.getEsnombrePiso());
						}
						// if (establecimiento.getEsnombreMunicipio() != null
						// && !establecimiento.getEsnombreMunicipio()
						// .equals("")) {
						// direccionCompleta.append(" ").append(
						// establecimiento.getEsnombreMunicipio());
						// }
						// if (establecimiento.getEsnombreProvincia() != null
						// && !establecimiento.getEsnombreProvincia()
						// .equals("")) {
						// direccionCompleta.append(" ").append(
						// establecimiento.getEsnombreProvincia());
						// }
					} else if (establecimiento.getEsdireccion_nocapv() != null
							&& !establecimiento.getEsdireccion_nocapv().equals("")) {
						direccionCompleta.append(establecimiento.getEsdireccion_nocapv());
						// if (establecimiento.getEsnombreMunicipio() != null
						// && !establecimiento.getEsnombreMunicipio()
						// .equals("")) {
						// direccionCompleta.append(" ").append(
						// establecimiento.getEsnombreMunicipio());
						// }
						// if (establecimiento.getEsnombreProvincia() != null
						// && !establecimiento.getEsnombreProvincia()
						// .equals("")) {
						// direccionCompleta.append(" ").append(
						// establecimiento.getEsnombreProvincia());
						// }
					} else if (establecimiento.getEsnodir() != null && !establecimiento.getEsnodir().equals("")) {
						direccionCompleta.append(establecimiento.getEsnodir());
						// if (establecimiento.getEsnombreMunicipio() != null
						// && !establecimiento.getEsnombreMunicipio()
						// .equals("")) {
						// direccionCompleta.append(" ").append(
						// establecimiento.getEsnombreMunicipio());
						// }
						// if (establecimiento.getEsnombreProvincia() != null
						// && !establecimiento.getEsnombreProvincia()
						// .equals("")) {
						// direccionCompleta.append(" ").append(
						// establecimiento.getEsnombreProvincia());
						// }
					}
					establecimiento.setEsdireccionCompleta(direccionCompleta.toString());
					String[] args = { establecimiento.getEsnombre(), establecimiento.getEsnif(),
							establecimiento.getEsdireccionCompleta(), establecimiento.getEsnombreMunicipio() == null
									? "" : establecimiento.getEsnombreMunicipio() };
					SolarbController.logger
							.debug("Inicio de envioMailEstablecimiento para: " + establecimiento.getEsnombre());
					this.solarbService.envioMailEstablecimiento(censoMonitor.getMocoem(), establecimiento);
					SolarbController.logger
							.debug("Fin de envioMailEstablecimiento para: " + establecimiento.getEsnombre());
					mensaje.append(this.appMessageSource.getMessage("arbitraje.petActDatos.establecimiento.1", args,
							LocaleContextHolder.getLocale())).append("<br><br>");
					SolarbController.logger.debug("Inicio de updatePetActDatos");
					this.establecimientoService.updatePetActDatos(establecimiento.getEscodigo());
					SolarbController.logger.debug("Fin de updatePetActDatos");

				}
				SolarbController.logger.debug("Inicio contador establecimiento pendientes");
				Long pendientes = this.establecimientoService.findAllCountPetActDatos(mesesPetActEst);
				String[] args1 = { pendientes.toString(), mesesPetActEst };
				mensaje.append("<br><br>").append(this.appMessageSource
						.getMessage("arbitraje.petActDatos.establecimiento.4", args1, LocaleContextHolder.getLocale()))
						.append("<br><br>");
				SolarbController.logger.debug("Fin contador establecimiento pendientes");
			} else {
				SolarbController.logger.debug("Numero de establecimientos: 0 ");
				String[] args = { mesesPetActEst };
				mensaje.append(this.appMessageSource.getMessage("arbitraje.petActDatos.establecimiento.2", args,
						LocaleContextHolder.getLocale())).append("<br><br>");
			}

			mapa.put("mensaje", mensaje.toString());
			SolarbController.logger.debug("Fin de enviaPeticionActualizacion");
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
		return mapa;
	}

	/**
	 * Method 'enviaMailingIconoWeb'.
	 * 
	 * @param numMailsIconoWeb
	 * @param mesesMailsIconoWeb
	 * @return Map<String, Object>
	 */
	@RequestMapping(value = "/enviaMailingIconoWeb", method = RequestMethod.GET)
	public @ResponseBody() Map<String, Object> enviaMailingIconoWeb(
			@ModelAttribute(value = "numMailsIconoWeb") String numMailsIconoWeb,
			@ModelAttribute(value = "mesesMailsIconoWeb") String mesesMailsIconoWeb, HttpServletRequest request) {
		Map<String, Object> mapa = new HashMap<String, Object>();
		StringBuilder mensaje = new StringBuilder("");
		HttpSession httpSession = request.getSession();
		SolarbController.logger.debug("Inicio enviaMailingIconoWeb");
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = censoMonitorService.find(censoMonitor);
		if (censoMonitor != null && (censoMonitor.getMocoem() == null || "".equals(censoMonitor.getMocoem()))) {
			throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, new Exception());
		}
		try {
			SolarbController.logger.debug("Recuperamos lista de establecimientos");
			List<Establecimiento> listMailingIconoWebEst = this.establecimientoService
					.findAllMailingIconoWeb(numMailsIconoWeb, mesesMailsIconoWeb);
			Establecimiento establecimiento = null;
			if (listMailingIconoWebEst != null && !listMailingIconoWebEst.isEmpty()) {
				SolarbController.logger.debug("Numero de establecimientos: " + listMailingIconoWebEst.size());
				mensaje.append(this.appMessageSource.getMessage("arbitraje.mailingIconoWeb.establecimiento.0", null,
						LocaleContextHolder.getLocale())).append("<br><br>");
				for (int i = 0; i < listMailingIconoWebEst.size(); i++) {
					establecimiento = listMailingIconoWebEst.get(i);
					StringBuffer direccionCompleta = new StringBuffer();

					if (establecimiento.getEsnombreCalle() != null && !"".equals(establecimiento.getEsnombreCalle())) {
						direccionCompleta.append(establecimiento.getEsnombreCalle());
						if (establecimiento.getEsnombrePortal() != null
								&& !"".equals(establecimiento.getEsnombrePortal())) {
							direccionCompleta.append(", ").append(establecimiento.getEsnombrePortal());
						}
						if (establecimiento.getEsnombrePiso() != null
								&& !"".equals(establecimiento.getEsnombrePiso())) {
							direccionCompleta.append(" ").append(establecimiento.getEsnombrePiso());
						}
						// if (establecimiento.getEsnombreMunicipio() != null
						// && !establecimiento.getEsnombreMunicipio()
						// .equals("")) {
						// direccionCompleta.append(" ").append(
						// establecimiento.getEsnombreMunicipio());
						// }
						// if (establecimiento.getEsnombreProvincia() != null
						// && !establecimiento.getEsnombreProvincia()
						// .equals("")) {
						// direccionCompleta.append(" ").append(
						// establecimiento.getEsnombreProvincia());
						// }
					} else if (establecimiento.getEsdireccion_nocapv() != null
							&& !"".equals(establecimiento.getEsdireccion_nocapv())) {
						direccionCompleta.append(establecimiento.getEsdireccion_nocapv());
						// if (establecimiento.getEsnombreMunicipio() != null
						// && !establecimiento.getEsnombreMunicipio()
						// .equals("")) {
						// direccionCompleta.append(" ").append(
						// establecimiento.getEsnombreMunicipio());
						// }
						// if (establecimiento.getEsnombreProvincia() != null
						// && !establecimiento.getEsnombreProvincia()
						// .equals("")) {
						// direccionCompleta.append(" ").append(
						// establecimiento.getEsnombreProvincia());
						// }
					} else if (establecimiento.getEsnodir() != null && !"".equals(establecimiento.getEsnodir())) {
						direccionCompleta.append(establecimiento.getEsnodir());
						// if (establecimiento.getEsnombreMunicipio() != null
						// && !establecimiento.getEsnombreMunicipio()
						// .equals("")) {
						// direccionCompleta.append(" ").append(
						// establecimiento.getEsnombreMunicipio());
						// }
						// if (establecimiento.getEsnombreProvincia() != null
						// && !establecimiento.getEsnombreProvincia()
						// .equals("")) {
						// direccionCompleta.append(" ").append(
						// establecimiento.getEsnombreProvincia());
						// }
					}
					establecimiento.setEsdireccionCompleta(direccionCompleta.toString());
					String[] args = { establecimiento.getEsnombre(), establecimiento.getEsnif(),
							establecimiento.getEsdireccionCompleta(), establecimiento.getEsnombreMunicipio() == null
									? "" : establecimiento.getEsnombreMunicipio() };
					SolarbController.logger
							.debug("Inicio de envioMailEstablecimientoIconoWeb para: " + establecimiento.getEsnombre());
					this.solarbService.envioMailEstablecimientoIconoWeb(censoMonitor.getMocoem(), establecimiento);
					SolarbController.logger
							.debug("Fin de envioMailEstablecimientoIconoWeb para: " + establecimiento.getEsnombre());
					mensaje.append(this.appMessageSource.getMessage("arbitraje.mailingIconoWeb.establecimiento.1", args,
							LocaleContextHolder.getLocale())).append("<br><br>");
					SolarbController.logger.debug("Inicio de updateMailingIconoWeb");
					this.establecimientoService.updateMailingIconoWeb(establecimiento.getEscodigo());
					SolarbController.logger.debug("Fin de updateMailingIconoWeb");

				}
				SolarbController.logger.debug("Inicio contador establecimiento pendientes");
				Long pendientes = this.establecimientoService.findAllCountMailingIconoWeb(mesesMailsIconoWeb);
				String[] args1 = { pendientes.toString(), mesesMailsIconoWeb };
				mensaje.append("<br><br>")
						.append(this.appMessageSource.getMessage("arbitraje.mailingIconoWeb.establecimiento.4", args1,
								LocaleContextHolder.getLocale()))
						.append("<br><br>");
				SolarbController.logger.debug("Fin contador establecimiento pendientes");
			} else {
				SolarbController.logger.debug("Numero de establecimientos: 0 ");
				String[] args = { mesesMailsIconoWeb };
				mensaje.append(this.appMessageSource.getMessage("arbitraje.mailingIconoWeb.establecimiento.2", args,
						LocaleContextHolder.getLocale())).append("<br><br>");
			}

			mapa.put("mensaje", mensaje.toString());
			SolarbController.logger.debug("Fin de enviaMailingIconoWeb");
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
		return mapa;
	}

	/**
	 * Method 'excelEmpresasAdheridas'.
	 * 
	 * @param tipoFiltro
	 *            Integer
	 * @param numeroDesde
	 *            Integer
	 * @param numeroHasta
	 *            Integer
	 * @param listaCIF
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return Map<String, Object>
	 */
	@RequestMapping(value = "/excelEmpresasAdheridas", method = RequestMethod.GET)
	public void excelEmpresasAdheridas(@ModelAttribute(value = "tipoFiltro") Integer tipoFiltro,
			@ModelAttribute(value = "numeroDesde") String numeroDesde,
			@ModelAttribute(value = "numeroHasta") String numeroHasta,
			@ModelAttribute(value = "listaCIF") String listaCIF, HttpServletRequest request,
			HttpServletResponse response) {
		SolarbController.logger.debug("Inicio excelEmpresasAdheridas");
		try {
			Integer integerNumeroDesde = null;
			Integer integerNumeroHasta = null;
			if (Y41bUtils.isNumeric(numeroDesde)) {
				integerNumeroDesde = new Integer(numeroDesde);
			}
			if (Y41bUtils.isNumeric(numeroHasta)) {
				integerNumeroHasta = new Integer(numeroHasta);
			}
			if (tipoFiltro == null || (tipoFiltro.intValue() != 0 && tipoFiltro.intValue() != 1)) {
				throw new Y41bUDAException("error.generico", true, null);
			}
			List<String> lista = null;
			if (listaCIF != null) {
				String listaLimpia = Y41bUtils.dejarLetrasNumerosComaEspacio(listaCIF);
				lista = Arrays.asList(listaLimpia.split("\\s*,\\s*"));
			}

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");
			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_EMPRESAS_ADHERIDAS + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getEmpresasAdheridasExcel(tipoFiltro, integerNumeroDesde,
					integerNumeroHasta, lista);

			SolarbController.logger.debug("Fin de excelEmpresasAdheridas");
			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "gestionPagosArbitrosMaint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("gestionPagoArbitros", "model", model);
	}

	/**
	 * Method 'getAllEstablecimiento'.
	 * 
	 * @param escodigo
	 *            String
	 * @param censoMonitorMocodigo
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esnif_
	 *            String
	 * 
	 */
	@RequestMapping(value = "/busqueda", method = RequestMethod.GET)
	public @ResponseBody Object getAllPagosArbitros(@RequestParam(value = "escodigo", required = false) String escodigo,
			@RequestParam(value = "estado", required = false) String estado_,
			@RequestParam(value = "incluir", required = false) String incluir_,
			@RequestParam(value = "cofechaInicioDesde", required = false) Date cofechaInicioDesde_,
			@RequestParam(value = "cofechaInicioHasta", required = false) Date cofechaInicioHasta_,
			@RequestParam(value = "fechaEnvioEIKAInicioDesde", required = false) Date fechaEnvioEIKAInicioDesde_,
			@RequestParam(value = "fechaEnvioEIKAInicioHasta", required = false) Date fechaEnvioEIKAInicioHasta_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro

			String estado = devuelveValorFiltro(estado_);
			String incluir = devuelveValorFiltro(incluir_);
			// Date fechadesde = devuelveValorFiltro(cofechaInicioDesde_);
			// Date fechahasta = devuelveValorFiltro(cofechaInicioHasta_);

			ArbPagoArbitroADO filterListado = new ArbPagoArbitroADO();

			// control de los campos susceptibles de llegar a "" desde el filtro
			// String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			// String mocodigo = ("".equals(mocodigo_)) ? null : mocodigo_;

			filterListado.setEstado(estado);
			filterListado.setIncluir(incluir);
			filterListado.setFechaDesde(cofechaInicioDesde_);
			filterListado.setFechaHasta(cofechaInicioHasta_);
			filterListado.setFechaEnvioEIKADesde(fechaEnvioEIKAInicioDesde_);
			filterListado.setFechaEnvioEIKAHasta(fechaEnvioEIKAInicioHasta_);

			Pagination pagination = null;

			pagination = new Pagination();
			pagination.setPage(Long.valueOf(request.getParameter("page")));
			pagination.setRows(Long.valueOf(request.getParameter("rows")));
			pagination.setSort(request.getParameter("sidx"));
			pagination.setAscDsc(request.getParameter("sord"));
			List<ArbPagoArbitroADO> lista = this.solarbService.findAllLikeListaADO(filterListado, pagination, false);

			if (lista == null) {
				throw new Exception("No data Found.");
			}

			Long total = this.solarbService.findAllLikeListaADOCount(filterListado, false);
			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(request.getParameter("page"));
			data.setRecords(total.intValue());
			data.setTotal(total, pagination.getRows());
			data.setRows(lista);
			return data;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * 
	 * @param cadena
	 *            cadena
	 * @return valor o ""
	 */
	private static String devuelveValorFiltro(String cadena) {
		if (null != cadena && !"".equalsIgnoreCase(cadena)) {
			return cadena;
		} else {
			return null;
		}
	}

	/**
	 * Method 'enviarEika'.
	 *
	 * @param listadoPagosArbitros
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/enviarEika", method = RequestMethod.POST)
	public void enviarEika(@RequestBody ArrayList<String> listadoPagosArbitros, HttpServletResponse response,
			HttpServletRequest httpRequest) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");

		ArrayList<ArbPagoArbitroADO> listaPagos = new ArrayList<ArbPagoArbitroADO>();
		ArbPagoArbitroADO pago = new ArbPagoArbitroADO();
		Map<String, String> mapParametros = this.parametrosService.findParametrosFicheroADO();

		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = this.censoMonitorService.find(censoMonitor);

		String codUsuario = censoMonitor.getPuestoxlnet();
		mapParametros.put(Y41bADOConstantes.NAME_ADO_USUARIO, codUsuario);

		mapParametros.put(Y41bADOConstantes.NAME_ADO_IDIOMA, "0");
		try {

			for (String codigo : listadoPagosArbitros) {

				pago = new ArbPagoArbitroADO();
				String[] parts = codigo.split("&");
				String sacodigo = parts[0];
				String arcodigo = parts[1];
				String trid = parts[2];
				pago.setSacodigo(sacodigo);
				pago.setArcodigo(arcodigo);
				pago.setTridpagolaudo(trid);
				listaPagos.add(pago);
			}

			this.solarbService.enviarEika(listaPagos, mapParametros, censoMonitor);

			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			logger.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
			throw e;
		} catch (Exception e) {
			logger.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException(e.getMessage());
		}
	}

	/**
	 * Method 'editInstructor'.
	 * 
	 * @return Map<String, Object>
	 */
	@RequestMapping(value = "/validaParametrosFicheroADO_nuevo", method = RequestMethod.POST)
	public @ResponseBody() Map<String, Object> validaParametrosFicheroADO_nuevo() {
		Map<String, Object> mapa = new HashMap<String, Object>();
		StringBuilder mensaje = new StringBuilder("");
		boolean flagError = false;
		try {

			Parametros parametrosfiltro = new Parametros();
			parametrosfiltro.setParametro("ADO_");
			List<Parametros> listParametros = this.parametrosService.findAllLike(parametrosfiltro, null, false);

			Map<String, BigDecimal> mapaLongitudes = Y41bADOConstantes.mapeoLongitudesParam_nuevo();

			Map<String, String> mapaTipos = Y41bADOConstantes.mapeoTiposParam_nuevo();

			if (listParametros != null && listParametros.size() > 0) {
				BigDecimal longitudCampoMaxima;
				BigDecimal paramTipoNumber;

				for (int i = 0; i < listParametros.size(); i++) {
					Parametros param = listParametros.get(i);

					if (mapaLongitudes.get(param.getParametro()) != null) {
						longitudCampoMaxima = mapaLongitudes.get(param.getParametro());

						BigDecimal longitudActual;
						if (param.getValor() != null) {
							longitudActual = new BigDecimal(param.getValor().length());
						} else {
							longitudActual = new BigDecimal(0);
						}
						if (longitudActual.compareTo(longitudCampoMaxima) == 1) {
							flagError = true;
							// el parametro guardado en BBDD supera la longitud
							// mxima permitida

							String[] args = { param.getParametro(), longitudCampoMaxima.toString() };
							mensaje.append(this.appMessageSource.getMessage("arbitraje.ficheroado.msg.parametrolong.0",
									args, LocaleContextHolder.getLocale())).append("<br>");

						}
					}

					// miramos si el parametro tiene algun tipo que no sea
					// String
					if (mapaTipos.get(param.getParametro()) != null) {

						if (param.getValor() != null
								&& mapaTipos.get(param.getParametro()).equals(Y41bADOConstantes.TIPO_NUMBER)) {
							try {
								paramTipoNumber = new BigDecimal(param.getValor());
								SolarbController.logger.debug(paramTipoNumber.toString());
							} catch (NumberFormatException ex) {
								flagError = true;
								String[] args = { param.getParametro() };

								mensaje.append(
										this.appMessageSource.getMessage("arbitraje.ficheroado.msg.parametrotipo.0",
												args, LocaleContextHolder.getLocale()))
										.append("<br>");

							}
						} else if (param.getValor() != null
								&& mapaTipos.get(param.getParametro()).equals(Y41bADOConstantes.TIPO_EMAIL)) {

							String[] emails = param.getValor().split(";");
							for (int j = 0; j < emails.length; j++) {

								if (!Y41bUtils.validaEmailFormato(emails[j])) {
									String[] args = { param.getParametro() };
									flagError = true;
									mensaje.append(
											this.appMessageSource.getMessage("arbitraje.ficheroado.msg.parametrotipo.1",
													args, LocaleContextHolder.getLocale()))
											.append("<br>");
								}
							}

						}

					}

				}

			}
			mapa.put("flagError", flagError);
			mapa.put("mensaje", mensaje.toString());

			return mapa;
		} catch (Y41bUDAException e) {
			SolarbController.logger.error(e.getMessage());
			throw e;
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editInstructor'.
	 * 
	 * @param arbFicheroADO
	 *            {@link ArbFicheroADO}
	 * @return Map<String, Object>
	 */
	@RequestMapping(value = "/validaTercerosFicheroADO_nuevo", method = RequestMethod.POST)
	public @ResponseBody() Map<String, Object> validaTercerosFicheroADO_nuevo(
			@RequestBody ArrayList<String> listadoPagosArbitros) {
		Map<String, Object> mapa = new HashMap<String, Object>();
		StringBuilder mensaje = new StringBuilder("");
		boolean flagError = false;
		try {

			ArbPagoArbitroADO pago = new ArbPagoArbitroADO();
			String identificadorArbitro;
			List<String> listaArbitrosSinAlta = new ArrayList<String>();

			for (String codigo : listadoPagosArbitros) {

				String[] parts = codigo.split("&");
				String sacodigo = parts[0];
				String trid = parts[2];
				pago.setSacodigo(sacodigo);
				pago.setTridpagolaudo(trid);

				List<ArbPagoArbitroADO> lista = this.solarbService.findAllLikeListaADO(pago, null, false);

				if (lista != null && lista.size() > 0) {
					// flagError =true;

					for (int i = 0; i < lista.size(); i++) {

						pago = lista.get(i);

						if (pago.getArtercero() == null || !"S".equals(pago.getArtercero())) {
							// el arbitro no est dado de alta para tercero

							String arnif = pago.getArnif();
							if (!listaArbitrosSinAlta.contains(arnif)) {

								listaArbitrosSinAlta.add(arnif);
								flagError = true;

								identificadorArbitro = pago.getArnombre()
										.concat(pago.getArnif() != null ? "-".concat(pago.getArnif()) : "");
								String[] args = { identificadorArbitro };

								mensaje.append(this.appMessageSource.getMessage("arbitraje.ficheroado.msg.arbitro.0",
										args, LocaleContextHolder.getLocale())).append("<br><br>");
							}

						}

					}
				}

			}

			mapa.put("flagError", flagError);
			mapa.put("mensaje", mensaje.toString());

			return mapa;
		} catch (Y41bUDAException e) {
			SolarbController.logger.error(e.getMessage());
			throw e;
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editInstructor'.
	 * 
	 * @param arbFicheroADO
	 *            {@link ArbFicheroADO}
	 * @return Map<String, Object>
	 */
	@RequestMapping(value = "/funcionValidaTercerosFicheroADO_nuevo", method = RequestMethod.POST)
	public @ResponseBody() Map<String, Object> funcionValidaTercerosFicheroADO_nuevo(
			@RequestBody ArrayList<String> listadoPagosArbitros) {
		Map<String, Object> mapa = new HashMap<String, Object>();
		StringBuilder mensaje = new StringBuilder("");
		boolean flagError = false;
		try {

			ArbPagoArbitroADO pago = new ArbPagoArbitroADO();
			String identificadorArbitro;
			List<String> listaArbitrosSinAlta = new ArrayList<String>();
			List<Arbitro> listaArbitros = new ArrayList<Arbitro>();
			Arbitro arbitro = new Arbitro();

			for (String codigo : listadoPagosArbitros) {

				arbitro = new Arbitro();
				String[] parts = codigo.split("&");
				// String sacodigo = parts[0];
				String arcodigo = parts[1];
				// String trid = parts[2];
				// pago.setSacodigo(sacodigo);
				// pago.setTridpagolaudo(trid);
				arbitro.setArcodigo(arcodigo);
				listaArbitros.add(arbitro);

			}

			this.solarbService.validarArbitrostercero(listaArbitros);

		} catch (Y41bUDAException e) {
			mensaje.append(e.getMessages().keySet().toString()).append("<br>");
			flagError = true;
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
		mapa.put("flagError", flagError);
		mapa.put("mensaje", mensaje.toString());
		return mapa;
	}

	private static final int NUMERO_REGISTRO_ACTUALIZAR = 20;

	/**
	 * Method 'editInstructor'.
	 * 
	 * @param arbFicheroADO
	 *            {@link ArbFicheroADO}
	 * @return Map<String, Object>
	 */
	@RequestMapping(value = "/actualizarEstadoFicheroADO", method = RequestMethod.POST)
	public @ResponseBody() Map<String, Object> actualizarEstadoFicheroADO() {
		try {
			Map<String, Object> mapa = new HashMap<String, Object>();

			// Localizar los sin actualizar
			List<Pagosarbitros> listaPagosArbitros = this.pagosArbitrosService.findAllSinActualizarOrdenado();

			// Actualizarlos
			if (listaPagosArbitros != null) {
				for (int i = 0; i < SolarbController.NUMERO_REGISTRO_ACTUALIZAR && i < listaPagosArbitros.size(); i++) {
					Pagosarbitros pagosarbitros = listaPagosArbitros.get(i);
					Date fechaPago = this.y41bEIKAAdapterService.consultaResultadoPagos(pagosarbitros.getPanumexp(),
							pagosarbitros.getPadocfi());
					pagosarbitros.setPafeccont(fechaPago);
					pagosarbitros.setPafecultcon(Y41bUtils.hoy());
					this.pagosArbitrosService.update(pagosarbitros);
				}
			}

			// Ver cuantos falta por actualizar y devolver el valor
			Long resto = this.pagosArbitrosService.findAllSinActualizarCount();
			mapa.put("mensaje", resto.toString());

			return mapa;
		} catch (Y41bUDAException e) {
			SolarbController.logger.error(e.getMessage());
			throw e;
		} catch (Exception e) {
			SolarbController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

}
