package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.SedeService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Sede;

/**
 * SedeController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/sede")
public class SedeController {

	private static final Logger logger = LoggerFactory
			.getLogger(SedeController.class);

	@Autowired
	private SedeService sedeService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SedeController.logger.info("[GET - View] : sede");
		return "sede";
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSedeTabs", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSedeTabs(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null
				|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("y41bSedeTabs", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSedeTabSolicitudes", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSedeTabSolicitudes(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null
				|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bSedeTabSolicitudes", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSedeTabSanciones", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSedeTabSanciones(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null
				|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bSedeTabSanciones", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSedeTabArbitraje", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSedeTabArbitraje(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null
				|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bSedeTabArbitraje", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSedeTabInspecciones", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSedeTabInspecciones(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null
				|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bSedeTabInspecciones", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idDatosede
	 *            String
	 * @return sede Sede
	 */
	@RequestMapping(value = "/{idDatosede}", method = RequestMethod.GET)
	public @ResponseBody
	Sede getById(@PathVariable String idDatosede) {
		Sede sede = new Sede();
		sede.setIdDatosede(idDatosede);
		sede = this.sedeService.find(sede);
		SedeController.logger.info("[GET - findBy_PK] : Obtener Sede por PK");
		return sede;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSede
	 *            Sede
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Sede> getAll(@ModelAttribute Sede filterSede) {
		SedeController.logger
				.info("[GET - find_ALL] : Obtener Sede por filtro");
		return this.sedeService.findAll(filterSede, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Sede edit(@RequestBody Sede sede) {
		Sede sedeAux = this.sedeService.update(sede);
		SedeController.logger.info("[PUT] : Sede actualizado correctamente");
		return sedeAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Sede add(@RequestBody Sede sede) {
		Sede sedeAux = this.sedeService.add(sede);
		SedeController.logger.info("[POST] : Sede insertado correctamente");
		return sedeAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idDatosede
	 *            String
	 * @return sede
	 */
	@RequestMapping(value = "/{idDatosede}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Sede remove(@PathVariable String idDatosede) {
		Sede sede = new Sede();
		sede.setIdDatosede(idDatosede);
		this.sedeService.remove(sede);
		SedeController.logger.info("[DELETE] : Sede borrado correctamente");
		return sede;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sedeIds
	 *            List
	 * @return sedeList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> sedeIds) {
		List<Sede> sedeList = new ArrayList<Sede>();
		for (List<String> sedeId : sedeIds) {
			Iterator<String> iterator = sedeId.iterator();
			Sede sede = new Sede(); // NOPMD - Objeto nuevo en la lista
									// (parametro del servicio)
			sede.setIdDatosede(ObjectConversionManager.convert(iterator.next(),
					String.class));
			sedeList.add(sede);
		}
		this.sedeService.removeMultiple(sedeList);
		SedeController.logger
				.info("[POST - DELETE_ALL] : Sede borrados correctamente");
		return sedeIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSede
	 *            Sede
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Sede filterSede,
			@ModelAttribute Pagination pagination) {
		List<Sede> sedes = this.sedeService.findAll(filterSede, pagination);
		Long recordNum = this.sedeService.findAllCount(filterSede);
		SedeController.logger.info("[GET - jqGrid] : Obtener Sede");
		return new JQGridJSONModel(pagination, recordNum, sedes);
	}

}
