package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.SectorAgrupado;
import com.ejie.y41b.model.Y41bArbolSectores;
import com.ejie.y41b.service.ArbolSectoresService;
import com.ejie.y41b.service.SectorService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.tree.Y41bSectoresTree;

/**
 * * SectorController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/sector")
@SessionAttributes({ "codSector", "modoBusquedaSector", "modoSector" })
public class SectorController {

	private static final Logger logger = LoggerFactory
			.getLogger(SectorController.class);

	@Autowired
	private SectorService sectorService;

	@Autowired
	private ArbolSectoresService arbolSectoresService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "sectores", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaSector", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("sectores", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionSector", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaSector",
				Y41bConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("seleccionSectores", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "arbolsector", method = RequestMethod.GET)
	public ModelAndView getCreateFormArbolProducto(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("arbolSectores", "model", model);
	}

	/**
	 * Method 'getCreateFormAltaSector'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaSector", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaSector(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codSector", "");

		model.addAttribute("modoSector", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleSector", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModSector'.
	 * 
	 * @param codSector
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modSector/{codSector}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModSector(@PathVariable String codSector,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codSector", codSector);

		model.addAttribute("modoSector", Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleSector", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param secodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{secodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Sector getById(@PathVariable String secodigo) {
		try {
			Sector sector = new Sector();
			sector.setSecodigo(secodigo);
			sector = this.sectorService.find(sector);
			if (sector == null) {
				throw new Exception(secodigo.toString());
			}
			return sector;
		} catch (Exception e) {
			throw new ResourceNotFoundException(secodigo.toString());
		}
	}

	/**
	 * Method 'getSectorById'.
	 * 
	 * @param secodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findSector/{secodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Sector getSectorById(@PathVariable String secodigo) {
		try {
			Sector sector = new Sector();
			sector.setSecodigo(secodigo);
			sector = this.sectorService.findSector(sector);
			if (sector == null) {
				throw new Exception(secodigo.toString());
			}
			return sector;
		} catch (Exception e) {
			throw new ResourceNotFoundException(secodigo.toString());
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param secodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "SectorSeleccionable/{secodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Sector getByIdSeleccionable(@PathVariable String secodigo) {
		try {
			Sector sector = new Sector();
			sector.setSecodigo(secodigo);
			sector = this.sectorService.findSectorSeleccionable(sector);
			if (sector == null) {
				throw new Exception(secodigo.toString());
			}
			return sector;
		} catch (Exception e) {
			throw new ResourceNotFoundException(secodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param secodigo
	 *            String
	 * @param sectorAgrupadoL0codigo
	 *            String
	 * @param senombre
	 *            String
	 * @param senoco
	 *            String
	 * @param sedescri
	 *            String
	 * @param secose
	 *            String
	 * @param senoco2
	 *            String
	 * @param seinsel1
	 *            String
	 * @param senombree
	 *            String
	 * @param senombrei
	 *            String
	 * @param senombref
	 *            String
	 * @param senocoe
	 *            String
	 * @param senocoi
	 *            String
	 * @param senocof
	 *            String
	 * @param sedescrie
	 *            String
	 * @param sedescrii
	 *            String
	 * @param sedescrif
	 *            String
	 * @param secodgrupo
	 *            String
	 * @param senombrea
	 *            String
	 * @param sedescria
	 *            String
	 * @param senocoa
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/sectoresAll", method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "secodigo", required = false) String secodigo,
			@RequestParam(value = "sectorAgrupadoL0codigo", required = false) String sectorAgrupadoL0codigo,
			@RequestParam(value = "senombre", required = false) String senombre,
			@RequestParam(value = "senoco", required = false) String senoco,
			@RequestParam(value = "sedescri", required = false) String sedescri,
			@RequestParam(value = "secose", required = false) String secose,
			@RequestParam(value = "senoco2", required = false) String senoco2,
			@RequestParam(value = "seinsel1", required = false) String seinsel1,
			@RequestParam(value = "senombree", required = false) String senombree,
			@RequestParam(value = "senombrei", required = false) String senombrei,
			@RequestParam(value = "senombref", required = false) String senombref,
			@RequestParam(value = "senocoe", required = false) String senocoe,
			@RequestParam(value = "senocoi", required = false) String senocoi,
			@RequestParam(value = "senocof", required = false) String senocof,
			@RequestParam(value = "sedescrie", required = false) String sedescrie,
			@RequestParam(value = "sedescrii", required = false) String sedescrii,
			@RequestParam(value = "sedescrif", required = false) String sedescrif,
			@RequestParam(value = "secodgrupo", required = false) String secodgrupo,
			@RequestParam(value = "senombrea", required = false) String senombrea,
			@RequestParam(value = "sedescria", required = false) String sedescria,
			@RequestParam(value = "senocoa", required = false) String senocoa,
			HttpServletRequest request) {
		try {
			Sector filterSector = new Sector(secodigo, senombre, senoco,
					sedescri, secose, senoco2, seinsel1, senombree, senombrei,
					senombref, senocoe, senocoi, senocof, sedescrie, sedescrii,
					sedescrif, secodgrupo, senombrea, sedescria, senocoa,
					new SectorAgrupado(sectorAgrupadoL0codigo, null, null,
							null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Sector> sectors = this.sectorService.findAll(filterSector,
						pagination);

				if (sectors == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterSector, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(sectors);
				return data;
			} else {
				List<Sector> sectors = this.sectorService.findAll(filterSector,
						pagination);
				if (sectors == null) {
					throw new Exception("No data Found.");
				}
				return sectors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterSector
	 *            Sector
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "sector", required = false) Sector filterSector,
			HttpServletRequest request) {
		try {
			return sectorService
					.findAllCount(filterSector != null ? filterSector
							: new Sector());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllSector'.
	 * 
	 * @param secodigo_
	 *            String
	 * @param sectorAgrupadoL0codigo_
	 *            String
	 * @param senombre_
	 *            String
	 * @param senoco
	 *            String
	 * @param sedescri
	 *            String
	 * @param secose
	 *            String
	 * @param senoco2
	 *            String
	 * @param seinsel1_
	 *            String
	 * @param senombree
	 *            String
	 * @param senombrei
	 *            String
	 * @param senombref
	 *            String
	 * @param senocoe
	 *            String
	 * @param senocoi
	 *            String
	 * @param senocof
	 *            String
	 * @param sedescrie
	 *            String
	 * @param sedescrii
	 *            String
	 * @param sedescrif
	 *            String
	 * @param secodgrupo
	 *            String
	 * @param senombrea
	 *            String
	 * @param sedescria
	 *            String
	 * @param senocoa
	 *            String
	 * @param idsDescriptores_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAllSector(
			@RequestParam(value = "secodigo", required = false) String secodigo_,
			@RequestParam(value = "sectorAgrupadoL0codigo", required = false) String sectorAgrupadoL0codigo_,
			@RequestParam(value = "senombre", required = false) String senombre_,
			@RequestParam(value = "senoco", required = false) String senoco,
			@RequestParam(value = "sedescri", required = false) String sedescri,
			@RequestParam(value = "secose", required = false) String secose,
			@RequestParam(value = "senoco2", required = false) String senoco2,
			@RequestParam(value = "seinsel1", required = false) String seinsel1_,
			@RequestParam(value = "senombree", required = false) String senombree,
			@RequestParam(value = "senombrei", required = false) String senombrei,
			@RequestParam(value = "senombref", required = false) String senombref,
			@RequestParam(value = "senocoe", required = false) String senocoe,
			@RequestParam(value = "senocoi", required = false) String senocoi,
			@RequestParam(value = "senocof", required = false) String senocof,
			@RequestParam(value = "sedescrie", required = false) String sedescrie,
			@RequestParam(value = "sedescrii", required = false) String sedescrii,
			@RequestParam(value = "sedescrif", required = false) String sedescrif,
			@RequestParam(value = "secodgrupo", required = false) String secodgrupo,
			@RequestParam(value = "senombrea", required = false) String senombrea,
			@RequestParam(value = "sedescria", required = false) String sedescria,
			@RequestParam(value = "senocoa", required = false) String senocoa,
			@RequestParam(value = "idsDescriptores", required = false) String idsDescriptores_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String seinsel1 = ("".equals(seinsel1_)) ? null : seinsel1_;
			String idsDescriptores = ("".equals(idsDescriptores_)) ? null
					: idsDescriptores_;
			String secodigo = ("".equals(secodigo_)) ? null : secodigo_;
			String senombre = ("".equals(senombre_)) ? null : senombre_;
			String sectorAgrupadoL0codigo = ("".equals(sectorAgrupadoL0codigo_)) ? null
					: sectorAgrupadoL0codigo_;
			Sector filterSector = new Sector(secodigo, senombre, senoco,
					sedescri, secose, senoco2, seinsel1, senombree, senombrei,
					senombref, senocoe, senocoi, senocof, sedescrie, sedescrii,
					sedescrif, secodgrupo, senombrea, sedescria, senocoa,
					new SectorAgrupado(sectorAgrupadoL0codigo, null, null,
							null, null));

			List<Descriptor> descriptores = new ArrayList<Descriptor>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();// NOPMD 2012/02/29 (IDA)
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}
			filterSector.setDescriptores(descriptores);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Sector> sectors = this.sectorService.findAllLikeSector(
						filterSector, pagination, false);

				if (sectors == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.sectorService.findAllLikeSectorCount(
						filterSector, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(sectors);
				return data;
			} else {
				pagination = new Pagination();
				pagination.setSort("SECODIGO");
				pagination.setAscDsc("ASC");

				List<Sector> sectors = this.sectorService.findAllLikeSector(
						filterSector, pagination, false);

				if (sectors == null) {
					throw new Exception("No data Found.");
				}
				return sectors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllSectorSeleccion'.
	 * 
	 * @param secodigo_
	 *            String
	 * @param sectorAgrupadoL0codigo_
	 *            String
	 * @param senombre_
	 *            String
	 * @param senoco
	 *            String
	 * @param sedescri
	 *            String
	 * @param secose
	 *            String
	 * @param senoco2
	 *            String
	 * @param seinsel1_
	 *            String
	 * @param senombree
	 *            String
	 * @param senombrei
	 *            String
	 * @param senombref
	 *            String
	 * @param senocoe
	 *            String
	 * @param senocoi
	 *            String
	 * @param senocof
	 *            String
	 * @param sedescrie
	 *            String
	 * @param sedescrii
	 *            String
	 * @param sedescrif
	 *            String
	 * @param secodgrupo
	 *            String
	 * @param senombrea
	 *            String
	 * @param sedescria
	 *            String
	 * @param senocoa
	 *            String
	 * @param idsDescriptores_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/likeSeleccion", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllSectorSeleccion(
			@RequestParam(value = "secodigo", required = false) String secodigo_,
			@RequestParam(value = "sectorAgrupadoL0codigo", required = false) String sectorAgrupadoL0codigo_,
			@RequestParam(value = "senombre", required = false) String senombre_,
			@RequestParam(value = "senoco", required = false) String senoco,
			@RequestParam(value = "sedescri", required = false) String sedescri,
			@RequestParam(value = "secose", required = false) String secose,
			@RequestParam(value = "senoco2", required = false) String senoco2,
			@RequestParam(value = "seinsel1", required = false) String seinsel1_,
			@RequestParam(value = "senombree", required = false) String senombree,
			@RequestParam(value = "senombrei", required = false) String senombrei,
			@RequestParam(value = "senombref", required = false) String senombref,
			@RequestParam(value = "senocoe", required = false) String senocoe,
			@RequestParam(value = "senocoi", required = false) String senocoi,
			@RequestParam(value = "senocof", required = false) String senocof,
			@RequestParam(value = "sedescrie", required = false) String sedescrie,
			@RequestParam(value = "sedescrii", required = false) String sedescrii,
			@RequestParam(value = "sedescrif", required = false) String sedescrif,
			@RequestParam(value = "secodgrupo", required = false) String secodgrupo,
			@RequestParam(value = "senombrea", required = false) String senombrea,
			@RequestParam(value = "sedescria", required = false) String sedescria,
			@RequestParam(value = "senocoa", required = false) String senocoa,
			@RequestParam(value = "idsDescriptores", required = false) String idsDescriptores_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String seinsel1 = ("".equals(seinsel1_)) ? null : seinsel1_;
			String idsDescriptores = ("".equals(idsDescriptores_)) ? null
					: idsDescriptores_;
			String secodigo = ("".equals(secodigo_)) ? null : secodigo_;
			String senombre = ("".equals(senombre_)) ? null : senombre_;
			String sectorAgrupadoL0codigo = ("".equals(sectorAgrupadoL0codigo_)) ? null
					: sectorAgrupadoL0codigo_;
			Sector filterSector = new Sector(secodigo, senombre, senoco,
					sedescri, secose, senoco2, seinsel1, senombree, senombrei,
					senombref, senocoe, senocoi, senocof, sedescrie, sedescrii,
					sedescrif, secodgrupo, senombrea, sedescria, senocoa,
					new SectorAgrupado(sectorAgrupadoL0codigo, null, null,
							null, null));

			List<Descriptor> descriptores = new ArrayList<Descriptor>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();// NOPMD 2012/02/29 (IDA)
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}
			filterSector.setDescriptores(descriptores);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Sector> sectors = this.sectorService
						.findAllLikeSectorSeleccion(filterSector, pagination,
								false);

				if (sectors == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.sectorService
						.findAllLikeSectorSeleccionCount(filterSector, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(sectors);
				return data;
			} else {
				pagination = new Pagination();
				pagination.setSort("SECODIGO");
				pagination.setAscDsc("ASC");

				List<Sector> sectors = this.sectorService
						.findAllLikeSectorSeleccion(filterSector, pagination,
								false);

				if (sectors == null) {
					throw new Exception("No data Found.");
				}
				return sectors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sector
	 *            Sector
	 * @param response
	 *            HttpServletResponse
	 * @return Sector
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Sector edit(@RequestBody Sector sector, HttpServletResponse response) {
		try {
			Sector sectorAux = this.sectorService.update(sector);
			logger.info("Entity correctly inserted!");
			return sectorAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sector
	 *            Sector
	 * @param response
	 *            HttpServletResponse
	 * @return Sector
	 */
	@RequestMapping(value = "/updateSector", method = RequestMethod.PUT)
	public @ResponseBody
	Sector editSector(@RequestBody Sector sector, HttpServletResponse response) {
		try {
			Sector sectorAux = this.sectorService.updateSector(sector);
			logger.info("Entity correctly inserted!");
			return sectorAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Sector add(@RequestBody Sector sector) {
		try {
			Sector sectorAux = this.sectorService.add(sector);
			logger.info("Entity correctly inserted!");
			return sectorAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	@RequestMapping(value = "/addSector", method = RequestMethod.POST)
	public @ResponseBody
	Sector addSector(@RequestBody Sector sector) {
		try {
			Sector sectorAux = this.sectorService.addSector(sector);
			logger.info("Entity correctly inserted!");
			return sectorAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param secodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{secodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String secodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Sector sector = new Sector();
			sector.setSecodigo(secodigo);
			this.sectorService.remove(sector);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + secodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param secodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeSector/{secodigo}", method = RequestMethod.DELETE)
	public void removeSector(@PathVariable String secodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Sector sector = new Sector();
			sector.setSecodigo(secodigo);
			this.sectorService.removeSector(sector);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + secodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sectorIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> sectorIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Sector> sectorList = new ArrayList<Sector>();
		try {
			for (ArrayList<String> sectorId : sectorIds) {
				Iterator<String> iterator = sectorId.iterator();
				Sector sector = new Sector();
				sector.setSecodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				sectorList.add(sector);
			}
			this.sectorService.removeMultiple(sectorList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Loading entity group tree
	 * 
	 * @param response
	 *            Response
	 * @param request
	 *            Request
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "/sectorestree", method = RequestMethod.GET)
	public void getCategoriasTree(HttpServletRequest request,
			HttpServletResponse response) throws IOException {

		response.setCharacterEncoding("ISO-8859-1");
		response.setHeader("Cache-Control", "no-cache");
		response.setContentType("text/html;charset=utf-8");

		String mostrarHabituales = "";
		String secodigo_ = "";
		String senombre_ = "";
		String sectorAgrupadoL0codigo_ = "";
		String idsDescriptores_ = "";
		Enumeration e = request.getParameterNames();
		while (e.hasMoreElements()) {
			String param = e.nextElement().toString();

			if (param.equals("mostrarHabituales")) {
				mostrarHabituales = request.getParameter(param);
			}
			if (param.equals("secodigo")) {
				secodigo_ = request.getParameter(param);
			}
			if (param.equals("senombre")) {
				senombre_ = request.getParameter(param);
			}
			if (param.equals("sectorAgrupadoL0codigo")) {
				sectorAgrupadoL0codigo_ = request.getParameter(param);
			}
			if (param.equals("idsDescriptores")) {
				idsDescriptores_ = request.getParameter(param);
			}
		}
		String seinsel1 = null;

		if (mostrarHabituales.equals("true")) {
			seinsel1 = Y41bConstantes.HABITUALES;
		}

		String idsDescriptores = ("".equals(idsDescriptores_)) ? null
				: idsDescriptores_;
		String secodigo = ("".equals(secodigo_)) ? null : secodigo_;
		String senombre = null;
		String senombree = null;
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
			senombre = ("".equals(senombre_)) ? null : senombre_;
		} else {
			senombree = ("".equals(senombre_)) ? null : senombre_;
		}

		String sectorAgrupadoL0codigo = ("".equals(sectorAgrupadoL0codigo_)) ? null
				: sectorAgrupadoL0codigo_;

		Sector filterSector = new Sector(secodigo, senombre, null, null, null,
				null, seinsel1, senombree, null, null, null, null, null, null,
				null, null, null, null, null, null, new SectorAgrupado(
						sectorAgrupadoL0codigo, null, null, null, null));

		List<Descriptor> descriptores = new ArrayList<Descriptor>();
		// Generar el listado listado de etiquetas (comun)
		if (null != idsDescriptores && !"".equals(idsDescriptores)) {
			Descriptor descriptor = null;
			for (String id : idsDescriptores.split(",")) {
				descriptor = new Descriptor();// NOPMD 2012/02/29 (IDA)
				descriptor.setIdDescriptor(id);
				descriptores.add(descriptor);
			}
		}
		filterSector.setDescriptores(descriptores);

		Pagination pagination = new Pagination();
		pagination.setSort("SECODIGO");
		pagination.setAscDsc("ASC");

		Y41bArbolSectores arbolSectores = this.arbolSectoresService
				.obtenerArbol(filterSector, pagination);

		String json = Y41bSectoresTree.obtieneJsonArbol(arbolSectores);

		json = json.replaceAll("", "A").replaceAll("", "E")
				.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U");

		PrintWriter out = response.getWriter();
		out.println(json);
		out.flush();
		out.close();
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getSectorService'.
	 * 
	 * @return SectorService
	 */
	protected SectorService getSectorService() {
		return this.sectorService;
	}

	/**
	 * Method 'setSectorService'.
	 * 
	 * @param sectorService
	 *            SectorService
	 * @return
	 */
	public void setSectorService(SectorService sectorService) {
		this.sectorService = sectorService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
