package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.SectorAgrupado;
import com.ejie.y41b.service.SectorAgrupadoService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SectorAgrupadoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/sectoragrupado")
public class SectorAgrupadoController {

	private static final Logger logger = LoggerFactory
			.getLogger(SectorAgrupadoController.class);

	@Autowired
	private SectorAgrupadoService sectorAgrupadoService;
	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SectorAgrupadoController.logger.info("[GET - View] : sectoragrupado");
		return "sectoresAgrupados";
	}

	/**
	 * Method 'getCreateFormAltaSectorAgrupado'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaSectorAgrupado", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaReclamacion(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codSectorAgrupado", Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoSectorAgrupado", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleSectoresAgrupados", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "sectoresAgrupados", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("sectoresAgrupados", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModSectoresAgrupados'.
	 * 
	 * @param codSectorAgrupado
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modSectorAgrupado/{codSectorAgrupado}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModSectoresAgrupados(
			@PathVariable String codSectorAgrupado, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codSectorAgrupado", codSectorAgrupado);

		model.addAttribute("modoSectorAgrupado",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		SectorAgrupado sectorAgrupado = new SectorAgrupado();
		sectorAgrupado.setL0codigo(codSectorAgrupado);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleSectoresAgrupados", "model", model);
		}
	}

	/**
	 * Method 'getAllSectorAgrupado'. de tipo like
	 * 
	 * @param l0codigo_
	 *            String
	 * @param l0nombre_
	 *            String
	 * @param l0nombree_
	 *            String
	 * @param l0nombrei_
	 *            String
	 * @param l0nombref_
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllSectoresAgrupados(
			@RequestParam(value = "l0codigo", required = false) String l0codigo_,
			@RequestParam(value = "l0nombre", required = false) String l0nombre_,
			@RequestParam(value = "l0nombree", required = false) String l0nombree_,
			@RequestParam(value = "l0nombrei", required = false) String l0nombrei_,
			@RequestParam(value = "l0nombref", required = false) String l0nombref_,

			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String l0codigo = ("".equals(l0codigo_)) ? null : l0codigo_;
			String l0nombre = null;
			String l0nombree = null;
			String l0nombrei = null;
			String l0nombref = null;

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				l0nombre = ("".equals(l0nombre_)) ? null : l0nombre_;
			} else {
				l0nombree = ("".equals(l0nombre_)) ? null : l0nombre_;
			}

			SectorAgrupado filterSectorAgrupado = new SectorAgrupado(l0codigo,
					l0nombre, l0nombree, l0nombrei, l0nombref);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<SectorAgrupado> sectoresAgrupados = this.sectorAgrupadoService
						.findAllLike(filterSectorAgrupado, pagination, false);

				if (sectoresAgrupados == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.sectorAgrupadoService.findAllLikeCount(
						filterSectorAgrupado, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(sectoresAgrupados);
				return data;
			} else {
				List<SectorAgrupado> sectoresAgrupados = this.sectorAgrupadoService
						.findAllLike(filterSectorAgrupado, pagination, false);
				if (sectoresAgrupados == null) {
					throw new Exception("No data Found.");
				}
				return sectoresAgrupados;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param l0codigo
	 *            String
	 * @return sectorAgrupado SectorAgrupado
	 */
	@RequestMapping(value = "/{l0codigo}", method = RequestMethod.GET)
	public @ResponseBody
	SectorAgrupado getById(@PathVariable String l0codigo) {
		SectorAgrupado sectorAgrupado = new SectorAgrupado();
		sectorAgrupado.setL0codigo(l0codigo);
		sectorAgrupado = this.sectorAgrupadoService.find(sectorAgrupado);
		SectorAgrupadoController.logger
				.info("[GET - findBy_PK] : Obtener SectorAgrupado por PK");
		return sectorAgrupado;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSectorAgrupado
	 *            SectorAgrupado
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<SectorAgrupado> getAll(
			@ModelAttribute SectorAgrupado filterSectorAgrupado) {
		SectorAgrupadoController.logger
				.info("[GET - find_ALL] : Obtener SectorAgrupado por filtro");
		return this.sectorAgrupadoService.findAll(filterSectorAgrupado, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sectorAgrupado
	 *            SectorAgrupado
	 * @return SectorAgrupado
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	SectorAgrupado edit(@RequestBody SectorAgrupado sectorAgrupado) {
		try {
			SectorAgrupado sectorAgrupadoAux = this.sectorAgrupadoService
					.update(sectorAgrupado);
			SectorAgrupadoController.logger
					.info("[PUT] : SectorAgrupado actualizado correctamente");
			return sectorAgrupadoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sectorAgrupado
	 *            SectorAgrupado
	 * @return SectorAgrupado
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	SectorAgrupado add(@RequestBody SectorAgrupado sectorAgrupado) {
		try {
			SectorAgrupado sectorAgrupadoAux = this.sectorAgrupadoService
					.add(sectorAgrupado);
			SectorAgrupadoController.logger
					.info("[POST] : SectorAgrupado insertado correctamente");
			return sectorAgrupadoAux;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param l0codigo
	 *            String
	 * @return sectorAgrupado
	 */
	@RequestMapping(value = "/{l0codigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	SectorAgrupado remove(@PathVariable String l0codigo) {
		SectorAgrupado sectorAgrupado = new SectorAgrupado();
		sectorAgrupado.setL0codigo(l0codigo);
		this.sectorAgrupadoService.remove(sectorAgrupado);
		SectorAgrupadoController.logger
				.info("[DELETE] : SectorAgrupado borrado correctamente");
		return sectorAgrupado;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sectorAgrupadoIds
	 *            List
	 * @return sectorAgrupadoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> sectorAgrupadoIds) {
		List<SectorAgrupado> sectorAgrupadoList = new ArrayList<SectorAgrupado>();
		for (List<String> sectorAgrupadoId : sectorAgrupadoIds) {
			Iterator<String> iterator = sectorAgrupadoId.iterator();
			SectorAgrupado sectorAgrupado = new SectorAgrupado(); // NOPMD -
																	// Objeto
																	// nuevo en
																	// la lista
																	// (parametro
																	// del
																	// servicio)
			sectorAgrupado.setL0codigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sectorAgrupadoList.add(sectorAgrupado);
		}
		this.sectorAgrupadoService.removeMultiple(sectorAgrupadoList);
		SectorAgrupadoController.logger
				.info("[POST - DELETE_ALL] : SectorAgrupado borrados correctamente");
		return sectorAgrupadoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSectorAgrupado
	 *            SectorAgrupado
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute SectorAgrupado filterSectorAgrupado,
			@ModelAttribute Pagination pagination) {
		List<SectorAgrupado> sectorAgrupados = this.sectorAgrupadoService
				.findAll(filterSectorAgrupado, pagination);
		Long recordNum = this.sectorAgrupadoService
				.findAllCount(filterSectorAgrupado);
		SectorAgrupadoController.logger
				.info("[GET - jqGrid] : Obtener SectorAgrupado");
		return new JQGridJSONModel(pagination, recordNum, sectorAgrupados);
	}

}
