package com.ejie.y41b.control;

import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Secretar;
import com.ejie.y41b.service.SecretarService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SecretarController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/secretar")
public class SecretarController {

	private static final Logger logger = LoggerFactory
			.getLogger(SecretarController.class);

	@Autowired
	private SecretarService secretarService;
	@Autowired()
	private Properties appConfiguration;
	@Autowired()
	private CensoMonitorDao censoMonitorDao;
	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| (censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO) && censoMonitor
						.getPerfilArbitraje().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO))) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("secretar", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model) {
		SecretarController.logger.info("[GET - View] : arbitro");
		String srcodigo = Y41bUIDGenerator.getInstance().generateId(
				Y41bConstantes.PK_SIZE);
		model.addAttribute("srcodigo", srcodigo);
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_ALTA);
		return new ModelAndView("secretarDetalle", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param srcodigo
	 *            String
	 * @return secretar Secretar
	 */
	@RequestMapping(value = "/{srcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Secretar getById(@PathVariable String srcodigo) {
		Secretar secretar = new Secretar();
		secretar.setSrcodigo(srcodigo);
		secretar = this.secretarService.find(secretar);
		SecretarController.logger
				.info("[GET - findBy_PK] : Obtener Secretar por PK");
		return secretar;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSecretar
	 *            Secretar
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Secretar> getAll(@ModelAttribute Secretar filterSecretar) {
		SecretarController.logger
				.info("[GET - find_ALL] : Obtener Secretar por filtro");
		return this.secretarService.findAll(filterSecretar, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return Secretar
	 * @throws ParseException
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Secretar edit(@RequestBody Secretar secretar, HttpServletRequest request)
			throws ParseException {
		Secretar secretarBD = this.secretarService.find(secretar);
		secretarBD.setSrnombre(secretar.getSrnombre());
		secretarBD.setSrnif(secretar.getSrnif());
		secretarBD.setSrnrtel(secretar.getSrnrtel());
		secretarBD.setSrnrtel2(secretar.getSrnrtel2());
		secretarBD.setSrnrfax(secretar.getSrnrfax());
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		secretarBD.setSrcozs(censoMonitor.getMocodigo());
		secretarBD.setSrfemod(Y41bUtils.formatearDateToString(new Date(),
				Y41bConstantes.FORMATO_FECHA_ES));
		secretarBD.setSrfeba(secretar.getSrfeba());
		secretarBD.setSrteobs(secretar.getSrteobs());
		secretarBD.setSrcota1(secretar.getSrcota1());
		Secretar secretarAux = this.secretarService.update(secretarBD);
		SecretarController.logger
				.info("[PUT] : Secretar actualizado correctamente");
		return secretarAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return Secretar
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Secretar add(@RequestBody Secretar secretar, HttpServletRequest request)
			throws ParseException {
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		secretar.setSrcozs(censoMonitor.getMocodigo());
		secretar.setSrfemod(Y41bUtils.formatearDateToString(new Date(),
				Y41bConstantes.FORMATO_FECHA_ES));
		Secretar secretarAux = this.secretarService.add(secretar);
		SecretarController.logger
				.info("[POST] : Secretar insertado correctamente");
		return secretarAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param srcodigo
	 *            String
	 * @return secretar
	 */
	@RequestMapping(value = "/{srcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Secretar remove(@PathVariable String srcodigo) {
		Secretar secretar = new Secretar();
		secretar.setSrcodigo(srcodigo);
		this.secretarService.remove(secretar);
		SecretarController.logger
				.info("[DELETE] : Secretar borrado correctamente");
		return secretar;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param secretarIds
	 *            List
	 * @return secretarList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> secretarIds) {
		List<Secretar> secretarList = new ArrayList<Secretar>();
		for (List<String> secretarId : secretarIds) {
			Iterator<String> iterator = secretarId.iterator();
			Secretar secretar = new Secretar(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			secretar.setSrcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			secretarList.add(secretar);
		}
		this.secretarService.removeMultiple(secretarList);
		SecretarController.logger
				.info("[POST - DELETE_ALL] : Secretar borrados correctamente");
		return secretarIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSecretar
	 *            Secretar
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Secretar filterSecretar,
			@ModelAttribute Pagination pagination) {
		List<Secretar> secretars = this.secretarService.findAll(filterSecretar,
				pagination);
		Long recordNum = this.secretarService.findAllCount(filterSecretar);
		SecretarController.logger.info("[GET - jqGrid] : Obtener Secretar");
		return new JQGridJSONModel(pagination, recordNum, secretars);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param pecodigo
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/detalle/{srcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalle(@PathVariable() String srcodigo,
			Model model) {
		SecretarController.logger.info("[GET - View] : Empper");
		model.addAttribute("srcodigo", srcodigo);
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_MODIFICACION);
		return new ModelAndView("secretarDetalle", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "seleccionSecretarios", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model,
			HttpServletRequest request) throws Exception {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaSecretario",
				Y41bConstantes.MODO_POPUP_SELECCION);

		StringBuffer cadenaJSON = new StringBuffer("'{");
		// Se ha pedido que no se filtro los secretarios por territorio por
		// defecto
		// String sacodigo = request.getParameter("sacodigo");
		// if (!Y41bUtils.esNullOCadenaVacia(sacodigo)) {
		// Solarb solarb = new Solarb();
		// solarb.setSacodigo(new String(Y41bUtilsDokusi.decode(sacodigo)));
		// solarb = this.solarbService.find(solarb);
		// Arbinterv arbinterv = new Arbinterv();
		// arbinterv.setSolarb(solarb);
		// List<Arbinterv> larbinterv = this.arbintervService.findAll(
		// arbinterv, null);
		// for (int i = 0; i < larbinterv.size(); i++) {
		// arbinterv = larbinterv.get(i);
		// if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE
		// .equals(arbinterv.getUatipointerv())) {
		// cadenaJSON.append("\\\"th\\\":\\\"")
		// .append(arbinterv.getUaprovId()).append("\\\",");
		// }
		// }
		// }
		cadenaJSON.append("\\\"baja\\\":\\\"N\\\"}'");

		model.addAttribute("filtroSecretario", cadenaJSON);
		return new ModelAndView("secretarioSeleccion", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param srcodigo
	 *            String
	 * @return secretar Secretar
	 */
	@RequestMapping(value = "/responsableExpediente/{mocodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Secretar getByIdResponsableExpediente(@PathVariable String mocodigo) {
		CensoMonitor monitor = new CensoMonitor();
		monitor.setMocodigo(mocodigo);
		monitor = this.censoMonitorDao.find(monitor);

		Secretar secretar = new Secretar();
		secretar.setSrnif(monitor.getModni());
		secretar.setBaja(Y41bConstantes.VALOR_NO);
		List<Secretar> lsecretar = this.secretarService.findAll(secretar, null);
		if (lsecretar != null && lsecretar.size() > 0) {
			secretar = lsecretar.get(0);
		}
		SecretarController.logger
				.info("[GET - findBy_PK] : Obtener Secretar por PK");
		return secretar;
	}

	/**
	 * Method 'getAllExcel'.
	 * 
	 * @param filterArbitro
	 *            Arbitro
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllExcel(@ModelAttribute() Secretar filterSecretar,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");
			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_ARBITRO + fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService
					.getSecretarExcel(filterSecretar);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
