package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
//import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SantramexpController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/santramexp")
public class SantramexpController {

	private static final Logger logger = LoggerFactory.getLogger(SantramexpController.class);

	@Autowired()
	private SantramexpService santramexpService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;
		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			// throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SantramexpController.logger.info("[GET - View] : santramexp");
		return "santramexp";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param trid
	 *            BigDecimal
	 * @return santramexp Santramexp
	 */
	@RequestMapping(value = "/{trid}", method = RequestMethod.GET)
	public @ResponseBody() Santramexp getById(@PathVariable() String trid) {
		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(trid);
		santramexp = this.santramexpService.find(santramexp);
		// trtexto se deja a null para evitar error parseo
		if (santramexp != null) {
			santramexp.setTrtexto(null);
			santramexp.setTrobserves(null);
			santramexp.setTrdocreqeus(null);
			santramexp.setTrresumenalegaciones(null);
		}
		SantramexpController.logger.info("[GET - findBy_PK] : Obtener Santramexp por PK");
		return santramexp;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSantramexp
	 *            Santramexp
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody() List<Santramexp> getAll(@ModelAttribute() Santramexp filterSantramexp) {
		SantramexpController.logger.info("[GET - find_ALL] : Obtener Santramexp por filtro");
		return this.santramexpService.findAll(filterSantramexp, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() Santramexp edit(@RequestBody() Santramexp santramexp) {
		Santramexp santramexpAux = this.santramexpService.update(santramexp);
		SantramexpController.logger.info("[PUT] : Santramexp actualizado correctamente");
		return santramexpAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() Santramexp add(@RequestBody() Santramexp santramexp) {
		Santramexp santramexpAux = this.santramexpService.add(santramexp);
		SantramexpController.logger.info("[POST] : Santramexp insertado correctamente");
		return santramexpAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param trid
	 *            BigDecimal
	 * @return santramexp
	 */
	@RequestMapping(value = "/{trid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() Santramexp remove(@PathVariable() String trid) {
		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(trid);
		this.santramexpService.remove(santramexp);
		SantramexpController.logger.info("[DELETE] : Santramexp borrado correctamente");
		return santramexp;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param santramexpIds
	 *            List
	 * @return santramexpList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() List<List<String>> removeMultiple(@RequestBody() List<List<String>> santramexpIds) {
		List<Santramexp> santramexpList = new ArrayList<Santramexp>();
		for (List<String> santramexpId : santramexpIds) {
			Iterator<String> iterator = santramexpId.iterator();
			Santramexp santramexp = new Santramexp(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			santramexp.setTrid(ObjectConversionManager.convert(iterator.next(), String.class));
			santramexpList.add(santramexp);
		}
		this.santramexpService.removeMultiple(santramexpList);
		SantramexpController.logger.info("[POST - DELETE_ALL] : Santramexp borrados correctamente");
		return santramexpIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSantramexp
	 *            Santramexp
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGrid(@ModelAttribute() Santramexp filterSantramexp,
			@ModelAttribute() Pagination pagination) {
		List<Santramexp> santramexps = this.santramexpService.findAll(filterSantramexp, pagination);
		Long recordNum = this.santramexpService.findAllCount(filterSantramexp);
		SantramexpController.logger.info("[GET - jqGrid] : Obtener Santramexp");
		return new JQGridJSONModel(pagination, recordNum, santramexps);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param excodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/dameTramitesExp", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGrid(
			@RequestParam(value = "excodigo", required = false) String excodigo,
			@ModelAttribute() Pagination pagination) {

		Santramexp filterSantramexp = new Santramexp();
		Expedien expedien = new Expedien();
		expedien.setExcodigo(excodigo);
		filterSantramexp.setExpedien(expedien);

		List<Santramexp> santramexps = this.santramexpService.findAll(filterSantramexp, pagination);
		Long recordNum = this.santramexpService.findAllCount(filterSantramexp);
		SantramexpController.logger.info("[GET - jqGrid] : Obtener Santramexp");
		return new JQGridJSONModel(pagination, recordNum, santramexps);
	}

	/**
	 * Method 'borraTramite'.
	 * 
	 * @param trid
	 *            BigDecimal
	 */
	@RequestMapping(value = "/eliminarTramite/{trid}", method = RequestMethod.POST)
	public @ResponseBody() void borraTramite(@PathVariable() String trid) {
		try {
			Santramexp santramexp = new Santramexp();
			santramexp.setTrid(trid);
			this.santramexpService.remove(santramexp);
			SantramexpController.logger.info("[DELETE] : Santramexp borrado correctamente");
			// return santramexp;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("sanciones.error.eliminacionTramites.Dependencias", true, null);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param excodigo
	 *            String
	 * @return sanexp Sanexp
	 */
	@RequestMapping(value = "/dameFaseUltimoTramiteEnCurso/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody() Santramexp getFaseYUltimoTramite(@PathVariable() String excodigo) {
		Santramexp santramexp = new Santramexp();
		try {

			santramexp = this.santramexpService.dameUltimoTramiteEnCurso(excodigo);
			SantramexpController.logger.info("[GET - dameFaseUltimoTramiteEnCurso] : ");
			return santramexp;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true, e);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param excodigo
	 *            String
	 * @param tipoTramite
	 *            String
	 * @param estado
	 *            String
	 * @return Santramexp
	 */
	@RequestMapping(value = "/dameTramiteTipoEstado/{excodigo}/{tipoTramite}/{estado}", method = RequestMethod.GET)
	public @ResponseBody() Santramexp getTramitePorTipo(@PathVariable() String excodigo,
			@PathVariable() String tipoTramite, @PathVariable() String estado) {
		Santramexp santramexp = new Santramexp();
		try {
			santramexp.setExpedien(new Expedien(excodigo));
			santramexp.setTrcodigo(tipoTramite);
			santramexp.setTrestado(estado);
			Pagination paginacion = new Pagination();
			paginacion.setSord("DESC");
			paginacion.setSort("TRFECFIN");
			List<Santramexp> listaTramites = this.santramexpService.findAll(santramexp, paginacion);
			if (listaTramites != null && listaTramites.size() > 0) {
				return listaTramites.get(0);
			} else {
				return new Santramexp();
			}
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true, e);
		}
	}

	/**
	 * Method 'reabrirExpediente'.
	 * 
	 * @param excodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/reabrirExpediente/{excodigo}", method = RequestMethod.POST)
	public @ResponseBody() void reabrirExpediente(@PathVariable() String excodigo, HttpServletRequest request) {
		try {
			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			this.santramexpService.reabrirExpediente(excodigo, censoMonitor);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramitePropuestaTramitado'.
	 * 
	 * @param excodigo
	 *            String
	 * @return Santramexp
	 */
	@RequestMapping(value = "/dameTramitePropuesta/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody() Santramexp getTramitePropuestaTramitado(@PathVariable() String excodigo) {
		Santramexp santramexp = new Santramexp();
		try {
			santramexp.setExpedien(new Expedien(excodigo));
			santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION);
			Pagination paginacion = new Pagination();
			paginacion.setSord("DESC");
			paginacion.setSort("TRFECFIN");
			List<Santramexp> listaTramites = this.santramexpService.findAll(santramexp, paginacion);
			if (listaTramites != null && listaTramites.size() > 0) {
				return listaTramites.get(0);
			} else {
				return null;
			}
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true, e);
		}
	}
}
