package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.SantipsanaccService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import org.springframework.context.i18n.LocaleContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Santipsanacc;

/**
 * SantipsanaccController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/santipsanacc")
public class SantipsanaccController {

	private static final Logger logger = LoggerFactory
			.getLogger(SantipsanaccController.class);

	@Autowired()
	private SantipsanaccService santipsanaccService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SantipsanaccController.logger.info("[GET - View] : santipsanacc");
		return "santipsanacc";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param taid
	 *            Long
	 * @return santipsanacc Santipsanacc
	 */
	@RequestMapping(value = "/{taid}", method = RequestMethod.GET)
	public @ResponseBody()
	Santipsanacc getById(@PathVariable() Long taid) {
		Santipsanacc santipsanacc = new Santipsanacc();
		santipsanacc.setTaid(taid);
		santipsanacc = this.santipsanaccService.find(santipsanacc);
		SantipsanaccController.logger
				.info("[GET - findBy_PK] : Obtener Santipsanacc por PK");
		return santipsanacc;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSantipsanacc
	 *            Santipsanacc
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Santipsanacc> getAll(@ModelAttribute() Santipsanacc filterSantipsanacc) {
		SantipsanaccController.logger
				.info("[GET - find_ALL] : Obtener Santipsanacc por filtro");
		return this.santipsanaccService.findAll(filterSantipsanacc, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @return Santipsanacc
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Santipsanacc edit(@RequestBody() Santipsanacc santipsanacc) {
		Santipsanacc santipsanaccAux = this.santipsanaccService
				.update(santipsanacc);
		SantipsanaccController.logger
				.info("[PUT] : Santipsanacc actualizado correctamente");
		return santipsanaccAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @return Santipsanacc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Santipsanacc add(@RequestBody() Santipsanacc santipsanacc) {
		Santipsanacc santipsanaccAux = this.santipsanaccService
				.add(santipsanacc);
		SantipsanaccController.logger
				.info("[POST] : Santipsanacc insertado correctamente");
		return santipsanaccAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param taid
	 *            Long
	 * @return santipsanacc
	 */
	@RequestMapping(value = "/{taid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Santipsanacc remove(@PathVariable() Long taid) {
		Santipsanacc santipsanacc = new Santipsanacc();
		santipsanacc.setTaid(taid);
		this.santipsanaccService.remove(santipsanacc);
		SantipsanaccController.logger
				.info("[DELETE] : Santipsanacc borrado correctamente");
		return santipsanacc;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param santipsanaccIds
	 *            List
	 * @return santipsanaccList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> santipsanaccIds) {
		List<Santipsanacc> santipsanaccList = new ArrayList<Santipsanacc>();
		for (List<String> santipsanaccId : santipsanaccIds) {
			Iterator<String> iterator = santipsanaccId.iterator();
			Santipsanacc santipsanacc = new Santipsanacc(); // NOPMD - Objeto
															// nuevo en la lista
															// (parametro del
															// servicio)
			santipsanacc.setTaid(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			santipsanaccList.add(santipsanacc);
		}
		this.santipsanaccService.removeMultiple(santipsanaccList);
		SantipsanaccController.logger
				.info("[POST - DELETE_ALL] : Santipsanacc borrados correctamente");
		return santipsanaccIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSantipsanacc
	 *            Santipsanacc
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Santipsanacc filterSantipsanacc,
			@ModelAttribute() Pagination pagination) {
		List<Santipsanacc> santipsanaccs = this.santipsanaccService.findAll(
				filterSantipsanacc, pagination);
		Long recordNum = this.santipsanaccService
				.findAllCount(filterSantipsanacc);
		SantipsanaccController.logger
				.info("[GET - jqGrid] : Obtener Santipsanacc");
		return new JQGridJSONModel(pagination, recordNum, santipsanaccs);
	}

	/**
	 * Method 'getComboIntervinientes'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/comboTiposSancion", method = RequestMethod.GET)
	public @ResponseBody()
	List<Santipsanacc> getComboIntervinientes(HttpServletRequest request) {

		SantipsanaccController.logger
				.info("[GET - find_ALL] : Obtener combo Tipos Resultado del Expediente");
		Santipsanacc filterSaninterv = new Santipsanacc();
		/*
		 * desde la ficha de expedientes
		 */
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("tadesces");
		} else {
			pagination.setSort("tadesceu");
		}
		pagination.setAscDsc("ASC");

		return this.santipsanaccService.findAll(filterSaninterv, pagination);
	}
}
