package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.SantipresulService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Santipresul;

/**
 * SantipresulController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/santipresul")
public class SantipresulController {

	private static final Logger logger = LoggerFactory
			.getLogger(SantipresulController.class);

	@Autowired()
	private SantipresulService santipresulService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SantipresulController.logger.info("[GET - View] : santipresul");
		return "santipresul";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param trid
	 *            Long
	 * @return santipresul Santipresul
	 */
	@RequestMapping(value = "/{trid}", method = RequestMethod.GET)
	public @ResponseBody()
	Santipresul getById(@PathVariable() Long trid) {
		Santipresul santipresul = new Santipresul();
		santipresul.setTrid(trid);
		santipresul = this.santipresulService.find(santipresul);
		SantipresulController.logger
				.info("[GET - findBy_PK] : Obtener Santipresul por PK");
		return santipresul;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSantipresul
	 *            Santipresul
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Santipresul> getAll(@ModelAttribute() Santipresul filterSantipresul) {
		SantipresulController.logger
				.info("[GET - find_ALL] : Obtener Santipresul por filtro");
		return this.santipresulService.findAll(filterSantipresul, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @return Santipresul
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Santipresul edit(@RequestBody() Santipresul santipresul) {
		Santipresul santipresulAux = this.santipresulService
				.update(santipresul);
		SantipresulController.logger
				.info("[PUT] : Santipresul actualizado correctamente");
		return santipresulAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @return Santipresul
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Santipresul add(@RequestBody() Santipresul santipresul) {
		Santipresul santipresulAux = this.santipresulService.add(santipresul);
		SantipresulController.logger
				.info("[POST] : Santipresul insertado correctamente");
		return santipresulAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param trid
	 *            Long
	 * @return santipresul
	 */
	@RequestMapping(value = "/{trid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Santipresul remove(@PathVariable() Long trid) {
		Santipresul santipresul = new Santipresul();
		santipresul.setTrid(trid);
		this.santipresulService.remove(santipresul);
		SantipresulController.logger
				.info("[DELETE] : Santipresul borrado correctamente");
		return santipresul;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param santipresulIds
	 *            List
	 * @return santipresulList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> santipresulIds) {
		List<Santipresul> santipresulList = new ArrayList<Santipresul>();
		for (List<String> santipresulId : santipresulIds) {
			Iterator<String> iterator = santipresulId.iterator();
			Santipresul santipresul = new Santipresul(); // NOPMD - Objeto nuevo
															// en la lista
															// (parametro del
															// servicio)
			santipresul.setTrid(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			santipresulList.add(santipresul);
		}
		this.santipresulService.removeMultiple(santipresulList);
		SantipresulController.logger
				.info("[POST - DELETE_ALL] : Santipresul borrados correctamente");
		return santipresulIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSantipresul
	 *            Santipresul
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Santipresul filterSantipresul,
			@ModelAttribute() Pagination pagination) {
		List<Santipresul> santipresuls = this.santipresulService.findAll(
				filterSantipresul, pagination);
		Long recordNum = this.santipresulService
				.findAllCount(filterSantipresul);
		SantipresulController.logger
				.info("[GET - jqGrid] : Obtener Santipresul");
		return new JQGridJSONModel(pagination, recordNum, santipresuls);
	}

	/**
	 * Method 'getComboIntervinientes'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/comboTiposResultado", method = RequestMethod.GET)
	public @ResponseBody()
	List<Santipresul> getComboIntervinientes(HttpServletRequest request) {

		SantipresulController.logger
				.info("[GET - find_ALL] : Obtener combo Tipos Resultado del Expediente");
		Santipresul filterSaninterv = new Santipresul();
		/*
		 * desde la ficha de expedientes
		 */
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("trdesces");
		} else {
			pagination.setSort("trdesceu");
		}
		pagination.setAscDsc("ASC");

		return this.santipresulService.findAll(filterSaninterv, pagination);
	}
}
