package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Santipinffrec;
import com.ejie.y41b.service.SantipinffrecService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SantipinffrecController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/santipinffrec")
public class SantipinffrecController {

	private static final Logger logger = LoggerFactory
			.getLogger(SantipinffrecController.class);

	@Autowired()
	private SantipinffrecService santipinffrecService;

	@Autowired()
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SantipinffrecController.logger.info("[GET - View] : santipinffrec");
		return "santipinffrec";
	}

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "infraccionesfrecuentes", method = RequestMethod.GET)
	public ModelAndView getCreateFormInfraccionesFrecuentes(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaInfraccionesFrecuentes", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("infraccionesfrecuentes", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param ifid
	 *            String
	 * @return santipinffrec Santipinffrec
	 */
	@RequestMapping(value = "/{ifid}", method = RequestMethod.GET)
	public @ResponseBody()
	Santipinffrec getById(@PathVariable() String ifid) {
		Santipinffrec santipinffrec = new Santipinffrec();
		santipinffrec.setIfid(ifid);
		santipinffrec = this.santipinffrecService.find(santipinffrec);
		SantipinffrecController.logger
				.info("[GET - findBy_PK] : Obtener Santipinffrec por PK");
		return santipinffrec;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSantipinffrec
	 *            Santipinffrec
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Santipinffrec> getAll(
			@ModelAttribute() Santipinffrec filterSantipinffrec) {
		SantipinffrecController.logger
				.info("[GET - find_ALL] : Obtener Santipinffrec por filtro");
		return this.santipinffrecService.findAll(filterSantipinffrec, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return Santipinffrec
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Santipinffrec edit(@RequestBody() Santipinffrec santipinffrec) {
		Santipinffrec santipinffrecAux = this.santipinffrecService
				.update(santipinffrec);
		SantipinffrecController.logger
				.info("[PUT] : Santipinffrec actualizado correctamente");
		return santipinffrecAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return Santipinffrec
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Santipinffrec add(@RequestBody() Santipinffrec santipinffrec) {
		Santipinffrec santipinffrecAux = this.santipinffrecService
				.add(santipinffrec);
		SantipinffrecController.logger
				.info("[POST] : Santipinffrec insertado correctamente");
		return santipinffrecAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param ifid
	 *            String
	 * @return santipinffrec
	 */
	@RequestMapping(value = "/{ifid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Santipinffrec remove(@PathVariable() String ifid) {
		Santipinffrec santipinffrec = new Santipinffrec();
		santipinffrec.setIfid(ifid);
		this.santipinffrecService.remove(santipinffrec);
		SantipinffrecController.logger
				.info("[DELETE] : Santipinffrec borrado correctamente");
		return santipinffrec;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param santipinffrecIds
	 *            List
	 * @return santipinffrecList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> santipinffrecIds) {
		List<Santipinffrec> santipinffrecList = new ArrayList<Santipinffrec>();
		for (List<String> santipinffrecId : santipinffrecIds) {
			Iterator<String> iterator = santipinffrecId.iterator();
			Santipinffrec santipinffrec = new Santipinffrec(); // NOPMD - Objeto
																// nuevo en la
																// lista
																// (parametro
																// del servicio)
			santipinffrec.setIfid(ObjectConversionManager.convert(
					iterator.next(), String.class));
			santipinffrecList.add(santipinffrec);
		}
		this.santipinffrecService.removeMultiple(santipinffrecList);
		SantipinffrecController.logger
				.info("[POST - DELETE_ALL] : Santipinffrec borrados correctamente");
		return santipinffrecIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSantipinffrec
	 *            Santipinffrec
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Santipinffrec filterSantipinffrec,
			@ModelAttribute() Pagination pagination) {
		List<Santipinffrec> santipinffrecs = this.santipinffrecService.findAll(
				filterSantipinffrec, pagination);
		Long recordNum = this.santipinffrecService
				.findAllCount(filterSantipinffrec);
		SantipinffrecController.logger
				.info("[GET - jqGrid] : Obtener Santipinffrec");
		return new JQGridJSONModel(pagination, recordNum, santipinffrecs);
	}

	/**
	 * Method 'getAllLikeInfraccion'
	 * 
	 * @param ifid_
	 *            String
	 * @param ifdesces_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllLikeInfraccion(
			@RequestParam(value = "ifid", required = false) String ifid_,
			@RequestParam(value = "ifdesces", required = false) String ifdesces_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String ifid = ("".equals(ifid_)) ? null : ifid_;

			String ifdesces = null;
			String ifdesceu = null;

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				ifdesces = ("".equals(ifdesces_)) ? null : ifdesces_;
			} else {
				ifdesceu = ("".equals(ifdesces_)) ? null : ifdesces_;
			}

			Santipinffrec filterSantipinffrec = new Santipinffrec();
			filterSantipinffrec.setIfid(ifid);
			filterSantipinffrec.setIfdesces(ifdesces);
			filterSantipinffrec.setIfdesceu(ifdesceu);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Santipinffrec> santipinffrecs = this.santipinffrecService
						.findAllLike(filterSantipinffrec, pagination, false);

				if (santipinffrecs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.santipinffrecService.findAllLikeCount(
						filterSantipinffrec, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(santipinffrecs);
				return data;
			} else {
				List<Santipinffrec> santipinffrecs = this.santipinffrecService
						.findAllLike(filterSantipinffrec, pagination, false);
				if (santipinffrecs == null) {
					throw new Exception("No data Found.");
				}
				return santipinffrecs;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codInfraccionesFrecuentes", Y41bUIDGenerator
				.getInstance().generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoInfraccionesFrecuentes",
				Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleInfraccionesFrecuentes", "model",
					model);
		}
	}

	/**
	 * Method 'getCreateFormModif'.
	 * 
	 * @param ifid
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modificar/{ifid}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModMotivo(@PathVariable() String ifid,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codInfraccionesFrecuentes", ifid);

		model.addAttribute("modoInfraccionesFrecuentes",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Santipinffrec santipinffrec = new Santipinffrec();
		santipinffrec.setIfid(ifid);

		// this.adjuntarprodagrupadoService.addProdAgrupadoTableTemporal(motivo);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleInfraccionesFrecuentes", "model",
					model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param ifid
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findInfFrec/{ifid}", method = RequestMethod.GET)
	public @ResponseBody()
	Santipinffrec getMotivoById(@PathVariable() String ifid) {
		try {
			Santipinffrec santipinffrec = new Santipinffrec();
			santipinffrec.setIfid(ifid);

			santipinffrec = this.santipinffrecService.find(santipinffrec);
			if (santipinffrec == null) {
				throw new Exception(ifid.toString());
			}
			return santipinffrec;
		} catch (Exception e) {
			throw new ResourceNotFoundException(ifid.toString());
		}
	}

	/**
	 * Method 'addSantipinffrec'.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param ifid
	 *            String
	 * @return Santipinffrec
	 */
	@RequestMapping(value = "/addSantipinffrec", method = RequestMethod.POST)
	public @ResponseBody()
	Santipinffrec addSantipinffrec(@RequestBody() Santipinffrec santipinffrec,
			@ModelAttribute(value = "ifid") String ifid) {
		try {
			Santipinffrec santipinffrecAux = this.santipinffrecService
					.add(santipinffrec);
			SantipinffrecController.logger.info("Entity correctly inserted!");
			return santipinffrecAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'updateSantipinffrec'.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param response
	 *            HttpServletResponse
	 * @return Motivo
	 */
	@RequestMapping(value = "/updateSantipinffrec", method = RequestMethod.PUT)
	public @ResponseBody()
	Santipinffrec updateSantipinffrec(
			@RequestBody() Santipinffrec santipinffrec,
			HttpServletResponse response) {
		try {
			Santipinffrec santipinffrecAux = this.santipinffrecService
					.update(santipinffrec);
			SantipinffrecController.logger.info("Entity correctly inserted!");
			return santipinffrecAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeSantipinffrec'.
	 * 
	 * @param ifid
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeSantipinffrec/{ifid}", method = RequestMethod.DELETE)
	public void removeSantipinffrec(@PathVariable() String ifid,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Santipinffrec santipinffrec = new Santipinffrec();
			santipinffrec.setIfid(ifid);
			this.santipinffrecService.remove(santipinffrec);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			SantipinffrecController.logger.error("Unable to delete " + ifid);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * 
	 * @param filter
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/findAllMaterias/{filter}", method = RequestMethod.GET)
	public @ResponseBody()
	Object findAllMaterias(@PathVariable() String filter,
			HttpServletRequest request) {
		try {
			String filterAux = filter.substring(1, filter.length() - 1);
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			Pagination pagination = new Pagination();
			pagination.setPage(Long.valueOf(request.getParameter("page")));
			pagination.setRows(Long.valueOf(request.getParameter("rows")));
			pagination.setSort(request.getParameter("sidx"));
			pagination.setAscDsc(request.getParameter("sord"));

			if (pagination.getSort() != null
					&& pagination.getSort().equals("nombre")) {
				if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					pagination.setSort("ifdesces");
				} else {
					pagination.setSort("ifdesceu");
				}
			}

			Santipinffrec filterSantipinffrec = new Santipinffrec();

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				filterSantipinffrec.setIfdesces(filterAux);
			} else {
				filterSantipinffrec.setIfdesceu(filterAux);
			}

			List<Santipinffrec> tipReqNormativos = this.santipinffrecService
					.findAllMaterias(
							filterSantipinffrec,
							pagination,
							(List<String>) request.getSession().getAttribute(
									"materiasAniadidas"));

			if (tipReqNormativos == null) {
				throw new Exception("No data Found.");
			}

			for (Santipinffrec santipinffrec : tipReqNormativos) {
				santipinffrec.setCodigo(santipinffrec.getIftticodigo());
				if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					santipinffrec.setNombre(santipinffrec.getIfdesces());
				} else {
					santipinffrec.setNombre(santipinffrec.getIfdesceu());
				}

				santipinffrec.setCodaux(santipinffrec.getIfid());
			}

			Long total = this.getAllCountMaterias(filterAux, request);
			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(request.getParameter("page"));
			data.setRecords(total.intValue());
			data.setTotal(total, pagination.getRows());
			data.setRows(tipReqNormativos);
			return data;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * 
	 * @param filter
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/countMaterias", method = RequestMethod.GET)
	public Long getAllCountMaterias(String filter, HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			Santipinffrec filterSantipinffrec = new Santipinffrec();
			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				filterSantipinffrec.setIfdesces(filter);
			} else {
				filterSantipinffrec.setIfdesceu(filter);
			}
			return this.santipinffrecService.findAllMateriasCount(
					filterSantipinffrec, (List<String>) request.getSession()
							.getAttribute("materiasAniadidas"));
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}
}