package com.ejie.y41b.control;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.SantipestimService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Santipestim;

/**
 * SantipestimController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/santipestim")
public class SantipestimController {

	private static final Logger logger = LoggerFactory
			.getLogger(SantipestimController.class);

	@Autowired()
	private SantipestimService santipestimService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SantipestimController.logger.info("[GET - View] : santipestim");
		return "santipestim";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param teid
	 *            String
	 * @return santipestim Santipestim
	 */
	@RequestMapping(value = "/{teid}", method = RequestMethod.GET)
	public @ResponseBody()
	Santipestim getById(@PathVariable() String teid) {
		Santipestim santipestim = new Santipestim();
		santipestim.setTeid(teid);
		santipestim = this.santipestimService.find(santipestim);
		SantipestimController.logger
				.info("[GET - findBy_PK] : Obtener Santipestim por PK");
		return santipestim;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSantipestim
	 *            Santipestim
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Santipestim> getAll(@ModelAttribute() Santipestim filterSantipestim) {
		SantipestimController.logger
				.info("[GET - find_ALL] : Obtener Santipestim por filtro");
		return this.santipestimService.findAll(filterSantipestim, null, false);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Santipestim
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Santipestim edit(@RequestBody() Santipestim santipestim) {
		Santipestim santipestimAux = this.santipestimService
				.update(santipestim);
		SantipestimController.logger
				.info("[PUT] : Santipestim actualizado correctamente");
		return santipestimAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Santipestim
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Santipestim add(@RequestBody() Santipestim santipestim) {
		Santipestim santipestimAux = this.santipestimService.add(santipestim);
		SantipestimController.logger
				.info("[POST] : Santipestim insertado correctamente");
		return santipestimAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param teid
	 *            String
	 * @return santipestim
	 */
	@RequestMapping(value = "/{teid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Santipestim remove(@PathVariable() String teid) {
		Santipestim santipestim = new Santipestim();
		santipestim.setTeid(teid);
		this.santipestimService.remove(santipestim);
		SantipestimController.logger
				.info("[DELETE] : Santipestim borrado correctamente");
		return santipestim;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param santipestimIds
	 *            List
	 * @return santipestimList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> santipestimIds) {
		List<Santipestim> santipestimList = new ArrayList<Santipestim>();
		for (List<String> santipestimId : santipestimIds) {
			Iterator<String> iterator = santipestimId.iterator();
			Santipestim santipestim = new Santipestim(); // NOPMD - Objeto nuevo
															// en la lista
															// (parametro del
															// servicio)
			santipestim.setTeid(ObjectConversionManager.convert(
					iterator.next(), String.class));
			santipestimList.add(santipestim);
		}
		this.santipestimService.removeMultiple(santipestimList);
		SantipestimController.logger
				.info("[POST - DELETE_ALL] : Santipestim borrados correctamente");
		return santipestimIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSantipestim
	 *            Santipestim
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Santipestim filterSantipestim,
			@ModelAttribute() Pagination pagination) {
		List<Santipestim> santipestims = this.santipestimService.findAll(
				filterSantipestim, pagination, false);
		Long recordNum = this.santipestimService.findAllCount(
				filterSantipestim, false);
		SantipestimController.logger
				.info("[GET - jqGrid] : Obtener Santipestim");
		return new JQGridJSONModel(pagination, recordNum, santipestims);
	}

	/**
	 * Method 'getComboTipoEstimacion'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param modo
	 *            String
	 * @return List
	 */
	@RequestMapping(value = "/combo/{modo}", method = RequestMethod.GET)
	public @ResponseBody()
	List<Santipestim> getComboTipoEstimacion(HttpServletRequest request,
			@PathVariable() String modo) {

		SantipestimController.logger
				.info("[GET - find_ALL] : Obtener combo Tipos Estimacion");
		Santipestim filterSantipestim = new Santipestim();
		/*
		 * desde la ficha de expedientes
		 */
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("tedesces");
		} else {
			pagination.setSort("tedesceu");
		}
		pagination.setAscDsc("ASC");
		boolean incluirDadosDeBaja = false;

		if (Y41bConstantes.SI.equals(modo)) {
			incluirDadosDeBaja = true;
		}
		return this.santipestimService.findAll(filterSantipestim, pagination,
				incluirDadosDeBaja);
	}

	/**
	 * Method 'getCreateFormModProcedimental'.
	 * 
	 * @param teid
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "modSantipestim/{teid}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModProcedimental(
			@PathVariable() String teid, Model model, HttpServletRequest request) {

		model.addAttribute("teid", teid);

		model.addAttribute("modoSantipestim",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Santipestim Santipestim = new Santipestim();
		Santipestim.setTeid(teid);

		if (censoMonitor.getPerfilMaestros() != null
				&& censoMonitor
						.getPerfilMaestros()
						.getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
			return new ModelAndView("santipestimDetalle", "model", model);
		} else {
			return new ModelAndView("accessDeniedModal", "model", model);
		}
	}

	/**
	 * Method 'getAllParametros'. de tipo like
	 * 
	 * @param parametro_
	 *            String
	 * @param valor_
	 *            String
	 * @param descripciones_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllProcedimental(
			@RequestParam(value = "parametro", required = false) String parametro_,
			@RequestParam(value = "valor", required = false) String valor_,
			@RequestParam(value = "descripciones", required = false) String descripciones_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro

			String descripciones = ("".equals(descripciones_)) ? null
					: descripciones_;
			String descripcioneu = null;
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.EUSKERA.equals(idioma)) {
				descripcioneu = ("".equals(descripciones_)) ? null
						: descripciones_;
				descripciones = null;
			}

			Santipestim filterSanTipEstim = new Santipestim();
			filterSanTipEstim.setTedesces(descripciones);
			filterSanTipEstim.setTedesceu(descripcioneu);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Santipestim> parametroses = this.santipestimService
						.findAllLike(filterSanTipEstim, pagination, false,
								false);

				if (parametroses == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.santipestimService.findAllLikeCount(
						filterSanTipEstim, false, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(parametroses);
				return data;
			} else {
				List<Santipestim> parametroses = this.santipestimService
						.findAllLike(filterSanTipEstim, pagination, false,
								false);
				if (parametroses == null) {
					throw new Exception("No data Found.");
				}
				return parametroses;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateFormAltaProcedimental'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaSantipestim", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaProcedimental(Model model,
			HttpServletRequest request) {

		model.addAttribute("teid", "");

		model.addAttribute("modoSantipestim", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() != null
				&& censoMonitor
						.getPerfilMaestros()
						.getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
			return new ModelAndView("santipestimDetalle", "model", model);
		} else {
			return new ModelAndView("accessDeniedModal", "model", model);
		}
	}

}
