package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.SantipdocService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Santipdoc;

/**
 * SantipdocController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/santipdoc")
public class SantipdocController {

	private static final Logger logger = LoggerFactory
			.getLogger(SantipdocController.class);

	@Autowired()
	private SantipdocService santipdocService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SantipdocController.logger.info("[GET - View] : santipdoc");
		return "santipdoc";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tdid
	 *            String
	 * @return santipdoc Santipdoc
	 */
	@RequestMapping(value = "/{tdid}", method = RequestMethod.GET)
	public @ResponseBody()
	Santipdoc getById(@PathVariable() String tdid) {
		Santipdoc santipdoc = new Santipdoc();
		santipdoc.setTdid(tdid);
		santipdoc = this.santipdocService.find(santipdoc);
		SantipdocController.logger
				.info("[GET - findBy_PK] : Obtener Santipdoc por PK");
		return santipdoc;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSantipdoc
	 *            Santipdoc
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Santipdoc> getAll(@ModelAttribute() Santipdoc filterSantipdoc) {
		SantipdocController.logger
				.info("[GET - find_ALL] : Obtener Santipdoc por filtro");
		return this.santipdocService.findAll(filterSantipdoc, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return Santipdoc
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Santipdoc edit(@RequestBody() Santipdoc santipdoc) {
		Santipdoc santipdocAux = this.santipdocService.update(santipdoc);
		SantipdocController.logger
				.info("[PUT] : Santipdoc actualizado correctamente");
		return santipdocAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return Santipdoc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Santipdoc add(@RequestBody() Santipdoc santipdoc) {
		Santipdoc santipdocAux = this.santipdocService.add(santipdoc);
		SantipdocController.logger
				.info("[POST] : Santipdoc insertado correctamente");
		return santipdocAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tdid
	 *            String
	 * @return santipdoc
	 */
	@RequestMapping(value = "/{tdid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Santipdoc remove(@PathVariable() String tdid) {
		Santipdoc santipdoc = new Santipdoc();
		santipdoc.setTdid(tdid);
		this.santipdocService.remove(santipdoc);
		SantipdocController.logger
				.info("[DELETE] : Santipdoc borrado correctamente");
		return santipdoc;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param santipdocIds
	 *            List
	 * @return santipdocList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> santipdocIds) {
		List<Santipdoc> santipdocList = new ArrayList<Santipdoc>();
		for (List<String> santipdocId : santipdocIds) {
			Iterator<String> iterator = santipdocId.iterator();
			Santipdoc santipdoc = new Santipdoc(); // NOPMD - Objeto nuevo en la
													// lista (parametro del
													// servicio)
			santipdoc.setTdid(ObjectConversionManager.convert(iterator.next(),
					String.class));
			santipdocList.add(santipdoc);
		}
		this.santipdocService.removeMultiple(santipdocList);
		SantipdocController.logger
				.info("[POST - DELETE_ALL] : Santipdoc borrados correctamente");
		return santipdocIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSantipdoc
	 *            Santipdoc
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Santipdoc filterSantipdoc,
			@ModelAttribute() Pagination pagination) {
		List<Santipdoc> santipdocs = this.santipdocService.findAll(
				filterSantipdoc, pagination);
		Long recordNum = this.santipdocService.findAllCount(filterSantipdoc);
		SantipdocController.logger.info("[GET - jqGrid] : Obtener Santipdoc");
		return new JQGridJSONModel(pagination, recordNum, santipdocs);
	}

	/**
	 * Method 'pCodigo'.
	 * 
	 * @param request
	 *            the request
	 * @return List
	 * @throws Exception
	 *             the exception
	 */
	@RequestMapping(value = "/comboTipoDocumentoEntrada", method = RequestMethod.GET)
	public @ResponseBody()
	Object getComboIntervinientes(HttpServletRequest request) throws Exception {

		SantipdocController.logger
				.info("[GET - find_ALL] : Obtener combo santipdoc del Expediente");

		Pagination pagination = new Pagination();
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();
		if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
			pagination.setSort("tdnombre");
		} else {
			pagination.setSort("tdnombree");
		}

		pagination.setAscDsc("ASC");

		Santipdoc santipdoc = new Santipdoc();
		santipdoc.setTdtipo(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA);

		return this.santipdocService.findAll(santipdoc, pagination);

	}
}
