package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Sanresulsen;
import com.ejie.y41b.service.SanresulsenService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SanresulsenController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sanresulsen")
public class SanresulsenController {

	private static final Logger logger = LoggerFactory
			.getLogger(SanresulsenController.class);

	@Autowired()
	private SanresulsenService sanresulsenService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintSentencia", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		SanresulsenController.logger.info("[GET - View] : sanresulsen");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return "accessDeniedEscritorio";
		} else {
			return "sentenciaBusqueda";
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param rsid
	 *            String
	 * @return sanresulsen Sanresulsen
	 */
	@RequestMapping(value = "/{rsid}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanresulsen getById(@PathVariable() String rsid) {
		Sanresulsen sanresulsen = new Sanresulsen();
		sanresulsen.setRsid(rsid);
		sanresulsen = this.sanresulsenService.find(sanresulsen);
		SanresulsenController.logger
				.info("[GET - findBy_PK] : Obtener Sanresulsen por PK");
		return sanresulsen;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSanresulsen
	 *            Sanresulsen
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanresulsen> getAll(@ModelAttribute() Sanresulsen filterSanresulsen) {
		SanresulsenController.logger
				.info("[GET - find_ALL] : Obtener Sanresulsen por filtro");
		return this.sanresulsenService.findAll(filterSanresulsen, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return Sanresulsen
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sanresulsen edit(@RequestBody() Sanresulsen sanresulsen) {
		Sanresulsen sanresulsenAux = this.sanresulsenService
				.update(sanresulsen);
		SanresulsenController.logger
				.info("[PUT] : Sanresulsen actualizado correctamente");
		return sanresulsenAux;
	}

	/**
	 * Method 'getCreateFormModSentencia'.
	 * 
	 * @param codSentencia
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modSanresulsen/{codSentencia}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModSentencia(
			@PathVariable() String codSentencia, Model model,
			HttpServletRequest request) {

		model.addAttribute("codSentencia", codSentencia);

		model.addAttribute("modoSentencia",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Sanresulsen sentencia = new Sanresulsen();
		sentencia.setRsid(codSentencia);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("sentenciaDetalle", "model", model);
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return Sanresulsen
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sanresulsen add(@RequestBody() Sanresulsen sanresulsen) {
		Sanresulsen sanresulsenAux = this.sanresulsenService.add(sanresulsen);
		SanresulsenController.logger
				.info("[POST] : Sanresulsen insertado correctamente");
		return sanresulsenAux;
	}

	/**
	 * Method 'getCreateFormAltaSentencia'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaSentencia", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaSentencia(Model model,
			HttpServletRequest request) {

		model.addAttribute("codSentencia", Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoSentencia", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("sentenciaDetalle", "model", model);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param rsid
	 *            String
	 * @return sanresulsen
	 */
	@RequestMapping(value = "/{rsid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sanresulsen remove(@PathVariable() String rsid) {
		Sanresulsen sanresulsen = new Sanresulsen();
		sanresulsen.setRsid(rsid);
		this.sanresulsenService.remove(sanresulsen);
		SanresulsenController.logger
				.info("[DELETE] : Sanresulsen borrado correctamente");
		return sanresulsen;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sanresulsenIds
	 *            List
	 * @return sanresulsenList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sanresulsenIds) {
		List<Sanresulsen> sanresulsenList = new ArrayList<Sanresulsen>();
		for (List<String> sanresulsenId : sanresulsenIds) {
			Iterator<String> iterator = sanresulsenId.iterator();
			Sanresulsen sanresulsen = new Sanresulsen(); // NOPMD - Objeto nuevo
															// en la lista
															// (parametro del
															// servicio)
			sanresulsen.setRsid(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanresulsenList.add(sanresulsen);
		}
		this.sanresulsenService.removeMultiple(sanresulsenList);
		SanresulsenController.logger
				.info("[POST - DELETE_ALL] : Sanresulsen borrados correctamente");
		return sanresulsenIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanresulsen
	 *            Sanresulsen
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Sanresulsen filterSanresulsen,
			@ModelAttribute() Pagination pagination) {
		List<Sanresulsen> sanresulsens = this.sanresulsenService.findAll(
				filterSanresulsen, pagination);
		Long recordNum = this.sanresulsenService
				.findAllCount(filterSanresulsen);
		SanresulsenController.logger
				.info("[GET - jqGrid] : Obtener Sanresulsen");
		return new JQGridJSONModel(pagination, recordNum, sanresulsens);
	}

	/**
	 * Method 'getComboResulsen'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanresulsen> getComboResulsen(HttpServletRequest request) {

		SanresulsenController.logger
				.info("[GET - find_ALL] : Obtener combo Resulsen");
		Sanresulsen filterSanresulsen = new Sanresulsen();
		/*
		 * desde la ficha de expedientes
		 */
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("rsdesces");
		} else {
			pagination.setSort("rsdesceu");
		}
		pagination.setAscDsc("ASC");

		return this.sanresulsenService.findAll(filterSanresulsen, pagination);
	}

	/**
	 * Method 'getAllResulsen'. de tipo like
	 * 
	 * @param rsid_
	 *            String
	 * @param rsdesces_
	 *            String
	 * @param rsdesceu_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllSentencia(
			@RequestParam(value = "rsid", required = false) String rsid_,
			@RequestParam(value = "rsdesces", required = false) String rsdesces_,
			@RequestParam(value = "rsdesceu", required = false) String rsdesceu_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String rsid = ("".equals(rsid_)) ? null : rsid_;
			String rsdesces = ("".equals(rsdesces_)) ? null : rsdesces_;
			String rsdesceu = ("".equals(rsdesceu_)) ? null : rsdesceu_;

			Sanresulsen filterSanresulsen = new Sanresulsen(rsid, rsdesces,
					rsdesceu);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Sanresulsen> prodAgrupados = this.sanresulsenService
						.findAllLike(filterSanresulsen, pagination, false);

				if (prodAgrupados == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.sanresulsenService.findAllLikeCount(
						filterSanresulsen, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(prodAgrupados);
				return data;
			} else {
				List<Sanresulsen> prodAgrupados = this.sanresulsenService
						.findAllLike(filterSanresulsen, pagination, false);
				if (prodAgrupados == null) {
					throw new Exception("No data Found.");
				}
				return prodAgrupados;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

}
