package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.RecursoService;
import com.ejie.y41b.service.SanrecrcaService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Recurso;
import com.ejie.y41b.model.Sanrecrca;

/**
 * SanrecrcaController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sanrecrca")
public class SanrecrcaController {

	private static final Logger logger = LoggerFactory
			.getLogger(SanrecrcaController.class);

	@Autowired()
	private SanrecrcaService sanrecrcaService;

	@Autowired()
	private RecursoService recursoservice;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SanrecrcaController.logger.info("[GET - View] : sanrecrca");
		return "sanrecrca";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param recodigo
	 *            String
	 * @return sanrecrca Sanrecrca
	 */
	@RequestMapping(value = "/{recodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanrecrca getById(@PathVariable() String recodigo) {
		Sanrecrca sanrecrca = new Sanrecrca();
		sanrecrca.setRecodigo(recodigo);
		sanrecrca = this.sanrecrcaService.find(sanrecrca);
		SanrecrcaController.logger
				.info("[GET - findBy_PK] : Obtener Sanrecrca por PK");
		return sanrecrca;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSanrecrca
	 *            Sanrecrca
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanrecrca> getAll(@ModelAttribute() Sanrecrca filterSanrecrca) {
		SanrecrcaController.logger
				.info("[GET - find_ALL] : Obtener Sanrecrca por filtro");
		return this.sanrecrcaService.findAll(filterSanrecrca, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @return Sanrecrca
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sanrecrca edit(@RequestBody() Sanrecrca sanrecrca) {
		Sanrecrca sanrecrcaAux = this.sanrecrcaService.update(sanrecrca);
		SanrecrcaController.logger
				.info("[PUT] : Sanrecrca actualizado correctamente");
		return sanrecrcaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @return Sanrecrca
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sanrecrca add(@RequestBody() Sanrecrca sanrecrca) {
		Sanrecrca sanrecrcaAux = this.sanrecrcaService.add(sanrecrca);
		SanrecrcaController.logger
				.info("[POST] : Sanrecrca insertado correctamente");
		return sanrecrcaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param recodigo
	 *            String
	 * @return sanrecrca
	 */
	@RequestMapping(value = "/{recodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sanrecrca remove(@PathVariable() String recodigo) {
		Sanrecrca sanrecrca = new Sanrecrca();
		sanrecrca.setRecodigo(recodigo);
		this.sanrecrcaService.remove(sanrecrca);
		SanrecrcaController.logger
				.info("[DELETE] : Sanrecrca borrado correctamente");
		return sanrecrca;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sanrecrcaIds
	 *            List
	 * @return sanrecrcaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sanrecrcaIds) {
		List<Sanrecrca> sanrecrcaList = new ArrayList<Sanrecrca>();
		for (List<String> sanrecrcaId : sanrecrcaIds) {
			Iterator<String> iterator = sanrecrcaId.iterator();
			Sanrecrca sanrecrca = new Sanrecrca(); // NOPMD - Objeto nuevo en la
													// lista (parametro del
													// servicio)
			sanrecrca.setRecodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanrecrcaList.add(sanrecrca);
		}
		this.sanrecrcaService.removeMultiple(sanrecrcaList);
		SanrecrcaController.logger
				.info("[POST - DELETE_ALL] : Sanrecrca borrados correctamente");
		return sanrecrcaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanrecrca
	 *            Sanrecrca
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Sanrecrca filterSanrecrca,
			@ModelAttribute() Pagination pagination) {
		List<Sanrecrca> sanrecrcas = this.sanrecrcaService.findAll(
				filterSanrecrca, pagination);
		Long recordNum = this.sanrecrcaService.findAllCount(filterSanrecrca);
		SanrecrcaController.logger.info("[GET - jqGrid] : Obtener Sanrecrca");
		return new JQGridJSONModel(pagination, recordNum, sanrecrcas);
	}

	/**
	 * Method 'obtenerDatosRecurso'.
	 * 
	 * @param idExpediente
	 *            String
	 * @return sanrecrca Sanrecrca
	 */
	@RequestMapping(value = "/obtenerDatosRecurso/{idExpediente}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanrecrca obtenerDatosRecurso(@PathVariable() String idExpediente) {
		Sanrecrca sanrecrca = new Sanrecrca();
		try {
			SanrecrcaController.logger
					.info("[GET - find] : Obtener Sanrecrca expediente "
							+ idExpediente);
			Expedien expedien = new Expedien();
			expedien.setExcodigo(idExpediente);

			Recurso recurso = new Recurso();
			recurso.setExpedien(expedien);
			List<Recurso> lrecursos = this.recursoservice
					.findAll(recurso, null);

			if (lrecursos != null && lrecursos.size() > 0) {

				recurso = lrecursos.get(0);
				sanrecrca.setRecodigo(recurso.getRecodigo());
				sanrecrca = this.sanrecrcaService.find(sanrecrca);

				if (sanrecrca == null) {
					sanrecrca = new Sanrecrca();
					sanrecrca.setRecodigo(lrecursos.get(0).getRecodigo());
				}
				// Acuerdo
				sanrecrca.setRercaacue(sanrecrca.getRercaacue() == null ? null
						: Y41bUtils.formatDouble2decimalesYcoma(Double
								.parseDouble(sanrecrca.getRercaacue())));
				// importeDev
				sanrecrca
						.setRercaimpdev(sanrecrca.getRercaimpdev() == null ? null
								: Y41bUtils.formatDouble2decimalesYcoma(Double
										.parseDouble(sanrecrca.getRercaimpdev())));
				// Fecha del acuse de la recepcion del consejero ya esta dentro
				// de sanrecrca
				sanrecrca.setRefenrro(recurso.getRefenrro());
				// Fecha de la orden del consejero
				sanrecrca.setRefeinrc(recurso.getRefeinrc());
				// Fecha del recurso
				sanrecrca.setRefereor(recurso.getRefereor());
				// Fecha de la sentencia
				sanrecrca.setRefeserc(recurso.getRefeserc());
				// multa
				sanrecrca.setRecamurc(recurso.getRecamurc() == null ? null
						: Y41bUtils.formatDouble2decimalesYcoma(recurso
								.getRecamurc().doubleValue()));
				// excodigo
				sanrecrca.setExcodigo(idExpediente);
			}

		} catch (Exception e) {
			SanrecrcaController.logger.info("[GET - find] : Obtener Sanrecrca "
					+ e.getMessage());
		}
		return sanrecrca;
	}

	/**
	 * Method 'guardarRCA'.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @param request
	 *            HttpServletRequest
	 * @return Sanrecrca
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody()
	Sanrecrca guardarRCA(@RequestBody() Sanrecrca sanrecrca,
			HttpServletRequest request) {
		try {
			// acuerdo
			sanrecrca.setRercaacue(sanrecrca.getRercaacue().replace('\u002c',
					'\u002e'));
			// importeDev
			sanrecrca.setRercaimpdev(sanrecrca.getRercaimpdev().toString()
					.replace('\u002c', '\u002e'));
			Recurso recurso = new Recurso();
			if (!Y41bUtils.esNullOCadenaVacia(sanrecrca.getRecodigo())) {
				recurso.setRecodigo(sanrecrca.getRecodigo());
				recurso = this.recursoservice.find(recurso);
			}

			recurso.setRefeinrc(sanrecrca.getRefeinrc());
			// Fecha de la sentencia
			recurso.setRefeserc(sanrecrca.getRefeserc());
			// multa
			if (!Y41bUtils.esNullOCadenaVacia(sanrecrca.getRecamurc())) {
				recurso.setRecamurc(new BigDecimal(sanrecrca.getRecamurc()
						.replace('\u002c', '\u002e')));
			}
			// excodigo
			recurso.setExpedien(new Expedien(sanrecrca.getExcodigo()));
			// Sanrecrca aux = null;

			if (Y41bUtils.esNullOCadenaVacia(sanrecrca.getRecodigo())) {
				recurso = this.recursoservice.add(recurso);
				sanrecrca.setRecodigo(recurso.getRecodigo());
				this.sanrecrcaService.add(sanrecrca);
			} else {

				this.recursoservice.update(recurso);
				// miramos a vr si existe
				Sanrecrca sanrecrca2 = this.sanrecrcaService.find(sanrecrca);
				if (sanrecrca2 != null) {
					this.sanrecrcaService.update(sanrecrca);
				} else {
					this.sanrecrcaService.add(sanrecrca);
				}

			}

			return sanrecrca;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
