package com.ejie.y41b.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sanprue;
import com.ejie.y41b.service.SanprueService;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SanprueController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sanprue")
public class SanprueController {

	private static final Logger logger = LoggerFactory
			.getLogger(SanprueController.class);

	@Autowired()
	private SanprueService sanprueService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SanprueController.logger.info("[GET - View] : sanprue");
		return "sanprue";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param prid
	 *            BigDecimal
	 * @return sanprue Sanprue
	 */
	@RequestMapping(value = "/{prid}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanprue getById(@PathVariable() BigDecimal prid) {
		Sanprue sanprue = new Sanprue();
		sanprue.setPrid(prid);
		sanprue = this.sanprueService.find(sanprue);
		SanprueController.logger
				.info("[GET - findBy_PK] : Obtener Sanprue por PK");
		return sanprue;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSanprue
	 *            Sanprue
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanprue> getAll(@ModelAttribute() Sanprue filterSanprue) {
		SanprueController.logger
				.info("[GET - find_ALL] : Obtener Sanprue por filtro");
		return this.sanprueService.findAll(filterSanprue, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @return Sanprue
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sanprue edit(@RequestBody() Sanprue sanprue) {
		Sanprue sanprueAux = this.sanprueService.update(sanprue);
		SanprueController.logger
				.info("[PUT] : Sanprue actualizado correctamente");
		return sanprueAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @return Sanprue
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sanprue add(@RequestBody() Sanprue sanprue) {
		Sanprue sanprueAux = this.sanprueService.add(sanprue);
		SanprueController.logger
				.info("[POST] : Sanprue insertado correctamente");
		return sanprueAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param prid
	 *            BigDecimal
	 * @return sanprue
	 */
	@RequestMapping(value = "/{prid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sanprue remove(@PathVariable() BigDecimal prid) {
		Sanprue sanprue = new Sanprue();
		sanprue.setPrid(prid);
		this.sanprueService.remove(sanprue);
		SanprueController.logger
				.info("[DELETE] : Sanprue borrado correctamente");
		return sanprue;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sanprueIds
	 *            List
	 * @return sanprueList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sanprueIds) {
		List<Sanprue> sanprueList = new ArrayList<Sanprue>();
		for (List<String> sanprueId : sanprueIds) {
			Iterator<String> iterator = sanprueId.iterator();
			Sanprue sanprue = new Sanprue(); // NOPMD - Objeto nuevo en la lista
												// (parametro del servicio)
			sanprue.setPrid(ObjectConversionManager.convert(iterator.next(),
					java.math.BigDecimal.class));
			sanprueList.add(sanprue);
		}
		this.sanprueService.removeMultiple(sanprueList);
		SanprueController.logger
				.info("[POST - DELETE_ALL] : Sanprue borrados correctamente");
		return sanprueIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanprue
	 *            Sanprue
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Sanprue filterSanprue,
			@ModelAttribute() Pagination pagination) {
		List<Sanprue> sanprues = this.sanprueService.findAll(filterSanprue,
				pagination);
		Long recordNum = this.sanprueService.findAllCount(filterSanprue);
		SanprueController.logger.info("[GET - jqGrid] : Obtener Sanprue");
		return new JQGridJSONModel(pagination, recordNum, sanprues);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param excodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/damePruebasExp", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGridPruebas(
			@RequestParam(value = "excodigo", required = false) String excodigo,
			@ModelAttribute() Pagination pagination) {

		Sanprue filterSanprue = new Sanprue();
		Expedien expedien = new Expedien();
		expedien.setExcodigo(excodigo);
		filterSanprue.setExpedien(expedien);

		List<Sanprue> sanintervs = this.sanprueService.findAll(filterSanprue,
				pagination);
		Long recordNum = this.sanprueService.findAllCount(filterSanprue);
		SanprueController.logger.info("[GET - jqGrid] : Obtener Sanprue");
		return new JQGridJSONModel(pagination, recordNum, sanintervs);

	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintMod/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable() String idExpediente,
			Model model, HttpServletRequest httpRequest) {

		String excodigo = (String) httpRequest.getSession().getAttribute(
				Y41bConstantes.SESSION_NUMEXP);

		model.addAttribute("exCodigo", excodigo);

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("modalSanPrueba", "model", model);
	}

	/**
	 * @param pruebanueva
	 *            Sanprue
	 * @param request
	 *            HttpServletRequest
	 * @return boolean
	 */
	@RequestMapping(value = "/darAltaPrueba", method = RequestMethod.POST)
	public @ResponseBody()
	boolean addPrueba(@RequestBody() Sanprue pruebanueva,
			HttpServletRequest request) {
		try {

			if (pruebanueva.getPrid() == null
					|| pruebanueva.getPrid().intValue() == 0) {
				this.sanprueService.add(pruebanueva);
			} else {
				this.sanprueService.update(pruebanueva);
			}
			SanprueController.logger.info("Entity correctly inserted!"
					+ pruebanueva.toString() + request.toString());
			return true;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}
}
