package com.ejie.y41b.control;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Sanpropbandeja;
import com.ejie.y41b.service.SanpropbandejaService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SanpropbandejaController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sanpropbandeja")
public class SanpropbandejaController {

	private static final Logger logger = LoggerFactory
			.getLogger(SanpropbandejaController.class);

	@Autowired()
	private SanpropbandejaService sanpropbandejaService;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SanpropbandejaController.logger.info("[GET - View] : sanpropbandeja");
		return "sanpropbandeja";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param baprsanid
	 *            Long
	 * @return sanpropbandeja Sanpropbandeja
	 */
	@RequestMapping(value = "/{baprsanid}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanpropbandeja getById(@PathVariable() Long baprsanid) {
		Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
		sanpropbandeja.setBaprsanid(baprsanid);
		sanpropbandeja = this.sanpropbandejaService.find(sanpropbandeja);
		SanpropbandejaController.logger
				.info("[GET - findBy_PK] : Obtener Sanpropbandeja por PK");
		return sanpropbandeja;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSanpropbandeja
	 *            Sanpropbandeja
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanpropbandeja> getAll(
			@ModelAttribute() Sanpropbandeja filterSanpropbandeja) {
		SanpropbandejaController.logger
				.info("[GET - find_ALL] : Obtener Sanpropbandeja por filtro");
		return this.sanpropbandejaService.findAll(filterSanpropbandeja, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @return Sanpropbandeja
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sanpropbandeja edit(@RequestBody() Sanpropbandeja sanpropbandeja) {
		Sanpropbandeja sanpropbandejaAux = this.sanpropbandejaService
				.update(sanpropbandeja);
		SanpropbandejaController.logger
				.info("[PUT] : Sanpropbandeja actualizado correctamente");
		return sanpropbandejaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @return Sanpropbandeja
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sanpropbandeja add(@RequestBody() Sanpropbandeja sanpropbandeja) {
		Sanpropbandeja sanpropbandejaAux = this.sanpropbandejaService
				.add(sanpropbandeja);
		SanpropbandejaController.logger
				.info("[POST] : Sanpropbandeja insertado correctamente");
		return sanpropbandejaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param baprsanid
	 *            Long
	 * @return sanpropbandeja
	 */
	@RequestMapping(value = "/{baprsanid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sanpropbandeja remove(@PathVariable() Long baprsanid) {
		Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
		sanpropbandeja.setBaprsanid(baprsanid);
		this.sanpropbandejaService.remove(sanpropbandeja);
		SanpropbandejaController.logger
				.info("[DELETE] : Sanpropbandeja borrado correctamente");
		return sanpropbandeja;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sanpropbandejaIds
	 *            List
	 * @return sanpropbandejaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sanpropbandejaIds) {
		List<Sanpropbandeja> sanpropbandejaList = new ArrayList<Sanpropbandeja>();
		for (List<String> sanpropbandejaId : sanpropbandejaIds) {
			Iterator<String> iterator = sanpropbandejaId.iterator();
			Sanpropbandeja sanpropbandeja = new Sanpropbandeja(); // NOPMD -
																	// Objeto
																	// nuevo en
																	// la lista
																	// (parametro
																	// del
																	// servicio)
			sanpropbandeja.setBaprsanid(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			sanpropbandejaList.add(sanpropbandeja);
		}
		this.sanpropbandejaService.removeMultiple(sanpropbandejaList);
		SanpropbandejaController.logger
				.info("[POST - DELETE_ALL] : Sanpropbandeja borrados correctamente");
		return sanpropbandejaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanpropbandeja
	 *            Sanpropbandeja
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Sanpropbandeja filterSanpropbandeja,
			@ModelAttribute() Pagination pagination,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			HttpServletRequest request) {
		// EVOLUTIVO 0135083 2.10
		String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
		SanpropbandejaController.logger.info(" codOrg: " + codOrg);
		// EVOLUTIVO 0135083 2.10
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		filterSanpropbandeja.setCensoMonitor(censoMonitor);
		// EVOLUTIVO 0135083 2.10
		filterSanpropbandeja.setCodOrg(codOrg);
		// EVOLUTIVO 0135083 2.10
		String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();
		List<Sanpropbandeja> sanpropbandejas = new ArrayList<Sanpropbandeja>();

		request.getSession().setAttribute("paginationSanpropbandeja",
				pagination);

		Long recordNum = 0L;
		if (Y41bConstantes.PERFIL_DIRECTOR.equals(perfil)
				|| Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)
				|| Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)
				|| Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)) {
			sanpropbandejas = this.sanpropbandejaService.findAll(
					filterSanpropbandeja, pagination);
			httpSession.setAttribute("sanPropBandejaBusqueda",
					filterSanpropbandeja);
			recordNum = this.sanpropbandejaService
					.findAllCount(filterSanpropbandeja);
		}
		SanpropbandejaController.logger
				.info("[GET - jqGrid] : Obtener Sanpropbandeja");
		return new JQGridJSONModel(pagination, recordNum, sanpropbandejas);
	}

	/**
	 * getAllCount
	 * 
	 * @param filterSanpropbandeja
	 *            Sanpropbandeja
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/numeroEntradasBandeja", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(@ModelAttribute() Sanpropbandeja filterSanpropbandeja,
			@ModelAttribute() Pagination pagination,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			HttpServletRequest request) {
		// EVOLUTIVO 0135083 2.10
		String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
		SanpropbandejaController.logger.info(" codOrg: " + codOrg);
		// EVOLUTIVO 0135083 2.10
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		filterSanpropbandeja.setCensoMonitor(censoMonitor);
		// EVOLUTIVO 0135083 2.10
		filterSanpropbandeja.setCodOrg(codOrg);
		// EVOLUTIVO 0135083 2.10
		String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();
		Long recordNum = 0L;
		if (Y41bConstantes.PERFIL_DIRECTOR.equals(perfil)
				|| Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)
				|| Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)
				|| Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)) {
			recordNum = this.sanpropbandejaService
					.findAllCount(filterSanpropbandeja);
		}
		SanpropbandejaController.logger
				.info("[GET - jqGrid] : Obtener Sanpropbandeja");
		return recordNum;
	}

	/*---- excel Bandeja-----*/

	/**
	 * Method 'getAllExcelBandejaSanProp'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandeja", method = RequestMethod.GET)
	public @ResponseBody()
	void getAllExcelBandejaSanProp(HttpServletRequest request,
			HttpServletResponse response) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			Sanpropbandeja filterSanpropbandeja = (Sanpropbandeja) httpSession
					.getAttribute("sanPropBandejaBusqueda");
			filterSanpropbandeja.setCensoMonitor(censoMonitor);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BANDEJA_SANPROP + fechaActual
					+ ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService
					.getSanPropExcelBandeja(filterSanpropbandeja);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanpropbandeja
	 *            Sanpropbandeja
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/sanpropbandejaSession", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGridSession(
			@ModelAttribute() Sanpropbandeja filterSanpropbandeja,
			@ModelAttribute() Pagination pagination,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			HttpServletRequest request) {

		try {
			// EVOLUTIVO 0135083 2.10
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			SanpropbandejaController.logger.info(" codOrg: " + codOrg);
			// EVOLUTIVO 0135083 2.10
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			filterSanpropbandeja.setCensoMonitor(censoMonitor);
			// EVOLUTIVO 0135083 2.10
			filterSanpropbandeja.setCodOrg(codOrg);
			// EVOLUTIVO 0135083 2.10

			String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();

			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = (Pagination) request.getSession().getAttribute(
						"paginationSanpropbandeja");

				// Si al refrescar la tabla existen menos elementos y la pgina
				// guardada en sesin no existe, se debe seleccionar la ltima
				// pgina con datos
				Long totalReg = new Long(0);
				totalReg = this.sanpropbandejaService
						.findAllCount(filterSanpropbandeja);

				Long pagSession = new Long(0);
				Long page = new Long(0);
				pagSession = pagination.getPage() * pagination.getRows();
				pagSession = pagSession - pagination.getRows();

				if (pagSession >= totalReg) {
					page = totalReg / pagination.getRows();
					pagination.setPage(page);
				}
			}

			List<Sanpropbandeja> sanpropbandejas = new ArrayList<Sanpropbandeja>();

			Long recordNum = 0L;
			if (Y41bConstantes.PERFIL_DIRECTOR.equals(perfil)
					|| Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)
					|| Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)
					|| Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)) {
				sanpropbandejas = this.sanpropbandejaService.findAll(
						filterSanpropbandeja, pagination);
				httpSession.setAttribute("sanPropBandejaBusqueda",
						filterSanpropbandeja);
				recordNum = this.sanpropbandejaService
						.findAllCount(filterSanpropbandeja);
			}
			SanpropbandejaController.logger
					.info("[GET - jqGrid] : Obtener Sanpropbandeja");

			return new JQGridJSONModel(pagination, recordNum, sanpropbandejas);

		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en getAllJQGrid: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

}