package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.SanplazosService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Sanplazos;

/**
 * SanplazosController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sanplazos")
public class SanplazosController {

	private static final Logger logger = LoggerFactory
			.getLogger(SanplazosController.class);

	@Autowired()
	private SanplazosService sanplazosService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SanplazosController.logger.info("[GET - View] : sanplazos");
		return "sanplazos";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param coid
	 *            BigDecimal
	 * @return sanplazos Sanplazos
	 */
	@RequestMapping(value = "/{coid}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanplazos getById(@PathVariable() BigDecimal coid) {
		Sanplazos sanplazos = new Sanplazos();
		sanplazos.setCoid(coid);
		sanplazos = this.sanplazosService.find(sanplazos);
		SanplazosController.logger
				.info("[GET - findBy_PK] : Obtener Sanplazos por PK");
		return sanplazos;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSanplazos
	 *            Sanplazos
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanplazos> getAll(@ModelAttribute() Sanplazos filterSanplazos) {
		SanplazosController.logger
				.info("[GET - find_ALL] : Obtener Sanplazos por filtro");
		return this.sanplazosService.findAll(filterSanplazos, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sanplazos
	 *            Sanplazos
	 * @return Sanplazos
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sanplazos edit(@RequestBody() Sanplazos sanplazos) {
		Sanplazos sanplazosAux = this.sanplazosService.update(sanplazos);
		SanplazosController.logger
				.info("[PUT] : Sanplazos actualizado correctamente");
		return sanplazosAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sanplazos
	 *            Sanplazos
	 * @return Sanplazos
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sanplazos add(@RequestBody() Sanplazos sanplazos) {
		Sanplazos sanplazosAux = this.sanplazosService.add(sanplazos);
		SanplazosController.logger
				.info("[POST] : Sanplazos insertado correctamente");
		return sanplazosAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param coid
	 *            BigDecimal
	 * @return sanplazos
	 */
	@RequestMapping(value = "/{coid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sanplazos remove(@PathVariable() BigDecimal coid) {
		Sanplazos sanplazos = new Sanplazos();
		sanplazos.setCoid(coid);
		this.sanplazosService.remove(sanplazos);
		SanplazosController.logger
				.info("[DELETE] : Sanplazos borrado correctamente");
		return sanplazos;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sanplazosIds
	 *            List
	 * @return sanplazosList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sanplazosIds) {
		List<Sanplazos> sanplazosList = new ArrayList<Sanplazos>();
		for (List<String> sanplazosId : sanplazosIds) {
			Iterator<String> iterator = sanplazosId.iterator();
			Sanplazos sanplazos = new Sanplazos(); // NOPMD - Objeto nuevo en la
													// lista (parametro del
													// servicio)
			sanplazos.setCoid(ObjectConversionManager.convert(iterator.next(),
					java.math.BigDecimal.class));
			sanplazosList.add(sanplazos);
		}
		this.sanplazosService.removeMultiple(sanplazosList);
		SanplazosController.logger
				.info("[POST - DELETE_ALL] : Sanplazos borrados correctamente");
		return sanplazosIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanplazos
	 *            Sanplazos
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Sanplazos filterSanplazos,
			@ModelAttribute() Pagination pagination) {
		List<Sanplazos> sanplazoss = this.sanplazosService.findAll(
				filterSanplazos, pagination);
		Long recordNum = this.sanplazosService.findAllCount(filterSanplazos);
		SanplazosController.logger.info("[GET - jqGrid] : Obtener Sanplazos");
		return new JQGridJSONModel(pagination, recordNum, sanplazoss);
	}

}
