package com.ejie.y41b.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.ConsumidorDetalle;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.SanintervDetalle;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.T17CalleService;
import com.ejie.y41b.service.T17MunicipioService;
import com.ejie.y41b.service.T17ProvinciaService;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * SanintervController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/saninterv")
public class SanintervController {

	private static final Logger logger = LoggerFactory
			.getLogger(SanintervController.class);

	@Autowired()
	private SanintervService sanintervService;

	@Autowired()
	private T17MunicipioService municipioService;

	@Autowired()
	private T17ProvinciaService provinciaService;

	@Autowired()
	private ExpedienService expedienService;

	@Autowired()
	private T17CalleService t17CalleService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SanintervController.logger.info("[GET - View] : saninterv");
		return "saninterv";
	}

	/**
	 * Method 'getCreateModalMantEstSancion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * @RequestMapping(value = "mantEstSancion", method = RequestMethod.GET)
	 *                       public ModelAndView
	 *                       getCreateModalMantEstSancion(Model model,
	 *                       HttpServletRequest request) {
	 *                       model.addAttribute("defaultLanguage",
	 *                       this.appConfiguration
	 *                       .get("y41bVistaWar.default.language"));
	 *                       model.addAttribute("defaultLayout",
	 *                       this.appConfiguration
	 *                       .get("y41bVistaWar.default.layout"));
	 * 
	 *                       return new ModelAndView("mantEstSancion", "model",
	 *                       model); }
	 */

	/**
	 * Method 'getById'.
	 * 
	 * @param uaidinterv
	 *            BigDecimal
	 * @return Saninterv
	 */
	@RequestMapping(value = "/{uaidinterv}", method = RequestMethod.GET)
	public @ResponseBody()
	Saninterv getById(@PathVariable() BigDecimal uaidinterv) {
		Saninterv saninterv = new Saninterv();
		saninterv.setUaidinterv(uaidinterv);
		saninterv = this.sanintervService.find(saninterv);
		SanintervController.logger
				.info("[GET - findBy_PK] : Obtener Saninterv por PK");
		return saninterv;
	}

	/**
	 * Method 'getEstSancionById'.
	 * 
	 * @param uaidinterv
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return SanintervDetalle
	 */
	@RequestMapping(value = "/detalle", method = RequestMethod.GET)
	public @ResponseBody()
	SanintervDetalle getEstSancionById(
			@RequestParam(value = "uaidinterv", required = true) BigDecimal uaidinterv,
			HttpServletRequest request) {
		try {
			Saninterv saninterv = new Saninterv();
			saninterv.setUaidinterv(uaidinterv);
			SanintervDetalle establecimientoDetalle = this.sanintervService
					.findEstSancion(saninterv);

			if (establecimientoDetalle == null) {
				throw new Exception(uaidinterv.toString());
			}
			request.getSession()
					.setAttribute(
							"establecimiento",
							new Establecimiento(establecimientoDetalle
									.getUaescodigo()));
			return establecimientoDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(uaidinterv.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSaninterv
	 *            Saninterv
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Saninterv> getAll(@ModelAttribute() Saninterv filterSaninterv) {
		SanintervController.logger
				.info("[GET - find_ALL] : Obtener Saninterv por filtro");
		return this.sanintervService.findAll(filterSaninterv, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Saninterv
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Saninterv edit(@RequestBody() Saninterv saninterv) {
		Saninterv sanintervAux = this.sanintervService.update(saninterv);
		SanintervController.logger
				.info("[PUT] : Saninterv actualizado correctamente");
		return sanintervAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Saninterv
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Saninterv add(@RequestBody() Saninterv saninterv) {
		Saninterv sanintervAux = this.sanintervService.add(saninterv);
		SanintervController.logger
				.info("[POST] : Saninterv insertado correctamente");
		return sanintervAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param uaidinterv
	 *            BigDecimal
	 * @return saninterv
	 */
	@RequestMapping(value = "/{uaidinterv}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Saninterv remove(@PathVariable() BigDecimal uaidinterv) {
		Saninterv saninterv = new Saninterv();
		saninterv.setUaidinterv(uaidinterv);
		this.sanintervService.remove(saninterv);
		SanintervController.logger
				.info("[DELETE] : Saninterv borrado correctamente");
		return saninterv;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sanintervIds
	 *            List
	 * @return sanintervList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sanintervIds) {
		List<Saninterv> sanintervList = new ArrayList<Saninterv>();
		for (List<String> sanintervId : sanintervIds) {
			Iterator<String> iterator = sanintervId.iterator();
			Saninterv saninterv = new Saninterv(); // NOPMD - Objeto nuevo en la
													// lista (parametro del
													// servicio)
			saninterv.setUaidinterv(ObjectConversionManager.convert(
					iterator.next(), java.math.BigDecimal.class));
			sanintervList.add(saninterv);
		}
		this.sanintervService.removeMultiple(sanintervList);
		SanintervController.logger
				.info("[POST - DELETE_ALL] : Saninterv borrados correctamente");
		return sanintervIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSaninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Saninterv filterSaninterv,
			@ModelAttribute() Pagination pagination) {
		List<Saninterv> sanintervs = this.sanintervService.findAll(
				filterSaninterv, pagination);
		Long recordNum = this.sanintervService.findAllCount(filterSaninterv);
		SanintervController.logger.info("[GET - jqGrid] : Obtener Saninterv");
		return new JQGridJSONModel(pagination, recordNum, sanintervs);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param excodigo
	 *            String
	 * @return saninterv Saninterv
	 */
	@RequestMapping(value = "/dameSancionado/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Saninterv getById(@PathVariable() String excodigo) {
		SanintervController.logger
				.info("[GET - getById] : Inicio dameSancionado");

		Saninterv saninterv = this.sanintervService.dameSancionado(excodigo);

		if (saninterv != null) {
			/*
			 * obtenemos el número de recursos de alzada de este usuario en
			 * otros expedientes
			 */
			Expedien expedien = new Expedien();
			expedien.setExcodigo(excodigo);
			int numeroExpedientesConRecursos = this.expedienService
					.expedientesConRecursos(expedien, saninterv);

			saninterv.setSentenciaFirme(numeroExpedientesConRecursos + "");
			/*
			 * obtenemos el número de expedientes para los que no haya recurso
			 * pero ya haya pasado un mes de la fecha de resolucion
			 */

			/*
			 * List<EstablecimSector> listaEstablecimientos =
			 * establecimientoSectorService .findAll(establecimientoSector,
			 * null); if (listaEstablecimientos != null &&
			 * listaEstablecimientos.size() == 1) { if
			 * (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
			 * saninterv.setNombreSector(listaEstablecimientos.get(0)
			 * .getSector().getSenombre()); } else {
			 * saninterv.setNombreSector(listaEstablecimientos.get(0)
			 * .getSector().getSenombree()); } }
			 */
			return saninterv;

		} else {
			SanintervController.logger.info("[GET - getById] : No data found");
		}
		SanintervController.logger.info("[GET - getById] : FIN dameSancionado");
		return null;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param excodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/dameIntervExp", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@RequestParam(value = "excodigo", required = false) String excodigo,
			@ModelAttribute() Pagination pagination) {

		Saninterv filterSaninterv = new Saninterv();
		Expedien expedien = new Expedien();
		expedien.setExcodigo(excodigo);
		filterSaninterv.setExpedien(expedien);

		List<Saninterv> sanintervs = this.sanintervService.findAll(
				filterSaninterv, pagination);
		Long recordNum = this.sanintervService.findAllCount(filterSaninterv);
		SanintervController.logger.info("[GET - jqGrid] : Obtener Saninterv");
		return new JQGridJSONModel(pagination, recordNum, sanintervs);
	}

	/**
	 * Method 'countAllByExp'.
	 * 
	 * @param excodigo
	 *            String
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/countIntervExp", method = RequestMethod.GET)
	public @ResponseBody()
	Long countAllByExp(
			@RequestParam(value = "excodigo", required = true) String excodigo) {

		SanintervController.logger
				.info("[GET - jqGrid] : Obtener countIntervExp");
		Saninterv filterSaninterv = new Saninterv();
		Expedien expedien = new Expedien();
		expedien.setExcodigo(excodigo);
		filterSaninterv.setExpedien(expedien);

		return this.sanintervService.findAllCount(filterSaninterv);

	}

	/**
	 * Method 'getComboIntervinientes'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/comboIntervinientes", method = RequestMethod.GET)
	public @ResponseBody()
	Object getComboIntervinientes(HttpServletRequest request) throws Exception {

		SanintervController.logger
				.info("[GET - find_ALL] : Obtener combo Intervinientes del Expediente");

		String excodigo = "";

		if (!"".equalsIgnoreCase((String) request.getParameter("excodigo"))
				&& null != (String) request.getParameter("excodigo")) {
			excodigo = (String) request.getParameter("excodigo");

			Pagination pagination = new Pagination();

			pagination.setSort("uanombre");
			pagination.setAscDsc("ASC");

			Long total = new Long(0);

			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				JQGridJSONModel data = new JQGridJSONModel();

				Saninterv interviniente = new Saninterv();
				Expedien exp = new Expedien();
				exp.setExcodigo(excodigo);

				interviniente.setExpedien(exp);
				List<Saninterv> listIntervinientes = this.sanintervService
						.findAllCombo(interviniente, pagination);
				if (listIntervinientes == null) {
					throw new Exception("No data Found.");
				}
				total = this.sanintervService.findAllCount(interviniente);
				data.setRows(listIntervinientes);

				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());

				return data;
			} else {

				Saninterv interviniente = new Saninterv();
				Expedien exp = new Expedien();
				exp.setExcodigo(excodigo);

				interviniente.setExpedien(exp);
				List<Saninterv> listIntervinientes = this.sanintervService
						.findAllCombo(interviniente, pagination);
				if (listIntervinientes == null) {
					throw new Exception("No data Found.");
				}
				total = this.sanintervService.findAllCount(interviniente);

				return listIntervinientes;
			}
		} else {
			throw new Exception("No data Found. EXCODIGO IS NULL");
		}

	}

	/**
	 * Method 'getById'.
	 * 
	 * @param excodigo
	 *            String
	 * @return saninterv Saninterv
	 */
	@RequestMapping(value = "/comprobarDireccion/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Saninterv comprobarDireccion(@PathVariable() String excodigo) {
		Saninterv saninterv = new Saninterv();
		Expedien expedien = new Expedien();
		expedien.setExcodigo(excodigo);
		saninterv.setExpedien(expedien);

		List<Saninterv> listaSantinterv = this.sanintervService.findAll(
				saninterv, null);
		boolean tieneDireccionCompleta = true;
		if (listaSantinterv != null && listaSantinterv.size() > 0) {
			for (int i = 0; i < listaSantinterv.size(); i++) {
				saninterv = listaSantinterv.get(i);
				if (!Y41bConstantes.COD_PAIS_ESTADO.equals(saninterv
						.getUapaisId())) { // si es extranjero
					if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUapaisId())
							&& !Y41bUtils.esNullOCadenaVacia(saninterv
									.getUadireNocapv())) {
						tieneDireccionCompleta = true;
					} else {
						tieneDireccionCompleta = false;
					}
				} else {// si es nacional
					if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUaprovId())
							&& !Y41bUtils.esNullOCadenaVacia(saninterv
									.getUamunId())) {
						if (saninterv.getUamunId() != null
								&& saninterv.getUaprovId() != null) {
							T17Municipio municipio = this.municipioService
									.find(this.crearMunicipio(
											saninterv.getUamunId(),
											saninterv.getUaprovId(), excodigo));
							saninterv.setNombreMunicipio(municipio.getDsO());
						}

						if (saninterv.getUaprovId() != null) {
							T17Provincia provincia = this.provinciaService
									.find(this.crearProvincia(
											saninterv.getUaprovId(), excodigo));
							saninterv.setNombreProvincia(provincia.getDsO());
						}
						if (!Y41bUtils.esNullOCadenaVacia(saninterv
								.getNombreProvincia())
								&& !Y41bUtils.esNullOCadenaVacia(saninterv
										.getNombreMunicipio())) {
							// si es de capv
							if (saninterv.getUaprovId().equals(
									Y41bConstantes.CODIGO_PROVINCIA_ARABA)
									|| saninterv
											.getUaprovId()
											.equals(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)
									|| saninterv
											.getUaprovId()
											.equals(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
								if (!Y41bUtils.esNullOCadenaVacia(saninterv
										.getUacalleId())) {
									tieneDireccionCompleta = true;
								} else {
									tieneDireccionCompleta = false;
								}
							} else { // si no es de capv
								if (!Y41bUtils.esNullOCadenaVacia(saninterv
										.getUadireNocapv())) {// si NO es de
																// capv
									tieneDireccionCompleta = true;
								} else {
									tieneDireccionCompleta = false;
								}
							}
						} else {// Es nacional y no tiene descripcin de
								// provincia y municipio
							tieneDireccionCompleta = false;
						}
					} else {// Es nacional y no tiene provincia
						tieneDireccionCompleta = false;
					}

				}
				if (!tieneDireccionCompleta) {
					break;
				}
			}
		}
		if (tieneDireccionCompleta) {
			saninterv.setDireccionCompleta("OK");
		} else {
			saninterv.setDireccionCompleta("ERROR");
		}
		return saninterv;
	}

	/**
	 * 
	 * @param munId
	 *            String
	 * @param provId
	 *            String
	 * @param excodigo
	 *            String
	 * @return T17Municipio
	 */
	private T17Municipio crearMunicipio(String munId, String provId,
			String excodigo) {
		return new T17Municipio(munId, provId, "", excodigo);
	}

	/**
	 * 
	 * @param provId
	 *            String
	 * @param excodigo
	 *            String
	 * @return T17Provincia
	 */
	private T17Provincia crearProvincia(String provId, String excodigo) {
		return new T17Provincia(provId, "", excodigo);
	}

	/**
	 * Method 'getConsumidorById'.
	 * 
	 * @param uaidinterv
	 *            BigDecimal
	 * @return ConsumidorDetalle
	 */
	@RequestMapping(value = "/detalleConsumidor/{uaidinterv}", method = RequestMethod.GET)
	public @ResponseBody()
	ConsumidorDetalle getConsumidorById(@PathVariable() BigDecimal uaidinterv) {
		try {

			Saninterv saninterv = new Saninterv();
			saninterv.setUaidinterv(uaidinterv);
			saninterv = this.sanintervService.find(saninterv);

			String calle = "";
			if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUacalleId())) {
				try {
					calle = this.t17CalleService.find(
							new T17Calle(Long.parseLong(saninterv
									.getUacalleId()), null)).getDsO();
				} catch (Exception e) {

				}
			}

			ConsumidorDetalle consumidorDetalle = new ConsumidorDetalle(
					saninterv.getUadtcodigo(), saninterv.getUausuultmod(),
					null, saninterv.getUsuarioxlnet(), saninterv.getUaedad(),
					null, saninterv.getUanombre(), saninterv.getUaapellido1(),
					saninterv.getUaapellido2(), saninterv.getUanif(), null,
					null, null, saninterv.getUanrtel(), null, null, null,
					saninterv.getUacoem(), saninterv.getUanrtel2(), null,
					saninterv.getUaidioma(), null, null, null, null, null,
					null, saninterv.getUasexo(), null, null,
					saninterv.getUafecultmod(), null, null, null, null, null,
					null, null, null, null, null, null,
					saninterv.getUatipoidentificacion(),
					saninterv.getUapaisId(), saninterv.getNombrePais(),
					saninterv.getUaprovId(), saninterv.getNombreProvincia(),
					saninterv.getUamunId(), saninterv.getNombreMunicipio(),
					saninterv.getUalocId(), saninterv.getNombreLocalidad(),
					saninterv.getUacalleId(), calle, saninterv.getUacpId(),
					saninterv.getCp(), saninterv.getUaportalId(), null,
					saninterv.getUanombrePiso(), saninterv.getUadireNocapv(),
					saninterv.getDireccionCompleta(), null, null, null,
					Y41bConstantes.COD_PAIS_ESTADO.equals(saninterv
							.getUapaisId()) ? Y41bConstantes.VALOR_NO
							: Y41bConstantes.VALOR_SI);

			return consumidorDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(uaidinterv.toString());
		}
	}

	/**
	 * Method 'getIntervinienteEstablecimiento'.
	 * 
	 * @param idinterviniente
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/detalleEstablecimiento/{idinterviniente}", method = RequestMethod.GET)
	public @ResponseBody
	EstablecimientoDetalle getIntervinienteEstablecimiento(
			@PathVariable BigDecimal idinterviniente, Model model) {
		try {
			Saninterv saninterv = new Saninterv();
			saninterv.setUaidinterv(idinterviniente);
			EstablecimientoDetalle establecimientoDetalle = this.sanintervService
					.findEstablecimiento(saninterv);

			if (establecimientoDetalle == null) {
				throw new Exception(idinterviniente.toString());
			}
			return establecimientoDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idinterviniente.toString());
		}
	}

}
