package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.SanfracsipcaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Sanfracsipca;

/**
 * SanfracsipcaController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sanfracsipca")
public class SanfracsipcaController {

	private static final Logger logger = LoggerFactory
			.getLogger(SanfracsipcaController.class);

	@Autowired()
	private SanfracsipcaService sanfracsipcaService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SanfracsipcaController.logger.info("[GET - View] : sanfracsipca");
		return "sanfracsipca";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param lfid
	 *            Long
	 * @return sanfracsipca Sanfracsipca
	 */
	@RequestMapping(value = "/{lfid}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanfracsipca getById(@PathVariable() Long lfid) {
		Sanfracsipca sanfracsipca = new Sanfracsipca();
		sanfracsipca.setLfid(lfid);
		sanfracsipca = this.sanfracsipcaService.find(sanfracsipca);
		SanfracsipcaController.logger
				.info("[GET - findBy_PK] : Obtener Sanfracsipca por PK");
		return sanfracsipca;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSanfracsipca
	 *            Sanfracsipca
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanfracsipca> getAll(@ModelAttribute() Sanfracsipca filterSanfracsipca) {
		SanfracsipcaController.logger
				.info("[GET - find_ALL] : Obtener Sanfracsipca por filtro");
		return this.sanfracsipcaService.findAll(filterSanfracsipca, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sanfracsipca
	 *            Sanfracsipca
	 * @return Sanfracsipca
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sanfracsipca edit(@RequestBody() Sanfracsipca sanfracsipca) {
		Sanfracsipca sanfracsipcaAux = this.sanfracsipcaService
				.update(sanfracsipca);
		SanfracsipcaController.logger
				.info("[PUT] : Sanfracsipca actualizado correctamente");
		return sanfracsipcaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sanfracsipca
	 *            Sanfracsipca
	 * @return Sanfracsipca
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sanfracsipca add(@RequestBody() Sanfracsipca sanfracsipca) {
		Sanfracsipca sanfracsipcaAux = this.sanfracsipcaService
				.add(sanfracsipca);
		SanfracsipcaController.logger
				.info("[POST] : Sanfracsipca insertado correctamente");
		return sanfracsipcaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param lfid
	 *            Long
	 * @return sanfracsipca
	 */
	@RequestMapping(value = "/{lfid}}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sanfracsipca remove(@PathVariable() Long lfid) {
		Sanfracsipca sanfracsipca = new Sanfracsipca();
		sanfracsipca.setLfid(lfid);
		this.sanfracsipcaService.remove(sanfracsipca);
		SanfracsipcaController.logger
				.info("[DELETE] : Sanfracsipca borrado correctamente");
		return sanfracsipca;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sanfracsipcaIds
	 *            List
	 * @return sanfracsipcaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sanfracsipcaIds) {
		List<Sanfracsipca> sanfracsipcaList = new ArrayList<Sanfracsipca>();
		for (List<String> sanfracsipcaId : sanfracsipcaIds) {
			Iterator<String> iterator = sanfracsipcaId.iterator();
			Sanfracsipca sanfracsipca = new Sanfracsipca(); // NOPMD - Objeto
															// nuevo en la lista
															// (parametro del
															// servicio)
			sanfracsipca.setLfid(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			sanfracsipca.setLftipreg(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLftipop(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfentem(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfsufijo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfnumref(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfdigcon(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLffeclimpa(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLfimporte(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLffecoper(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLffecsolic(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLftipter(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfcif(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfnombre(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfape1(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfape2(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLftel(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLffax(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfemail(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfsigl(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfviapu(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfportal(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfletra(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfescal(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfpiso(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfpuerta(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfcodprov(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfcodmun(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfcodloc(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfcodpos(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfcodcau(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfmotcau(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfpropag(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfmotpro(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfcuenta(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfexgara(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLftipgara(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLffecdep(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLffecaporav(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLfindicsuf(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLffecnotif(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLffecinform(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLffecresol(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLfestimresol(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfmotres(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfnumpl(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLffrecpl(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLffeclim1pa(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLfporcdem(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLftippag(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLftipnot(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLffecnotresol(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLffecinval(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLftipinval(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfmotinval(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLffecalc(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLfimppdte(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfimpint(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLforgresp(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfnumexp(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLffecenv3(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLffecenvcen(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLffeclimpagvol(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLfiban(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfestado(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLffecalta(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLffecmodif(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			sanfracsipca.setLfusualta(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipca.setLfusumodif(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sanfracsipcaList.add(sanfracsipca);
		}
		this.sanfracsipcaService.removeMultiple(sanfracsipcaList);
		SanfracsipcaController.logger
				.info("[POST - DELETE_ALL] : Sanfracsipca borrados correctamente");
		return sanfracsipcaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanfracsipca
	 *            Sanfracsipca
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Sanfracsipca filterSanfracsipca,
			@ModelAttribute() Pagination pagination) {
		List<Sanfracsipca> sanfracsipcas = this.sanfracsipcaService.findAll(
				filterSanfracsipca, pagination);
		Long recordNum = this.sanfracsipcaService
				.findAllCount(filterSanfracsipca);
		SanfracsipcaController.logger
				.info("[GET - jqGrid] : Obtener Sanfracsipca");
		return new JQGridJSONModel(pagination, recordNum, sanfracsipcas);
	}

}
