package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.SanfraccService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.model.Sanfracc;

/**
 * SanfraccController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sanfracc")
public class SanfraccController {

	private static final Logger logger = LoggerFactory
			.getLogger(SanfraccController.class);

	@Autowired()
	private SanfraccService sanfraccService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SanfraccController.logger.info("[GET - View] : sanfracc");
		return "sanfracc";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param faid
	 *            BigDecimal
	 * @return sanfracc Sanfracc
	 */
	@RequestMapping(value = "/{faid}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanfracc getById(@PathVariable() BigDecimal faid) {
		Sanfracc sanfracc = new Sanfracc();
		sanfracc.setFaid(faid);
		sanfracc = this.sanfraccService.find(sanfracc);
		SanfraccController.logger
				.info("[GET - findBy_PK] : Obtener Sanfracc por PK");
		return sanfracc;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSanfracc
	 *            Sanfracc
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanfracc> getAll(@ModelAttribute() Sanfracc filterSanfracc) {
		SanfraccController.logger
				.info("[GET - find_ALL] : Obtener Sanfracc por filtro");
		return this.sanfraccService.findAll(filterSanfracc, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return Sanfracc
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sanfracc edit(@RequestBody() Sanfracc sanfracc) {
		Sanfracc sanfraccAux = this.sanfraccService.update(sanfracc);
		SanfraccController.logger
				.info("[PUT] : Sanfracc actualizado correctamente");
		return sanfraccAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return Sanfracc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sanfracc add(@RequestBody() Sanfracc sanfracc) {
		Sanfracc sanfraccAux = this.sanfraccService.add(sanfracc);
		SanfraccController.logger
				.info("[POST] : Sanfracc insertado correctamente");
		return sanfraccAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param faid
	 *            BigDecimal
	 * @return sanfracc
	 */
	@RequestMapping(value = "/{faid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sanfracc remove(@PathVariable() BigDecimal faid) {
		Sanfracc sanfracc = new Sanfracc();
		sanfracc.setFaid(faid);
		this.sanfraccService.remove(sanfracc);
		SanfraccController.logger
				.info("[DELETE] : Sanfracc borrado correctamente");
		return sanfracc;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sanfraccIds
	 *            List
	 * @return sanfraccList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sanfraccIds) {
		List<Sanfracc> sanfraccList = new ArrayList<Sanfracc>();
		for (List<String> sanfraccId : sanfraccIds) {
			Iterator<String> iterator = sanfraccId.iterator();
			Sanfracc sanfracc = new Sanfracc(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			sanfracc.setFaid(ObjectConversionManager.convert(iterator.next(),
					java.math.BigDecimal.class));
			sanfraccList.add(sanfracc);
		}
		this.sanfraccService.removeMultiple(sanfraccList);
		SanfraccController.logger
				.info("[POST - DELETE_ALL] : Sanfracc borrados correctamente");
		return sanfraccIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanfracc
	 *            Sanfracc
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Sanfracc filterSanfracc,
			@ModelAttribute() Pagination pagination) {
		List<Sanfracc> sanfraccs = this.sanfraccService.findAll(filterSanfracc,
				pagination);
		Long recordNum = this.sanfraccService.findAllCount(filterSanfracc);
		SanfraccController.logger.info("[GET - jqGrid] : Obtener Sanfracc");
		return new JQGridJSONModel(pagination, recordNum, sanfraccs);
	}

}
