package com.ejie.y41b.control;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.SanexprelService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sanexprel;

/**
 * SanexprelController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sanexprel")
public class SanexprelController {

	private static final Logger logger = LoggerFactory
			.getLogger(SanexprelController.class);

	@Autowired()
	private SanexprelService sanexprelService;

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SanexprelController.logger.info("[GET - View] : sanexprel");
		return "sanexprel";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param rlid
	 *            String
	 * @return sanexprel Sanexprel
	 */
	@RequestMapping(value = "/{rlid}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanexprel getById(@PathVariable() String rlid) {
		Sanexprel sanexprel = new Sanexprel();
		sanexprel.setRlid(rlid);
		sanexprel = this.sanexprelService.find(sanexprel);
		SanexprelController.logger
				.info("[GET - findBy_PK] : Obtener Sanexprel por PK");
		return sanexprel;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSanexprel
	 *            Sanexprel
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanexprel> getAll(@ModelAttribute() Sanexprel filterSanexprel) {
		SanexprelController.logger
				.info("[GET - find_ALL] : Obtener Sanexprel por filtro");
		return this.sanexprelService.findAll(filterSanexprel, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Sanexprel
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sanexprel edit(@RequestBody() Sanexprel sanexprel) {
		Sanexprel sanexprelAux = this.sanexprelService.update(sanexprel);
		SanexprelController.logger
				.info("[PUT] : Sanexprel actualizado correctamente");
		return sanexprelAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Sanexprel
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sanexprel add(@RequestBody() Sanexprel sanexprel) {
		Sanexprel sanexprelAux = this.sanexprelService.add(sanexprel);
		SanexprelController.logger
				.info("[POST] : Sanexprel insertado correctamente");
		return sanexprelAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param rlid
	 *            String
	 * @param datos
	 *            String[]
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return sanexprel
	 */
	@RequestMapping(value = "/{rlid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sanexprel remove(@PathVariable() String rlid,
			@RequestBody() String[] datos, HttpServletRequest httpRequest) {
		try {
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			// Actualizar consumidores origen del expediente a borrar como
			// consumidores
			Sanexprel sanexprel = new Sanexprel();
			sanexprel.setRlid(rlid);
			Expedien expedien = new Expedien();
			if (datos != null) {
				expedien.setcodCompleto(datos[0]);
			}
			sanexprel.setExpedienByRlexcodigo(expedien);
			if (datos != null) {
				sanexprel.setCodCompleto(datos[1]);
			}
			this.sanexprelService.remove(sanexprel, censoMonitor);
			SanexprelController.logger
					.info("[DELETE] : Sanexprel borrado correctamente");
			return sanexprel;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sanexprelIds
	 *            List
	 * @return sanexprelList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sanexprelIds) {
		List<Sanexprel> sanexprelList = new ArrayList<Sanexprel>();
		for (List<String> sanexprelId : sanexprelIds) {
			Iterator<String> iterator = sanexprelId.iterator();
			Sanexprel sanexprel = new Sanexprel(); // NOPMD - Objeto nuevo en la
													// lista (parametro del
													// servicio)
			sanexprel.setRlid(ObjectConversionManager.convert(iterator.next(),
					String.class));
			sanexprelList.add(sanexprel);
		}
		this.sanexprelService.removeMultiple(sanexprelList);
		SanexprelController.logger
				.info("[POST - DELETE_ALL] : Sanexprel borrados correctamente");
		return sanexprelIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Sanexprel filterSanexprel,
			@ModelAttribute() Pagination pagination) {
		List<Sanexprel> sanexprels = this.sanexprelService.findAll(
				filterSanexprel, pagination);
		Long recordNum = this.sanexprelService.findAllCount(filterSanexprel);
		SanexprelController.logger.info("[GET - jqGrid] : Obtener Sanexprel");
		return new JQGridJSONModel(pagination, recordNum, sanexprels);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param excodigo
	 *            String
	 * @param rlhdcodigo
	 *            String
	 * @param rlarbcodigo
	 *            String
	 * @param rlinscodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/dameExpRelacionados", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@RequestParam(value = "excodigo", required = false) String excodigo,
			@RequestParam(value = "rlhdcodigo", required = false) String rlhdcodigo,
			@RequestParam(value = "rlarbcodigo", required = false) String rlarbcodigo,
			@RequestParam(value = "rlinscodigo", required = false) String rlinscodigo,
			@ModelAttribute() Pagination pagination) {

		Sanexprel filterSanexprel = new Sanexprel();
		Expedien expedien = new Expedien();
		expedien.setExcodigo(excodigo);
		/*
		 * solo viene relleno uno de los 3, si venimos de sanciones, de
		 * solicitudes o de arbitraje
		 */
		filterSanexprel.setExpedienByRlexcodigo(expedien);
		filterSanexprel.setRlhdcodigo(rlhdcodigo);
		filterSanexprel.setRlarbcodigo(rlarbcodigo);
		filterSanexprel.setRlinscodigo(rlinscodigo);

		List<Sanexprel> sanexprels = this.sanexprelService.findAll(
				filterSanexprel, pagination);
		Long recordNum = this.sanexprelService.findAllCount(filterSanexprel);
		SanexprelController.logger.info("[GET - jqGrid] : Obtener Sanexprel");
		return new JQGridJSONModel(pagination, recordNum, sanexprels);
	}

}
