package com.ejie.y41b.control;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.SandoctempService;
import com.ejie.y41b.service.SanexpService;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.fichero.Y41bFicheroUtils;

/**
 * SanexpController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sanexp")
public class SanexpController {

	private static final Logger logger = LoggerFactory
			.getLogger(SanexpController.class);

	@Autowired()
	private SanexpService sanexpService;

	@Autowired()
	private SandoctempService sandoctempService;

	@Autowired()
	private ExpedienService expedienService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SanexpController.logger.info("[GET - View] : sanexp");
		return "sanexp";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param excodigo
	 *            String
	 * @return sanexp Sanexp
	 */
	@RequestMapping(value = "/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanexp getById(@PathVariable() String excodigo) {
		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(excodigo);
		sanexp = this.sanexpService.find(sanexp);
		SanexpController.logger
				.info("[GET - findBy_PK] : Obtener Sanexp por PK");
		return sanexp;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSanexp
	 *            Sanexp
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanexp> getAll(@ModelAttribute() Sanexp filterSanexp) {
		SanexpController.logger
				.info("[GET - find_ALL] : Obtener Sanexp por filtro");
		return this.sanexpService.findAll(filterSanexp, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sanexp edit(@RequestBody() Sanexp sanexp) {
		Sanexp sanexpAux = this.sanexpService.update(sanexp);
		SanexpController.logger
				.info("[PUT] : Sanexp actualizado correctamente");
		return sanexpAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sanexp add(@RequestBody() Sanexp sanexp) {
		Sanexp sanexpAux = this.sanexpService.add(sanexp);
		SanexpController.logger.info("[POST] : Sanexp insertado correctamente");
		return sanexpAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param excodigo
	 *            String
	 * @return sanexp
	 */
	@RequestMapping(value = "/{excodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sanexp remove(@PathVariable() String excodigo) {
		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(excodigo);
		this.sanexpService.remove(sanexp);
		SanexpController.logger.info("[DELETE] : Sanexp borrado correctamente");
		return sanexp;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sanexpIds
	 *            List
	 * @return sanexpList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sanexpIds) {
		List<Sanexp> sanexpList = new ArrayList<Sanexp>();
		for (List<String> sanexpId : sanexpIds) {
			Iterator<String> iterator = sanexpId.iterator();
			Sanexp sanexp = new Sanexp(); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			sanexp.setExcodigo(ObjectConversionManager.convert(iterator.next(),
					String.class));
			sanexpList.add(sanexp);
		}
		this.sanexpService.removeMultiple(sanexpList);
		SanexpController.logger
				.info("[POST - DELETE_ALL] : Sanexp borrados correctamente");
		return sanexpIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanexp
	 *            Sanexp
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Sanexp filterSanexp,
			@ModelAttribute() Pagination pagination) {
		List<Sanexp> sanexps = this.sanexpService.findAll(filterSanexp,
				pagination);
		Long recordNum = this.sanexpService.findAllCount(filterSanexp);
		SanexpController.logger.info("[GET - jqGrid] : Obtener Sanexp");
		return new JQGridJSONModel(pagination, recordNum, sanexps);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param excodigo
	 *            String
	 * @return sanexp Sanexp
	 */
	@RequestMapping(value = "/dameFaseUltimoTramite/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanexp getFaseYUltimoTramite(@PathVariable() String excodigo) {
		Sanexp sanexp = new Sanexp();
		try {

			sanexp.setExcodigo(excodigo);
			sanexp = this.sanexpService.dameDetallesExpediente(sanexp);
			SanexpController.logger
					.info("[GET - findBy_PK] : Obtener Sanexp por PK");
			return sanexp;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}

	/**
	 * Method 'getDocsByHdcodigo'.
	 * 
	 * @param excodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/imprimirdocumentos/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	void imprimirDocsByHdcodigo(@PathVariable() String excodigo,
			HttpServletResponse response) {
		try {
			SanexpController.logger
					.info("SanexpController - ImprimirDocsByHdcodigo: "
							+ excodigo + ".");

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(excodigo);

			Expedien expedien = this.expedienService
					.find(new Expedien(excodigo));
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
			tramiteComun.setTipoProcedimiento(tipoProcedimiento);

			List<DocumentoExpediente> documentosExpediente = this.sandoctempService
					.findAllDocumentosExpediente(tramiteComun, null);
			SanexpController.logger
					.info("SanexpController - ImprimirDocsByHdcodigo: "
							+ (documentosExpediente == null) + ".");

			if (documentosExpediente == null
					|| documentosExpediente.size() == 0) {
				throw new Exception("No data Found.");
			} else {
				// CONSTRUIR ZIP
				InputStream ficheroStream = null;
				File fileFichero = null;

				Properties prop = Y41bConfig
						.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Ej. /datos/y41b/tmp/zip/
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147

				String strZipDirectory = strTmpZipDirectory
						+ expedien.damecodCompleto();
				// Ej.
				// /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147.zip
				String strZipFile = strZipDirectory
						+ Y41bConstantes.EXTENSION_ZIP;

				// 1. Validamos que exista el directorio TMP para los ZIP. Si no
				// existe, lo creo
				Y41bFicheroUtils.crearDirectorio(strTmpZipDirectory);
				// 2. Validamos que exista el directorio TMP para el ZIP actual.
				// Si
				// no existe, lo creo
				Y41bFicheroUtils.crearDirectorio(strZipDirectory);
				// 3. Creamos el ZIP
				Y41bFicheroUtils.crearFichero(new File(strZipFile));

				// ******* Borramos historico de ficheros con mas de 1 minuto
				// (60000ms) de
				// diferencia en la fecha de creacion
				Y41bFicheroUtils.deleteFilesFromDate(new File(
						strTmpZipDirectory), Y41bConstantes.NUM_60000);

				// **************************************************************
				String nombreFichero = null;
				int numDoc = 1;
				// 4. Recorremos la lista de documentos a zipear y los dejamos
				// en el directorio TMP para el ZIP actual

				SanexpController.logger
						.info("SanexpController - ImprimirDocsByHdcodigo: "
								+ (documentosExpediente.size()) + ".");
				Sandoctemp documentoHechoDetalle = new Sandoctemp();
				for (DocumentoExpediente documento : documentosExpediente) {

					documentoHechoDetalle.setU5codocumento(documento
							.getCodocumento());

					SanexpController.logger
							.info("SanexpController - ImprimirDocsByHdcodigo: DOC:"
									+ documento.getCodocumento() + ".");

					Sandoctemp documentoHechoDetalleAux = this.sandoctempService
							.find(documentoHechoDetalle);

					nombreFichero = documentoHechoDetalleAux.getU5nofile();
					ficheroStream = documentoHechoDetalleAux.getU5datafile()
							.getBinaryStream();

					String local = (String) prop
							.getProperty("y41bVistaWar.entorno.local");
					if ("true".equals(local)) {
						fileFichero = this.crearFichero(strZipDirectory + "\\"
								+ numDoc + "." + nombreFichero);
					} else {
						fileFichero = this.crearFichero(strZipDirectory + "/"
								+ numDoc + "." + nombreFichero);
					}

					Y41bFicheroUtils
							.escribirFichero(ficheroStream, fileFichero);
					ficheroStream.close();
					numDoc++;
				}

				Y41bFicheroUtils.comprimirFichero(new File(strZipDirectory),
						strZipFile);
				// ***********************************************************************

				// PARA DESCARGALO
				File ficheroZip = new File(strZipFile);
				byte[] bFile = new byte[(int) ficheroZip.length()];

				FileInputStream fileInputStream = new FileInputStream(
						ficheroZip);
				fileInputStream.read(bFile);
				fileInputStream.close();

				response.setHeader("Content-Disposition",
						"attachment; filename=\"" + expedien.damecodCompleto()
								+ Y41bConstantes.EXTENSION_ZIP + "\"");
				response.setContentType("application/zip");
				response.setContentLength(bFile.length);
				response.getOutputStream().write(bFile);

				// Vaciamos el stream
				response.getOutputStream().flush();
			}

		} catch (Exception e) {
			throw new Y41bUDAException("No hay ficheros para esta solicitud",
					false, e);
		}
	}

	/**
	 * 
	 * @param path
	 *            String
	 * @return File
	 */
	private File crearFichero(String path) {
		return new File(path);
	}

	// Testeo del parseo de un mensaje JMS que parece haber producido un error
	// private final static String xml =
	// "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\r\n<NotificationBody xmlns=\"com/ejie/notification/xml\">\r\n	<Property>\r\n		<Name>EventWhat</Name>\r\n		<Value>MANAGE_NOTIFICATION_EXPIRATION</Value>\r\n	</Property>\r\n	<Property>\r\n		<Name>EventWho</Name>\r\n		<Value>PASARELA DE NOTIFICACIONES</Value>\r\n	</Property>\r\n	<Property>\r\n		<Name>EventTipology</Name>\r\n		<Value>EXPEDIENTE</Value>\r\n	</Property>\r\n	<Property>\r\n		<Name>EventCorrelationId</Name>\r\n		<Value xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nil=\"true\"/>\r\n	</Property>\r\n	<Property>\r\n		<Name>EventTimeStamp</Name>\r\n		<Value xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nil=\"true\"/>\r\n	</Property>\r\n	<Property>\r\n		<Name>notificationID</Name>\r\n		<Value>R02O8590254D887E2B0EEFF19EE540167128EA550BE7</Value>\r\n	</Property>\r\n	<Property>\r\n		<Name>procedureID</Name>\r\n		<Value>Y41B_SANCIONES</Value>\r\n	</Property>\r\n	<Property>\r\n		<Name>departmentID</Name>\r\n		<Value>94</Value>\r\n	</Property>\r\n	<Property>\r\n		<Name>managingUnitID</Name>\r\n		<Value>2167</Value>\r\n	</Property>\r\n	<Property>\r\n		<Name>folderID</Name>\r\n		<Value/>\r\n	</Property>\r\n	<Property>\r\n		<Name>folderNumber</Name>\r\n		<Value>SAN-48A001-99-2019</Value>\r\n	</Property>\r\n	<Property>\r\n		<Name>DeliveredNotificationInfo</Name>\r\n		<Value>&lt;ns:DeliveredNotificationInfo xmlns:ns=&quot;com/ejie/horizontalSystemOfNotification/xml&quot;&gt;&lt;ns:notificationID&gt;R02O8590254D887E2B0EEFF19EE540167128EA550BE7&lt;/ns:notificationID&gt;&lt;ns:procedureID&gt;Y41B_SANCIONES&lt;/ns:procedureID&gt;&lt;ns:departmentID&gt;94&lt;/ns:departmentID&gt;&lt;ns:managingUnitID&gt;2167&lt;/ns:managingUnitID&gt;&lt;ns:folderID/&gt;&lt;ns:folderNumber&gt;SAN-48A001-99-2019&lt;/ns:folderNumber&gt;&lt;ns:notifiedActID&gt;ACUERDOINCOACION&lt;/ns:notifiedActID&gt;&lt;ns:addresseeID&gt;13912387D&lt;/ns:addresseeID&gt;&lt;ns:deliveryStatus&gt;3&lt;/ns:deliveryStatus&gt;&lt;ns:deliveryPersonID xsi:nil=&quot;true&quot; xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot;/&gt;&lt;ns:deliveryPersonName xsi:nil=&quot;true&quot; xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot;/&gt;&lt;ns:deliveryTimestamp&gt;2019-07-16T00:06:01&lt;/ns:deliveryTimestamp&gt;&lt;/ns:DeliveredNotificationInfo&gt;</Value>\r\n	</Property>\r\n	<Property>\r\n		<Name>entity</Name>\r\n		<Value>04833001</Value>\r\n	</Property>\r\n</NotificationBody>";
	//
	// /**
	// * Method 'getPrueba'.
	// */
	// @RequestMapping(value = "/prueba", method = RequestMethod.GET)
	// public void prueba() {
	// Map mapa = Y41bJMSHelper.parsearMensajeJms(this.xml);
	// (System.out).println("INICIO");
	// (System.out).println("1");
	// (System.out).println("notificationID: "
	// + (String) mapa.get("notificationID"));
	// (System.out).println("Iguales?: "
	// + ("R02O8590254D887E2B0EEFF19EE540167128EA550BE7"
	// .equals((String) mapa.get("notificationID"))));
	// (System.out).println("2");
	// (System.out).println("FIN");
	// }
}
