package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.SanenvioService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sanenvio;

/**
 * SanenvioController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sanenvio")
public class SanenvioController {

	private static final Logger logger = LoggerFactory
			.getLogger(SanenvioController.class);

	@Autowired()
	private SanenvioService sanenvioService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SanenvioController.logger.info("[GET - View] : sanenvio");
		return "sanenvio";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param enid
	 *            BigDecimal
	 * @return sanenvio Sanenvio
	 */
	@RequestMapping(value = "/{enid}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanenvio getById(@PathVariable() BigDecimal enid) {
		Sanenvio sanenvio = new Sanenvio();
		sanenvio.setEnid(enid);
		sanenvio = this.sanenvioService.find(sanenvio);
		SanenvioController.logger
				.info("[GET - findBy_PK] : Obtener Sanenvio por PK");
		return sanenvio;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSanenvio
	 *            Sanenvio
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanenvio> getAll(@ModelAttribute() Sanenvio filterSanenvio) {
		SanenvioController.logger
				.info("[GET - find_ALL] : Obtener Sanenvio por filtro");
		return this.sanenvioService.findAll(filterSanenvio, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @return Sanenvio
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sanenvio edit(@RequestBody() Sanenvio sanenvio) {
		Sanenvio sanenvioAux = this.sanenvioService.update(sanenvio);
		SanenvioController.logger
				.info("[PUT] : Sanenvio actualizado correctamente");
		return sanenvioAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @return Sanenvio
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sanenvio add(@RequestBody() Sanenvio sanenvio) {
		Sanenvio sanenvioAux = this.sanenvioService.add(sanenvio);
		SanenvioController.logger
				.info("[POST] : Sanenvio insertado correctamente");
		return sanenvioAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param enid
	 *            BigDecimal
	 * @return sanenvio
	 */
	@RequestMapping(value = "/{enid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sanenvio remove(@PathVariable() BigDecimal enid) {
		Sanenvio sanenvio = new Sanenvio();
		sanenvio.setEnid(enid);
		this.sanenvioService.remove(sanenvio);
		SanenvioController.logger
				.info("[DELETE] : Sanenvio borrado correctamente");
		return sanenvio;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sanenvioIds
	 *            List
	 * @return sanenvioList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sanenvioIds) {
		List<Sanenvio> sanenvioList = new ArrayList<Sanenvio>();
		for (List<String> sanenvioId : sanenvioIds) {
			Iterator<String> iterator = sanenvioId.iterator();
			Sanenvio sanenvio = new Sanenvio(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			sanenvio.setEnid(ObjectConversionManager.convert(iterator.next(),
					java.math.BigDecimal.class));
			sanenvioList.add(sanenvio);
		}
		this.sanenvioService.removeMultiple(sanenvioList);
		SanenvioController.logger
				.info("[POST - DELETE_ALL] : Sanenvio borrados correctamente");
		return sanenvioIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanenvio
	 *            Sanenvio
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Sanenvio filterSanenvio,
			@ModelAttribute() Pagination pagination) {
		List<Sanenvio> sanenvios = this.sanenvioService.findAll(filterSanenvio,
				pagination);
		Long recordNum = this.sanenvioService.findAllCount(filterSanenvio);
		SanenvioController.logger.info("[GET - jqGrid] : Obtener Sanenvio");
		return new JQGridJSONModel(pagination, recordNum, sanenvios);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param excodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/dameEnviosExp", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@RequestParam(value = "excodigo", required = false) String excodigo,
			@ModelAttribute() Pagination pagination) {
		Sanenvio filterSanenvio = new Sanenvio();
		Expedien expedien = new Expedien();
		expedien.setExcodigo(excodigo);
		filterSanenvio.setExpedien(expedien);

		List<Sanenvio> sanenvios = this.sanenvioService.findAll(filterSanenvio,
				pagination);
		Long recordNum = this.sanenvioService.findAllCount(filterSanenvio);
		SanenvioController.logger.info("[GET - jqGrid] : Obtener Sanenvio");
		return new JQGridJSONModel(pagination, recordNum, sanenvios);
	}
}
