package com.ejie.y41b.control;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.service.SandoctempService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SandoctempController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sandoctemp")
public class SandoctempController {

	private static final Logger logger = LoggerFactory.getLogger(SandoctempController.class);

	@Autowired()
	private SandoctempService sandoctempService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SandoctempController.logger.info("[GET - View] : sandoctemp");
		return "sandoctemp";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param u5codocumento
	 *            String
	 * @return sandoctemp Sandoctemp
	 */
	@RequestMapping(value = "/{u5codocumento}", method = RequestMethod.GET)
	public @ResponseBody() Sandoctemp getById(@PathVariable() String u5codocumento) {
		Sandoctemp sandoctemp = new Sandoctemp();
		sandoctemp.setU5codocumento(u5codocumento);
		try {
			sandoctemp = this.sandoctempService.find(sandoctemp);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
		SandoctempController.logger.info("[GET - findBy_PK] : Obtener Sandoctemp por PK");
		return sandoctemp;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSandoctemp
	 *            Sandoctemp
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody() List<Sandoctemp> getAll(@ModelAttribute() Sandoctemp filterSandoctemp) {
		SandoctempController.logger.info("[GET - find_ALL] : Obtener Sandoctemp por filtro");
		return this.sandoctempService.findAll(filterSandoctemp, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() Sandoctemp edit(@RequestBody() Sandoctemp sandoctemp) {
		Sandoctemp sandoctempAux = this.sandoctempService.update(sandoctemp);
		SandoctempController.logger.info("[PUT] : Sandoctemp actualizado correctamente");
		return sandoctempAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() Sandoctemp add(@RequestBody() Sandoctemp sandoctemp) {
		Sandoctemp sandoctempAux = this.sandoctempService.add(sandoctemp);
		SandoctempController.logger.info("[POST] : Sandoctemp insertado correctamente");
		return sandoctempAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param u5codocumento
	 *            String
	 * @return sandoctemp
	 */
	@RequestMapping(value = "/{u5codocumento}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() Sandoctemp remove(@PathVariable() String u5codocumento) {
		Sandoctemp sandoctemp = new Sandoctemp();
		sandoctemp.setU5codocumento(u5codocumento);
		this.sandoctempService.remove(sandoctemp);
		SandoctempController.logger.info("[DELETE] : Sandoctemp borrado correctamente");
		return sandoctemp;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sandoctempIds
	 *            List
	 * @return sandoctempList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() List<List<String>> removeMultiple(@RequestBody() List<List<String>> sandoctempIds) {
		List<Sandoctemp> sandoctempList = new ArrayList<Sandoctemp>();
		for (List<String> sandoctempId : sandoctempIds) {
			Iterator<String> iterator = sandoctempId.iterator();
			Sandoctemp sandoctemp = new Sandoctemp(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			sandoctemp.setU5codocumento(iterator.next());
			sandoctempList.add(sandoctemp);
		}
		this.sandoctempService.removeMultiple(sandoctempList);
		SandoctempController.logger.info("[POST - DELETE_ALL] : Sandoctemp borrados correctamente");
		return sandoctempIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSandoctemp
	 *            Sandoctemp
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGrid(@ModelAttribute() Sandoctemp filterSandoctemp,
			@ModelAttribute() Pagination pagination) {
		List<Sandoctemp> sandoctemps = this.sandoctempService.findAll(filterSandoctemp, pagination);
		Long recordNum = new Long(0);
		SandoctempController.logger.info("[GET - jqGrid] : Obtener Sandoctemp");
		return new JQGridJSONModel(pagination, recordNum, sandoctemps);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param excodigo
	 *            String
	 * @param tipoProcedimiento
	 *            String
	 * @param filterSandoctemp
	 *            Sandoctemp
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/findAllDocumentsExp/{excodigo}/{tipoProcedimiento}", method = RequestMethod.GET, headers = {
			"JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGridDocExp(@PathVariable() String excodigo,
			@PathVariable() String tipoProcedimiento, @ModelAttribute() Sandoctemp filterSandoctemp,
			@ModelAttribute() Pagination pagination) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(excodigo);
		tramiteComun.setTipoProcedimiento(new TipoProcedimiento(tipoProcedimiento));

		List<DocumentoExpediente> sandoctemps = this.sandoctempService.findAllDocumentosExpediente(tramiteComun,
				pagination);

		Long recordNum = this.sandoctempService.findAllDocumentosExpedienteCount(tramiteComun);
		SandoctempController.logger.info("[GET - jqGrid] : Obtener Sandoctemp");
		return new JQGridJSONModel(pagination, recordNum, sandoctemps);
	}

	/**
	 * Method 'getByIdDocumentoComunicacion'.
	 * 
	 * @param codocumento
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{codocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumentoComunicacion(@PathVariable() String codocumento,
			HttpServletResponse response) {
		try {
			Sandoctemp sandoctemp = new Sandoctemp();
			sandoctemp.setU5codocumento(codocumento);
			sandoctemp = this.sandoctempService.find(sandoctemp);

			Blob contenido = sandoctemp.getU5datafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(sandoctemp.getU5nofile()) + "\"");
			response.setContentType(sandoctemp.getU5conttype());
			response.setContentLength(sandoctemp.getU5sizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllDocumentosTramite'.
	 * 
	 * @param idTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocumentosTramite/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocumentosTramite(@PathVariable() String idTramite,
			HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(idTramite);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Sandoctemp> listDocumentoHecho = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null) {
					listDocumentoHecho = this.sandoctempService.findAllDocumentosTramite(tramiteComun, pagination);
				}

				if (listDocumentoHecho == null) {
					throw new Exception("No data Found.");
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null) {
					total = this.sandoctempService.findAllDocumentosTramiteCount(tramiteComun);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listDocumentoHecho);
				return data;
			} else {
				List<Sandoctemp> listDocumentoHecho = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)) {
					listDocumentoHecho = this.sandoctempService.findAllDocumentosTramite(tramiteComun, null);
				}
				if (listDocumentoHecho == null) {
					throw new Exception("No data Found.");
				}
				return listDocumentoHecho;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getDocumentosTramiteForm'.
	 * 
	 * @param idTramiteSanciones
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "documentosTramite/{idTramiteSanciones}", method = RequestMethod.GET)
	public ModelAndView getDocumentosTramiteForm(@PathVariable() String idTramiteSanciones, Model model) {

		model.addAttribute("idTramiteSanciones", idTramiteSanciones);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("documentosTramiteSanciones", "model", model);
	}
}
