package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Sancuesproced;
import com.ejie.y41b.service.SancuesprocedService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SancuesprocedController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sancuesproced")
public class SancuesprocedController {

	private static final Logger logger = LoggerFactory
			.getLogger(SancuesprocedController.class);

	@Autowired()
	private SancuesprocedService sancuesprocedService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintProcedimental", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		SancuesprocedController.logger.info("[GET - View] : sancuesproced");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return "accessDeniedEscritorio";
		} else {
			return "procedimentalBusqueda";
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param cpcodigo
	 *            String
	 * @return sancuesproced Sancuesproced
	 */
	@RequestMapping(value = "/{cpcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Sancuesproced getById(@PathVariable() String cpcodigo) {
		Sancuesproced sancuesproced = new Sancuesproced();
		sancuesproced.setCpcodigo(cpcodigo);
		sancuesproced = this.sancuesprocedService.find(sancuesproced);
		SancuesprocedController.logger
				.info("[GET - findBy_PK] : Obtener Sancuesproced por PK");
		return sancuesproced;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSancuesproced
	 *            Sancuesproced
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sancuesproced> getAll(
			@ModelAttribute() Sancuesproced filterSancuesproced) {
		SancuesprocedController.logger
				.info("[GET - find_ALL] : Obtener Sancuesproced por filtro");
		return this.sancuesprocedService.findAll(filterSancuesproced, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return Sancuesproced
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sancuesproced edit(@RequestBody() Sancuesproced sancuesproced) {
		Sancuesproced sancuesprocedAux = this.sancuesprocedService
				.update(sancuesproced);
		SancuesprocedController.logger
				.info("[PUT] : Sancuesproced actualizado correctamente");
		return sancuesprocedAux;
	}

	/**
	 * Method 'getCreateFormModProcedimental'.
	 * 
	 * @param codProcedimental
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modSancuesproced/{codProcedimental}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModProcedimental(
			@PathVariable() String codProcedimental, Model model,
			HttpServletRequest request) {

		model.addAttribute("codProcedimental", codProcedimental);

		model.addAttribute("modoProcedimental",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Sancuesproced procedimental = new Sancuesproced();
		procedimental.setCpcodigo(codProcedimental);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("procedimentalDetalle", "model", model);
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return Sancuesproced
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sancuesproced add(@RequestBody() Sancuesproced sancuesproced) {
		Sancuesproced sancuesprocedAux = this.sancuesprocedService
				.add(sancuesproced);
		SancuesprocedController.logger
				.info("[POST] : Sancuesproced insertado correctamente");
		return sancuesprocedAux;
	}

	/**
	 * Method 'getCreateFormAltaProcedimental'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaProcedimental", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaProcedimental(Model model,
			HttpServletRequest request) {

		model.addAttribute("codProcedimental", Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoProcedimental", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("procedimentalDetalle", "model", model);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param cpcodigo
	 *            String
	 * @return sancuesproced
	 */
	@RequestMapping(value = "/{cpcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sancuesproced remove(@PathVariable() String cpcodigo) {
		Sancuesproced sancuesproced = new Sancuesproced();
		sancuesproced.setCpcodigo(cpcodigo);
		this.sancuesprocedService.updateFechaBaja(sancuesproced);
		SancuesprocedController.logger
				.info("[DELETE] : Sancuesproced borrado correctamente");
		return sancuesproced;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sancuesprocedIds
	 *            List
	 * @return sancuesprocedList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sancuesprocedIds) {
		List<Sancuesproced> sancuesprocedList = new ArrayList<Sancuesproced>();
		for (List<String> sancuesprocedId : sancuesprocedIds) {
			Iterator<String> iterator = sancuesprocedId.iterator();
			Sancuesproced sancuesproced = new Sancuesproced(); // NOPMD - Objeto
																// nuevo en la
																// lista
																// (parametro
																// del servicio)
			sancuesproced.setCpcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sancuesprocedList.add(sancuesproced);
		}
		this.sancuesprocedService.removeMultiple(sancuesprocedList);
		SancuesprocedController.logger
				.info("[POST - DELETE_ALL] : Sancuesproced borrados correctamente");
		return sancuesprocedIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSancuesproced
	 *            Sancuesproced
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Sancuesproced filterSancuesproced,
			@ModelAttribute() Pagination pagination) {
		List<Sancuesproced> sancuesproceds = this.sancuesprocedService.findAll(
				filterSancuesproced, pagination);
		Long recordNum = this.sancuesprocedService
				.findAllCount(filterSancuesproced);
		SancuesprocedController.logger
				.info("[GET - jqGrid] : Obtener Sancuesproced");
		return new JQGridJSONModel(pagination, recordNum, sancuesproceds);
	}

	/**
	 * Method 'getComboCuestionproc'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody()
	List<Sancuesproced> getComboCuestionproc(HttpServletRequest request) {

		SancuesprocedController.logger
				.info("[GET - find_ALL] : Obtener combo Cuestionproc");
		Sancuesproced filterSancuesproced = new Sancuesproced();
		/*
		 * desde la ficha de expedientes
		 */
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("cpdesces");
		} else {
			pagination.setSort("cpdesceu");
		}
		pagination.setAscDsc("ASC");

		return this.sancuesprocedService.findAll(filterSancuesproced,
				pagination);
	}

	/**
	 * Method 'getComboCuestionproc'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/comboAlta", method = RequestMethod.GET)
	public @ResponseBody()
	List<Sancuesproced> getComboCuestionprocAlta(HttpServletRequest request) {

		SancuesprocedController.logger
				.info("[GET - find_ALL] : Obtener combo Cuestionproc");
		Sancuesproced filterSancuesproced = new Sancuesproced();
		/*
		 * desde la ficha de expedientes
		 */
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("cpdesces");
		} else {
			pagination.setSort("cpdesceu");
		}
		pagination.setAscDsc("ASC");

		return this.sancuesprocedService.findAllAlta(filterSancuesproced,
				pagination);
	}

	/**
	 * Method 'getAllSancuesproced'. de tipo like
	 * 
	 * @param cpcodigo_
	 *            String
	 * @param cpdesces_
	 *            String
	 * @param cpdesceu_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllProcedimental(
			@RequestParam(value = "cpcodigo", required = false) String cpcodigo_,
			@RequestParam(value = "cpdesces", required = false) String cpdesces_,
			@RequestParam(value = "cpdesceu", required = false) String cpdesceu_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String cpcodigo = ("".equals(cpcodigo_)) ? null : cpcodigo_;
			String cpdesces = ("".equals(cpdesces_)) ? null : cpdesces_;
			String cpdesceu = ("".equals(cpdesceu_)) ? null : cpdesceu_;

			Sancuesproced filterSancuesproced = new Sancuesproced(cpcodigo,
					cpdesces, cpdesceu);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Sancuesproced> procedimentales = this.sancuesprocedService
						.findAllLike(filterSancuesproced, pagination, false);

				if (procedimentales == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.sancuesprocedService.findAllLikeCount(
						filterSancuesproced, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(procedimentales);
				return data;
			} else {
				List<Sancuesproced> procedimentales = this.sancuesprocedService
						.findAllLike(filterSancuesproced, pagination, false);
				if (procedimentales == null) {
					throw new Exception("No data Found.");
				}
				return procedimentales;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

}
