package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.SancuesfondoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Sancuesfondo;

/**
 * SancuesfondoController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sancuesfondo")
public class SancuesfondoController {

	private static final Logger logger = LoggerFactory
			.getLogger(SancuesfondoController.class);

	@Autowired()
	private SancuesfondoService sancuesfondoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SancuesfondoController.logger.info("[GET - View] : sancuesfondo");
		return "sancuesfondo";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param cfcodigo
	 *            String
	 * @return sancuesfondo Sancuesfondo
	 */
	@RequestMapping(value = "/{cfcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Sancuesfondo getById(@PathVariable() String cfcodigo) {
		Sancuesfondo sancuesfondo = new Sancuesfondo();
		sancuesfondo.setCfcodigo(cfcodigo);
		sancuesfondo = this.sancuesfondoService.find(sancuesfondo);
		SancuesfondoController.logger
				.info("[GET - findBy_PK] : Obtener Sancuesfondo por PK");
		return sancuesfondo;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSancuesfondo
	 *            Sancuesfondo
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sancuesfondo> getAll(@ModelAttribute() Sancuesfondo filterSancuesfondo) {
		SancuesfondoController.logger
				.info("[GET - find_ALL] : Obtener Sancuesfondo por filtro");
		return this.sancuesfondoService.findAll(filterSancuesfondo, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sancuesfondo
	 *            Sancuesfondo
	 * @return Sancuesfondo
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sancuesfondo edit(@RequestBody() Sancuesfondo sancuesfondo) {
		Sancuesfondo sancuesfondoAux = this.sancuesfondoService
				.update(sancuesfondo);
		SancuesfondoController.logger
				.info("[PUT] : Sancuesfondo actualizado correctamente");
		return sancuesfondoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sancuesfondo
	 *            Sancuesfondo
	 * @return Sancuesfondo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sancuesfondo add(@RequestBody() Sancuesfondo sancuesfondo) {
		Sancuesfondo sancuesfondoAux = this.sancuesfondoService
				.add(sancuesfondo);
		SancuesfondoController.logger
				.info("[POST] : Sancuesfondo insertado correctamente");
		return sancuesfondoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param cfcodigo
	 *            String
	 * @return sancuesfondo
	 */
	@RequestMapping(value = "/{cfcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sancuesfondo remove(@PathVariable() String cfcodigo) {
		Sancuesfondo sancuesfondo = new Sancuesfondo();
		sancuesfondo.setCfcodigo(cfcodigo);
		this.sancuesfondoService.remove(sancuesfondo);
		SancuesfondoController.logger
				.info("[DELETE] : Sancuesfondo borrado correctamente");
		return sancuesfondo;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sancuesfondoIds
	 *            List
	 * @return sancuesfondoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sancuesfondoIds) {
		List<Sancuesfondo> sancuesfondoList = new ArrayList<Sancuesfondo>();
		for (List<String> sancuesfondoId : sancuesfondoIds) {
			Iterator<String> iterator = sancuesfondoId.iterator();
			Sancuesfondo sancuesfondo = new Sancuesfondo(); // NOPMD - Objeto
															// nuevo en la lista
															// (parametro del
															// servicio)
			sancuesfondo.setCfcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			sancuesfondoList.add(sancuesfondo);
		}
		this.sancuesfondoService.removeMultiple(sancuesfondoList);
		SancuesfondoController.logger
				.info("[POST - DELETE_ALL] : Sancuesfondo borrados correctamente");
		return sancuesfondoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSancuesfondo
	 *            Sancuesfondo
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Sancuesfondo filterSancuesfondo,
			@ModelAttribute() Pagination pagination) {
		List<Sancuesfondo> sancuesfondos = this.sancuesfondoService.findAll(
				filterSancuesfondo, pagination);
		Long recordNum = this.sancuesfondoService
				.findAllCount(filterSancuesfondo);
		SancuesfondoController.logger
				.info("[GET - jqGrid] : Obtener Sancuesfondo");
		return new JQGridJSONModel(pagination, recordNum, sancuesfondos);
	}

}
