package com.ejie.y41b.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Sancontrolplazos;
import com.ejie.y41b.service.SancontrolplazosService;

/**
 * SancontrolplazosController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sancontrolplazos")
public class SancontrolplazosController {

	private static final Logger logger = LoggerFactory
			.getLogger(SancontrolplazosController.class);

	@Autowired()
	private SancontrolplazosService sancontrolplazosService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SancontrolplazosController.logger
				.info("[GET - View] : sancontrolplazos");
		return "sancontrolplazos";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param coid
	 *            BigDecimal
	 * @return sancontrolplazos Sancontrolplazos
	 */
	@RequestMapping(value = "/{coid}", method = RequestMethod.GET)
	public @ResponseBody()
	Sancontrolplazos getById(@PathVariable() BigDecimal coid) {
		Sancontrolplazos sancontrolplazos = new Sancontrolplazos();
		sancontrolplazos.setCoid(coid);
		sancontrolplazos = this.sancontrolplazosService.find(sancontrolplazos);
		SancontrolplazosController.logger
				.info("[GET - findBy_PK] : Obtener Sancontrolplazos por PK");
		return sancontrolplazos;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSancontrolplazos
	 *            Sancontrolplazos
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sancontrolplazos> getAll(
			@ModelAttribute() Sancontrolplazos filterSancontrolplazos) {
		SancontrolplazosController.logger
				.info("[GET - find_ALL] : Obtener Sancontrolplazos por filtro");
		return this.sancontrolplazosService.findAll(filterSancontrolplazos,
				null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sancontrolplazos
	 *            Sancontrolplazos
	 * @return Sancontrolplazos
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sancontrolplazos edit(@RequestBody() Sancontrolplazos sancontrolplazos) {
		Sancontrolplazos sancontrolplazosAux = this.sancontrolplazosService
				.update(sancontrolplazos);
		SancontrolplazosController.logger
				.info("[PUT] : Sancontrolplazos actualizado correctamente");
		return sancontrolplazosAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sancontrolplazos
	 *            Sancontrolplazos
	 * @return Sancontrolplazos
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sancontrolplazos add(@RequestBody() Sancontrolplazos sancontrolplazos) {
		Sancontrolplazos sancontrolplazosAux = this.sancontrolplazosService
				.add(sancontrolplazos);
		SancontrolplazosController.logger
				.info("[POST] : Sancontrolplazos insertado correctamente");
		return sancontrolplazosAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param coid
	 *            BigDecimal
	 * @return sancontrolplazos
	 */
	@RequestMapping(value = "/{coid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sancontrolplazos remove(@PathVariable() BigDecimal coid) {
		Sancontrolplazos sancontrolplazos = new Sancontrolplazos();
		sancontrolplazos.setCoid(coid);
		this.sancontrolplazosService.remove(sancontrolplazos);
		SancontrolplazosController.logger
				.info("[DELETE] : Sancontrolplazos borrado correctamente");
		return sancontrolplazos;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sancontrolplazosIds
	 *            List
	 * @return sancontrolplazosList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sancontrolplazosIds) {
		List<Sancontrolplazos> sancontrolplazosList = new ArrayList<Sancontrolplazos>();
		for (List<String> sancontrolplazosId : sancontrolplazosIds) {
			Iterator<String> iterator = sancontrolplazosId.iterator();
			Sancontrolplazos sancontrolplazos = new Sancontrolplazos(); // NOPMD
																		// -
																		// Objeto
																		// nuevo
																		// en la
																		// lista
																		// (parametro
																		// del
																		// servicio)
			sancontrolplazos.setCoid(ObjectConversionManager.convert(
					iterator.next(), java.math.BigDecimal.class));
			sancontrolplazosList.add(sancontrolplazos);
		}
		this.sancontrolplazosService.removeMultiple(sancontrolplazosList);
		SancontrolplazosController.logger
				.info("[POST - DELETE_ALL] : Sancontrolplazos borrados correctamente");
		return sancontrolplazosIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSancontrolplazos
	 *            Sancontrolplazos
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Sancontrolplazos filterSancontrolplazos,
			@ModelAttribute() Pagination pagination) {
		List<Sancontrolplazos> sancontrolplazoss = this.sancontrolplazosService
				.findAll(filterSancontrolplazos, pagination);
		Long recordNum = this.sancontrolplazosService
				.findAllCount(filterSancontrolplazos);
		SancontrolplazosController.logger
				.info("[GET - jqGrid] : Obtener Sancontrolplazos");
		return new JQGridJSONModel(pagination, recordNum, sancontrolplazoss);
	}

}
