package com.ejie.y41b.control;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sanbandeja;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.SanbandejaService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SanbandejaController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sanbandeja")
public class SanbandejaController {

	private static final Logger logger = LoggerFactory
			.getLogger(SanbandejaController.class);

	@Autowired()
	private SanbandejaService sanbandejaService;

	@Autowired()
	private CensoMonitorService censoMonitorService;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private ExpedienService expedienService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		SanbandejaController.logger.info("[GET - View] : sanbandeja");
		return "sanbandeja";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param baid
	 *            String
	 * @return sanbandeja Sanbandeja
	 */
	@RequestMapping(value = "/{baid}", method = RequestMethod.GET)
	public @ResponseBody()
	Sanbandeja getById(@PathVariable() String baid) {
		Sanbandeja sanbandeja = new Sanbandeja();
		sanbandeja.setBaid(baid);
		sanbandeja = this.sanbandejaService.find(sanbandeja);
		SanbandejaController.logger
				.info("[GET - findBy_PK] : Obtener Sanbandeja por PK");
		return sanbandeja;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterSanbandeja
	 *            Sanbandeja
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Sanbandeja> getAll(@ModelAttribute() Sanbandeja filterSanbandeja) {
		SanbandejaController.logger
				.info("[GET - find_ALL] : Obtener Sanbandeja por filtro");
		return this.sanbandejaService.findAll(filterSanbandeja, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Sanbandeja
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Sanbandeja edit(@RequestBody() Sanbandeja sanbandeja) {
		Sanbandeja sanbandejaAux = this.sanbandejaService.update(sanbandeja);
		SanbandejaController.logger
				.info("[PUT] : Sanbandeja actualizado correctamente");
		return sanbandejaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Sanbandeja
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Sanbandeja add(@RequestBody() Sanbandeja sanbandeja) {
		Sanbandeja sanbandejaAux = this.sanbandejaService.add(sanbandeja);
		SanbandejaController.logger
				.info("[POST] : Sanbandeja insertado correctamente");
		return sanbandejaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param baid
	 *            String
	 * @return sanbandeja
	 */
	@RequestMapping(value = "/{baid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Sanbandeja remove(@PathVariable() String baid) {
		Sanbandeja sanbandeja = new Sanbandeja();
		sanbandeja.setBaid(baid);
		this.sanbandejaService.remove(sanbandeja);
		SanbandejaController.logger
				.info("[DELETE] : Sanbandeja borrado correctamente");
		return sanbandeja;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sanbandejaIds
	 *            List
	 * @return sanbandejaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> sanbandejaIds) {
		List<Sanbandeja> sanbandejaList = new ArrayList<Sanbandeja>();
		for (List<String> sanbandejaId : sanbandejaIds) {
			Iterator<String> iterator = sanbandejaId.iterator();
			Sanbandeja sanbandeja = new Sanbandeja(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			sanbandeja.setBaid(ObjectConversionManager.convert(iterator.next(),
					String.class));
			sanbandejaList.add(sanbandeja);
		}
		this.sanbandejaService.removeMultiple(sanbandejaList);
		SanbandejaController.logger
				.info("[POST - DELETE_ALL] : Sanbandeja borrados correctamente");
		return sanbandejaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            the request
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Sanbandeja filterSanbandeja,
			@ModelAttribute() Pagination pagination,
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "mocodigo", required = false) String mocodigo_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "pcodigo", required = false) String pcodigo_,
			@RequestParam(value = "accoororigen", required = false) String accoororigen_,
			@RequestParam(value = "atcocm", required = false) String atcocm_,
			HttpServletRequest request) {
		try {

			// EVOLUTIVO 0135083 2.10
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String mocodigo = ("".equals(mocodigo_)) ? null : mocodigo_;
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			// EVOLUTIVO 0150942
			String pcodigo = ("".equals(pcodigo_)) ? null : pcodigo_;
			String accoororigen = ("".equals(accoororigen_)) ? null
					: accoororigen_;
			String atcocm = ("".equals(atcocm_)) ? null : atcocm_;

			SanbandejaController.logger.info("desde: " + trFechaDesde
					+ " hasta: " + trFechaHasta + " trcodigo: " + trcodigo
					+ " mocodigo: " + mocodigo + " codOrg: " + codOrg
					+ " pcodigo: " + pcodigo + " accoororigen: " + accoororigen
					+ " atcocm: " + atcocm);
			// EVOLUTIVO 0135083 2.10
			// EVOLUTIVO 0150942 aniadimos pcodigo

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			String oficina = "";
			oficina = censoMonitor.getOrganismo().getCodOrg();
			filterSanbandeja.setExpedien(new Expedien());
			filterSanbandeja.getExpedien().setExcoor(oficina);
			filterSanbandeja.setMonitor(censoMonitor);
			// EVOLUTIVO 0135083 2.10
			filterSanbandeja.setTrcodigo(trcodigo);
			filterSanbandeja.setMocodigo(mocodigo);
			filterSanbandeja.setCodOrg(codOrg);
			filterSanbandeja.setTrFechaDesde(trFechaDesde);
			filterSanbandeja.setTrFechaHasta(trFechaHasta);
			// EVOLUTIVO 0135083 2.10
			// EVOLUTIVO 0150942
			filterSanbandeja.setPcodigo(pcodigo);
			filterSanbandeja.setAccoororigen(accoororigen);
			filterSanbandeja.setAtcocm(atcocm);

			String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();

			List<Sanbandeja> sanbandejas = this.sanbandejaService.dameBandeja(
					filterSanbandeja, pagination, censoMonitor, perfil);

			request.getSession().setAttribute("paginationSanbandeja",
					pagination);

			httpSession.setAttribute("sanbandejaBusqueda", filterSanbandeja);

			Long recordNum = this.sanbandejaService.dameBandejaCount(
					filterSanbandeja, censoMonitor, perfil);

			SanbandejaController.logger
					.info("[GET - jqGrid] : Obtener Sanbandeja");

			return new JQGridJSONModel(pagination, recordNum, sanbandejas);
		} catch (Exception e) {
			e.printStackTrace();
			SanbandejaController.logger.error(
					"Error producido en getAllJQGrid: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanbandeja
	 *            Sanbandeja
	 * @param request
	 *            the request
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/sanbandejaSession", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGridSession(
			@ModelAttribute() Sanbandeja filterSanbandeja,
			@ModelAttribute() Pagination paginationReq,
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "mocodigo", required = false) String mocodigo_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "pcodigo", required = false) String pcodigo_,
			@RequestParam(value = "accoororigen", required = false) String accoororigen_,
			@RequestParam(value = "atcocm", required = false) String atcocm_,
			HttpServletRequest request) {
		try {
			// EVOLUTIVO 0135083 2.10
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String mocodigo = ("".equals(mocodigo_)) ? null : mocodigo_;
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			// EVOLUTIVO 0150942
			String pcodigo = ("".equals(pcodigo_)) ? null : pcodigo_;
			String accoororigen = ("".equals(accoororigen_)) ? null
					: accoororigen_;
			String atcocm = ("".equals(atcocm_)) ? null : atcocm_;

			SanbandejaController.logger.info("desde: " + trFechaDesde
					+ " hasta: " + trFechaHasta + " trcodigo: " + trcodigo
					+ " mocodigo: " + mocodigo + " codOrg: " + codOrg
					+ " pcodigo: " + pcodigo + " accoororigen: " + accoororigen
					+ " atcocm: " + atcocm);
			// EVOLUTIVO 0135083 2.10

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			String oficina = "";
			oficina = censoMonitor.getOrganismo().getCodOrg();
			filterSanbandeja.setExpedien(new Expedien());
			filterSanbandeja.getExpedien().setExcoor(oficina);
			filterSanbandeja.setMonitor(censoMonitor);
			// EVOLUTIVO 0135083 2.10
			filterSanbandeja.setTrcodigo(trcodigo);
			filterSanbandeja.setMocodigo(mocodigo);
			filterSanbandeja.setCodOrg(codOrg);
			filterSanbandeja.setTrFechaDesde(trFechaDesde);
			filterSanbandeja.setTrFechaHasta(trFechaHasta);
			// EVOLUTIVO 0135083 2.10
			// EVOLUTIVO 0150942
			filterSanbandeja.setPcodigo(pcodigo);
			filterSanbandeja.setAccoororigen(accoororigen);
			filterSanbandeja.setAtcocm(atcocm);
			
			String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = (Pagination) request.getSession().getAttribute(
						"paginationSanbandeja");

				// Si al refrescar la tabla existen menos elementos y la pgina
				// guardada en sesin no existe, se debe seleccionar la ltima
				// pgina con datos
				if (pagination != null) {
					Long totalReg = new Long(0);
					totalReg = this.sanbandejaService.dameBandejaCount(
							filterSanbandeja, censoMonitor, perfil);
					Long pagSession = new Long(0);
					Long page = new Long(0);
					pagSession = pagination.getPage() * pagination.getRows();
					pagSession = pagSession - pagination.getRows();

					if (pagSession >= totalReg) {
						page = totalReg / pagination.getRows();
						pagination.setPage(page);
					}
				} else {
					pagination = paginationReq;
					Long page = new Long(1);
					pagination.setPage(page);
				}
			}

			List<Sanbandeja> sanbandejas = this.sanbandejaService.dameBandeja(
					filterSanbandeja, pagination, censoMonitor, perfil);

			httpSession.setAttribute("sanbandejaBusqueda", filterSanbandeja);

			Long recordNum = this.sanbandejaService.dameBandejaCount(
					filterSanbandeja, censoMonitor, perfil);

			SanbandejaController.logger
					.info("[GET - jqGrid] : Obtener Sanbandeja");

			return new JQGridJSONModel(pagination, recordNum, sanbandejas);
		} catch (Exception e) {
			e.printStackTrace();
			SanbandejaController.logger.error(
					"Error producido en getAllJQGrid: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterSanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/numeroEntradasBandeja", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(
			@ModelAttribute() Sanbandeja filterSanbandeja,
			@ModelAttribute() Pagination pagination,
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "mocodigo", required = false) String mocodigo_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "pcodigo", required = false) String pcodigo_,
			@RequestParam(value = "accoororigen", required = false) String accoororigen_,
			@RequestParam(value = "atcocm", required = false) String atcocm_,
			HttpServletRequest request) {
		try {
			SanbandejaController.logger
					.info("**** ELIMINAMOS LAS ENTRADAS DE AVISOS CADUCADAS DE TIPO PLAZO DE ALEGACIONES");
			this.sanbandejaService.deleteBandejaAvisosCaducados();

			// EVOLUTIVO 0135083 2.10
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String mocodigo = ("".equals(mocodigo_)) ? null : mocodigo_;
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			// EVOLUTIVO 0150942
			String pcodigo = ("".equals(pcodigo_)) ? null : pcodigo_;
			String accoororigen = ("".equals(accoororigen_)) ? null
					: accoororigen_;
			String atcocm = ("".equals(atcocm_)) ? null : atcocm_;

			SanbandejaController.logger.info("desde: " + trFechaDesde
					+ " hasta: " + trFechaHasta + " trcodigo: " + trcodigo
					+ " mocodigo: " + mocodigo + " codOrg: " + codOrg
					+ " pcodigo: " + pcodigo + " accoororigen: " + accoororigen
					+ " atcocm: " + atcocm);
			// EVOLUTIVO 0135083 2.10

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			String oficina = "";
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			SanbandejaController.logger.info("**** MONITOR CONECTADO **"
					+ censoMonitor.getMocodigo() + ".");

			censoMonitor = this.censoMonitorService.find(censoMonitor);

			oficina = censoMonitor.getOrganismo().getCodOrg();
			filterSanbandeja.setExpedien(new Expedien());
			filterSanbandeja.getExpedien().setExcoor(oficina);
			filterSanbandeja.setMonitor(censoMonitor);
			// EVOLUTIVO 0135083 2.10
			filterSanbandeja.setTrcodigo(trcodigo);
			filterSanbandeja.setMocodigo(mocodigo);
			filterSanbandeja.setCodOrg(codOrg);
			filterSanbandeja.setTrFechaDesde(trFechaDesde);
			filterSanbandeja.setTrFechaHasta(trFechaHasta);
			// EVOLUTIVO 0135083 2.10
			// EVOLUTIVO 0150942
			filterSanbandeja.setPcodigo(pcodigo);
			filterSanbandeja.setAccoororigen(accoororigen);
			filterSanbandeja.setAtcocm(atcocm);
			
			String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();

			Long recordNum = this.sanbandejaService.dameBandejaCount(
					filterSanbandeja, censoMonitor, perfil);

			SanbandejaController.logger
					.info("[GET - jqGrid] : Obtener Sanbandeja");
			return recordNum;
		} catch (Exception e) {
			e.printStackTrace();
			SanbandejaController.logger.error(
					"Error producido en getAllCount: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/busqueda", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllSanciones(HttpServletRequest request) {
		try {

			Pagination pagination = null;

			pagination = new Pagination();
			pagination.setSort("BAFEC");
			pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);

			List<Sanbandeja> consultasBusqueda = this.sanbandejaService
					.findAll(null, pagination);
			if (consultasBusqueda == null) {
				throw new Exception("No data Found.");
			}
			return consultasBusqueda;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllConsultaExcel(HttpServletRequest request,
			HttpServletResponse response) {
		try {

			HttpSession httpSession = request.getSession();
			Sanbandeja filterSanbandeja = (Sanbandeja) httpSession
					.getAttribute("sanbandejaBusqueda");

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_BANDSANCIONES
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();

			String xslString = this.y41bExcelGeneratorService
					.getSanbandejaExcel(filterSanbandeja, censoMonitor, perfil);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'getAllTramitesPendientes'.
	 * 
	 * @param excodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/findAllTramitesPendientes/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllTramitesPendientes(@PathVariable() String excodigo,
			HttpServletRequest request) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			String oficina = "";
			oficina = censoMonitor.getOrganismo().getCodOrg();
			Sanbandeja filterSanbandeja = new Sanbandeja();
			filterSanbandeja.setExpedien(new Expedien(excodigo));
			filterSanbandeja.getExpedien().setExcoor(oficina);
			filterSanbandeja.setMonitor(censoMonitor);

			String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Sanbandeja> sanbandejas = this.sanbandejaService
						.dameBandejaTP(filterSanbandeja, pagination,
								censoMonitor, perfil);

				Long recordNum = this.sanbandejaService.dameBandejaTPCount(
						filterSanbandeja, censoMonitor, perfil);

				SanbandejaController.logger
						.info("[GET - jqGrid] : Obtener Sanbandeja");

				return new JQGridJSONModel(pagination, recordNum, sanbandejas);
			} else {
				List<Sanbandeja> sanbandejas = this.sanbandejaService
						.dameBandejaTP(filterSanbandeja, null, censoMonitor,
								perfil);

				if (sanbandejas == null) {
					throw new Exception("No data Found.");
				}
				return sanbandejas;
			}
		} catch (Exception e) {
			e.printStackTrace();
			SanbandejaController.logger.error(
					"Error producido en getAllJQGrid: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllTramitesPendientes'.
	 * 
	 * @param excodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllAvisos/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllAvisos(@PathVariable() String excodigo,
			HttpServletRequest request) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			String oficina = "";
			oficina = censoMonitor.getOrganismo().getCodOrg();
			Sanbandeja filterSanbandeja = new Sanbandeja();
			filterSanbandeja.setExpedien(new Expedien(excodigo));
			filterSanbandeja.getExpedien().setExcoor(oficina);
			filterSanbandeja.setMonitor(censoMonitor);

			String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Sanbandeja> sanbandejas = this.sanbandejaService
						.dameBandejaAvisos(filterSanbandeja, pagination,
								censoMonitor, perfil);

				Long recordNum = this.sanbandejaService.dameBandejaAvisosCount(
						filterSanbandeja, censoMonitor, perfil);

				SanbandejaController.logger
						.info("[GET - jqGrid] : Obtener Sanbandeja");

				return new JQGridJSONModel(pagination, recordNum, sanbandejas);
			} else {
				List<Sanbandeja> sanbandejas = this.sanbandejaService
						.dameBandejaAvisos(filterSanbandeja, null,
								censoMonitor, perfil);

				if (sanbandejas == null) {
					throw new Exception("No data Found.");
				}
				return sanbandejas;
			}
		} catch (Exception e) {
			e.printStackTrace();
			SanbandejaController.logger.error(
					"Error producido en getAllJQGrid: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCreateFormTP'.
	 * 
	 * @param excodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/tramitesPendientes/{excodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormTP(@PathVariable() String excodigo,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		Expedien expediente = new Expedien();
		expediente.setExcodigo(excodigo);
		expediente = this.expedienService.find(expediente);
		model.addAttribute("idExpediente", excodigo);
		model.addAttribute("numExpedienteSancion",
				expediente.getCodCompletoConPrefijo());
		return new ModelAndView("tramitesPendientesSanciones", "model", model);
	}

	/**
	 * Method 'getCreateFormTP'.
	 * 
	 * @param excodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/avisos/{excodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAvisos(@PathVariable() String excodigo,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		Expedien expediente = new Expedien();
		expediente.setExcodigo(excodigo);
		expediente = this.expedienService.find(expediente);
		model.addAttribute("idExpediente", excodigo);
		model.addAttribute("numExpedienteSancion",
				expediente.getCodCompletoConPrefijo());
		return new ModelAndView("avisosSanciones", "model", model);
	}
}
