/**
 * 
 */
package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.service.ArbexpService;
import com.ejie.y41b.service.Arbtramexp4Service;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.InspeccionService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.RepresentantesService;
import com.ejie.y41b.service.SanexpService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * RepresentanteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/representante")
public class RepresentanteController {

	@Autowired
	private RepresentantesService representantesService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private ArbexpService arbexpService;

	@Autowired
	private SanexpService sanexpService;

	@Autowired
	private InspeccionService inspeccionService;

	@Autowired()
	private InstramexpService instramexpService;

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private SantramexpService santramexpService;

	@Autowired()
	private Arbtramexp4Service arbtramexp4Service;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormY41bRepresentantes'.
	 * 
	 * @param idExpedientePadre
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modalAlta/{idExpedientePadre}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bRepresentantes(
			@PathVariable String idExpedientePadre, Model model,
			HttpServletRequest request) {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		model.addAttribute("idExpediente", idExpedientePadre);

		if (censoMonitor.getPerfilSolicitudes() == null
				|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("representantes", "model", model);
		}
	}

	/**
	 * Method 'addRepresentante'.
	 * 
	 * @param padreModalRep
	 *            String
	 * @param idExpediente
	 *            String
	 * @param intervinientes
	 *            Intervinientes
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return Intervinientes
	 */
	@RequestMapping(value = "/guardarRepresentante", method = RequestMethod.POST)
	public @ResponseBody
	Intervinientes addRepresentante(
			@RequestParam(value = "padreModalRep", required = true) String padreModalRep,
			@RequestParam(value = "idExpediente", required = true) String idExpediente,
			@RequestBody Intervinientes intervinientes,
			HttpServletRequest request) {
		try {
			CensoMonitor censoMonitor = (CensoMonitor) request
					.getSession(false).getAttribute(
							Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if ("SolicitudDetalle".equals(padreModalRep)) {
				TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
				tipoProcedimiento
						.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				intervinientes.setTipoProcedimiento(tipoProcedimiento);
				intervinientes.setIdExpediente(idExpediente);
				this.denunciaService.addInterviniente(intervinientes);
				// IntervinientesController.logger
				// .info("Entity correctly inserted!");
			} else if ("FichaExpArbitraje".equals(padreModalRep)) {
				TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
				tipoProcedimiento
						.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				intervinientes.setTipoProcedimiento(tipoProcedimiento);
				intervinientes.setIdExpediente(idExpediente);
				this.arbexpService.addInterviniente(intervinientes,
						censoMonitor);
				// ArbintervController.logger
				// .info("Entity correctly inserted!");
			} else if ("FichaExpSancion".equals(padreModalRep)) {
				TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
				tipoProcedimiento
						.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				intervinientes.setTipoProcedimiento(tipoProcedimiento);
				intervinientes.setIdExpediente(idExpediente);
				this.sanexpService.addInterviniente(intervinientes,
						censoMonitor);
				// SanintervController.logger
				// .info("Entity correctly inserted!");
			} else if ("InspeccionDetalle".equals(padreModalRep)) {
				TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
				tipoProcedimiento
						.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				intervinientes.setTipoProcedimiento(tipoProcedimiento);
				intervinientes.setIdExpediente(idExpediente);
				this.inspeccionService.addInterviniente(intervinientes);
			}
			return intervinientes;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.intervinientes", true, e);
		}
	}

	/**
	 * Method 'eliminarRepresentacion'.
	 * 
	 * @param pcodigo
	 *            String
	 * @param idinterviniente
	 *            String
	 * @param idExpediente
	 *            String
	 * @param tipoInterv
	 *            String
	 * 
	 * @return intervinientes
	 */
	@RequestMapping(value = "/eliminarrepresentacion/{pcodigo}/{idExpediente}/{idinterviniente}/{tipoInterv}", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Intervinientes eliminarRepresentacion(@PathVariable String idinterviniente,
			@PathVariable String pcodigo, @PathVariable String idExpediente,
			@PathVariable String tipoInterv) {

		try {
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(idinterviniente);
			intervinientes.setIdExpediente(idExpediente);
			intervinientes.setTipoInterviniente(tipoInterv);

			if (pcodigo != null
					&& pcodigo.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				this.denunciaService.eliminarRepresentacion(intervinientes);

			} else if (pcodigo != null
					&& pcodigo.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				this.representantesService
						.eliminarRepresentacionSAN(intervinientes);

			} else if (pcodigo != null
					&& pcodigo.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

				this.representantesService.eliminarRepresentacionARB(
						intervinientes, null);

			} else if (pcodigo != null
					&& pcodigo.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				this.inspeccionService.eliminarRepresentacion(intervinientes);

			}

			return intervinientes;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'validarrepresentacion'.
	 * 
	 * @param pcodigo
	 *            String
	 * @param idinterviniente
	 *            String
	 * @param idExpediente
	 *            String
	 * @param tipoInterv
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return intervinientes
	 */
	@RequestMapping(value = "/validarrepresentacion/{pcodigo}/{idExpediente}/{idinterviniente}/{tipoInterv}", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Intervinientes validarrepresentacion(@PathVariable String idinterviniente,
			@PathVariable String pcodigo, @PathVariable String idExpediente,
			@PathVariable String tipoInterv, HttpServletRequest request) {

		try {
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(idinterviniente);
			intervinientes.setIdExpediente(idExpediente);
			intervinientes.setTipoInterviniente(tipoInterv);

			CensoMonitor censoMonitor = (CensoMonitor) request
					.getSession(false).getAttribute(
							Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (pcodigo != null
					&& pcodigo.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				this.denunciaService.validarRepresentacion(intervinientes);

			} else if (pcodigo != null
					&& pcodigo.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				this.representantesService.validarRepresentacionSAN(
						intervinientes, censoMonitor);

			} else if (pcodigo != null
					&& pcodigo.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

				this.representantesService.validarRepresentacionARB(
						intervinientes, censoMonitor);

			} else if (pcodigo != null
					&& pcodigo.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				this.inspeccionService.validarRepresentacion(intervinientes);

			}

			return intervinientes;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'generartramitereqacreditacion'.
	 * 
	 * @param pcodigo
	 *            String
	 * @param idinterviniente
	 *            String
	 * @param idExpediente
	 *            String
	 * @param tipoInterv
	 *            String
	 * 
	 * @return intervinientes
	 */
	@RequestMapping(value = "/generartramitereqacreditacion/{pcodigo}/{idExpediente}/{idinterviniente}/{tipoInterv}", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Intervinientes generartramitereqacreditacion(
			@PathVariable String idinterviniente, @PathVariable String pcodigo,
			@PathVariable String idExpediente, @PathVariable String tipoInterv) {

		try {
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(idinterviniente);
			intervinientes.setIdExpediente(idExpediente);
			intervinientes.setTipoInterviniente(tipoInterv);

			if (pcodigo != null
					&& pcodigo.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				this.soltramexpService
						.generarTramiteRequerimientoAcreditacionRepresentacion(intervinientes);

			} else if (pcodigo != null
					&& pcodigo.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				Saninterv saninterv = new Saninterv();
				saninterv.setExpedien(new Expedien(idExpediente));
				saninterv.setUaidinterv(new BigDecimal(idinterviniente));
				this.santramexpService
						.sugiereTramiteRequerimientoAcreditacionRepresentacion(saninterv);

			} else if (pcodigo != null
					&& pcodigo.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setSolarb(new Solarb(idExpediente));
				arbinterv.setUaidinterv(new BigDecimal(idinterviniente));
				arbinterv.setUatipointerv(tipoInterv);
				this.arbtramexp4Service
						.sugiereTramiteRequerimientoAcreditacionRepresentacion(arbinterv);

			} else if (pcodigo != null
					&& pcodigo.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				this.instramexpService
						.generarTramiteRequerimientoAcreditacionRepresentacion(intervinientes);

			}

			return intervinientes;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
