package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.RemesaBusqueda;
import com.ejie.y41b.model.SituacionCorreos;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.service.ArbadhtramService;
import com.ejie.y41b.service.Arbtramexp3Service;
import com.ejie.y41b.service.EnviosPorRemesaService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.ParametrosService;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.service.RemesaService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * RemesaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/remesa")
@SessionAttributes({ "modoRemesa" })
public class RemesaController {

	private static final Logger logger = LoggerFactory
			.getLogger(RemesaController.class);

	@Autowired
	private RemesaService remesaService;

	@Autowired
	private PlantillaTramiteService plantillaTramiteService;

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private SantramexpService santramexpService;

	@Autowired
	private InstramexpService instramexpService;

	@Autowired
	private MessageSource messageSource;

	@Autowired
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired
	private EnviosPorRemesaService enviosPorRemesaService;

	// @Autowired
	// private Y41bRemesasClientJMSService remesasClientJMSService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private ParametrosService parametrosService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;
	@Autowired
	private Arbtramexp3Service arbtramexp3Service;
	@Autowired
	private ArbadhtramService arbadhtramService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		RemesaController.logger.info("[GET - View] : OBTENER PANTALLA REMESAS");
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		model.addAttribute("organismo", censoMonitor.getOrganismo().getCodOrg());

		return new ModelAndView("remesas", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param rmcodigo
	 *            Strings
	 * @return remesa Remesa
	 */
	@RequestMapping(value = "findRemesa/{rmcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Remesa getById(@PathVariable String rmcodigo) {
		try {
			Remesa remesa = new Remesa(rmcodigo);
			remesa = this.remesaService.find(remesa);
			RemesaController.logger
					.info("[GET - findBy_PK] : Obtener Remesa por PK");
			if (remesa == null) {
				throw new Exception(rmcodigo.toString());
			}

			return remesa;
		} catch (Exception e) {
			throw new ResourceNotFoundException(rmcodigo.toString());
		}
	}

	// /**
	// * Method 'getById'.
	// *
	// * @param rmcodigo
	// * Strings
	// * @return remesa Remesa
	// */
	// @RequestMapping(value = "findRemesa/{rmcodigo}/{idTramite}", method =
	// RequestMethod.GET)
	// public @ResponseBody
	// Remesa getById(@PathVariable String rmcodigo, @PathVariable String
	// idTramite) {
	// try {
	// Remesa remesa = this.remesaService.findRemesaEnvio(rmcodigo,
	// idTramite);
	// RemesaController.logger
	// .info("[GET - findBy_PK] : Obtener Remesa por PK");
	// if (remesa == null) {
	// throw new Exception(rmcodigo.toString());
	// }
	//
	// return remesa;
	// } catch (Exception e) {
	// throw new ResourceNotFoundException(rmcodigo.toString());
	// }
	// }

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterRemesa
	 *            Remesa
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Remesa> getAll(@ModelAttribute Remesa filterRemesa,
			HttpServletRequest request) {
		RemesaController.logger
				.info("[GET - find_ALL] : Obtener Remesa por filtro"
						+ filterRemesa.getRmcodigo());

		// HttpServletRequest httpRequest = (HttpServletRequest) request;
		// HttpSession httpSession = httpRequest.getSession(false);
		// CensoMonitor censoMonitor = (CensoMonitor) httpSession
		// .getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		//
		// // filterRemesa.setRmcodigo(("".equals(tbcodigo_)) ? null :
		// tbcodigo_);
		// filterRemesa.setRmcomo(censoMonitor.getMocodigo());

		return this.remesaService.findAll(filterRemesa, null);
	}

	/**
	 * Method 'add'.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Remesa add(@RequestBody Remesa remesa) {
		try {
			// Obtenemos el numero de remesa
			String numRemesa = this.remesaService.getIdRemesa();
			remesa.setRmcodigo(numRemesa);

			Remesa remesaAux = this.remesaService.addRemesa(remesa);

			RemesaController.logger
					.info("[POST] : Remesa insertado correctamente");
			return remesaAux;
		} catch (Y41bUDAException e) {
			logger.error("Error en RemesaController mtodo add", e);
			throw e;
		} catch (Exception e) {
			logger.error("Error en RemesaController mtodo add", e);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param rmcodigo
	 *            String
	 * @return remesa
	 */
	@RequestMapping(value = "/{rmcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Remesa remove(@PathVariable String rmcodigo) {
		Remesa remesa = new Remesa();
		remesa.setRmcodigo(rmcodigo);
		remesa = this.remesaService.remove(remesa);
		RemesaController.logger.info("[DELETE] : Remesa borrado correctamente");
		return remesa;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param remesaIds
	 *            List
	 * @return remesaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> remesaIds) {
		List<Remesa> remesaList = new ArrayList<Remesa>();
		for (List<String> remesaId : remesaIds) {
			Iterator<String> iterator = remesaId.iterator();
			Remesa remesa = new Remesa(); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			remesa.setRmcodigo(ObjectConversionManager.convert(iterator.next(),
					String.class));
			remesaList.add(remesa);
		}
		this.remesaService.removeMultiple(remesaList);
		RemesaController.logger
				.info("[POST - DELETE_ALL] : Remesa borrados correctamente");
		return remesaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param rmcodigoRemesa_
	 *            String
	 * @param defereDesde_
	 *            String
	 * @param defereHasta_
	 *            String
	 * @param rmtipo_
	 *            String
	 * @param rmcodOrg_
	 *            String
	 * @param rmtipoexpediente_
	 *            String
	 * @param rmestado_
	 *            String
	 * @param rmcheckcerradas_
	 *            String
	 * @param fechaActEnvDesde_
	 *            String
	 * @param fechaActEnvHasta_
	 *            String
	 * @param rmestadoenvio_
	 *            String
	 * @param rmsituacioncorreos_
	 *            String
	 * @param rmsituacionacuse_
	 *            String
	 * @param rmestadoacuse_
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@RequestParam(value = "rmcodigoRemesa", required = false) String rmcodigoRemesa_,
			@RequestParam(value = "defedeDesde", required = false) String defereDesde_,
			@RequestParam(value = "defedeHasta", required = false) String defereHasta_,
			@RequestParam(value = "rmtipo", required = false) String rmtipo_,
			@RequestParam(value = "rmcodOrg", required = false) String rmcodOrg_,
			@RequestParam(value = "rmtipoexpediente", required = false) String rmtipoexpediente_,
			@RequestParam(value = "rmestado", required = false) String rmestado_,
			@RequestParam(value = "rmcheckcerradas", required = false) String rmcheckcerradas_,
			@RequestParam(value = "fechaActEnvDesde", required = false) String fechaActEnvDesde_,
			@RequestParam(value = "fechaActEnvHasta", required = false) String fechaActEnvHasta_,
			@RequestParam(value = "rmestadoenvio", required = false) String rmestadoenvio_,
			@RequestParam(value = "rmsituacioncorreos", required = false) String rmsituacioncorreos_,
			@RequestParam(value = "rmsituacionacuse", required = false) String rmsituacionacuse_,
			@RequestParam(value = "rmestadoacuse", required = false) String rmestadoacuse_,
			@ModelAttribute Pagination pagination, HttpServletRequest request) {

		RemesaController.logger
				.info("[GET - find_ALL] : Obtener remesas por filtro");
		List<Remesa> remesas = new ArrayList<Remesa>();

		try {
			String rmcodigo = ("".equals(rmcodigoRemesa_)) ? null
					: rmcodigoRemesa_;
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date defereDesde = Y41bUtils.parseDate(defereDesde_, locale);
			Date defereHasta = Y41bUtils.parseDate(defereHasta_, locale);
			Date fechaActEnvDesde = Y41bUtils.parseDate(fechaActEnvDesde_,
					locale);
			Date fechaActEnvHasta = Y41bUtils.parseDate(fechaActEnvHasta_,
					locale);

			// control check
			String rmcheckcerradas = ("on".equals(rmcheckcerradas_)) ? Y41bConstantes.VALOR_SI
					: Y41bConstantes.VALOR_NO;

			RemesaBusqueda filterRemesa = new RemesaBusqueda();
			filterRemesa.setRmcodigo(rmcodigo);
			filterRemesa.setRmfechageneracionDesde(defereDesde);
			filterRemesa.setRmfechageneracionHasta(defereHasta);

			filterRemesa.setRmtipo(rmtipo_);

			if (rmcodOrg_ != null && !rmcodOrg_.equals("")) {
				filterRemesa.setRmcodorg(rmcodOrg_);
			}

			if (rmtipoexpediente_ != null && !rmtipoexpediente_.equals("")) {
				filterRemesa.setRmtipoexpediente(rmtipoexpediente_);
			}

			if (rmestado_ != null && !rmestado_.equals("")) {
				filterRemesa.setRmestado(rmestado_);
			}

			filterRemesa.setRmcheckcerradas(rmcheckcerradas);

			filterRemesa.setRmFechaActEnvDesde(fechaActEnvDesde);
			filterRemesa.setRmFechaActEnvHasta(fechaActEnvHasta);

			if (rmestadoenvio_ != null && !rmestadoenvio_.equals("")) {
				filterRemesa.setRmestadoenvio(rmestadoenvio_);
			}

			if (rmsituacioncorreos_ != null && !rmsituacioncorreos_.equals("")) {
				filterRemesa.setRmsituacioncorreos(rmsituacioncorreos_);
			}

			if (rmsituacionacuse_ != null && !rmsituacionacuse_.equals("")) {
				filterRemesa.setRmsituacionacuse(rmsituacionacuse_);
			}

			if (rmestadoacuse_ != null && !rmestadoacuse_.equals("")) {
				filterRemesa.setRmestadoacuse(rmestadoacuse_);
			}

			remesas = this.remesaService.findAllRemesasLikeVista(filterRemesa,
					pagination, false);
			Long recordNum = this.remesaService.findAllRemesasLikeVistaCount(
					filterRemesa, false);
			RemesaController.logger.info("[GET - jqGrid] : Obtener Remesa");
			return new JQGridJSONModel(pagination, recordNum, remesas);
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateFormAltaRemesa'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaRemesa", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaRemesa(Model remesa,
			HttpServletRequest request) {
		remesa.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		remesa.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		remesa.addAttribute("modoRemesa", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		remesa.addAttribute("organismo", censoMonitor.getOrganismo()
				.getCodOrg());

		// se agrega, comentado de momento, por si es necesario para incidencia
		// 107168, tocar jsp y js, condicion de validacion
		// remesa.addAttribute("telefono", censoMonitor.getOrganismo()
		// .getTelefono());

		remesa.addAttribute("codMonitor", censoMonitor.getMocodigo());
		RemesaController.logger
				.info("[GET - getCreateFormAltaRemesa] : Organismo"
						+ censoMonitor.getOrganismo());
		// Obtener numero de remesa nuevo
		/*
		 * String numRemesa = this.remesaService.getIdRemesa();
		 * remesa.addAttribute("numRemesa", numRemesa);
		 */

		return new ModelAndView("detalleRemesa", "model", remesa);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterRemesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "busquedaNotificacionesComunicaciones", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllNotificacionesComunicacionesJQGrid(
			@RequestParam(value = "CAPVRemesas", required = false) String CAPVRemesas_,
			@RequestParam(value = "rmtipodetalle", required = false) String rmtipo_,
			@RequestParam(value = "rmtipoExpediente", required = false) String pcodigo_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "rmcodigodetalle", required = false) String rmcodigo_,
			@RequestParam(value = "modoRemesa", required = false) String modoRemesa,
			// @ModelAttribute(value = "modoRemesa") String modoRemesa,
			@ModelAttribute Pagination pagination, HttpServletRequest request) {

		RemesaController.logger
				.info("[GET - getAllNotificacionesComunicacionesJQGrid] : Obtener remesas por filtro");
		List<NotificacionesComunicacionesBusqueda> listNotifiComuni = new ArrayList<NotificacionesComunicacionesBusqueda>();
		if (Y41bConstantes.MODO_POPUP_ALTA.equals(modoRemesa)
				&& rmtipo_
						.equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)
				&& !this.comprobarCompatibilidadAA66()) {
			return new JQGridJSONModel(pagination, 0L, listNotifiComuni);
		}
		// HttpSession httpSession = httpRequest.getSession(false);
		// CensoMonitor censoMonitor = (CensoMonitor) httpSession
		// .getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		try {
			NotificacionesComunicacionesBusqueda filterNotifComuni = new NotificacionesComunicacionesBusqueda();
			filterNotifComuni.setRmtipoExpediente(pcodigo_);

			filterNotifComuni.setRmtipo(rmtipo_);
			filterNotifComuni.setModoRemesa(modoRemesa);
			if (modoRemesa.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
				filterNotifComuni.setRmorganico(codOrg_);

				String CAPVRemesas = ("".equals(CAPVRemesas_)) ? null
						: CAPVRemesas_;
				filterNotifComuni.setRmcapv(CAPVRemesas);
			} else {
				// ESTAMOS EN EL CASO DE EDITAR REMESA
				filterNotifComuni.setRmcodigo(rmcodigo_);
			}
			// Recuperar todas las notificaciones o comunicaciones que pueden
			// llevarse a remesa

			Long recordNum = null;
			if (pcodigo_ != null
					&& pcodigo_.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				listNotifiComuni = this.soltramexpService.findAllNotifiComuni(
						filterNotifComuni, pagination);
				recordNum = this.soltramexpService
						.findAllNotifiComuniCount(filterNotifComuni);
			} else if (pcodigo_ != null
					&& pcodigo_.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				listNotifiComuni = this.santramexpService.findAllNotifiComuni(
						filterNotifComuni, pagination);
				recordNum = this.santramexpService
						.findAllNotifiComuniCount(filterNotifComuni);
			} else if (pcodigo_ != null
					&& (pcodigo_
							.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| pcodigo_
									.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA) || pcodigo_
							.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD))) {
				filterNotifComuni.setTipoProcedimiento(pcodigo_);
				listNotifiComuni = this.arbadhtramService.findAllNotifiComuni(
						filterNotifComuni, pagination);
				recordNum = this.arbadhtramService
						.findAllNotifiComuniCount(filterNotifComuni);
			} else if (pcodigo_ != null
					&& pcodigo_.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				listNotifiComuni = this.arbtramexp3Service.findAllNotifiComuni(
						filterNotifComuni, pagination);
				recordNum = this.arbtramexp3Service
						.findAllNotifiComuniCount(filterNotifComuni);
			} else if (pcodigo_ != null
					&& pcodigo_.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				listNotifiComuni = this.instramexpService.findAllNotifiComuni(
						filterNotifComuni, pagination);
				recordNum = this.instramexpService
						.findAllNotifiComuniCount(filterNotifComuni);
			} else {

			}
			RemesaController.logger
					.info("[GET - getAllNotificacionesComunicacionesJQGrid] : Fin");
			return new JQGridJSONModel(pagination, recordNum, listNotifiComuni);
		} catch (Exception e) {
			RemesaController.logger
					.info("[GET - getAllNotificacionesComunicacionesJQGrid] : Exception : "
							+ e.getMessage());
			String msg = messageSource.getMessage(
					"error.remesa.notifiComuniVacios", null,
					LocaleContextHolder.getLocale());
			throw new Y41bUDAException(msg, true,
					new ResourceNotFoundException(msg));
		}
	}

	@RequestMapping(value = "/comprobarCompatibilidadAA66", method = RequestMethod.GET)
	public @ResponseBody
	boolean comprobarCompatibilidadAA66() {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.INTEGRACION_CON_AA66);
		parametros = this.parametrosService.find(parametros);
		if (parametros.getValor().equalsIgnoreCase(Y41bConstantes.NO)) {
			String msg = messageSource.getMessage("error.remesa.noIntegrado",
					null, LocaleContextHolder.getLocale());
			RemesaController.logger
					.info("[GET - comprobarCompatibilidadAA66] : ResourceNotFoundException : "
							+ msg);

			return false;
		}
		return true;
	}

	/**
	 * Method 'getCreateFormModRemesa'.
	 * 
	 * @param rmcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modRemesa/{rmcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModRemesa(@PathVariable String rmcodigo,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("rmcodigo", rmcodigo);
		Remesa remesa = this.solicitadaTiempoMaximoAA66(rmcodigo);
		model.addAttribute("modoRemesa", Y41bConstantes.MODO_POPUP_MODIFICACION);
		model.addAttribute("remesa", remesa);

		return new ModelAndView("detalleRemesa", "model", model);
	}

	@RequestMapping(value = "solicitadaTiempoMaximoAA66/{rmcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Remesa solicitadaTiempoMaximoAA66(@PathVariable String rmcodigo) {
		return this.remesaService.solicitadaTiempoMaximoAA66(rmcodigo);
	}

	/**
	 * Method 'getAllPlantillasComunicacion'.
	 * 
	 * @param codTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findRemesaPlantilla/{codTramite}", method = RequestMethod.GET)
	public @ResponseBody
	List<PlantillaTramite> getAllPlantillasTramiteComunicacion(
			@PathVariable String codTramite, HttpServletRequest request) {
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();
			Tramite tramite = new Tramite();
			tramite.setTrcodigo(codTramite);
			plantillaTramite.setTramite(tramite);

			List<PlantillaTramite> listPlantillaTramiteBusqueda = null;

			listPlantillaTramiteBusqueda = this.plantillaTramiteService
					.findAll(plantillaTramite, null);

			if (listPlantillaTramiteBusqueda == null) {
				throw new Exception("No data Found.");
			}

			return listPlantillaTramiteBusqueda;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByDocumentoRemesa'.
	 * 
	 * @param q5codocumento
	 *            Long
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@SuppressWarnings("deprecation")
	@RequestMapping(value = "/documentacion/link/{codRemesa}/{ficheroTipo}", method = RequestMethod.GET)
	public @ResponseBody
	void getByDocumentoRemesa(@PathVariable String codRemesa,
			@PathVariable String ficheroTipo, HttpServletResponse response) {
		try {
			RemesaController.logger
					.info("[GET - getByDocumentoRemesa] : Inicio");

			Remesa remesa = this.remesaService.findAllBlobRemesa(codRemesa);
			Blob contenido = null;
			String filename = "";
			if (ficheroTipo.equals("C")) {
				contenido = remesa.getRmdatafile();
				filename = codRemesa + "_Notificaciones.pdf";
			} else if (ficheroTipo.equals("A")) {
				contenido = remesa.getRmacusesfile();
				filename = codRemesa + "_Acuses.pdf";
			} else if (ficheroTipo.equals("L")) {
				contenido = remesa.getRmlistadofile();
				filename = codRemesa + "_Listado.pdf";
			}
			if (contenido != null) {
				byte[] bContenido = contenido.getBytes(1,
						(int) contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader(
						"Content-Disposition",
						"attachment; filename=\""
								+ StringEscapeUtils.unescapeHtml(filename)
								+ "\"");
				response.setContentType("application/pdf");

				response.flushBuffer();

				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();
			}

			RemesaController.logger.info("[GET - getByDocumentoRemesa] : Fin");

		} catch (Exception e) {
			RemesaController.logger.error("Error al abrir el fichero", e);
			throw new ResourceNotFoundException("Problemas al abrir el fichero");
		}

		Remesa remesa = new Remesa();
		remesa.setRmcodigo(codRemesa);
		remesa = this.remesaService.find(remesa);
		if (this.remesaNoNulaYGenerada(remesa)
				&& remesa.getRmtipo() != null
				&& remesa.getRmtipo().equals(
						Y41bConstantes.TRAMITE_NOTIFICACION)) {
			try {
				RemesaController.logger.info("[GET - pepararRemesa] : Inicio");
				Remesa remesaEmitida = new Remesa();
				remesaEmitida.setRmcodigo(codRemesa);
				remesaEmitida.setRmestado(Y41bConstantes.ESTADO_REMESA_EMITIDA);
				remesaEmitida.setRmfechaemision(new Date());
				this.remesaService.updateEstadoRemesa(remesaEmitida);
				RemesaController.logger.info("[GET - pepararRemesa] : Fin");
			} catch (Exception e) {
				RemesaController.logger.error("Error al actualizar la remesa",
						e);
				throw new Y41bUDAException("Error al actualizar la remesa",
						true, e);
			}
		}
	}

	/**
	 * 
	 * @param codRemesa
	 */
	@RequestMapping(value = "/pepararRemesa/{codRemesa}", method = RequestMethod.GET)
	public @ResponseBody()
	void pepararRemesa(@PathVariable String codRemesa) {

		Remesa remesa = this.remesaService.find(new Remesa(codRemesa));
		if (this.remesaNoNulaYGenerada(remesa)) {
			this.remesaService.prepararLaRemesa(remesa);
		}
	}

	/**
	 * 
	 * @param remesa
	 * @return
	 */
	private boolean remesaNoNulaYGenerada(Remesa remesa) {
		return remesa != null
				&& remesa.getRmestado() != null
				&& remesa.getRmestado().equals(
						Y41bConstantes.ESTADO_REMESA_GENERADA);
	}

	/**
	 * Mtodo para actualizar todos los envos de la remesa actual (en estado
	 * EMITIDA o EMITIDA_RESPUESTAS_ERRONEAS) tras pulsar el botn
	 * 
	 * @throws Exception
	 * 
	 * @throws Throwable
	 */
	@RequestMapping(value = "actualizarEnvios/{codRemesa}", method = RequestMethod.GET)
	public @ResponseBody()
	void actualizarEnvios(@PathVariable String codRemesa,
			HttpServletRequest request) {

		Remesa remesaEmitida = this.remesaService.find(new Remesa(codRemesa));
		if (null == remesaEmitida) {
			RemesaController.logger.error("Remesa vaca");
			throw new Y41bUDAException("remesa.vacia", true, new Exception());
		}
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		this.remesaService.actualizarEnvios(remesaEmitida, censoMonitor);
	}

	/**
	 * Method 'getAllSituacionCorreos'.
	 * 
	 * @return 'lista de situaciones de correos' para el COMBO
	 */
	@RequestMapping(value = "/getAllSituacionCorreos", method = RequestMethod.GET)
	public @ResponseBody()
	List<SituacionCorreos> getAllSituacionCorreos() {
		RemesaController.logger
				.info("[GET - find_ALL] : Obtener lista Situacion Correos");

		return this.remesaService.findAllSituacionCorreos(null, null);
	}

	/**
	 * Method 'getAllSolicitudExcelBandejaECTP'.
	 * 
	 * @param rmcodigoRemesa_
	 *            String
	 * @param defereDesde_
	 *            String
	 * @param defereHasta_
	 *            String
	 * @param rmtipo_
	 *            String
	 * @param rmcodOrg_
	 *            String
	 * @param rmtipoexpediente_
	 *            String
	 * @param rmestado_
	 *            String
	 * @param rmcheckcerradas_
	 *            String
	 * @param fechaActEnvDesde_
	 *            String
	 * @param fechaActEnvHasta_
	 *            String
	 * @param rmestadoenvio_
	 *            String
	 * @param rmsituacioncorreos_
	 *            String
	 * @param rmsituacionacuse_
	 *            String
	 * @param rmestadoacuse_
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelRemesas", method = RequestMethod.GET)
	public @ResponseBody
	void getAllRemesasExcel(
			@RequestParam(value = "rmcodigoRemesa", required = false) String rmcodigoRemesa_,
			@RequestParam(value = "defedeDesde", required = false) String defereDesde_,
			@RequestParam(value = "defedeHasta", required = false) String defereHasta_,
			@RequestParam(value = "rmtipo", required = false) String rmtipo_,
			@RequestParam(value = "rmcodOrg", required = false) String rmcodOrg_,
			@RequestParam(value = "rmtipoexpediente", required = false) String rmtipoexpediente_,
			@RequestParam(value = "rmestado", required = false) String rmestado_,
			@RequestParam(value = "rmcheckcerradas", required = false) String rmcheckcerradas_,
			@RequestParam(value = "fechaActEnvDesde", required = false) String fechaActEnvDesde_,
			@RequestParam(value = "fechaActEnvHasta", required = false) String fechaActEnvHasta_,
			@RequestParam(value = "rmestadoenvio", required = false) String rmestadoenvio_,
			@RequestParam(value = "rmsituacioncorreos", required = false) String rmsituacioncorreos_,
			@RequestParam(value = "rmsituacionacuse", required = false) String rmsituacionacuse_,
			@RequestParam(value = "rmestadoacuse", required = false) String rmestadoacuse_,
			HttpServletRequest request, HttpServletResponse response) {

		try {
			// ///
			String rmcodigo = ("".equals(rmcodigoRemesa_)) ? null
					: rmcodigoRemesa_;
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date defereDesde = Y41bUtils.parseDate(defereDesde_, locale);
			Date defereHasta = Y41bUtils.parseDate(defereHasta_, locale);
			Date fechaActEnvDesde = Y41bUtils.parseDate(fechaActEnvDesde_,
					locale);
			Date fechaActEnvHasta = Y41bUtils.parseDate(fechaActEnvHasta_,
					locale);

			// control check
			String rmcheckcerradas = ("on".equals(rmcheckcerradas_)) ? Y41bConstantes.VALOR_SI
					: Y41bConstantes.VALOR_NO;

			RemesaBusqueda filterRemesa = new RemesaBusqueda();
			filterRemesa.setRmcodigo(rmcodigo);
			filterRemesa.setRmfechageneracionDesde(defereDesde);
			filterRemesa.setRmfechageneracionHasta(defereHasta);

			filterRemesa.setRmtipo(rmtipo_);

			if (rmcodOrg_ != null && !rmcodOrg_.equals("")) {
				filterRemesa.setRmcodorg(rmcodOrg_);
			}

			if (rmtipoexpediente_ != null && !rmtipoexpediente_.equals("")) {
				filterRemesa.setRmtipoexpediente(rmtipoexpediente_);
			}

			if (rmestado_ != null && !rmestado_.equals("")) {
				filterRemesa.setRmestado(rmestado_);
			}

			filterRemesa.setRmcheckcerradas(rmcheckcerradas);

			filterRemesa.setRmFechaActEnvDesde(fechaActEnvDesde);
			filterRemesa.setRmFechaActEnvHasta(fechaActEnvHasta);

			if (rmestadoenvio_ != null && !rmestadoenvio_.equals("")) {
				filterRemesa.setRmestadoenvio(rmestadoenvio_);
			}

			if (rmsituacioncorreos_ != null && !rmsituacioncorreos_.equals("")) {
				filterRemesa.setRmsituacioncorreos(rmsituacioncorreos_);
			}

			if (rmsituacionacuse_ != null && !rmsituacionacuse_.equals("")) {
				filterRemesa.setRmsituacionacuse(rmsituacionacuse_);
			}

			if (rmestadoacuse_ != null && !rmestadoacuse_.equals("")) {
				filterRemesa.setRmestadoacuse(rmestadoacuse_);
			}

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_REMESAS + fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getRemesasExcel(
					filterRemesa, censoMonitor);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param rmcodigo
	 *            String
	 * 
	 */
	@RequestMapping(value = "/cerrar/{rmcodigo}", method = RequestMethod.POST)
	public @ResponseBody()
	void closeById(@PathVariable String rmcodigo) {
		try {
			Remesa remesa = new Remesa(rmcodigo);
			this.enviosPorRemesaService.cerrarRemesa(remesa);
		} catch (Exception e) {
			throw new ResourceNotFoundException(rmcodigo.toString());
		}
	}

}