package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.FiltroArbitraje;
import com.ejie.y41b.model.FiltroInspeccion;
import com.ejie.y41b.model.FiltroSanciones;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Sanpropbandeja;
import com.ejie.y41b.model.SolicitudBusqueda;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.InspeccionService;
import com.ejie.y41b.service.SanexprelService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.SanpropbandejaService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.modulos.Y41bModuloUtils;

/**
 * RelacionarExpedientesController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/relacionarExpedientes")
public class RelacionarExpedientesController {

	private static final Logger logger = LoggerFactory.getLogger(RelacionarExpedientesController.class);

	@Autowired()
	private ExpedienService expedienService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private SanexprelService sanexprelService;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired()
	private InspeccionService inspeccionService;

	@Autowired()
	private SanintervService sanintervService;

	@Autowired()
	private SolarbService solarbService;

	@Autowired()
	private ArbintervService arbintervService;

	@Autowired()
	private SanpropbandejaService sanpropbandejaService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	// @Autowired()
	// private EstablecimientoService establecimientoService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * 
	 * @param origen
	 *            String
	 * @param tipoprocExp
	 *            String
	 * @param excodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param model
	 *            Model
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintBusqueda/{origen}/{tipoprocExp}/{excodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateForm(@PathVariable() String origen, @PathVariable() String tipoprocExp,
			@PathVariable() String excodigo,
			@RequestParam(value = "relacionados", required = false) String relacionados,
			@RequestParam(value = "tipoprocAcumularOrigen", required = false) String tipoprocAcumularOrigen,
			@RequestParam(value = "sancionbaprsanidOrigen", required = false) String sancionbaprsanidOrigen,
			Model model, HttpServletRequest httpRequest) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		try {
			String codigo = excodigo;
			if (tipoprocExp.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				codigo = new String(Y41bUtilsDokusi.decode(excodigo));
			}
			model.addAttribute("excodigo", codigo);
			model.addAttribute("tipoprocExp", tipoprocExp);
			model.addAttribute("origen", origen);
			model.addAttribute("tipoprocAcumularOrigen", tipoprocAcumularOrigen);
			model.addAttribute("sancionbaprsanidOrigen", sancionbaprsanidOrigen);

			String expedienteOrigen = "";
			String tipoprocOrigen = "";
			StringBuffer exp_relacionadosSol = new StringBuffer("");
			StringBuffer exp_relacionadosSan = new StringBuffer("");
			StringBuffer exp_relacionadosArb = new StringBuffer("");
			StringBuffer exp_relacionadosIns = new StringBuffer("");
			if ("0".equals(codigo)) {// Añadimos los expedientes que vienen
										// de la
										// request
				String[] expedientes = relacionados.split(",");
				if (expedientes != null && expedientes.length > 0) {
					for (int i = 0; i < expedientes.length; i++) {
						if (!Y41bUtils.esNullOCadenaVacia(expedientes[i])) {
							if (expedientes[i].indexOf(Y41bConstantes.TIPO_PROC_ARBITRAJE) > 0) {
								if (exp_relacionadosArb.length() > 0) {
									exp_relacionadosArb.append(",");
								}
								exp_relacionadosArb.append(
										expedientes[i].replaceAll("-" + Y41bConstantes.TIPO_PROC_ARBITRAJE, ""));
							} else if (expedientes[i].indexOf(Y41bConstantes.TIPO_PROC_SOLICITUDES) > 0) {
								if (exp_relacionadosSol.length() > 0) {
									exp_relacionadosSol.append(",");
								}
								exp_relacionadosSol.append(
										expedientes[i].replaceAll("-" + Y41bConstantes.TIPO_PROC_SOLICITUDES, ""));
							} else if (expedientes[i].indexOf(Y41bConstantes.TIPO_PROC_INSPECCIONES) > 0) {
								if (exp_relacionadosIns.length() > 0) {
									exp_relacionadosIns.append(",");
								}
								exp_relacionadosIns.append(
										expedientes[i].replaceAll("-" + Y41bConstantes.TIPO_PROC_INSPECCIONES, ""));
							} else if (expedientes[i].indexOf(Y41bConstantes.TIPO_PROC_SANCIONES) > 0) {
								if (exp_relacionadosSan.length() > 0) {
									exp_relacionadosSan.append(",");
								}
								exp_relacionadosSan.append(
										expedientes[i].replaceAll("-" + Y41bConstantes.TIPO_PROC_SANCIONES, ""));
							}
						}
					}
				}
			} else {
				Sanexprel sanexprel = new Sanexprel();
				List<Sanexprel> listaRelacionados = null;
				if (tipoprocExp.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					sanexprel.setRlarbcodigo(codigo);
					listaRelacionados = this.sanexprelService.findAll(sanexprel, null);
				} else if (tipoprocExp.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					sanexprel.setRlhdcodigo(codigo);
					listaRelacionados = this.sanexprelService.findAll(sanexprel, null);
				} else if (tipoprocExp.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					sanexprel.setRlinscodigo(codigo);
					listaRelacionados = this.sanexprelService.findAll(sanexprel, null);
				} else if (tipoprocExp.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					Expedien expedien = new Expedien();
					expedien.setExcodigo(codigo);
					sanexprel.setExpedienByRlexcodigo(expedien);
					listaRelacionados = this.sanexprelService.findAll(sanexprel, null);
				}

				if (listaRelacionados != null) {
					for (int i = 0; i < listaRelacionados.size(); i++) {
						sanexprel = listaRelacionados.get(i);
						if (!Y41bUtils.esNullOCadenaVacia(sanexprel.getRlarbcodrel())) {
							if (exp_relacionadosArb.length() > 0) {
								exp_relacionadosArb.append(",");
							}
							exp_relacionadosArb.append(sanexprel.getExcodigo());
							if (Y41bConstantes.VALOR_SI.equals(sanexprel.getRlesorig())) {
								expedienteOrigen = sanexprel.getRlesorig();
								tipoprocOrigen = Y41bConstantes.TIPO_PROC_ARBITRAJE;
							}
						} else if (!Y41bUtils.esNullOCadenaVacia(sanexprel.getRlhdcodrel())) {
							if (exp_relacionadosSol.length() > 0) {
								exp_relacionadosSol.append(",");
							}
							exp_relacionadosSol.append(sanexprel.getExcodigo());
							if (Y41bConstantes.VALOR_SI.equals(sanexprel.getRlesorig())) {
								expedienteOrigen = sanexprel.getRlesorig();
								tipoprocOrigen = Y41bConstantes.TIPO_PROC_SOLICITUDES;
							}
						} else if (!Y41bUtils.esNullOCadenaVacia(sanexprel.getRlinscodrel())) {
							if (exp_relacionadosIns.length() > 0) {
								exp_relacionadosIns.append(",");
							}
							exp_relacionadosIns.append(sanexprel.getExcodigo());
							if (Y41bConstantes.VALOR_SI.equals(sanexprel.getRlesorig())) {
								expedienteOrigen = sanexprel.getRlesorig();
								tipoprocOrigen = Y41bConstantes.TIPO_PROC_INSPECCIONES;
							}
						} else if (!Y41bUtils.esNullOCadenaVacia(sanexprel.getRlexcodrel())) {
							if (exp_relacionadosSan.length() > 0) {
								exp_relacionadosSan.append(",");
							}
							exp_relacionadosSan.append(sanexprel.getExcodigo());
							if (Y41bConstantes.VALOR_SI.equals(sanexprel.getRlesorig())) {
								expedienteOrigen = sanexprel.getRlesorig();
								tipoprocOrigen = Y41bConstantes.TIPO_PROC_SANCIONES;
							}
						}

					}
				}
			}
			model.addAttribute("relacionadosArb", exp_relacionadosArb.toString());
			model.addAttribute("relacionadosSol", exp_relacionadosSol.toString());
			model.addAttribute("relacionadosSan", exp_relacionadosSan.toString());
			model.addAttribute("relacionadosIns", exp_relacionadosIns.toString());
			model.addAttribute("expedienteOrigen", expedienteOrigen);
			model.addAttribute("tipoprocOrigen", tipoprocOrigen);
			return new ModelAndView("relacionarExpedientes", "model", model);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param tipoproc
	 *            String
	 * @param origen
	 *            String
	 * @param excodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param excoor
	 *            String
	 * @param exnror
	 *            String
	 * @param exnran
	 *            String
	 * @param cofechaInicioDesde
	 *            String
	 * @param cofechaInicioHasta
	 *            String
	 * @param cofechaHechoDesde
	 *            String
	 * @param cofechaHechoHasta
	 *            String
	 * @param pagination
	 *            pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/lista", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGrid(
			@RequestParam(value = "tipoproc", required = false) String tipoproc,
			@RequestParam(value = "origen", required = false) String origen,
			@RequestParam(value = "excodigo", required = false) String excodigo,
			@RequestParam(value = "relacionadosArb", required = false) String relacionadosArb,
			@RequestParam(value = "relacionadosSol", required = false) String relacionadosSol,
			@RequestParam(value = "relacionadosIns", required = false) String relacionadosIns,
			@RequestParam(value = "relacionadosSan", required = false) String relacionadosSan,
			@RequestParam(value = "excoor", required = false) String excoor,
			@RequestParam(value = "exnror", required = false) BigDecimal exnror,
			@RequestParam(value = "exnran", required = false) BigDecimal exnran,
			@RequestParam(value = "cofechaInicioDesde", required = false) String cofechaInicioDesde,
			@RequestParam(value = "cofechaInicioHasta", required = false) String cofechaInicioHasta,
			@RequestParam(value = "cofechaHechoDesde", required = false) String cofechaHechoDesde,
			@RequestParam(value = "cofechaHechoHasta", required = false) String cofechaHechoHasta,
			@RequestParam(value = "tipoprocAcumularOrigen", required = false) String tipoprocAcumularOrigen,
			@RequestParam(value = "sancionbaprsanidOrigen", required = false) String sancionbaprsanidOrigen,
			@ModelAttribute() Pagination pagination) {

		JQGridJSONModel jqGrid = null;
		try {
			if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoproc)) {
				FiltroSanciones filtroSanciones = new FiltroSanciones();
				// Expediente
				if (!Y41bUtils.esNullOCadenaVacia(excoor)) {
					filtroSanciones.setExcoor(excoor);
				}
				if (exnror != null) {
					filtroSanciones.setExnror(exnror);
				}
				if (exnran != null) {
					filtroSanciones.setExnran(exnran);
				}

				// 0170995: Acumulacin de expedientes en SAncionador
				if ("G".equals(origen) && !Y41bUtils.esNullOCadenaVacia(excodigo)) {

					if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoprocAcumularOrigen)) {
						try {
							Saninterv saninterv = this.sanintervService.dameSancionado(excodigo);
							if (null != saninterv && null != saninterv.getUanif()) {
								filtroSanciones.setCifnif(saninterv.getUanif());
							}
						} catch (Exception e) {
							filtroSanciones.setCifnif("XXXXXXXX");
						}
					} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoprocAcumularOrigen)) {
						try {
							Intervinientes intervinien = new Intervinientes();
							intervinien.setIdExpediente(excodigo);
							EstablecimientoDetalle establecimientoDetalleActa = this.denunciaService
									.findIntervinienteEstablecimiento(intervinien);
							if (null != establecimientoDetalleActa && null != establecimientoDetalleActa.getEsnif()) {
								filtroSanciones.setCifnif(establecimientoDetalleActa.getEsnif());
							}
						} catch (Exception e) {
							filtroSanciones.setCifnif("XXXXXXXX");
						}
					} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoprocAcumularOrigen)) {
						try {
							Arbinterv arbinterv = this.arbintervService.dameInterviniente(excodigo,
									Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
							if (null != arbinterv && null != arbinterv.getUanif()) {
								filtroSanciones.setCifnif(arbinterv.getUanif());
							}
						} catch (Exception e) {
							filtroSanciones.setCifnif("XXXXXXXX");
						}
					} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoprocAcumularOrigen)) {
						try {
							if (Y41bUtils.esNullOCadenaVacia(sancionbaprsanidOrigen)) {
								Intervinientes intervinien = new Intervinientes();
								intervinien.setIdExpediente(excodigo);
								EstablecimientoDetalle establecimientoDetalleActa = this.inspeccionService
										.findIntervinienteEstablecimientoResponsable(intervinien);
								if (null != establecimientoDetalleActa
										&& null != establecimientoDetalleActa.getEsnif()) {
									filtroSanciones.setCifnif(establecimientoDetalleActa.getEsnif());
								} else {
									filtroSanciones.setCifnif("XXXXXXXX");
								}
							} else {
								Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
								sanpropbandeja.setBaprsanid(Long.parseLong(sancionbaprsanidOrigen));
								sanpropbandeja = this.sanpropbandejaService.find(sanpropbandeja);
								if (null != sanpropbandeja && null != sanpropbandeja.getBaprsansancionado()) {
									Intervinientes intervinien = new Intervinientes();
									intervinien.setIdExpediente(excodigo);
									EstablecimientoDetalle establecimientoDetalleActaResponsable;
									try {
										establecimientoDetalleActaResponsable = this.inspeccionService
												.findIntervinienteEstablecimientoResponsable(intervinien);
									} catch (Exception e) {
										establecimientoDetalleActaResponsable = null;
									}
									Intervinientes intervinien2 = new Intervinientes();
									intervinien2.setIdExpediente(excodigo);
									EstablecimientoDetalle establecimientoDetalleActaVisitado;
									try {
										establecimientoDetalleActaVisitado = this.inspeccionService
												.findIntervinienteEstablecimientoVisitado(intervinien2);
									} catch (Exception e) {
										establecimientoDetalleActaVisitado = null;
									}
									if (null != establecimientoDetalleActaResponsable
											&& establecimientoDetalleActaResponsable.getEscodigo() != null
											&& establecimientoDetalleActaResponsable.getEscodigo()
													.equals(sanpropbandeja.getBaprsansancionado())) {
										filtroSanciones.setCifnif(establecimientoDetalleActaResponsable.getEsnif());
									} else if (null != establecimientoDetalleActaVisitado
											&& establecimientoDetalleActaVisitado.getEscodigo() != null
											&& establecimientoDetalleActaVisitado.getEscodigo()
													.equals(sanpropbandeja.getBaprsansancionado())) {
										filtroSanciones.setCifnif(establecimientoDetalleActaVisitado.getEsnif());
									} else {
										filtroSanciones.setCifnif("XXXXXXXX");
									}
								} else {
									filtroSanciones.setCifnif("XXXXXXXX");
								}
							}

						} catch (Exception e) {
							filtroSanciones.setCifnif("XXXXXXXX");
						}
					}

				}
				// 0170995: Acumulacin de expedientes en SAncionador

				// parseo de fechas
				Locale locale = LocaleContextHolder.getLocale();
				if (!Y41bUtils.esNullOCadenaVacia(cofechaInicioDesde)) {
					filtroSanciones.setFechaIniDesde(Y41bUtils.parseDate(cofechaInicioDesde, locale));
				}
				if (!Y41bUtils.esNullOCadenaVacia(cofechaInicioHasta)) {
					filtroSanciones.setFechaIniHasta(Y41bUtils.parseDate(cofechaInicioHasta, locale));
				}
				if (!Y41bUtils.esNullOCadenaVacia(cofechaHechoDesde)) {
					filtroSanciones.setFechaHechoDesde(Y41bUtils.parseDate(cofechaHechoDesde, locale));
				}
				if (!Y41bUtils.esNullOCadenaVacia(cofechaHechoHasta)) {
					filtroSanciones.setFechaHechoHasta(Y41bUtils.parseDate(cofechaHechoHasta, locale));
				}

				List<FiltroSanciones> listaExpedientesARelacionar = this.expedienService
						.findAllSancionesRelacionar(filtroSanciones, excodigo, relacionadosSan, pagination);
				Long recordNum = this.expedienService.findAllCountSancionesRelacionar(filtroSanciones, excodigo,
						relacionadosSan);
				RelacionarExpedientesController.logger.info("[GET - jqGrid] : Obtener sanciones");
				jqGrid = new JQGridJSONModel(pagination, recordNum, listaExpedientesARelacionar);

			} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc)) {
				SolicitudBusqueda filtroSolicitud = new SolicitudBusqueda();
				// Expediente
				if (!Y41bUtils.esNullOCadenaVacia(excoor)) {
					filtroSolicitud.setDecoor(excoor);
				}
				if (exnror != null) {
					filtroSolicitud.setDenror(exnror);
				}
				if (exnran != null) {
					filtroSolicitud.setDenran(exnran);
				}
				// parseo de fechas
				Locale locale = LocaleContextHolder.getLocale();
				if (!Y41bUtils.esNullOCadenaVacia(cofechaInicioDesde)) {
					filtroSolicitud.setDefedeDesde(Y41bUtils.parseDate(cofechaInicioDesde, locale));
				}
				if (!Y41bUtils.esNullOCadenaVacia(cofechaInicioHasta)) {
					filtroSolicitud.setDefedeHasta(Y41bUtils.parseDate(cofechaInicioHasta, locale));
				}
				// parseo de fechas
				if (!Y41bUtils.esNullOCadenaVacia(cofechaHechoDesde)) {
					filtroSolicitud.setHdfehdDesde(Y41bUtils.parseDate(cofechaHechoDesde, locale));
				}
				if (!Y41bUtils.esNullOCadenaVacia(cofechaHechoHasta)) {
					filtroSolicitud.setHdfehdHasta(Y41bUtils.parseDate(cofechaHechoHasta, locale));
				}
				if ("A".equals(origen) && !Y41bUtils.esNullOCadenaVacia(excodigo)) {
					filtroSolicitud.setEsnif(((this.sanintervService.dameSancionado(excodigo).getUanif())));
				}

				// 0170995: Acumulacin de expedientes en SAncionador
				if ("G".equals(origen) && !Y41bUtils.esNullOCadenaVacia(excodigo)) {
					if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoprocAcumularOrigen)) {
						try {
							Saninterv saninterv = this.sanintervService.dameSancionado(excodigo);
							if (null != saninterv && null != saninterv.getUanif()) {
								filtroSolicitud.setEsnif(saninterv.getUanif());
							}
						} catch (Exception e) {
							filtroSolicitud.setEsnif("XXXXXXXX");
						}
					} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoprocAcumularOrigen)) {
						try {
							Intervinientes intervinien = new Intervinientes();
							intervinien.setIdExpediente(excodigo);
							EstablecimientoDetalle establecimientoDetalleActa = this.denunciaService
									.findIntervinienteEstablecimiento(intervinien);
							if (null != establecimientoDetalleActa && null != establecimientoDetalleActa.getEsnif()) {
								filtroSolicitud.setEsnif(establecimientoDetalleActa.getEsnif());
							}
						} catch (Exception e) {
							filtroSolicitud.setEsnif("XXXXXXXX");
						}
					} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoprocAcumularOrigen)) {
						try {
							Arbinterv arbinterv = this.arbintervService.dameInterviniente(excodigo,
									Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
							if (null != arbinterv && null != arbinterv.getUanif()) {
								filtroSolicitud.setEsnif(arbinterv.getUanif());
							}
						} catch (Exception e) {
							filtroSolicitud.setEsnif("XXXXXXXX");
						}
					} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoprocAcumularOrigen)) {
						try {

							if (Y41bUtils.esNullOCadenaVacia(sancionbaprsanidOrigen)) {
								Intervinientes intervinien = new Intervinientes();
								intervinien.setIdExpediente(excodigo);
								EstablecimientoDetalle establecimientoDetalleActa = this.inspeccionService
										.findIntervinienteEstablecimientoResponsable(intervinien);
								if (null != establecimientoDetalleActa
										&& null != establecimientoDetalleActa.getEsnif()) {
									filtroSolicitud.setEsnif(establecimientoDetalleActa.getEsnif());
								} else {
									filtroSolicitud.setEsnif("XXXXXXXX");
								}
							} else {
								Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
								sanpropbandeja.setBaprsanid(Long.parseLong(sancionbaprsanidOrigen));
								sanpropbandeja = this.sanpropbandejaService.find(sanpropbandeja);
								if (null != sanpropbandeja && null != sanpropbandeja.getBaprsansancionado()) {
									Intervinientes intervinien = new Intervinientes();
									intervinien.setIdExpediente(excodigo);
									EstablecimientoDetalle establecimientoDetalleActaResponsable;
									try {
										establecimientoDetalleActaResponsable = this.inspeccionService
												.findIntervinienteEstablecimientoResponsable(intervinien);
									} catch (Exception e) {
										establecimientoDetalleActaResponsable = null;
									}
									Intervinientes intervinien2 = new Intervinientes();
									intervinien2.setIdExpediente(excodigo);
									EstablecimientoDetalle establecimientoDetalleActaVisitado;
									try {
										establecimientoDetalleActaVisitado = this.inspeccionService
												.findIntervinienteEstablecimientoVisitado(intervinien2);
									} catch (Exception e) {
										establecimientoDetalleActaVisitado = null;
									}
									if (null != establecimientoDetalleActaResponsable
											&& establecimientoDetalleActaResponsable.getEscodigo() != null
											&& establecimientoDetalleActaResponsable.getEscodigo()
													.equals(sanpropbandeja.getBaprsansancionado())) {
										filtroSolicitud.setEsnif(establecimientoDetalleActaResponsable.getEsnif());
									} else if (null != establecimientoDetalleActaVisitado
											&& establecimientoDetalleActaVisitado.getEscodigo() != null
											&& establecimientoDetalleActaVisitado.getEscodigo()
													.equals(sanpropbandeja.getBaprsansancionado())) {
										filtroSolicitud.setEsnif(establecimientoDetalleActaVisitado.getEsnif());
									} else {
										filtroSolicitud.setEsnif("XXXXXXXX");
									}
								} else {
									filtroSolicitud.setEsnif("XXXXXXXX");
								}
							}
						} catch (Exception e) {
							filtroSolicitud.setEsnif("XXXXXXXX");
						}

					}

				}
				// 0170995: Acumulacin de expedientes en SAncionador

				List<SolicitudBusqueda> listaSolicitudesRelacionar;
				Long recordNum;

				/*
				 * FILTRAMOS POR EL CODIGO DE DECISION SEGUN TABLA DE PARAMETROS
				 */
				if (Y41bConstantes.VALOR_SI.equals(origen) || "A".equals(origen) || "G".equals(origen)) {
					/*
					 * Parametros parametros = new Parametros();
					 * parametros.setParametro
					 * (Y41bConstantes.DECISION_PROPUESTA_SAN_DENUNCIA);
					 * parametros = parametrosDao.find(parametros); if
					 * (parametros != null) { String codigoDecision =
					 * parametros.getValor();
					 * filtroSolicitud.setDecodigo(codigoDecision); } else {
					 * filtroSolicitud.setDecodigo("9999999999"); }
					 */

					listaSolicitudesRelacionar = this.denunciaService.findAllSolicitudesRelacionarNuevaSancion(
							filtroSolicitud, excodigo, relacionadosSol, pagination);
					recordNum = this.denunciaService.findAllCountSolicitudesRelacionarNuevaSancion(filtroSolicitud,
							excodigo, relacionadosSol);
				} else {
					listaSolicitudesRelacionar = this.denunciaService.findAllSolicitudesRelacionar(filtroSolicitud,
							excodigo, relacionadosSol, pagination);
					recordNum = this.denunciaService.findAllCountSolicitudesRelacionar(filtroSolicitud, excodigo,
							relacionadosSol);
				}
				jqGrid = new JQGridJSONModel(pagination, recordNum, listaSolicitudesRelacionar);
			} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
				FiltroInspeccion filtroInspeccion = new FiltroInspeccion();
				// Expediente
				if (!Y41bUtils.esNullOCadenaVacia(excoor)) {
					filtroInspeccion.setAccoor(excoor);
				}
				if (exnror != null) {
					filtroInspeccion.setAcnror(exnror.toString());
				}
				if (exnran != null) {
					filtroInspeccion.setAcnran(exnran);
				}
				// parseo de fechas
				Locale locale = LocaleContextHolder.getLocale();
				if (!Y41bUtils.esNullOCadenaVacia(cofechaInicioDesde)) {
					filtroInspeccion.setAcfereDesde(Y41bUtils.parseDate(cofechaInicioDesde, locale));
				}
				if (!Y41bUtils.esNullOCadenaVacia(cofechaInicioHasta)) {
					filtroInspeccion.setAcfereHasta(Y41bUtils.parseDate(cofechaInicioHasta, locale));
				}
				if ("A".equals(origen) && !Y41bUtils.esNullOCadenaVacia(excodigo)) {
					filtroInspeccion.setEsnif(((this.sanintervService.dameSancionado(excodigo).getUanif())));
				}
				// 0170995: Acumulacin de expedientes en SAncionador
				if ("G".equals(origen) && !Y41bUtils.esNullOCadenaVacia(excodigo)) {
					if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoprocAcumularOrigen)) {
						try {
							Saninterv saninterv = this.sanintervService.dameSancionado(excodigo);
							if (null != saninterv && null != saninterv.getUanif()) {
								filtroInspeccion.setEsnif(saninterv.getUanif());
							}
						} catch (Exception e) {
							filtroInspeccion.setEsnif("XXXXXXXX");
						}

					} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoprocAcumularOrigen)) {
						try {
							Intervinientes intervinien = new Intervinientes();
							intervinien.setIdExpediente(excodigo);
							EstablecimientoDetalle establecimientoDetalleActa = this.denunciaService
									.findIntervinienteEstablecimiento(intervinien);
							if (null != establecimientoDetalleActa && null != establecimientoDetalleActa.getEsnif()) {
								filtroInspeccion.setEsnif(establecimientoDetalleActa.getEsnif());
							}
						} catch (Exception e) {
							filtroInspeccion.setEsnif("XXXXXXXX");
						}

					} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoprocAcumularOrigen)) {
						try {
							Arbinterv arbinterv = this.arbintervService.dameInterviniente(excodigo,
									Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
							if (null != arbinterv && null != arbinterv.getUanif()) {
								filtroInspeccion.setEsnif(arbinterv.getUanif());
							}
						} catch (Exception e) {
							filtroInspeccion.setEsnif("XXXXXXXX");
						}
					} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoprocAcumularOrigen)) {
						try {

							if (Y41bUtils.esNullOCadenaVacia(sancionbaprsanidOrigen)) {
								Intervinientes intervinien = new Intervinientes();
								intervinien.setIdExpediente(excodigo);
								EstablecimientoDetalle establecimientoDetalleActa = this.inspeccionService
										.findIntervinienteEstablecimientoResponsable(intervinien);
								if (null != establecimientoDetalleActa
										&& null != establecimientoDetalleActa.getEsnif()) {
									filtroInspeccion.setEsnif(establecimientoDetalleActa.getEsnif());
								} else {
									filtroInspeccion.setEsnif("XXXXXXXX");
								}
							} else {
								Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
								sanpropbandeja.setBaprsanid(Long.parseLong(sancionbaprsanidOrigen));
								sanpropbandeja = this.sanpropbandejaService.find(sanpropbandeja);
								if (null != sanpropbandeja && null != sanpropbandeja.getBaprsansancionado()) {
									Intervinientes intervinien = new Intervinientes();
									intervinien.setIdExpediente(excodigo);
									EstablecimientoDetalle establecimientoDetalleActaResponsable;
									try {
										establecimientoDetalleActaResponsable = this.inspeccionService
												.findIntervinienteEstablecimientoResponsable(intervinien);
									} catch (Exception e) {
										establecimientoDetalleActaResponsable = null;
									}
									Intervinientes intervinien2 = new Intervinientes();
									intervinien2.setIdExpediente(excodigo);
									EstablecimientoDetalle establecimientoDetalleActaVisitado;
									try {
										establecimientoDetalleActaVisitado = this.inspeccionService
												.findIntervinienteEstablecimientoVisitado(intervinien2);
									} catch (Exception e) {
										establecimientoDetalleActaVisitado = null;
									}
									if (null != establecimientoDetalleActaResponsable
											&& establecimientoDetalleActaResponsable.getEscodigo() != null
											&& establecimientoDetalleActaResponsable.getEscodigo()
													.equals(sanpropbandeja.getBaprsansancionado())) {
										filtroInspeccion.setEsnif(establecimientoDetalleActaResponsable.getEsnif());
									} else if (null != establecimientoDetalleActaVisitado
											&& establecimientoDetalleActaVisitado.getEscodigo() != null
											&& establecimientoDetalleActaVisitado.getEscodigo()
													.equals(sanpropbandeja.getBaprsansancionado())) {
										filtroInspeccion.setEsnif(establecimientoDetalleActaVisitado.getEsnif());
									} else {
										filtroInspeccion.setEsnif("XXXXXXXX");
									}
								} else {
									filtroInspeccion.setEsnif("XXXXXXXX");
								}
							}
						} catch (Exception e) {
							filtroInspeccion.setEsnif("XXXXXXXX");
						}

					}

				}
				// 0170995: Acumulacin de expedientes en SAncionador

				List<FiltroInspeccion> listaInspeccionesRelacionar = new ArrayList<FiltroInspeccion>();
				Long recordNum = 0L;

				/*
				 * FILTRAMOS POR EL CODIGO DE DECISION SEGUN TABLA DE PARAMETROS
				 */
				if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
					if (Y41bConstantes.VALOR_SI.equals(origen) || "A".equals(origen) || "G".equals(origen)) {

						listaInspeccionesRelacionar = this.inspeccionService.findAllInspeccionesRelacionarNuevaSancion(
								filtroInspeccion, excodigo, relacionadosIns, pagination);
						recordNum = this.inspeccionService.findAllCountInspeccionesRelacionarNuevaSancion(
								filtroInspeccion, excodigo, relacionadosIns);
					} else {
						listaInspeccionesRelacionar = this.inspeccionService
								.findAllInspeccionesRelacionar(filtroInspeccion, excodigo, relacionadosIns, pagination);
						recordNum = this.inspeccionService.findAllCountInspeccionesRelacionar(filtroInspeccion,
								excodigo, relacionadosIns);
					}
				}
				jqGrid = new JQGridJSONModel(pagination, recordNum, listaInspeccionesRelacionar);
			} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc)) {
				FiltroArbitraje filtroArbitraje = new FiltroArbitraje();
				// Solarb
				if (!Y41bUtils.esNullOCadenaVacia(excoor)) {
					filtroArbitraje.setSacoja(excoor);
				}
				if (exnror != null) {
					filtroArbitraje.setSanror(exnror);
				}
				if (exnran != null) {
					filtroArbitraje.setSanran(exnran);
				}
				// parseo de fechas
				Locale locale = LocaleContextHolder.getLocale();
				if (!Y41bUtils.esNullOCadenaVacia(cofechaInicioDesde)) {
					filtroArbitraje.setFechaIniDesde(Y41bUtils.parseDate(cofechaInicioDesde, locale));
				}
				if (!Y41bUtils.esNullOCadenaVacia(cofechaInicioHasta)) {
					filtroArbitraje.setFechaIniHasta(Y41bUtils.parseDate(cofechaInicioHasta, locale));
				}
				if (!Y41bUtils.esNullOCadenaVacia(cofechaHechoDesde)) {
					filtroArbitraje.setFechaHechoDesde(Y41bUtils.parseDate(cofechaHechoDesde, locale));
				}
				if (!Y41bUtils.esNullOCadenaVacia(cofechaHechoHasta)) {
					filtroArbitraje.setFechaHechoHasta(Y41bUtils.parseDate(cofechaHechoHasta, locale));
				}
				if ("A".equals(origen) && !Y41bUtils.esNullOCadenaVacia(excodigo)) {
					Arbinterv reclamado = new Arbinterv();
					reclamado.setUanif(((this.sanintervService.dameSancionado(excodigo).getUanif())));
					filtroArbitraje.setArbintervReclamado(reclamado);
				}

				// 0170995: Acumulacin de expedientes en SAncionador
				if ("G".equals(origen) && !Y41bUtils.esNullOCadenaVacia(excodigo)) {
					Arbinterv reclamado = new Arbinterv();

					if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoprocAcumularOrigen)) {
						try {
							Saninterv saninterv = this.sanintervService.dameSancionado(excodigo);
							if (null != saninterv && null != saninterv.getUanif()) {
								reclamado.setUanif(saninterv.getUanif());
							}
						} catch (Exception e) {
							reclamado.setUanif("XXXXXXXX");
						}

					} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoprocAcumularOrigen)) {
						try {
							Intervinientes intervinien = new Intervinientes();
							intervinien.setIdExpediente(excodigo);
							EstablecimientoDetalle establecimientoDetalleActa = this.denunciaService
									.findIntervinienteEstablecimiento(intervinien);
							if (null != establecimientoDetalleActa && null != establecimientoDetalleActa.getEsnif()) {
								reclamado.setUanif(establecimientoDetalleActa.getEsnif());
							}
						} catch (Exception e) {
							reclamado.setUanif("XXXXXXXX");
						}

					} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoprocAcumularOrigen)) {
						try {
							Arbinterv arbinterv = this.arbintervService.dameInterviniente(excodigo,
									Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
							if (null != arbinterv && null != arbinterv.getUanif()) {
								reclamado.setUanif(arbinterv.getUanif());
							}
						} catch (Exception e) {
							reclamado.setUanif("XXXXXXXX");
						}
					} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoprocAcumularOrigen)) {
						try {

							if (Y41bUtils.esNullOCadenaVacia(sancionbaprsanidOrigen)) {
								Intervinientes intervinien = new Intervinientes();
								intervinien.setIdExpediente(excodigo);
								EstablecimientoDetalle establecimientoDetalleActa = this.inspeccionService
										.findIntervinienteEstablecimientoResponsable(intervinien);
								if (null != establecimientoDetalleActa
										&& null != establecimientoDetalleActa.getEsnif()) {
									reclamado.setUanif(establecimientoDetalleActa.getEsnif());
								} else {
									reclamado.setUanif("XXXXXXXX");
								}
							} else {
								Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
								sanpropbandeja.setBaprsanid(Long.parseLong(sancionbaprsanidOrigen));
								sanpropbandeja = this.sanpropbandejaService.find(sanpropbandeja);
								if (null != sanpropbandeja && null != sanpropbandeja.getBaprsansancionado()) {
									Intervinientes intervinien = new Intervinientes();
									intervinien.setIdExpediente(excodigo);
									EstablecimientoDetalle establecimientoDetalleActaResponsable;
									try {
										establecimientoDetalleActaResponsable = this.inspeccionService
												.findIntervinienteEstablecimientoResponsable(intervinien);
									} catch (Exception e) {
										establecimientoDetalleActaResponsable = null;
									}
									Intervinientes intervinien2 = new Intervinientes();
									intervinien2.setIdExpediente(excodigo);
									EstablecimientoDetalle establecimientoDetalleActaVisitado;
									try {
										establecimientoDetalleActaVisitado = this.inspeccionService
												.findIntervinienteEstablecimientoVisitado(intervinien2);
									} catch (Exception e) {
										establecimientoDetalleActaVisitado = null;
									}
									if (null != establecimientoDetalleActaResponsable
											&& establecimientoDetalleActaResponsable.getEscodigo() != null
											&& establecimientoDetalleActaResponsable.getEscodigo()
													.equals(sanpropbandeja.getBaprsansancionado())) {
										reclamado.setUanif(establecimientoDetalleActaResponsable.getEsnif());
									} else if (null != establecimientoDetalleActaVisitado
											&& establecimientoDetalleActaVisitado.getEscodigo() != null
											&& establecimientoDetalleActaVisitado.getEscodigo()
													.equals(sanpropbandeja.getBaprsansancionado())) {
										reclamado.setUanif(establecimientoDetalleActaVisitado.getEsnif());
									} else {
										reclamado.setUanif("XXXXXXXX");
									}
								} else {
									reclamado.setUanif("XXXXXXXX");
								}
							}
						} catch (Exception e) {
							reclamado.setUanif("XXXXXXXX");
						}

					}
					filtroArbitraje.setArbintervReclamado(reclamado);
				}
				// 0170995: Acumulacin de expedientes en SAncionador

				List<FiltroArbitraje> listaExpedientesARelacionar = new ArrayList<FiltroArbitraje>();
				Long recordNum = 0L;
				if (Y41bModuloUtils.getInstance().mostrarArbitraje()) {
					listaExpedientesARelacionar = this.solarbService.findAllArbitrajesRelacionar(filtroArbitraje,
							excodigo, relacionadosArb, pagination);
					recordNum = this.solarbService.findAllCountArbitrajesRelacionar(filtroArbitraje, excodigo,
							relacionadosArb);
				}
				RelacionarExpedientesController.logger.info("[GET - jqGrid] : Obtener expdts de arbitraje");
				jqGrid = new JQGridJSONModel(pagination, recordNum, listaExpedientesARelacionar);

			}
			return jqGrid;
		} catch (Exception e) {

			RelacionarExpedientesController.logger
					.error("Error producido en RelacionarExpedientesController.getAllJQGrid: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * 
	 * @param seleccionados
	 *            String
	 * @param excodigo
	 *            String
	 * @param origen
	 *            String
	 * @param tipoproc
	 *            String
	 * @param tipoprocExp
	 *            String
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/guardarRelacionados", method = RequestMethod.POST)
	public @ResponseBody() void guardarSanexpRelacionados(
			@RequestParam(value = "seleccionados", required = false) String seleccionados,
			@RequestParam(value = "excodigo", required = false) String excodigo,
			@RequestParam(value = "origen", required = false) String origen,
			@RequestParam(value = "tipoproc", required = false) String tipoproc,
			@RequestParam(value = "tipoprocExp", required = false) String tipoprocExp, HttpServletRequest request) {
		try {

			Sanexprel sanexprel = new Sanexprel();
			// Set expediente principal
			if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoprocExp)) {
				Expedien expedien = new Expedien();
				expedien.setExcodigo(excodigo);
				sanexprel.setExpedienByRlexcodigo(expedien);
			} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoprocExp)) {
				sanexprel.setRlhdcodigo(excodigo);
			} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoprocExp)) {
				sanexprel.setRlarbcodigo(excodigo);
			} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoprocExp)) {
				sanexprel.setRlinscodigo(excodigo);
			}
			// Set Expediente relacionado
			Expedien expedienRel = new Expedien();
			long relacionado = 0;
			String[] arrayIds = seleccionados.split(",");
			for (int i = 0; i < arrayIds.length; i++) {
				if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoproc)) {
					expedienRel.setExcodigo(arrayIds[i]);
					sanexprel.setExpedienByRlexcodrel(expedienRel);
					sanexprel.setRlexcodrel(arrayIds[i]);
				} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc)) {
					sanexprel.setRlhdcodrel(arrayIds[i]);
				} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
					sanexprel.setRlinscodrel(arrayIds[i]);
				} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc)) {
					sanexprel.setRlarbcodrel(arrayIds[i]);
				}
				// Comprobamos si ya esta relacionado
				relacionado = this.sanexprelService.findAllCount(sanexprel).longValue();
				if (relacionado == 0) {
					sanexprel.setRlesorig(origen);
					this.sanexprelService.add(sanexprel);
				}
			}

		} catch (Y41bUDAException uda_exception) {
			throw uda_exception;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'guardarSanexpRelacionados'.
	 * 
	 * @param relacionados
	 *            String
	 * @param seleccionados
	 *            String
	 * @param tipoproc
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/comprobarRelacionados", method = RequestMethod.POST)
	public @ResponseBody() void comprobarRelacionados(
			@RequestParam(value = "relacionadosArb", required = false) String relacionadosArb,
			@RequestParam(value = "relacionadosSol", required = false) String relacionadosSol,
			@RequestParam(value = "relacionadosSan", required = false) String relacionadosSan,
			@RequestParam(value = "relacionadosIns", required = false) String relacionadosIns,
			@RequestParam(value = "seleccionados", required = false) String seleccionados,
			@RequestParam(value = "tipoproc", required = false) String tipoproc, HttpServletRequest request)
			throws Exception {
		try {

			// Comprobar si tienen el mismo cif de establecimiento
			// boolean mismoEstablecimiento = this.establecimientoService
			// .comprobarEstablecimiento(relacionadosArb, relacionadosSol,
			// relacionadosSan, relacionadosIns, seleccionados,
			// tipoproc);
			//
			// if (!mismoEstablecimiento) {
			// throw new Exception("ERROR_ESTABLECIMIENTO");
			// }

		} catch (Y41bUDAException uda_exception) {
			throw uda_exception;
		} catch (Exception e) {
			if ("ERROR_ESTABLECIMIENTO".equals(e.getMessage())) {
				throw new Exception("ERROR_ESTABLECIMIENTO");
			} else {
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	}

	/**
	 * 
	 * @param excodigo
	 *            String
	 * @param seleccionados
	 *            String
	 * @param tipoproc
	 *            String
	 * @param acumularActualizarHecho
	 *            String
	 * @param expedienteOrigen
	 *            String
	 * @param tipoprocOrigen
	 *            String
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/acumular", method = RequestMethod.POST)
	public @ResponseBody() void acumular(@RequestParam(value = "excodigo", required = false) String excodigo,
			@RequestParam(value = "seleccionados", required = false) String seleccionados,
			@RequestParam(value = "tipoproc", required = false) String tipoproc,
			@RequestParam(value = "acumularActualizarHecho", required = false) String acumularActualizarHecho,
			@RequestParam(value = "sanexp.expedienteOrigen", required = false) String expedienteOrigen,
			@RequestParam(value = "sanexp.tipoprocOrigen", required = false) String tipoprocOrigen,
			HttpServletRequest request) {
		try {
			// Obtenemos el expediente de bd
			Expedien expedien = new Expedien();
			expedien.setExcodigo(excodigo);
			expedien = this.expedienService.find(expedien);
			// Completamos el objeto con los datos de la request
			Sanexp sanexp = new Sanexp();
			sanexp.setExcodigo(excodigo);
			if (tipoprocOrigen != null) {
				// Cuando viene desde seleccionar expediente origen
				sanexp.setTipoprocOrigen(tipoprocOrigen);
			} else {
				// Cuando viene desde relacionar expedientes
				sanexp.setTipoprocOrigen(tipoproc);
			}
			sanexp.setExpedienteOrigen(expedienteOrigen);
			sanexp.setExcodrel(seleccionados);
			expedien.setSanexp(sanexp);

			this.expedienService.acumular(expedien, acumularActualizarHecho);

		} catch (Y41bUDAException uda_exception) {
			throw uda_exception;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
