package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.RecursoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Recurso;

/**
 * RecursoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/recurso")

public class RecursoController  {

	private static final Logger logger = LoggerFactory.getLogger(RecursoController.class);

	@Autowired
	private RecursoService recursoService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		RecursoController.logger.info("[GET - View] : recurso");
		return "recurso";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param recodigo String
	 * @return recurso Recurso
	 */
	@RequestMapping(value = "/{recodigo}", method = RequestMethod.GET)
	public @ResponseBody Recurso getById(@PathVariable String recodigo) {
        Recurso recurso = new Recurso();
		recurso.setRecodigo(recodigo);
        recurso = this.recursoService.find(recurso);
        RecursoController.logger.info("[GET - findBy_PK] : Obtener Recurso por PK");
        return recurso;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterRecurso Recurso
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Recurso> getAll(@ModelAttribute Recurso filterRecurso) {
		RecursoController.logger.info("[GET - find_ALL] : Obtener Recurso por filtro");
	    return this.recursoService.findAll(filterRecurso, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param recurso Recurso 
	 * @return Recurso
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Recurso edit(@RequestBody Recurso recurso) {		
        Recurso recursoAux = this.recursoService.update(recurso);
		RecursoController.logger.info("[PUT] : Recurso actualizado correctamente");
        return recursoAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param recurso Recurso 
	 * @return Recurso
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Recurso add(@RequestBody Recurso recurso) {		
        Recurso recursoAux = this.recursoService.add(recurso);
        RecursoController.logger.info("[POST] : Recurso insertado correctamente");
    	return recursoAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param recodigo String
	 * @return recurso
	 */
	@RequestMapping(value = "/{recodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Recurso remove(@PathVariable String recodigo) {
        Recurso recurso = new Recurso();
        recurso.setRecodigo(recodigo);
        this.recursoService.remove(recurso);
       	RecursoController.logger.info("[DELETE] : Recurso borrado correctamente");
       	return recurso;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param recursoIds List
	 * @return recursoList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> recursoIds) {
        List<Recurso> recursoList = new ArrayList<Recurso>();
        for (List<String> recursoId:recursoIds) {
		    Iterator<String> iterator = recursoId.iterator();
		    Recurso recurso = new Recurso(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        recurso.setRecodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    recursoList.add(recurso);
	    }
        this.recursoService.removeMultiple(recursoList);
		RecursoController.logger.info("[POST - DELETE_ALL] : Recurso borrados correctamente");
		return recursoIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterRecurso Recurso
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Recurso filterRecurso, @ModelAttribute Pagination pagination) {
        List<Recurso> recursos = this.recursoService.findAll(filterRecurso, pagination);
        Long recordNum = this.recursoService.findAllCount(filterRecurso);
        RecursoController.logger.info("[GET - jqGrid] : Obtener Recurso");
		return new JQGridJSONModel(pagination, recordNum, recursos);
	}
	
}	
